/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.core.type;

import com.sas.lsaf.core.type.AttributeDefinition;
import com.sas.lsaf.core.type.Type;
import com.sas.lsaf.macro.common.utils.SasUtils;

public class SasTypeAttributeDefinition {
    private String typeId;
    private String typeName;
    private AttributeDefinition attrDef;

    public SasTypeAttributeDefinition(Type type, AttributeDefinition attrDef) {
        this.typeId = SasUtils.toSasString(type.getId());
        this.typeName = SasUtils.toSasString(type.getName());
        this.attrDef = attrDef;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getAttributeId() {
        return this.attrDef.getId();
    }

    public String getAttributeName() {
        return this.attrDef.getName();
    }

    public String getAttributeType() {
        return this.attrDef.getAttributeType().name();
    }

    public boolean attributeIsEditable() {
        return this.attrDef.isEditable();
    }

    public boolean attributeIsExtended() {
        return this.attrDef.isExtended();
    }

    public boolean attributeIsInherited() {
        return this.attrDef.isInherited();
    }

    public boolean attributeIsRequired() {
        return this.attrDef.isRequired();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SasTypeAttribute [");
        sb.append("TypeId: " + this.getTypeId());
        sb.append(", TypeName: " + this.getTypeName());
        sb.append(", AttribId: " + this.getAttributeId());
        sb.append(", AttribName: " + this.getAttributeName());
        sb.append(", AttribType: " + this.getAttributeType());
        sb.append(", AttrIsEditable: " + this.attributeIsEditable());
        sb.append(", AttrIsExtended: " + this.attributeIsExtended());
        sb.append(", AttrIsInherited: " + this.attributeIsInherited());
        sb.append(", AttrIsRequired: " + this.attributeIsRequired());
        sb.append("]");
        return sb.toString();
    }
}

