/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.core.type;

import com.sas.lsaf.core.type.Type;
import com.sas.lsaf.macro.common.utils.SasUtils;
import java.util.ArrayList;
import java.util.List;

public class SasType {
    private final String id;
    private final String name;
    private final String description;
    private String allowableChildTypes;
    private String capabilities;
    private String lsafType;

    public SasType(Type lsafType) {
        this.id = SasUtils.toSasString(lsafType.getId());
        this.name = SasUtils.toSasString(lsafType.getName());
        this.description = SasUtils.toSasString(lsafType.getDescription());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAllowableChildTypes() {
        return this.allowableChildTypes;
    }

    public void setAllowableChildTypes(String acts) {
        this.allowableChildTypes = acts;
    }

    public String getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(String caps) {
        this.capabilities = caps;
    }

    public String getLsafType() {
        return this.lsafType;
    }

    public void setType(Type type) {
        this.lsafType = type.isContextType() ? LsafType.CONTEXT.label : (type.isFileType() ? LsafType.FILE.label : (type.isFolderType() ? LsafType.FOLDER.label : type.getName()));
    }

    public static List<SasType> toSasTypes(List<Type> lsafTypes) {
        if (lsafTypes == null) {
            return new ArrayList<SasType>();
        }
        ArrayList<SasType> sasContextTypes = new ArrayList<SasType>(lsafTypes.size());
        for (Type t : lsafTypes) {
            SasType sct = new SasType(t);
            sct.setAllowableChildTypes(SasUtils.toSasCommaDelimitedString(t.getAllowableChildTypes()));
            sct.setType(t);
            List tCaps = t.getCapabilities();
            ArrayList<String> caps = new ArrayList<String>(tCaps.size());
            for (Type.Capability c : tCaps) {
                caps.add(c.name());
            }
            sct.setCapabilities(SasUtils.toSasCommaDelimitedString(caps));
            sasContextTypes.add(sct);
        }
        return sasContextTypes;
    }

    public static enum LsafType {
        CONTEXT("Context"),
        FILE("File"),
        FOLDER("Folder");

        public final String label;

        private LsafType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

