/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.core.system;

import com.sas.lsaf.core.configuration.ApplicationInformationService;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.SasProperty;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.SasPropertiesResult;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.core.system.SasSystemConstant;
import com.sas.lsaf.macro.core.system.SasSystemConstantsResult;
import com.sas.lsaf.macro.core.system.SystemConstantsHelper;
import com.sas.lsaf.macro.security.authentication.LsafSessionHolder;
import com.sas.lsaf.macro.security.authentication.LsafSessionMissingException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SystemService {
    private static Log LOG = LogFactory.getLog(SystemService.class);
    private static final String prodName = "SAS Life Science Analytics Framework";
    public static final String API_VERSION_PROPERTY_NAME = "SAS Life Science Analytics Framework Java API Client Version";
    public static final String MACRO_VERSION_PROPERTY_NAME = "SAS Life Science Analytics Framework SAS Macro API Client Version";
    private static List<SasSystemConstant> constants = new ArrayList<SasSystemConstant>();
    private static List<SasProperty> apiVersions = new ArrayList<SasProperty>();
    private static String macroVersion;
    private static SystemService FOR_COVERAGE;

    private SystemService() {
    }

    private static ApplicationInformationService doGetService() {
        return ServiceManagerFactory.getApiApplicationInformationService();
    }

    private static void doSetApiVersions() {
        if (!LsafSessionHolder.hasSession()) {
            throw new LsafSessionMissingException();
        }
        if (apiVersions.size() == 0) {
            macroVersion = SystemService.class.getPackage().getImplementationVersion();
            apiVersions.add(new SasProperty(API_VERSION_PROPERTY_NAME, SystemService.doGetService().getApplicationInformation().getApiClientVersion()));
            apiVersions.add(new SasProperty(MACRO_VERSION_PROPERTY_NAME, macroVersion));
        }
    }

    public static void getApiVersions(SasPropertiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Retrieving api versions");
        }
        try {
            SystemService.doSetApiVersions();
            result.setProperties(apiVersions);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getSystemConstants(String name, SasSystemConstantsResult result) {
        try {
            if (!LsafSessionHolder.hasSession()) {
                throw new LsafSessionMissingException();
            }
            if (constants.size() == 0) {
                SystemService.doSetApiVersions();
                constants = SystemConstantsHelper.getApiConstants();
            }
            ArrayList<SasSystemConstant> cons = new ArrayList<SasSystemConstant>();
            if (ValidationUtils.valueIsMissing((Serializable)((Object)name))) {
                cons.addAll(constants);
            } else {
                for (SasSystemConstant c : constants) {
                    if (!c.getName().equalsIgnoreCase(name)) continue;
                    cons.add(c);
                }
            }
            result.setConstants(macroVersion, cons);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    static {
        FOR_COVERAGE = new SystemService();
    }
}

