/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.core.system;

import com.sas.lsaf.clinical.common.UpdateAction;
import com.sas.lsaf.clinical.model.ModelConstants;
import com.sas.lsaf.clinical.study.StudyComponent;
import com.sas.lsaf.content.repository.RepositoryFile;
import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.content.repository.RepositoryService;
import com.sas.lsaf.content.repository.RunHealthStatus;
import com.sas.lsaf.content.repository.SynchronizationInfo;
import com.sas.lsaf.content.repository.VersionDeleteInfo;
import com.sas.lsaf.content.repository.VersionType;
import com.sas.lsaf.content.repository.signature.SignatureService;
import com.sas.lsaf.core.DataType;
import com.sas.lsaf.core.EntityState;
import com.sas.lsaf.core.EntityStatus;
import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.core.action.ActionStatus;
import com.sas.lsaf.core.type.AttributeDefinition;
import com.sas.lsaf.core.type.Type;
import com.sas.lsaf.execution.job.JobParameter;
import com.sas.lsaf.execution.job.JobSubmissionStatus;
import com.sas.lsaf.execution.job.Manifest;
import com.sas.lsaf.execution.job.ManifestProgram;
import com.sas.lsaf.execution.session.EngineType;
import com.sas.lsaf.execution.session.Session;
import com.sas.lsaf.macro.clinical.SasClinicalImportValidationResult;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.utilization.ResourceUtilizationService;
import com.sas.lsaf.macro.core.system.SasSystemConstant;
import com.sas.lsaf.macro.core.type.SasType;
import com.sas.lsaf.macro.execution.job.SasJobPublishSetups;
import com.sas.lsaf.macro.execution.jobmanifest.SasManifestExternalReferencesResult;
import com.sas.lsaf.macro.execution.jobsubmission.SasJobSubmissionStatusResult;
import com.sas.lsaf.macro.execution.schedule.ScheduleService;
import com.sas.lsaf.macro.query.QueryService;
import com.sas.lsaf.macro.query.SasQueryValidationHelper;
import com.sas.lsaf.macro.security.acl.SasAce;
import com.sas.lsaf.macro.security.acl.SasAcl;
import com.sas.lsaf.macro.workflow.task.CompletedTaskHelper;
import com.sas.lsaf.messaging.subscription.SubscriptionEvent;
import com.sas.lsaf.query.Column;
import com.sas.lsaf.query.Comparison;
import com.sas.lsaf.query.Condition;
import com.sas.lsaf.query.security.membership.ContextMembershipQuery;
import com.sas.lsaf.schedule.ScheduleDescriptor;
import com.sas.lsaf.schedule.ScheduleTrigger;
import com.sas.lsaf.security.audit.AuditEntry;
import com.sas.lsaf.security.privilege.GlobalPrivilege;
import com.sas.lsaf.security.privilege.GlobalPrivilegeService;
import com.sas.lsaf.security.privilege.ScopedPrivilege;
import com.sas.lsaf.security.privilege.ScopedPrivilegeService;
import com.sas.lsaf.security.user.AccountInfo;
import com.sas.lsaf.security.user.UserService;
import com.sas.lsaf.workflow.AutoFlowType;
import com.sas.lsaf.workflow.FlowAttributeType;
import com.sas.lsaf.workflow.element.CompletedElement;
import com.sas.lsaf.workflow.element.Element;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionInfo;
import com.sas.lsaf.workflow.processflow.CreationMethod;
import com.sas.lsaf.workflow.processflow.DataProperty;
import com.sas.lsaf.workflow.processflow.ProcessFlowDescriptor;
import com.sas.lsaf.workflow.processflow.setup.NotificationTaskSetup;
import com.sas.lsaf.workflow.processflow.setup.TimerEventSetup;
import com.sas.lsaf.workflow.task.Task;
import com.sas.lsaf.workflow.task.TaskQuery;
import com.sas.lsaf.workflow.task.TaskService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class SystemConstantsHelper {
    private static final String PREFIX_DECLARINGCLASS = "class ";
    private static final String PREFIX_NAME = "com.sas.lsaf.";
    private static final String PREFIX_MACRONAME = "com.sas.lsaf.macro.";
    private static final String TYPE_SEARCHLIMIT = "Search Limit";
    private static final String SOURCE_DERIVED = "<Derived>";
    private static List<SasSystemConstant> constants = new ArrayList<SasSystemConstant>();
    private static String name;
    private static SystemConstantsHelper FOR_COVERAGE;

    private SystemConstantsHelper() {
    }

    private static void doAddConstantsValue(String source, String value, String details, boolean isDefaultValue) {
        constants.add(new SasSystemConstant(source, name, value, details, isDefaultValue));
    }

    private static void doAddConstantsValue(String source, String value) {
        SystemConstantsHelper.doAddConstantsValue(source, value, "", false);
    }

    private static void doAddConstantsValue(String source, String value, String details) {
        SystemConstantsHelper.doAddConstantsValue(source, value, details, false);
    }

    private static void doAddEnumToConstants(Class<? extends Enum<?>> eClass) {
        SystemConstantsHelper.doAddEnumToConstants(eClass, null);
    }

    private static void doAddEnumToConstants(Class<? extends Enum<?>> eClass, String defaultValue) {
        Enum<?>[] values = eClass.getEnumConstants();
        int size = values.length;
        if (size == 0) {
            return;
        }
        name = eClass.getSimpleName();
        String source = SystemConstantsHelper.doGetEnumSource(eClass);
        for (int indx = 0; indx < size; ++indx) {
            String value = values[indx].name();
            SystemConstantsHelper.doAddConstantsValue(source, value, "", value.equalsIgnoreCase(defaultValue));
        }
    }

    private static void doAddEnumLabelToConstants(Class<? extends Enum<?>> eClass) {
        Enum<?>[] values = eClass.getEnumConstants();
        int size = values.length;
        if (size == 0) {
            return;
        }
        name = eClass.getSimpleName();
        String source = SystemConstantsHelper.doGetEnumSource(eClass);
        for (int indx = 0; indx < size; ++indx) {
            String value = values[indx].toString();
            SystemConstantsHelper.doAddConstantsValue(source, value, "", false);
        }
    }

    private static String doGetEnumSource(Class<? extends Enum<?>> eClass) {
        Class<?> declaringClass = eClass.getDeclaringClass();
        String source = declaringClass == null ? eClass.getName().toString() : declaringClass.toString();
        source = SystemConstantsHelper.doCleanupSourceName(source, PREFIX_DECLARINGCLASS);
        source = SystemConstantsHelper.doCleanupSourceName(source, PREFIX_MACRONAME);
        source = SystemConstantsHelper.doCleanupSourceName(source, PREFIX_NAME);
        return source.trim();
    }

    private static String doCleanupSourceName(String srcName, String prefix) {
        if (srcName.trim().startsWith(prefix)) {
            return srcName.replace(prefix, "");
        }
        return srcName;
    }

    private static void doSetSigningStatusConstants() {
        Class<RepositoryFile.SigningStatus> eClass = RepositoryFile.SigningStatus.class;
        Enum[] values = (Enum[])eClass.getEnumConstants();
        name = eClass.getSimpleName();
        String source = SystemConstantsHelper.doGetEnumSource(eClass);
        for (int indx = 0; indx < values.length; ++indx) {
            String value;
            String details = "";
            switch (value = values[indx].name()) {
                case "NONE": {
                    details = "There are no signatures associated with the file.";
                    break;
                }
                case "PREVIOUS": {
                    details = "Current version is not signed but at least one previous version is.";
                    break;
                }
                case "CURRENT": {
                    details = "The current version of the file is signed but no previous versions are.";
                    break;
                }
                case "CURRENT_AND_PREVIOUS": {
                    details = "The current version and at least one previous version of the file are signed.";
                    break;
                }
            }
            SystemConstantsHelper.doAddConstantsValue(source, value, details);
        }
    }

    private static String doGetParenedText(String parenText, String otherText) {
        StringBuffer sb = new StringBuffer();
        if (!ValidationUtils.valueIsMissing((Serializable)((Object)parenText))) {
            sb.append("(");
            sb.append(parenText);
            sb.append(") ");
        }
        sb.append(otherText);
        return sb.toString().trim();
    }

    public static List<SasSystemConstant> getApiConstants() {
        GlobalPrivilegeService globSrv = ServiceManagerFactory.getApiGlobalPrivilegeService();
        RepositoryService repoSrv = ServiceManagerFactory.getApiRepositoryService();
        ScopedPrivilegeService scopedSrv = ServiceManagerFactory.getApiScopedPrivilegeService();
        SignatureService signSrv = ServiceManagerFactory.getApiSignatureService();
        TaskService taskSrv = ServiceManagerFactory.getApiTaskService();
        UserService userSrv = ServiceManagerFactory.getApiUserService();
        constants.clear();
        SystemConstantsHelper.doAddEnumToConstants(AccountInfo.AccountType.class);
        SystemConstantsHelper.doAddEnumToConstants(SasAce.AceType.class);
        SystemConstantsHelper.doAddEnumToConstants(SasAce.AclPrincipalType.class);
        SystemConstantsHelper.doAddEnumToConstants(SasAcl.AclType.class);
        SystemConstantsHelper.doAddEnumToConstants(TaskQuery.AssigneeType.class, TaskQuery.AssigneeType.CURRENT_USER.name());
        SystemConstantsHelper.doAddEnumToConstants(AttributeDefinition.AttributeType.class);
        SystemConstantsHelper.doAddEnumToConstants(AutoFlowType.class, AutoFlowType.TLF.name());
        SystemConstantsHelper.doAddEnumToConstants(Type.Capability.class);
        SystemConstantsHelper.doAddEnumToConstants(SynchronizationInfo.CheckoutStatus.class);
        SystemConstantsHelper.doAddEnumToConstants(Column.Type.class);
        SystemConstantsHelper.doAddEnumToConstants(ActionStatus.CompletionStatus.class);
        SystemConstantsHelper.doAddEnumToConstants(Task.Complexity.class);
        SystemConstantsHelper.doAddEnumToConstants(Condition.Operator.class);
        SystemConstantsHelper.doAddEnumToConstants(CreationMethod.class);
        SystemConstantsHelper.doAddEnumToConstants(DataProperty.Type.class);
        SystemConstantsHelper.doAddEnumToConstants(DataType.class);
        SystemConstantsHelper.doAddEnumToConstants(ModelConstants.DataType.class);
        SystemConstantsHelper.doAddEnumToConstants(ScheduleTrigger.DayOfWeek.class);
        SystemConstantsHelper.doAddEnumToConstants(VersionDeleteInfo.DeleteStatus.class);
        SystemConstantsHelper.doAddEnumToConstants(JobSubmissionStatus.DetailStatus.class);
        SystemConstantsHelper.doAddEnumToConstants(Element.ElementType.class);
        SystemConstantsHelper.doAddEnumToConstants(EngineType.class);
        SystemConstantsHelper.doAddEnumToConstants(EntityStatus.class, EntityStatus.PUBLISHED.name());
        SystemConstantsHelper.doAddEnumToConstants(EntityState.class);
        SystemConstantsHelper.doAddEnumToConstants(ManifestProgram.ExecutionStatus.class);
        SystemConstantsHelper.doAddEnumToConstants(SynchronizationInfo.FileStatus.class);
        SystemConstantsHelper.doAddEnumToConstants(FlowAttributeType.class);
        SystemConstantsHelper.doAddEnumToConstants(ProcessFlowDescriptor.FlowStatus.class);
        SystemConstantsHelper.doAddEnumToConstants(SasClinicalImportValidationResult.ImportCompletionStatus.class);
        SystemConstantsHelper.doAddEnumToConstants(SasJobPublishSetups.ItemType.class);
        SystemConstantsHelper.doAddEnumToConstants(ModelConstants.LogicalType.class);
        SystemConstantsHelper.doAddEnumLabelToConstants(SasType.LsafType.class);
        SystemConstantsHelper.doAddEnumToConstants(SasManifestExternalReferencesResult.ManifestExtRefType.class);
        SystemConstantsHelper.doAddEnumToConstants(Manifest.ManifestType.class);
        SystemConstantsHelper.doAddEnumToConstants(ContextMembershipQuery.MembershipScope.class, ContextMembershipQuery.MembershipScope.ALL.name());
        SystemConstantsHelper.doAddEnumToConstants(SasJobSubmissionStatusResult.MessageLevel.class);
        SystemConstantsHelper.doAddEnumToConstants(NotificationTaskSetup.MessagePriority.class, NotificationTaskSetup.MessagePriority.MEDIUM.name());
        SystemConstantsHelper.doAddEnumToConstants(AuditEntry.Mode.class);
        SystemConstantsHelper.doAddEnumToConstants(JobParameter.ParameterType.class);
        SystemConstantsHelper.doAddEnumToConstants(Task.Priority.class, Task.Priority.MEDIUM.name());
        SystemConstantsHelper.doAddEnumToConstants(ProcessDefinitionInfo.ProcessDefinitionStatus.class);
        SystemConstantsHelper.doAddEnumToConstants(QueryService.QueryType.class);
        SystemConstantsHelper.doAddEnumToConstants(Comparison.Operator.class);
        SystemConstantsHelper.doAddEnumToConstants(SasQueryValidationHelper.QueryRecordType.class);
        SystemConstantsHelper.doAddEnumToConstants(CompletedTaskHelper.RecordType.class);
        SystemConstantsHelper.doAddEnumToConstants(RunHealthStatus.class);
        SystemConstantsHelper.doAddEnumToConstants(ScheduleService.ScheduleEndType.class);
        SystemConstantsHelper.doAddEnumToConstants(ScheduleService.ScheduleIntervalType.class);
        SystemConstantsHelper.doAddEnumToConstants(ScheduleDescriptor.ScheduleStatus.class);
        SystemConstantsHelper.doAddEnumToConstants(Session.SessionEngine.class);
        SystemConstantsHelper.doAddEnumToConstants(Session.SessionType.class);
        SystemConstantsHelper.doAddEnumToConstants(Session.SessionState.class);
        name = "Signature Reason";
        Set sigReasons = signSrv.getSignatureReasons();
        for (Object sr : sigReasons) {
            SystemConstantsHelper.doAddConstantsValue("SignatureService", (String)sr);
        }
        name = "Signature Role";
        Set sigRoles = signSrv.getSignatureRoles();
        for (Object sRole : sigRoles) {
            SystemConstantsHelper.doAddConstantsValue("SignatureService", (String)sRole);
        }
        SystemConstantsHelper.doSetSigningStatusConstants();
        SystemConstantsHelper.doAddEnumToConstants(SourceLocation.class);
        SystemConstantsHelper.doAddEnumToConstants(RepositoryItem.State.class);
        SystemConstantsHelper.doAddEnumToConstants(StudyComponent.class);
        SystemConstantsHelper.doAddEnumToConstants(SubscriptionEvent.class);
        SystemConstantsHelper.doAddEnumToConstants(JobSubmissionStatus.SummaryStatus.class);
        SystemConstantsHelper.doAddEnumToConstants(RepositoryItem.Syncable.class);
        SystemConstantsHelper.doAddEnumToConstants(SynchronizationInfo.SynchronizationStatus.class);
        SystemConstantsHelper.doAddEnumToConstants(CompletedElement.TaskCompletedState.class);
        SystemConstantsHelper.doAddEnumToConstants(Task.TaskStatus.class);
        SystemConstantsHelper.doAddEnumToConstants(TimerEventSetup.TimerType.class);
        SystemConstantsHelper.doAddEnumToConstants(UpdateAction.class);
        SystemConstantsHelper.doAddEnumToConstants(ResourceUtilizationService.UtilizationArea.class);
        SystemConstantsHelper.doAddEnumToConstants(ResourceUtilizationService.UtilizationType.class);
        SystemConstantsHelper.doAddEnumToConstants(VersionType.class);
        name = TYPE_SEARCHLIMIT;
        SystemConstantsHelper.doAddConstantsValue("TaskService", String.valueOf(taskSrv.getSearchLimit()));
        SystemConstantsHelper.doAddConstantsValue("RepositoryService: Checked out files", String.valueOf(repoSrv.getPageSizeLimit()));
        name = "License Type";
        Set lTypes = userSrv.getLicenseTypes();
        for (Object lt : lTypes) {
            SystemConstantsHelper.doAddConstantsValue("UserService", lt.getId(), SystemConstantsHelper.doGetParenedText(lt.getName(), lt.getDescription()));
        }
        name = "Permission Value";
        SystemConstantsHelper.doAddConstantsValue(SOURCE_DERIVED, "1", "Allowed");
        SystemConstantsHelper.doAddConstantsValue(SOURCE_DERIVED, "-1", "Denied");
        SystemConstantsHelper.doAddConstantsValue(SOURCE_DERIVED, "0", "Not specified (inherited)");
        name = "User Authenticator";
        List providers = userSrv.getAuthenticationProviderInfos();
        for (Object a : providers) {
            if (a.isPrimary()) {
                SystemConstantsHelper.doAddConstantsValue("UserService", a.getId(), SystemConstantsHelper.doGetParenedText("Primary", a.getDescription()));
                continue;
            }
            SystemConstantsHelper.doAddConstantsValue("UserService", a.getId(), a.getDescription());
        }
        name = "Global Privilege";
        Set gPrivs = globSrv.getAvailablePrivileges();
        for (GlobalPrivilege p : gPrivs) {
            SystemConstantsHelper.doAddConstantsValue("GlobalPrivilegeService", p.getId(), p.getName());
        }
        name = "Scoped Privilege";
        Set sPrivs = scopedSrv.getAvailablePrivileges();
        for (ScopedPrivilege p : sPrivs) {
            SystemConstantsHelper.doAddConstantsValue("ScopedPrivilegeService", p.getId(), p.getName());
        }
        return constants;
    }

    static {
        FOR_COVERAGE = new SystemConstantsHelper();
    }
}

