/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.content.workspace;

import com.sas.lsaf.content.repository.SynchronizationInfo;
import com.sas.lsaf.content.workspace.WorkspaceFolder;
import com.sas.lsaf.content.workspace.WorkspaceItem;
import com.sas.lsaf.content.workspace.WorkspaceItemNotFoundException;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.PathUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.ItemTypeException;
import com.sas.lsaf.macro.content.workspace.SasWorkspaceItemsResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class WorkspaceService {
    private static final Log LOG = LogFactory.getLog(WorkspaceService.class);
    private static WorkspaceService FOR_COVERAGE = new WorkspaceService();

    private WorkspaceService() {
    }

    private static com.sas.lsaf.content.workspace.WorkspaceService doGetService() {
        return ServiceManagerFactory.getApiWorkspaceService();
    }

    private static void doGetChildren(WorkspaceFolder currentParent, List<WorkspaceItem> allChildren, int currentDepth, int targetDepth) throws WorkspaceItemNotFoundException {
        List children = WorkspaceService.doGetService().getChildren(currentParent.getPath());
        if (children.isEmpty()) {
            return;
        }
        allChildren.addAll(children);
        if (currentDepth >= targetDepth) {
            return;
        }
        for (WorkspaceItem child : children) {
            if (!(child instanceof WorkspaceFolder)) continue;
            WorkspaceService.doGetChildren((WorkspaceFolder)child, allChildren, currentDepth + 1, targetDepth);
        }
    }

    private static List<WorkspaceItem> doGetChildren(WorkspaceFolder parent, int depth) throws WorkspaceItemNotFoundException {
        ArrayList<WorkspaceItem> children = new ArrayList<WorkspaceItem>();
        WorkspaceService.doGetChildren(parent, children, 1, depth);
        return children;
    }

    public static void getChildren(String path, String recursion, SasWorkspaceItemsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting workspace children for " + path + " with a depth of " + recursion));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            int depth = ValidationUtils.validateRecursionGetChildren(recursion);
            WorkspaceItem wr = WorkspaceService.doGetService().getItem(path);
            if (!(wr instanceof WorkspaceFolder)) {
                throw new ItemTypeException("This operation can only be performed on a container.");
            }
            ArrayList<WorkspaceItem> wrs = new ArrayList<WorkspaceItem>();
            wrs.add(wr);
            if (depth > 0) {
                wrs.addAll(WorkspaceService.doGetChildren((WorkspaceFolder)wr, depth));
            }
            result.setResources(wrs);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean exists(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking existence of " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            boolean exists = WorkspaceService.doGetService().exists(path);
            result.init(0, "Success.");
            return exists;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return false;
        }
    }

    public static void createFolder(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating folder " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            WorkspaceService.doGetService().createFolder(path, true);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void markForAdd(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Marking for Add " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            WorkspaceService.doGetService().markForAdd(path);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String getCheckoutStatus(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting checkout status for " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            SynchronizationInfo.CheckoutStatus status = WorkspaceService.doGetService().getCheckoutStatus(path);
            result.init(0, "Success.");
            return status.name();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void delete(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            WorkspaceService.doGetService().delete(path);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void createFile(String localFilePath, String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating file " + path + " from " + localFilePath));
        }
        try {
            ValidationUtils.validateInvalidTrustedLsafSessionOperation();
            ValidationUtils.validateRequiredParameter(localFilePath, "Local path");
            ValidationUtils.assertRequiredPath(path);
            WorkspaceService.doGetService().createFile(path, localFilePath, true);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateFile(String localFilePath, String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating file " + path + " from " + localFilePath));
        }
        try {
            ValidationUtils.validateInvalidTrustedLsafSessionOperation();
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.validateRequiredParameter(localFilePath, "Local path");
            WorkspaceService.doGetService().updateFileContents(path, localFilePath);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void downloadFile(String path, String localFilePath, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Downloading " + path + " to local path " + localFilePath));
        }
        try {
            ValidationUtils.validateInvalidTrustedLsafSessionOperation();
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.validateRequiredParameter(localFilePath, "Local path");
            WorkspaceService.doGetService().downloadFile(path, localFilePath);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String rename(String sourcePath, String newName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming item from " + sourcePath + " to " + PathUtils.getParentPath(sourcePath) + "/" + newName));
        }
        try {
            ValidationUtils.validateRequiredParameter(sourcePath, "Source path");
            ValidationUtils.validateRequiredParameter(newName, "New name");
            WorkspaceItem item = WorkspaceService.doGetService().rename(sourcePath, newName);
            result.init(0, "Success.");
            return item.getPath();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void move(String sourcePath, String destinationPath, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Moving item from " + sourcePath + " to " + destinationPath));
        }
        try {
            ValidationUtils.validateRequiredParameter(sourcePath, "Source path");
            ValidationUtils.validateRequiredParameter(destinationPath, "Target path");
            WorkspaceService.doGetService().move(sourcePath, destinationPath);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void copy(String sourcePath, String destinationPath, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Copying item from " + sourcePath + " to " + destinationPath));
        }
        try {
            ValidationUtils.validateRequiredParameter(sourcePath, "Source path");
            ValidationUtils.validateRequiredParameter(destinationPath, "Target path");
            WorkspaceService.doGetService().copy(sourcePath, destinationPath);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

