/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.content.workspace;

import com.sas.lsaf.content.workspace.SharedWorkspaceEntry;
import com.sas.lsaf.content.workspace.WorkspaceItemExistsException;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.workspace.SasSharedWorkspaceEntriesResult;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SharedWorkspaceService {
    private static final Log LOG = LogFactory.getLog(SharedWorkspaceService.class);
    private static SharedWorkspaceService FOR_COVERAGE = new SharedWorkspaceService();

    private SharedWorkspaceService() {
    }

    private static com.sas.lsaf.content.workspace.SharedWorkspaceService doGetService() {
        return ServiceManagerFactory.getApiSharedWorkspaceService();
    }

    public static String createLink(String sharedFolderId, String userId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating link for " + userId + " to " + sharedFolderId));
        }
        try {
            ValidationUtils.validateRequiredParameter(sharedFolderId, "Shared folder id");
            ValidationUtils.assertRequiredUserId(userId);
            result.init(0, "Success.");
            SharedWorkspaceEntry wse = SharedWorkspaceService.doGetService().createLink(sharedFolderId, userId);
            return wse.getPath();
        }
        catch (WorkspaceItemExistsException e) {
            ExceptionHandler.handleException(new ResultException(e.getLocalizedMessage()), result);
            return "";
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void deleteLink(String sharedFolderId, String userId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting link for " + userId + " from " + sharedFolderId));
        }
        try {
            ValidationUtils.validateRequiredParameter(sharedFolderId, "Shared folder id");
            ValidationUtils.assertRequiredUserId(userId);
            SharedWorkspaceService.doGetService().deleteLink(sharedFolderId, userId);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getSharedWorkspaceEntries(String sharedFolderId, SasSharedWorkspaceEntriesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting shared workspace entries " + sharedFolderId));
        }
        try {
            ValidationUtils.validateRequiredParameter(sharedFolderId, "Shared folder id");
            Set swe = SharedWorkspaceService.doGetService().getSharedWorkspaceEntries(sharedFolderId);
            result.setSharedWorkspaceEntries(swe);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

