/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.content.workspace;

import com.sas.lsaf.content.workspace.WorkspaceFile;
import com.sas.lsaf.content.workspace.WorkspaceFolder;
import com.sas.lsaf.content.workspace.WorkspaceItem;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.PathUtils;
import com.sas.lsaf.macro.common.utils.SasUtils;
import java.util.ArrayList;
import java.util.List;

public class SasWorkspaceItemsResult
extends Result {
    private List<WorkspaceItem> items = new ArrayList<WorkspaceItem>();

    public void setResources(List<WorkspaceItem> resources) {
        this.items = resources;
    }

    public int getSize() {
        return this.items.size();
    }

    public WorkspaceItem getWorkspaceItem(double index) {
        return this.items.get((int)index);
    }

    public String getName(double index) {
        return SasUtils.toSasString(PathUtils.getName(this.getWorkspaceItem(index).getPath()));
    }

    public String getPath(double index) {
        return SasUtils.toSasString(this.getWorkspaceItem(index).getPath());
    }

    public int isFolder(double index) {
        if (this.getWorkspaceItem(index) instanceof WorkspaceFolder) {
            return 1;
        }
        return 0;
    }

    public long getFileSize(double index) {
        WorkspaceItem w = this.getWorkspaceItem(index);
        if (w instanceof WorkspaceFile) {
            return ((WorkspaceFile)w).getSize();
        }
        return -1L;
    }

    public String getFormattedFileSize(double index) {
        long size = this.getFileSize(index);
        if (size > -1L) {
            return SasUtils.toSasFormattedFileSize(size);
        }
        return "";
    }

    public String getItemType(double index) {
        if (this.getWorkspaceItem(index) instanceof WorkspaceFolder) {
            return "sas:folder";
        }
        return "sas:file";
    }

    public String getLastModified(double index) {
        return SasUtils.toSasString(this.getWorkspaceItem(index).getLastModifiedDate());
    }

    public String getLastModifiedSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.getWorkspaceItem(index).getLastModifiedDate());
    }
}

