/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.content.workspace;

import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.core.action.ActionStatus;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.result.SasActionStatusResult;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BatchWorkspaceService {
    private static final Log LOG = LogFactory.getLog(BatchWorkspaceService.class);
    private static BatchWorkspaceService FOR_COVERAGE = new BatchWorkspaceService();

    private BatchWorkspaceService() {
    }

    private static com.sas.lsaf.content.workspace.BatchWorkspaceService doGetService() {
        return ServiceManagerFactory.getApiBatchWorkspaceService();
    }

    public static void downloadAsZip(String path, String localFilePath, String overwrite, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Downloading " + path + " as a zip file to local path " + localFilePath));
        }
        try {
            ValidationUtils.validateInvalidTrustedLsafSessionOperation();
            ValidationUtils.validateRequiredParameter(path, "Path");
            boolean overwriteLocalFile = ValidationUtils.validateBinaryFlagDefaultFalse(overwrite, "Overwrite file");
            ValidationUtils.validateRequiredParameter(localFilePath, "Local path");
            HashSet<String> zipPaths = new HashSet<String>();
            zipPaths.add(path);
            BatchWorkspaceService.doGetService().downloadAsZip(zipPaths, localFilePath, overwriteLocalFile);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void uploadAndExpand(String localZipFilePath, String parentPath, SasActionStatusResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Uploading and expanding " + localZipFilePath + " to " + parentPath));
        }
        try {
            ValidationUtils.validateInvalidTrustedLsafSessionOperation();
            ValidationUtils.validateRequiredParameter(parentPath, "Path");
            ValidationUtils.validateRequiredParameter(localZipFilePath, "Local path");
            ActionStatus as = BatchWorkspaceService.doGetService().uploadAndExpand(parentPath, localZipFilePath, true);
            result.setActionStatus(as);
            result.init(0, as.getCompletionMessage());
        }
        catch (SystemException e) {
            ExceptionHandler.handleException(new ResultException(e.getLocalizedMessage()), result);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

