/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.content.utilization;

import com.sas.lsaf.content.utilization.ResourceUtilizationContainerInfo;
import com.sas.lsaf.content.utilization.ResourceUtilizationPathNotFoundException;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.utilization.ResourceUtilizationRecursionException;
import com.sas.lsaf.macro.content.utilization.SasAdminTransientUtilizationInfosResult;
import com.sas.lsaf.macro.content.utilization.SasAdminWorkspaceUtilizationInfosResult;
import com.sas.lsaf.macro.content.utilization.SasResourceUtilizationResult;
import com.sas.lsaf.macro.content.utilization.SasUserTransientUtilizationInfosResult;
import com.sas.lsaf.macro.content.utilization.SasUtilizationSummaryResult;
import com.sas.lsaf.macro.security.authentication.AuthenticationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ResourceUtilizationService {
    static Log LOG = LogFactory.getLog(ResourceUtilizationService.class);
    private static ResourceUtilizationService FOR_COVERAGE = new ResourceUtilizationService();

    private ResourceUtilizationService() {
    }

    private static com.sas.lsaf.content.utilization.ResourceUtilizationService doGetService() {
        return ServiceManagerFactory.getApiResourceUtilizationService();
    }

    private static int doValidateRecursion(String recursion) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)recursion))) {
            return 1;
        }
        try {
            int r = Integer.parseInt(recursion);
            if (0 >= r || r >= 100) {
                throw new ResourceUtilizationRecursionException();
            }
            return r;
        }
        catch (NumberFormatException e) {
            throw new ResourceUtilizationRecursionException();
        }
    }

    private static void doGetChildren(com.sas.lsaf.content.utilization.ResourceUtilizationService srv, UtilizationArea srcLoc, String currentParent, List<ResourceUtilizationContainerInfo> allChildren, UtilizationType type, int currentDepth, int targetDepth) throws ResourceUtilizationPathNotFoundException {
        if (currentParent.contains("<system files>")) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting " + String.valueOf((Object)srcLoc) + " children for " + currentParent + "depth " + currentDepth + " of " + targetDepth));
        }
        ArrayList children = new ArrayList();
        if (UtilizationArea.WORKSPACE.equals((Object)srcLoc)) {
            children.addAll(srv.getWorkspaceContainerChildrenAndSizes(currentParent));
        } else if (UtilizationArea.REPOSITORY.equals((Object)srcLoc)) {
            children.addAll(srv.getRepositoryContainerChildrenAndSizes(currentParent));
        } else if (UtilizationType.ADMINISTRATION.equals((Object)type)) {
            children.addAll(srv.getAdminSharedWorkspaceContainerChildrenAndSizes(currentParent));
        } else {
            children.addAll(srv.getUserSharedWorkspaceContainerChildrenAndSizes(currentParent));
        }
        if (children.isEmpty()) {
            return;
        }
        allChildren.addAll(children);
        if (currentDepth < targetDepth) {
            for (ResourceUtilizationContainerInfo child : children) {
                ResourceUtilizationService.doGetChildren(srv, srcLoc, child.getPath(), allChildren, type, currentDepth + 1, targetDepth);
            }
        }
    }

    private static List<ResourceUtilizationContainerInfo> doGetContainerInfos(UtilizationArea sourceLoc, List<ResourceUtilizationContainerInfo> startingInfo, UtilizationType type, int depth) throws ResourceUtilizationPathNotFoundException {
        if (depth == 1) {
            return startingInfo;
        }
        com.sas.lsaf.content.utilization.ResourceUtilizationService srv = ResourceUtilizationService.doGetService();
        ArrayList<ResourceUtilizationContainerInfo> all = new ArrayList<ResourceUtilizationContainerInfo>();
        for (ResourceUtilizationContainerInfo container : startingInfo) {
            all.add(container);
            ResourceUtilizationService.doGetChildren(srv, sourceLoc, container.getPath(), all, type, 2, depth);
        }
        return all;
    }

    public static void getUtilizationSummary(SasUtilizationSummaryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Get Utilization Summary");
        }
        try {
            com.sas.lsaf.content.utilization.ResourceUtilizationService srv = ResourceUtilizationService.doGetService();
            if (ServiceManagerFactory.getApiGlobalPrivilegeService().hasPrivilege(AuthenticationService.getLoggedInUserId(), "PRIVILEGE_VIEW_ADMINISTRATIVE_DASHBOARD_TILES")) {
                result.addSummary(UtilizationType.ADMINISTRATION, UtilizationArea.REPOSITORY, srv.getTotalRepositorySize());
                result.addSummary(UtilizationType.ADMINISTRATION, UtilizationArea.WORKSPACE, srv.getTotalUserWorkspaceSize());
                result.addSummary(UtilizationType.ADMINISTRATION, UtilizationArea.TRANSIENTWORKSPACE, srv.getTotalTransientWorkspaceSize());
                result.addSummary(UtilizationType.ADMINISTRATION, UtilizationArea.SHAREDWORKSPACE, srv.getTotalSharedWorkspaceSize());
            }
            result.addSummary(UtilizationType.USER, UtilizationArea.REPOSITORY, srv.getCurrentUserRepositorySize());
            result.addSummary(UtilizationType.USER, UtilizationArea.WORKSPACE, srv.getCurrentUserWorkspaceSize());
            result.addSummary(UtilizationType.USER, UtilizationArea.TRANSIENTWORKSPACE, srv.getCurrentUserTransientWorkspaceSize());
            result.addSummary(UtilizationType.USER, UtilizationArea.SHAREDWORKSPACE, srv.getCurrentUserSharedWorkspaceSize());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getAdminRepositoryUtilizationDetails(String path, String recursion, SasResourceUtilizationResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting Admin Repository Utilization with recursion " + recursion + ": " + path));
        }
        try {
            String startingPath = ValidationUtils.valueIsMissing((Serializable)((Object)path)) ? "/" : path;
            int depth = ResourceUtilizationService.doValidateRecursion(recursion);
            List info = ResourceUtilizationService.doGetService().getRepositoryContainerChildrenAndSizes(startingPath);
            result.setInfos(ResourceUtilizationService.doGetContainerInfos(UtilizationArea.REPOSITORY, info, UtilizationType.ADMINISTRATION, depth));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getUserRepositoryUtilizationDetails(String path, String recursion, SasResourceUtilizationResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting current user's repository utilization");
        }
        try {
            Object startingPath;
            ValidationUtils.validateHaveLsafSession();
            String userDepot = "/Users/" + AuthenticationService.getLoggedInUserId();
            Object object = startingPath = ValidationUtils.valueIsMissing((Serializable)((Object)path)) ? userDepot : path;
            if (!((String)startingPath).startsWith(userDepot)) {
                throw new ResultException("Path must be in " + userDepot + ".");
            }
            int depth = ResourceUtilizationService.doValidateRecursion(recursion);
            List info = ResourceUtilizationService.doGetService().getRepositoryContainerChildrenAndSizes((String)startingPath);
            result.setInfos(ResourceUtilizationService.doGetContainerInfos(UtilizationArea.REPOSITORY, info, UtilizationType.USER, depth));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getAdminTransientWorkspaceUtilizationDetails(SasAdminTransientUtilizationInfosResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting Admin transient workspace utilization");
        }
        try {
            result.setInfos(ResourceUtilizationService.doGetService().getAllTransientWorkspaceUtilization());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getAdminWorkspaceUtilizationDetails(SasAdminWorkspaceUtilizationInfosResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting Admin workspace utilization");
        }
        try {
            result.setInfos(ResourceUtilizationService.doGetService().getAllUserWorkspaceUtilization());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getUserTransientWorkspaceUtilizationDetails(SasUserTransientUtilizationInfosResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting current user's transient workspace utilization");
        }
        try {
            result.setInfos(ResourceUtilizationService.doGetService().getCurrentUserTransientWorkspaceUtilization());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getUserWorkspaceUtilizationDetails(String path, String recursion, SasResourceUtilizationResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting current user's workspace utilization with recursion " + recursion + ": " + path));
        }
        try {
            String startingPath = ValidationUtils.valueIsMissing((Serializable)((Object)path)) ? "/" : path;
            int depth = ResourceUtilizationService.doValidateRecursion(recursion);
            List info = ResourceUtilizationService.doGetService().getWorkspaceContainerChildrenAndSizes(startingPath);
            result.setInfos(ResourceUtilizationService.doGetContainerInfos(UtilizationArea.WORKSPACE, info, UtilizationType.USER, depth));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getAdminSharedWorkspaceUtilizationDetails(String path, String recursion, SasResourceUtilizationResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting Admin shared workspace utilization");
        }
        try {
            String startingPath = ValidationUtils.valueIsMissing((Serializable)((Object)path)) ? "/" : path;
            int depth = ResourceUtilizationService.doValidateRecursion(recursion);
            List info = ResourceUtilizationService.doGetService().getAdminSharedWorkspaceContainerChildrenAndSizes(startingPath);
            result.setInfos(ResourceUtilizationService.doGetContainerInfos(UtilizationArea.SHAREDWORKSPACE, info, UtilizationType.ADMINISTRATION, depth));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getUserSharedWorkspaceUtilizationDetails(String path, String recursion, SasResourceUtilizationResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting User shared workspace utilization");
        }
        try {
            String startingPath = ValidationUtils.valueIsMissing((Serializable)((Object)path)) ? "/" : path;
            int depth = ResourceUtilizationService.doValidateRecursion(recursion);
            List info = ResourceUtilizationService.doGetService().getUserSharedWorkspaceContainerChildrenAndSizes(startingPath);
            result.setInfos(ResourceUtilizationService.doGetContainerInfos(UtilizationArea.SHAREDWORKSPACE, info, UtilizationType.USER, depth));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static enum UtilizationArea {
        REPOSITORY,
        WORKSPACE,
        TRANSIENTWORKSPACE,
        SHAREDWORKSPACE;

    }

    public static enum UtilizationType {
        ADMINISTRATION,
        USER;

    }
}

