/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.content.repository.signature;

import com.sas.lsaf.content.repository.RepositoryFile;
import com.sas.lsaf.content.repository.signature.CreateSignatureInfo;
import com.sas.lsaf.content.repository.signature.Signature;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.repository.RepositoryUtils;
import com.sas.lsaf.macro.content.repository.signature.SasSignaturesResult;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SignatureService {
    private static final Log LOG = LogFactory.getLog(SignatureService.class);
    private static SignatureService FOR_COVERAGE = new SignatureService();

    private SignatureService() {
    }

    private static com.sas.lsaf.content.repository.signature.SignatureService doGetService() {
        return ServiceManagerFactory.getApiSignatureService();
    }

    private static CreateSignatureInfo doCreateSignatureInfo(String userId, byte[] password, String role, String reason, String comment) {
        CreateSignatureInfo sigInfo = new CreateSignatureInfo();
        sigInfo.setUserId(userId);
        sigInfo.setPassword(password);
        sigInfo.setRole(role);
        sigInfo.setReason(reason);
        sigInfo.setComment(comment);
        return sigInfo;
    }

    public static void getSignatures(String path, String version, SasSignaturesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting esign for information " + path + " version: " + version));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            com.sas.lsaf.content.repository.signature.SignatureService srv = SignatureService.doGetService();
            Set sigs = ValidationUtils.valueIsMissing((Serializable)((Object)version)) ? srv.getSignatures(path) : srv.getSignaturesByVersion(path, version);
            result.setSignatures(sigs, RepositoryUtils.getItemTypeByPath(path));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isVersionSigned(String path, String version, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking if version " + version + " is signed: " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.validateRequiredParameter(version, "Version");
            boolean signed = SignatureService.doGetService().isVersionSigned(path, version);
            result.init(0, "Success.");
            return signed;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static String getSigningStatus(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting file signing status: " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryFile.SigningStatus ss = SignatureService.doGetService().getSigningStatus(path);
            String stat = ss == null ? "" : ss.name();
            result.init(0, "Success.");
            return stat;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void signFile(String path, String userId, String password, String role, String reason, String comment, SasSignaturesResult result) {
        try {
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.assertRequiredUserId(userId);
            byte[] pw = ValidationUtils.assertRequiredPassword(password);
            ValidationUtils.validateRequiredString(role, "Signature Role is required");
            ValidationUtils.validateRequiredString(reason, "Signature Reason is required");
            CreateSignatureInfo csi = SignatureService.doCreateSignatureInfo(userId, pw, role, reason, comment);
            Signature signature = SignatureService.doGetService().createSignature(path, csi);
            HashSet<Signature> sigs = new HashSet<Signature>(1);
            sigs.add(signature);
            result.setSignatures(sigs, RepositoryUtils.getItemTypeByPath(path));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

