/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.content.repository.recyclebin;

import com.sas.lsaf.content.repository.recyclebin.RecycleBinItem;
import com.sas.lsaf.content.repository.recyclebin.RecycleBinQuery;
import com.sas.lsaf.content.repository.recyclebin.RecycleBinSearchResults;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.SasStrings;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.SasPathResult;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.repository.recyclebin.SasRecycleBinQuery;
import com.sas.lsaf.macro.content.repository.recyclebin.SasRecycleBinResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RecycleBinService {
    private static final Log LOG = LogFactory.getLog(RecycleBinService.class);
    private static RecycleBinService FOR_COVERAGE = new RecycleBinService();

    private RecycleBinService() {
    }

    private static com.sas.lsaf.content.repository.recyclebin.RecycleBinService doGetService() {
        return ServiceManagerFactory.getApiRecycleBinService();
    }

    private static RecycleBinQuery doGetRecycleBinQuery(SasRecycleBinQuery rbQuery) {
        RecycleBinQuery query = new RecycleBinQuery();
        query.setLocation(ValidationUtils.toJavaString(rbQuery.getLocation()));
        query.setName(ValidationUtils.toJavaString(rbQuery.getName()));
        query.setDeletedBy(ValidationUtils.toJavaString(rbQuery.getDeletedBy()));
        query.setFromDate(ValidationUtils.validateDateString("From date", rbQuery.getFromDate()));
        query.setToDate(ValidationUtils.validateDateString("To date", rbQuery.getToDate()));
        boolean recurse = ValidationUtils.validateBinaryFlagDefaultTrue(rbQuery.includeSubFolders(), "Include subfolders");
        query.setRecurse(recurse);
        return query;
    }

    public static void getRecycleBinItemsByQuery(SasRecycleBinQuery rbQuery, SasRecycleBinResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting recycle bin items by query.");
        }
        try {
            RecycleBinSearchResults searchResults = RecycleBinService.doGetService().search(RecycleBinService.doGetRecycleBinQuery(rbQuery));
            ArrayList<RecycleBinItem> rbItems = new ArrayList<RecycleBinItem>(searchResults.getRecycleBinSearchResults());
            boolean limitReached = searchResults.isLimitReached();
            result.setItems(rbItems, limitReached);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void deleteRecycleBinItemsByQuery(SasRecycleBinQuery rbQuery, SasPathResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Deleting recycle bin items by query.");
        }
        try {
            List deletedPaths = RecycleBinService.doGetService().deleteItemsByQuery(RecycleBinService.doGetRecycleBinQuery(rbQuery));
            result.setPaths(deletedPaths);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void deleteItems(SasStrings ids, SasPathResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Delete specific items from the recycle bin.");
        }
        try {
            List deletedPaths = RecycleBinService.doGetService().deleteItemsByIds(new HashSet<String>(ids.getList()));
            result.setPaths(deletedPaths);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

