/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.content.repository;

import com.sas.lsaf.content.repository.RepositoryFileInfo;
import com.sas.lsaf.content.repository.SynchronizationFileInfo;
import com.sas.lsaf.content.repository.SynchronizationInfo;
import com.sas.lsaf.content.repository.WorkspaceFileInfo;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.content.repository.SasSyncProperty;
import java.util.ArrayList;
import java.util.List;

public class SasSyncPropertiesResult
extends Result {
    private List<SasSyncProperty> properties = new ArrayList<SasSyncProperty>();

    private void doAddSyncInfoProperty(String name, String description, String value) {
        this.properties.add(new SasSyncProperty(name, value, description));
    }

    private void doConvertSyncInfoToProperties(SynchronizationInfo syncInfo) {
        this.doAddSyncInfoProperty("filePath", "File path", syncInfo.getPath());
        this.doAddSyncInfoProperty("fileStatus", "File status", syncInfo.getFileStatus().name());
        this.doAddSyncInfoProperty("syncFileStatus", "File synchronization status", syncInfo.getSynchronizationStatus().name());
        this.doAddSyncInfoProperty("fileCheckOutStatus", "File check out status", syncInfo.getCheckoutStatus().name());
        RepositoryFileInfo rfi = syncInfo.getRepositoryFileInfo();
        this.doAddSyncInfoProperty("repoFileVersion", "File version", rfi == null ? "" : SasUtils.toSasString(rfi.getVersion()));
        this.doAddSyncInfoProperty("repoLastModifiedDate", "Date the repository file was last modified", rfi == null ? "" : SasUtils.toSasString(rfi.getLastModified()));
        this.doAddSyncInfoProperty("repoLastModifiedSASDate", "SAS date the repository file was last modified", rfi == null ? "" : SasUtils.toSasDatetimeFormat(rfi.getLastModified()));
        this.doAddSyncInfoProperty("repoFileSize", "File size", rfi == null ? "" : SasUtils.toSasString((float)rfi.getSize()));
        this.doAddSyncInfoProperty("repoFileSizeFormatted", "Formatted file size", rfi == null ? "" : SasUtils.toSasFormattedFileSize(rfi.getSize()));
        this.doAddSyncInfoProperty("repoFileCheckedOut", "File checked out", rfi == null ? "0" : SasUtils.toSasString(rfi.isCheckedOut()));
        this.doAddSyncInfoProperty("repoFileCheckedOutUser", "The user that has the repository file checked out", rfi == null ? "" : SasUtils.toSasString(rfi.getCheckedOutBy()));
        SynchronizationFileInfo sfi = syncInfo.getSynchronizationFileInfo();
        this.doAddSyncInfoProperty("syncFileVersion", "The version of the repository file that was synchronized to the workspace", sfi == null ? "" : SasUtils.toSasString(sfi.getVersion()));
        this.doAddSyncInfoProperty("syncDate", "The file synchronization date", sfi == null ? "" : SasUtils.toSasString(sfi.getSynchronization()));
        this.doAddSyncInfoProperty("syncSASDate", "The file synchronization SAS date", sfi == null ? "" : SasUtils.toSasDatetimeFormat(sfi.getSynchronization()));
        this.doAddSyncInfoProperty("syncRepoLastModifiedDate", "The date of the repository file version that was synchronized to the workspace was last modified", sfi == null ? "" : SasUtils.toSasString(sfi.getRepositoryFileLastModified()));
        this.doAddSyncInfoProperty("syncRepoLastModifiedSASDate", "The SAS date of the repository file version that was synchronized to the workspace was last modified", sfi == null ? "" : SasUtils.toSasDatetimeFormat(sfi.getRepositoryFileLastModified()));
        this.doAddSyncInfoProperty("syncFileRepoSize", "The file size of the repository file synchronized to the workspace", sfi == null ? "" : SasUtils.toSasString((float)sfi.getRepositoryFileSize()));
        this.doAddSyncInfoProperty("syncFileRepoSizeFormatted", "The formatted file size of the repository file synchronized to the workspace", sfi == null ? "" : SasUtils.toSasFormattedFileSize(sfi.getRepositoryFileSize()));
        WorkspaceFileInfo wfi = syncInfo.getWorkspaceFileInfo();
        this.doAddSyncInfoProperty("workspaceFileSize", "The file size of the workspace file", wfi == null ? "" : SasUtils.toSasString((float)wfi.getSize()));
        this.doAddSyncInfoProperty("workspaceFileSizeFormatted", "The formatted file size of the workspace file", wfi == null ? "" : SasUtils.toSasString(SasUtils.toSasFormattedFileSize(wfi.getSize())));
        this.doAddSyncInfoProperty("workspaceLastModifiedDate", "Date the workspace file was last modified", wfi == null ? "" : wfi.getLastModifiedDate().toString());
        this.doAddSyncInfoProperty("workspaceLastModifiedSASDate", "SAS date the workspace file was last modified", wfi == null ? "" : SasUtils.toSasDatetimeFormat(wfi.getLastModifiedDate()));
    }

    public void setSyncProperties(List<SasSyncProperty> properties) {
        this.properties = properties;
    }

    public void setSyncProperties(SynchronizationInfo syncInfo) {
        if (syncInfo != null) {
            this.doConvertSyncInfoToProperties(syncInfo);
        }
    }

    public List<SasSyncProperty> getSyncProperties() {
        return this.properties;
    }

    public int getSize() {
        return this.properties.size();
    }

    public String getPropertyName(double index) {
        return this.properties.get((int)index).getName();
    }

    public String getPropertyValue(double index) {
        return this.properties.get((int)index).getValue();
    }

    public String getPropertyDescription(double index) {
        return this.properties.get((int)index).getDescription();
    }

    public String getSpecifiedValue(String propName) {
        for (SasSyncProperty ssp : this.properties) {
            if (!ssp.getName().equalsIgnoreCase(propName)) continue;
            return ssp.getValue();
        }
        return "";
    }
}

