/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.content.repository;

import com.sas.lsaf.content.repository.RepositoryContainer;
import com.sas.lsaf.content.repository.RepositoryFile;
import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.PathUtils;
import com.sas.lsaf.macro.common.utils.SasUtils;
import java.util.ArrayList;
import java.util.List;

public class SasRepositoryItemsResult
extends Result {
    private List<? extends RepositoryItem> items = new ArrayList<RepositoryItem>();

    public void setRepositoryItems(List<? extends RepositoryItem> rItems) {
        this.items = rItems;
    }

    public List<? extends RepositoryItem> getRepositoryItems() {
        return this.items;
    }

    public int getSize() {
        return this.items.size();
    }

    public String getName(double index) {
        return SasUtils.toSasString(PathUtils.getName(this.items.get((int)index).getPath()));
    }

    public String getPath(double index) {
        return SasUtils.toSasString(this.items.get((int)index).getPath());
    }

    public String getComment(double index) {
        RepositoryFile file = (RepositoryFile)this.items.get((int)index);
        return file.getComment();
    }

    public int isContainer(double index) {
        if (this.items.get((int)index) instanceof RepositoryContainer) {
            return 1;
        }
        return 0;
    }

    public String getItemType(double index) {
        return this.items.get((int)index).getTypeId();
    }

    public String getDescription(double index) {
        return this.items.get((int)index).getDescription();
    }

    public String getCreated(double index) {
        return SasUtils.toSasString(this.items.get((int)index).getCreated());
    }

    public String getCreatedSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.items.get((int)index).getCreated());
    }

    public String getCreatedBy(double index) {
        return this.items.get((int)index).getCreatedBy();
    }

    public String getLastModified(double index) {
        return SasUtils.toSasString(this.items.get((int)index).getLastModified());
    }

    public String getLastModifiedSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.items.get((int)index).getLastModified());
    }

    public String getLastModifiedBy(double index) {
        return this.items.get((int)index).getLastModifiedBy();
    }

    public String getPropertiesLastModified(double index) {
        return SasUtils.toSasString(this.items.get((int)index).getPropertiesLastModified());
    }

    public String getPropertiesLastModifiedSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.items.get((int)index).getPropertiesLastModified());
    }

    public String getPropertiesLastModifiedBy(double index) {
        return this.items.get((int)index).getPropertiesLastModifiedBy();
    }

    public String getState(double index) {
        return this.items.get((int)index).getState().name();
    }

    public long getFileSize(double index) {
        RepositoryItem r = this.items.get((int)index);
        if (r instanceof RepositoryFile) {
            return ((RepositoryFile)r).getSize();
        }
        return -1L;
    }

    public String getFormattedFileSize(double index) {
        long size = this.getFileSize(index);
        if (size > -1L) {
            return SasUtils.toSasFormattedFileSize(size);
        }
        return "";
    }

    public int isVersioned(double index) {
        RepositoryItem r = this.items.get((int)index);
        if (r instanceof RepositoryFile && ((RepositoryFile)r).isVersioned()) {
            return 1;
        }
        return 0;
    }

    public int isCheckedOut(double index) {
        RepositoryItem r = this.items.get((int)index);
        if (r instanceof RepositoryFile && ((RepositoryFile)r).isCheckedOut()) {
            return 1;
        }
        return 0;
    }

    public int isLocked(double index) {
        RepositoryItem r = this.items.get((int)index);
        if (r instanceof RepositoryFile && ((RepositoryFile)r).isLocked()) {
            return 1;
        }
        return 0;
    }

    public String getSignatureStatus(double index) {
        RepositoryItem r = this.items.get((int)index);
        if (!(r instanceof RepositoryFile)) {
            return "";
        }
        return SasUtils.toSasString(((RepositoryFile)r).getSigningStatus().name());
    }

    public String getVersion(double index) {
        RepositoryItem r = this.items.get((int)index);
        if (!(r instanceof RepositoryFile)) {
            return "";
        }
        return SasUtils.toSasString(((RepositoryFile)r).getVersion());
    }
}

