/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.content.repository;

import com.sas.lsaf.content.repository.SynchronizationInfo;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.PathUtils;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.security.authentication.AuthenticationService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SasCheckedOutFilesResult
extends Result {
    private List<SynchronizationInfo> syncinfos = new ArrayList<SynchronizationInfo>();
    private boolean limitReached = false;

    public void setCheckedOutFiles(List<SynchronizationInfo> syncinfos) {
        this.syncinfos = syncinfos;
    }

    public void setLimitReached(boolean limitReached) {
        this.limitReached = limitReached;
    }

    public boolean isLimitReached() {
        return this.limitReached;
    }

    public String getStatus(double index) {
        return this.syncinfos.get((int)index).getCheckoutStatus().name();
    }

    public String getUserId(double index) {
        return this.syncinfos.get((int)index).getRepositoryFileInfo().getCheckedOutBy();
    }

    public String getPath(double index) {
        return this.syncinfos.get((int)index).getPath();
    }

    public String getName(double index) {
        String path = this.getPath(index);
        return PathUtils.getName(path);
    }

    public String getLocation(double index) {
        String path = this.getPath(index);
        return PathUtils.getParentPath(path);
    }

    public long getFileSize(double index) {
        return this.syncinfos.get((int)index).getSynchronizationFileInfo().getRepositoryFileSize();
    }

    public String getFormattedSize(double index) {
        long size = this.getFileSize(index);
        return SasUtils.toSasFormattedFileSize(size);
    }

    public String getCheckedOutBy(double index) {
        String status = this.syncinfos.get((int)index).getFileStatus().name();
        if (SynchronizationInfo.FileStatus.WORKSPACE_ONLY.name().equals(status)) {
            return AuthenticationService.getLoggedInUserId();
        }
        return this.syncinfos.get((int)index).getRepositoryFileInfo().getCheckedOutBy();
    }

    public String getModifiedDate(double index) {
        Date lastMod = this.syncinfos.get((int)index).getSynchronizationFileInfo().getRepositoryFileLastModified();
        return SasUtils.toSasDatetimeFormat(lastMod);
    }

    public String getVersion(double index) {
        return this.syncinfos.get((int)index).getSynchronizationFileInfo().getVersion();
    }

    public String getWsStatus(double index) {
        return this.syncinfos.get((int)index).getCheckoutStatus().name();
    }

    public int getSize() {
        return this.syncinfos.size();
    }
}

