/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.content.repository;

import com.sas.lsaf.content.repository.RepositoryContainer;
import com.sas.lsaf.content.repository.RepositoryContext;
import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.content.repository.RepositoryItemNotFoundException;
import com.sas.lsaf.content.repository.RepositoryService;
import com.sas.lsaf.core.ObjectIdentity;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RepositoryUtils {
    private static final Log LOG = LogFactory.getLog(RepositoryUtils.class);
    public static final String TYPE_USERFOLDER = "sas:userFolder";
    public static final String TYPE_USERSFOLDER = "sas:usersFolder";
    public static final String TYPE_FILE = "sas:file";
    public static final String TYPE_FOLDER = "sas:folder";
    public static final String TYPE_SHAREDFOLDER = "sas:sharedFolder";
    private static RepositoryUtils FOR_COVERAGE = new RepositoryUtils();

    private RepositoryUtils() {
    }

    private static RepositoryService doGetRepoService() {
        return ServiceManagerFactory.getApiRepositoryService();
    }

    private static void doGetChildren(RepositoryService srv, RepositoryContainer currentParent, List<RepositoryItem> allChildren, int currentDepth, int targetDepth) throws RepositoryItemNotFoundException {
        List children = srv.getChildren(currentParent.getPath());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting children for " + String.valueOf(currentParent) + "depth " + currentDepth + " of " + targetDepth));
        }
        if (!children.isEmpty()) {
            allChildren.addAll(children);
            if (currentDepth < targetDepth) {
                for (RepositoryItem child : children) {
                    if (!(child instanceof RepositoryContainer)) continue;
                    RepositoryUtils.doGetChildren(srv, (RepositoryContainer)child, allChildren, currentDepth + 1, targetDepth);
                }
            }
        }
    }

    public static List<RepositoryItem> getChildren(RepositoryContainer parent, int depth) throws RepositoryItemNotFoundException {
        RepositoryService srv = RepositoryUtils.doGetRepoService();
        ArrayList<RepositoryItem> children = new ArrayList<RepositoryItem>();
        RepositoryUtils.doGetChildren(srv, parent, children, 1, depth);
        return children;
    }

    public static String getPathFromItemIdentity(ObjectIdentity oi) {
        try {
            String id = oi.getId();
            RepositoryContext rc = ServiceManagerFactory.getApiRepositoryService().getContextById(id);
            return rc.getPath();
        }
        catch (Exception e) {
            ExceptionHandler.throwNewResultException(e);
            return null;
        }
    }

    public static String getRepositoryItemId(String path) throws RepositoryItemNotFoundException {
        RepositoryItem ri = ServiceManagerFactory.getApiRepositoryService().getItem(path);
        return ri.getId();
    }

    public static String getItemTypeByPath(String path) {
        try {
            RepositoryItem r = ServiceManagerFactory.getApiRepositoryService().getItem(path);
            return r.getTypeId();
        }
        catch (Exception e) {
            ExceptionHandler.throwNewResultException(e);
            return null;
        }
    }

    public static enum UpdateFileVersionType {
        MAJOR,
        MINOR;

    }
}

