/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.content.repository;

import com.sas.lsaf.content.repository.CheckedOutFilesQuery;
import com.sas.lsaf.content.repository.RepositoryCheckinSpecification;
import com.sas.lsaf.content.repository.RepositoryContainer;
import com.sas.lsaf.content.repository.RepositoryContext;
import com.sas.lsaf.content.repository.RepositoryExecutableFile;
import com.sas.lsaf.content.repository.RepositoryFile;
import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.content.repository.RepositoryItemNotFoundException;
import com.sas.lsaf.content.repository.RepositorySearchResults;
import com.sas.lsaf.content.repository.RepositorySharedFolder;
import com.sas.lsaf.content.repository.SearchQuery;
import com.sas.lsaf.content.repository.VersionDeleteInfo;
import com.sas.lsaf.content.repository.VersionLimits;
import com.sas.lsaf.core.AbstractIdentifiable;
import com.sas.lsaf.core.Attribute;
import com.sas.lsaf.core.SearchResultsInfo;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.SasProperties;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.PathUtils;
import com.sas.lsaf.macro.common.utils.PropertyUtils;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.SasParameterInvalidException;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.ContentCreationParametersHelper;
import com.sas.lsaf.macro.content.ItemTypeException;
import com.sas.lsaf.macro.content.repository.RepositoryUtils;
import com.sas.lsaf.macro.content.repository.SasCheckedOutFilesResult;
import com.sas.lsaf.macro.content.repository.SasDeleteVersionException;
import com.sas.lsaf.macro.content.repository.SasFileCheckinParameters;
import com.sas.lsaf.macro.content.repository.SasItemProperty;
import com.sas.lsaf.macro.content.repository.SasRepositoryItemPropertiesResult;
import com.sas.lsaf.macro.content.repository.SasRepositoryItemsResult;
import com.sas.lsaf.macro.content.repository.SasRepositoryItemsSearchResult;
import com.sas.lsaf.macro.content.repository.SasRepositoryVersionsResult;
import com.sas.lsaf.macro.content.repository.SasSyncPropertiesResult;
import com.sas.lsaf.security.membership.MembershipContextNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RepositoryService {
    private static final Log LOG = LogFactory.getLog(RepositoryService.class);
    public static final String NOT_PROVIDED = "_LSAF_VALUE_NOT_PROVIDED_";
    private static RepositoryService FOR_COVERAGE = new RepositoryService();

    private RepositoryService() {
    }

    private static String validateSearchParameter(String value, String notProvidedValue) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value)) || value.equalsIgnoreCase(notProvidedValue)) {
            return "*";
        }
        return value;
    }

    private static com.sas.lsaf.content.repository.RepositoryService doGetService() {
        return ServiceManagerFactory.getApiRepositoryService();
    }

    public static RepositoryItem.Syncable doValidateCopyToWorkspaceStatus(String value) {
        return (RepositoryItem.Syncable)ValidationUtils.validateUpcasedEnum(value, "Workspace status", RepositoryItem.Syncable.class);
    }

    private static Integer doValidateVersionLimit(String type, String versionLimit) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)versionLimit)) || NOT_PROVIDED.equals(versionLimit)) {
            return null;
        }
        try {
            return Integer.parseInt(versionLimit);
        }
        catch (NumberFormatException e) {
            throw new SasParameterInvalidException(type, null);
        }
    }

    private static RepositoryFile doValidateRepositoryFile(String path) throws RepositoryItemNotFoundException {
        RepositoryItem item = RepositoryService.doGetService().getItem(path);
        if (item instanceof RepositoryContainer) {
            throw new ItemTypeException("This operation cannot be performed on a container.");
        }
        return (RepositoryFile)item;
    }

    private static RepositoryExecutableFile doValidateRepositoryExecutableFile(String path) throws RepositoryItemNotFoundException {
        RepositoryItem item = RepositoryService.doGetService().getItem(path);
        if (!(item instanceof RepositoryExecutableFile)) {
            throw new ItemTypeException("This operation can only be performed on a job file.");
        }
        return (RepositoryExecutableFile)item;
    }

    private static final List<SasItemProperty> doGetSasItemProperties(RepositoryItem rItem) {
        List attrs = rItem.getAttributes();
        attrs.add(new Attribute("type", (Serializable)((Object)rItem.getTypeId())));
        String path = rItem.getPath();
        attrs.add(new Attribute("created", (Serializable)((Object)SasUtils.toSasString(rItem.getCreated()))));
        attrs.add(new Attribute("createdBy", (Serializable)((Object)rItem.getCreatedBy())));
        attrs.add(new Attribute("description", (Serializable)((Object)rItem.getDescription())));
        attrs.add(new Attribute("lastModified", (Serializable)((Object)SasUtils.toSasString(rItem.getLastModified()))));
        attrs.add(new Attribute("lastModifiedBy", (Serializable)((Object)rItem.getLastModifiedBy())));
        attrs.add(new Attribute("name", (Serializable)((Object)rItem.getName())));
        attrs.add(new Attribute("path", (Serializable)((Object)path)));
        attrs.add(new Attribute("propertiesLastModified", (Serializable)((Object)SasUtils.toSasString(rItem.getPropertiesLastModified()))));
        attrs.add(new Attribute("propertiesLastModifiedBy", (Serializable)((Object)rItem.getPropertiesLastModifiedBy())));
        attrs.add(new Attribute("state", (Serializable)((Object)rItem.getState().name())));
        attrs.add(new Attribute("syncable", (Serializable)((Object)rItem.getSyncable().name())));
        if (rItem instanceof RepositoryFile) {
            RepositoryFile rf = (RepositoryFile)rItem;
            attrs.add(new Attribute("version", (Serializable)((Object)rf.getVersion())));
            attrs.add(new Attribute("size", (Serializable)((Object)SasUtils.toSasFormattedFileSize(rf.getSize()))));
            attrs.add(new Attribute("isLocked", (Serializable)((Object)SasUtils.toSasString(rf.isLocked()))));
            attrs.add(new Attribute("digest", (Serializable)((Object)rf.getDigest())));
            boolean isVersioned = rf.isVersioned();
            attrs.add(new Attribute("isVersioned", (Serializable)((Object)SasUtils.toSasString(isVersioned))));
            attrs.add(new Attribute("majorVersionLimit", (Serializable)(isVersioned ? rf.getVersionLimits().getMajorVersionLimit() : "")));
            attrs.add(new Attribute("minorVersionLimit", (Serializable)(isVersioned ? rf.getVersionLimits().getMinorVersionLimit() : "")));
            if (rItem instanceof RepositoryExecutableFile) {
                RepositoryExecutableFile re = (RepositoryExecutableFile)rItem;
                attrs.add(new Attribute("runAsOwner", (Serializable)((Object)SasUtils.toSasString(re.isRunAsOwner()))));
                attrs.add(new Attribute("healthStatus", (Serializable)((Object)SasUtils.toSasString(re.getHealthStatus()))));
                attrs.add(new Attribute("lastRunDate", (Serializable)((Object)SasUtils.toSasString(re.getLastRunDate()))));
            }
        } else {
            RepositoryContainer rc = (RepositoryContainer)rItem;
            attrs.add(new Attribute("defaultMajorVersionLimit", (Serializable)rc.getDefaultVersionLimits().getMajorVersionLimit()));
            attrs.add(new Attribute("defaultMinorVersionLimit", (Serializable)rc.getDefaultVersionLimits().getMinorVersionLimit()));
        }
        return PropertyUtils.doGetSasItemPropsFromAttrs(rItem.getTypeId(), attrs);
    }

    public static String getItemId(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting id for " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryItem ri = RepositoryService.doGetService().getItem(path);
            result.init(0, "Success.");
            return ri.getId();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void createContext(String path, String contextTypeId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating context of type " + contextTypeId + ": " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.assertRequiredType(contextTypeId);
            RepositoryService.doGetService().createContext(path, contextTypeId);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String getContextState(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting state for context " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryContext rc = RepositoryService.doGetService().getContext(path);
            result.init(0, "Success.");
            return rc.getState().name();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void getTopLevelContexts(SasRepositoryItemsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting top level context");
        }
        try {
            List contexts = RepositoryService.doGetService().getTopLevelContexts();
            result.setRepositoryItems(contexts);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void setContextState(String path, String state, String comment, String recursion, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting state for context " + path + " to " + state));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryItem.State cState = (RepositoryItem.State)ValidationUtils.validateUpcasedEnum(state, "State", RepositoryItem.State.class);
            boolean recurse = ValidationUtils.validateBinaryFlagDefaultFalse(recursion, "Recursive");
            String c = ValidationUtils.toJavaString(comment);
            RepositoryService.doGetService().setState(path, cState, c, recurse);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String getParentMembershipContext(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting parent membership context for " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            result.init(0, "Success.");
            RepositoryContext rc = RepositoryService.doGetService().getParentMembershipContext(path);
            return rc.getPath();
        }
        catch (MembershipContextNotFoundException e) {
            return "";
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void createFolder(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating folder " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryService.doGetService().createFolder(path, true);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String createSharedFolder(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating sharedfolder " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositorySharedFolder rsf = RepositoryService.doGetService().createSharedFolder(path);
            result.init(0, "Success.");
            return rsf.getId();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static boolean exists(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking existence of " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            result.init(0, "Success.");
            return RepositoryService.doGetService().exists(path);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return false;
        }
    }

    public static boolean isContainer(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking is container " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryItem r = RepositoryService.doGetService().getItem(path);
            result.init(0, "Success.");
            return r instanceof RepositoryContainer;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static boolean isSharedFolder(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking is shared folder " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryItem r = RepositoryService.doGetService().getItem(path);
            result.init(0, "Success.");
            return r instanceof RepositorySharedFolder;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void delete(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryService.doGetService().delete(path);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void deleteVersion(String path, String version, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting version " + version + " of " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.validateRequiredParameter(version, "Version");
            List info = RepositoryService.doGetService().deleteVersions(path, new HashSet<String>(Arrays.asList(version)));
            VersionDeleteInfo.DeleteStatus status = ((VersionDeleteInfo)info.get(0)).getDeleteStatus();
            if (!VersionDeleteInfo.DeleteStatus.DELETED.equals((Object)status)) {
                throw new SasDeleteVersionException(status, version);
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void permanentlyDelete(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Permanently deleting " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryService.doGetService().permanentlyDelete(path);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String rename(String sourcePath, String newName, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming item from " + sourcePath + " to " + PathUtils.getParentPath(sourcePath) + "/" + newName));
        }
        try {
            ValidationUtils.validateRequiredParameter(sourcePath, "Source path");
            ValidationUtils.validateRequiredParameter(newName, "New name");
            RepositoryItem item = RepositoryService.doGetService().rename(sourcePath, newName);
            result.init(0, "Success.");
            return item.getPath();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String getItemType(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting item type for " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            result.init(0, "Success.");
            RepositoryItem r = RepositoryService.doGetService().getItem(path);
            return r.getTypeId();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return null;
        }
    }

    public static String getJobHealthStatus(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting job health status for " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryExecutableFile job = RepositoryService.doValidateRepositoryExecutableFile(path);
            result.init(0, "Success.");
            return job.getHealthStatus().toString();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void move(String sourcePath, String destinationPath, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Moving item from " + sourcePath + " to " + destinationPath));
        }
        try {
            ValidationUtils.validateRequiredParameter(sourcePath, "Source path");
            ValidationUtils.validateRequiredParameter(destinationPath, "Target path");
            RepositoryService.doGetService().move(sourcePath, destinationPath);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void copy(String sourcePath, String destinationPath, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Copying item from " + sourcePath + " to " + destinationPath));
        }
        try {
            ValidationUtils.validateRequiredParameter(sourcePath, "Source path");
            ValidationUtils.validateRequiredParameter(destinationPath, "Target path");
            RepositoryService.doGetService().copy(sourcePath, destinationPath);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getProperties(String path, String version, SasRepositoryItemPropertiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting properties for " + path));
        }
        try {
            List<SasItemProperty> properties;
            com.sas.lsaf.content.repository.RepositoryService srv = RepositoryService.doGetService();
            ValidationUtils.assertRequiredPath(path);
            RepositoryItem rItem = srv.getItem(path);
            if (rItem instanceof RepositoryFile) {
                RepositoryFile rFile = (RepositoryFile)rItem;
                if (!ValidationUtils.valueIsMissing((Serializable)((Object)version))) {
                    rFile = srv.getFileVersion(path, version);
                }
                properties = RepositoryService.doGetSasItemProperties((RepositoryItem)rFile);
            } else {
                properties = RepositoryService.doGetSasItemProperties(rItem);
            }
            result.setProperties(properties);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateProperties(String path, SasProperties properties, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating properties for " + path));
        }
        try {
            com.sas.lsaf.content.repository.RepositoryService srv = RepositoryService.doGetService();
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.assertRequiredSasProperties(properties);
            RepositoryItem r = srv.getItem(path);
            PropertyUtils.updateIdentifiablePropertiesByType((AbstractIdentifiable)r, r.getAttributes(), properties);
            srv.updateItem(r);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isVersioned(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking is versioned " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryFile r = RepositoryService.doValidateRepositoryFile(path);
            result.init(0, "Success.");
            return r.isVersioned();
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void getVersions(String path, SasRepositoryVersionsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting version information for " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            List rfvi = RepositoryService.doGetService().getFileVersionInfos(path);
            result.setVersionInfo(rfvi);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void enableVersioning(String path, String comment, String startingVersion, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Enable versioning for file" + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            String sv = ValidationUtils.toJavaString(startingVersion);
            RepositoryService.doGetService().enableVersioning(path, sv, comment);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void disableVersioning(String path, String comment, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Disable versioning for file" + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryService.doGetService().disableVersioning(path, comment);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String getCopyToWorkspaceStatus(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting copy to workspace property for " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryItem r = RepositoryService.doGetService().getItem(path);
            result.init(0, "Success.");
            return r.getSyncable().name();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return null;
        }
    }

    public static void updateCopyToWorkspaceStatus(String path, String status, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating workspace property for " + path));
        }
        try {
            com.sas.lsaf.content.repository.RepositoryService srv = RepositoryService.doGetService();
            ValidationUtils.assertRequiredPath(path);
            RepositoryItem.Syncable sync = RepositoryService.doValidateCopyToWorkspaceStatus(status);
            RepositoryItem r = srv.getItem(path);
            r.setSyncable(sync);
            srv.updateItem(r);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void copyFileToWorkspace(String path, String version, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Get repository file to workspace:" + path));
        }
        try {
            boolean versionSupplied;
            ValidationUtils.assertRequiredPath(path);
            RepositoryFile file = RepositoryService.doValidateRepositoryFile(path);
            boolean bl = versionSupplied = !ValidationUtils.valueIsMissing((Serializable)((Object)version));
            if (file.isVersioned() && versionSupplied) {
                RepositoryService.doGetService().copySpecificFileVersionToWorkspace(path, version);
            } else {
                RepositoryService.doGetService().copyLatestFileVersionToWorkspace(path);
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void checkIn(String path, SasFileCheckinParameters fileParms, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking in file " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryCheckinSpecification rcs = ContentCreationParametersHelper.toRepoCheckinSpec(fileParms);
            RepositoryService.doGetService().checkin(path, rcs);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void checkOut(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking out file " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryService.doGetService().checkout(path);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void undoCheckOut(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Undo Check out for file " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryService.doGetService().undoCheckout(path);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isCheckedOut(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking is checked out " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryFile r = RepositoryService.doValidateRepositoryFile(path);
            result.init(0, "Success.");
            return r.isCheckedOut();
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void getCheckedOutFiles(String userId, String name, String location, SasCheckedOutFilesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting checked out files from the repository");
        }
        String userIdu = RepositoryService.validateSearchParameter(userId, NOT_PROVIDED);
        String nameu = RepositoryService.validateSearchParameter(name, NOT_PROVIDED);
        String locationu = RepositoryService.validateSearchParameter(location, NOT_PROVIDED);
        try {
            com.sas.lsaf.content.repository.RepositoryService srv = RepositoryService.doGetService();
            CheckedOutFilesQuery arg = new CheckedOutFilesQuery(userIdu, nameu, locationu);
            SearchResultsInfo sri = srv.searchCheckedOutFiles(arg);
            result.setLimitReached(sri.isLimitReached());
            if (sri.getRowCount() > 0) {
                int max = srv.getPageSizeLimit();
                int callRecords = sri.getRowCount() > max ? max : sri.getRowCount();
                List si = srv.getCheckedOutFilesSearchResults(1, callRecords);
                result.setCheckedOutFiles(si);
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void search(String location, String name, String typeId, String owner, String lastModifiedBy, String createdBy, String fromCreated, String toCreated, String fromLastModified, String toLastModified, String content, String copyToWorkspaceStatus, SasRepositoryItemsSearchResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Searching repository.");
        }
        try {
            SearchQuery query = new SearchQuery();
            query.setLocation(ValidationUtils.toJavaString(location));
            query.setName(ValidationUtils.toJavaString(name));
            query.setTypeId(ValidationUtils.toJavaString(typeId));
            query.setOwner(ValidationUtils.toJavaString(owner));
            query.setLastModifiedBy(ValidationUtils.toJavaString(lastModifiedBy));
            query.setCreatedBy(ValidationUtils.toJavaString(createdBy));
            query.setFromCreated(ValidationUtils.validateDateString("From created", fromCreated));
            query.setToCreated(ValidationUtils.validateDateString("To created", toCreated));
            query.setFromLastModifiedDate(ValidationUtils.validateDateString("From last modified", fromLastModified));
            query.setToLastModifiedDate(ValidationUtils.validateDateString("TO last modified", toLastModified));
            query.setContent(ValidationUtils.toJavaString(content));
            if (!ValidationUtils.valueIsMissing((Serializable)((Object)copyToWorkspaceStatus))) {
                query.setCopyToWorkspaceStatus(RepositoryService.doValidateCopyToWorkspaceStatus(copyToWorkspaceStatus));
            }
            RepositorySearchResults searchResults = RepositoryService.doGetService().search(query);
            result.setRepositoryItems(searchResults.getSearchResults(), searchResults.isLimitReached());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getChildren(String path, String recursion, SasRepositoryItemsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting children for " + path + " with a depth of " + recursion));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            int depth = ValidationUtils.validateRecursionGetChildren(recursion);
            RepositoryItem item = RepositoryService.doGetService().getItem(path);
            if (!(item instanceof RepositoryContainer)) {
                throw new ItemTypeException("This operation can only be performed on a container.");
            }
            ArrayList<RepositoryItem> children = new ArrayList<RepositoryItem>();
            children.add(item);
            if (depth > 0) {
                children.addAll(RepositoryUtils.getChildren((RepositoryContainer)item, depth));
            }
            result.setRepositoryItems(children);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void createFile(String localFilePath, String path, String versioning, String startingVersion, String comment, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating file " + path + " from " + localFilePath + " (versioning=" + versioning + ", startingVersion=" + startingVersion + ", comment=" + comment + ")"));
        }
        try {
            ValidationUtils.validateInvalidTrustedLsafSessionOperation();
            ValidationUtils.validateRequiredParameter(localFilePath, "Local path");
            ValidationUtils.assertRequiredPath(path);
            boolean isVersioned = ValidationUtils.validateBinaryFlagDefaultFalse(versioning, "Versioning");
            if (isVersioned) {
                String stVersion = ValidationUtils.toJavaString(startingVersion);
                RepositoryService.doGetService().createVersionedFile(path, localFilePath, comment, stVersion, true);
            } else {
                RepositoryService.doGetService().createFile(path, localFilePath, comment, true);
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateFile(String localFilePath, String path, SasFileCheckinParameters checkInParms, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating file " + path + " from " + localFilePath));
        }
        try {
            ValidationUtils.validateInvalidTrustedLsafSessionOperation();
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.validateRequiredParameter(localFilePath, "Local path");
            RepositoryCheckinSpecification rcs = ContentCreationParametersHelper.toRepoCheckinSpec(checkInParms);
            RepositoryService.doGetService().updateFileContents(path, rcs, localFilePath);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void downloadFile(String path, String version, String localFilePath, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Downloading " + path + " version " + version + " to local path " + localFilePath));
        }
        try {
            ValidationUtils.validateInvalidTrustedLsafSessionOperation();
            ValidationUtils.assertRequiredPath(path);
            ValidationUtils.validateRequiredParameter(localFilePath, "Local path");
            String v = ValidationUtils.valueIsMissing((Serializable)((Object)version)) ? null : version;
            RepositoryService.doGetService().downloadFile(path, v, localFilePath);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void lockFile(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Locking file" + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryService.doGetService().lockFile(path);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void unlockFile(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unlocking file" + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryService.doGetService().unlockFile(path);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isFileLocked(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking file is locked " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryFile r = RepositoryService.doValidateRepositoryFile(path);
            result.init(0, "Success.");
            return r.isLocked();
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void getSynchInfo(String path, SasSyncPropertiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting synchronization information for " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            result.setSyncProperties(RepositoryService.doGetService().getSynchronizationInfo(path));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateVersionLimits(String path, String major, String minor, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting version limits on " + path));
        }
        try {
            VersionLimits vl;
            ValidationUtils.assertRequiredPath(path);
            if (NOT_PROVIDED.equals(major) && NOT_PROVIDED.equals(minor)) {
                throw new ResultException(-1, "A version limit must be provided.");
            }
            Integer validatedLimitMajor = RepositoryService.doValidateVersionLimit("Major version limit", major);
            Integer validatedLimitMinor = RepositoryService.doValidateVersionLimit("Minor version limit", minor);
            RepositoryItem item = RepositoryService.doGetService().getItem(path);
            boolean isContainer = item instanceof RepositoryContainer;
            VersionLimits versionLimits = vl = isContainer ? ((RepositoryContainer)item).getDefaultVersionLimits() : ((RepositoryFile)item).getVersionLimits();
            if (vl == null) {
                vl = new VersionLimits(null, null);
                if (isContainer) {
                    ((RepositoryContainer)item).setDefaultVersionLimits(vl);
                } else {
                    ((RepositoryFile)item).setVersionLimits(vl);
                }
            }
            if (!NOT_PROVIDED.equals(major)) {
                vl.setMajorVersionLimit(validatedLimitMajor);
            }
            if (!NOT_PROVIDED.equals(minor)) {
                vl.setMinorVersionLimit(validatedLimitMinor);
            }
            RepositoryService.doGetService().updateItem(item);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

