/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.content.repository;

import com.sas.lsaf.content.repository.RepositoryCheckinSpecification;
import com.sas.lsaf.core.action.ActionStatus;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.result.SasActionStatusResult;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.ContentCreationParametersHelper;
import com.sas.lsaf.macro.content.repository.SasFileCheckinParameters;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BatchRepositoryService {
    private static final Log LOG = LogFactory.getLog(BatchRepositoryService.class);
    private static BatchRepositoryService FOR_COVERAGE = new BatchRepositoryService();

    private BatchRepositoryService() {
    }

    private static com.sas.lsaf.content.repository.BatchRepositoryService doGetService() {
        return ServiceManagerFactory.getApiBatchRepositoryService();
    }

    public static void downloadAsZip(String path, String localFilePath, String overwrite, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Downloading " + path + " as a zip file to local path " + localFilePath));
        }
        try {
            ValidationUtils.validateInvalidTrustedLsafSessionOperation();
            ValidationUtils.validateRequiredParameter(path, "Path");
            boolean overwriteLocalFile = ValidationUtils.validateBinaryFlagDefaultFalse(overwrite, "Overwrite file");
            ValidationUtils.validateRequiredParameter(localFilePath, "Local path");
            HashSet<String> zipPaths = new HashSet<String>();
            zipPaths.add(path);
            BatchRepositoryService.doGetService().downloadAsZip(zipPaths, localFilePath, overwriteLocalFile);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void uploadAndExpand(String localZipFilePath, String parentPath, SasFileCheckinParameters checkInParms, SasActionStatusResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Uploading and expanding " + localZipFilePath + " to " + parentPath));
        }
        try {
            ValidationUtils.validateInvalidTrustedLsafSessionOperation();
            ValidationUtils.validateRequiredParameter(parentPath, "Path");
            ValidationUtils.validateRequiredParameter(localZipFilePath, "Local path");
            RepositoryCheckinSpecification rcs = ContentCreationParametersHelper.toRepoCheckinSpec(checkInParms);
            ActionStatus as = BatchRepositoryService.doGetService().uploadAndExpand(parentPath, localZipFilePath, rcs.isEnableVersioningForNewFiles(), rcs, true);
            result.setActionStatus(as);
            result.init(0, as.getCompletionMessage());
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

