/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.content;

import com.sas.lsaf.clinical.common.BatchFileCreateInfo;
import com.sas.lsaf.clinical.common.ExportFileCreateInfo;
import com.sas.lsaf.content.common.FileCreateInfo;
import com.sas.lsaf.content.repository.RepositoryCheckinSpecification;
import com.sas.lsaf.content.repository.VersionType;
import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.utils.PathUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.SasBatchFileCreateParameters;
import com.sas.lsaf.macro.content.SasFileCreateParameters;
import com.sas.lsaf.macro.content.repository.SasFileCheckinParameters;
import com.sas.lsaf.query.ExtractFileCreateInfo;
import java.io.Serializable;

public class ContentCreationParametersHelper {
    private static void doSetFileCreateInfo(FileCreateInfo info, SasFileCreateParameters fcp, SourceLocation srcLoc) {
        String vt;
        String ow = fcp.getOverwrite();
        if (!ValidationUtils.valueIsMissing((Serializable)((Object)ow))) {
            info.setOverwrite(ValidationUtils.validateBinaryFlag(ow, "Overwrite file"));
        }
        if (SourceLocation.WORKSPACE.equals((Object)srcLoc)) {
            return;
        }
        info.setComment(fcp.getComment());
        String ev = fcp.getEnableVersioning();
        if (!ValidationUtils.valueIsMissing((Serializable)((Object)ev))) {
            info.setEnableVersioning(ValidationUtils.validateBinaryFlag(ev, "Versioning"));
        }
        if (!ValidationUtils.valueIsMissing((Serializable)((Object)(vt = fcp.getVersionType())))) {
            info.setVersionType(ContentCreationParametersHelper.validateVersionTypeWithCustom(vt, fcp.getCustomVersion()));
        }
        info.setCustomVersion(fcp.getCustomVersion());
    }

    private static BatchFileCreateInfo doGetBatchFileCreateInfo(SasBatchFileCreateParameters bp) {
        SourceLocation sl = ValidationUtils.validateSourceLocation(bp.location);
        BatchFileCreateInfo info = new BatchFileCreateInfo(bp.getPath(), sl);
        String ow = bp.getOverwrite();
        if (!ValidationUtils.valueIsMissing((Serializable)((Object)ow))) {
            info.setOverwrite(ValidationUtils.validateBinaryFlag(ow, "Overwrite file"));
        }
        if (SourceLocation.REPOSITORY.equals((Object)sl)) {
            info.setComment(bp.getComment());
            String ev = bp.getEnableVersioning();
            if (!ValidationUtils.valueIsMissing((Serializable)((Object)ev))) {
                info.setEnableVersioning(ValidationUtils.validateBinaryFlag(ev, "Versioning"));
            }
            if (info.isEnableVersioning()) {
                if (!ValidationUtils.valueIsMissing((Serializable)((Object)bp.getVersionType()))) {
                    info.setVersionTypeForNewFiles(ContentCreationParametersHelper.validateVersionTypeWithCustom(bp.getVersionType(), bp.getCustomVersion()));
                }
                info.setCustomVersionForNewFiles(bp.getCustomVersion());
            }
            String vtForExisting = bp.getVersionTypeForExistingFiles();
            String cvForExisting = bp.getCustomVersionForExistingFiles();
            if (!ValidationUtils.valueIsMissing((Serializable)((Object)vtForExisting))) {
                info.setVersionTypeForExistingFiles(ContentCreationParametersHelper.validateVersionTypeWithCustom(vtForExisting, cvForExisting));
            }
            info.setCustomVersionForExistingFiles(cvForExisting);
        }
        return info;
    }

    public static VersionType validateVersionType(String value) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value))) {
            return null;
        }
        return (VersionType)ValidationUtils.validateUpcasedEnum(value, "Version type", VersionType.class);
    }

    public static VersionType validateVersionTypeWithCustom(String versionType, String customVersion) {
        VersionType vtype = ContentCreationParametersHelper.validateVersionType(versionType);
        if (VersionType.CUSTOM.equals((Object)vtype)) {
            ValidationUtils.validateRequiredString(customVersion, "Version is required when requesting a custom version.");
        }
        return vtype;
    }

    public static FileCreateInfo toFileCreateInfo(SasFileCreateParameters fcp) {
        String path = ValidationUtils.assertRequiredPath(fcp.getPath());
        FileCreateInfo info = new FileCreateInfo(PathUtils.getParentPath(path), PathUtils.getName(path));
        ContentCreationParametersHelper.doSetFileCreateInfo(info, fcp, null);
        return info;
    }

    public static ExtractFileCreateInfo toExtractFileCreateInfo(SasFileCreateParameters fcp) {
        String path = ValidationUtils.validateRequiredParameter(fcp.getPath(), "Export path");
        SourceLocation sl = ValidationUtils.validateSourceLocation(fcp.location);
        ExtractFileCreateInfo info = new ExtractFileCreateInfo(path, sl);
        ContentCreationParametersHelper.doSetFileCreateInfo((FileCreateInfo)info, fcp, sl);
        return info;
    }

    public static ExportFileCreateInfo toExportFileCreateInfo(SasFileCreateParameters fcp) {
        String path = ValidationUtils.validateRequiredParameter(fcp.getPath(), "Export path");
        SourceLocation sl = ValidationUtils.validateSourceLocation(fcp.location);
        ExportFileCreateInfo info = new ExportFileCreateInfo(path, sl);
        ContentCreationParametersHelper.doSetFileCreateInfo((FileCreateInfo)info, fcp, sl);
        return info;
    }

    public static ExportFileCreateInfo toClinicalImportValidationReportInfo(SasFileCreateParameters fcp) {
        boolean locIsMissing;
        SourceLocation sl = (SourceLocation)ValidationUtils.validateNotRequiredEnum(fcp.getLocation(), "Location", SourceLocation.class, true);
        String path = fcp.getPath();
        boolean pathIsMissing = ValidationUtils.valueIsMissing((Serializable)((Object)path));
        boolean bl = locIsMissing = sl == null;
        if (!locIsMissing && !pathIsMissing) {
            ExportFileCreateInfo info = new ExportFileCreateInfo(path, sl);
            ContentCreationParametersHelper.doSetFileCreateInfo((FileCreateInfo)info, fcp, sl);
            return info;
        }
        if (locIsMissing && pathIsMissing && ValidationUtils.valueIsMissing((Serializable)((Object)fcp.getEnableVersioning())) && ValidationUtils.valueIsMissing((Serializable)((Object)fcp.getOverwrite())) && ValidationUtils.valueIsMissing((Serializable)((Object)fcp.getVersionType())) && ValidationUtils.valueIsMissing((Serializable)((Object)fcp.getCustomVersion())) && ValidationUtils.valueIsMissing((Serializable)((Object)fcp.getComment()))) {
            return null;
        }
        throw new ResultException("Unable to determine validation report creation.  To create the report, report location and path are required. For no report, omit all report information.");
    }

    public static BatchFileCreateInfo toBatchFileCreateInfo(SasBatchFileCreateParameters bp) {
        bp.setPath(ValidationUtils.validateRequiredParameter(bp.getPath(), "Path"));
        return ContentCreationParametersHelper.doGetBatchFileCreateInfo(bp);
    }

    public static BatchFileCreateInfo toBatchFileCreateInfoWithPrefix(SasBatchFileCreateParameters batchParms) {
        batchParms.setPath(ValidationUtils.assertRequiredPath(batchParms.getPath()) + "/" + ValidationUtils.validateRequiredParameter(batchParms.getPrefix(), "Prefix"));
        return ContentCreationParametersHelper.toBatchFileCreateInfo(batchParms);
    }

    public static RepositoryCheckinSpecification toRepoCheckinSpec(SasFileCheckinParameters cParms) {
        RepositoryCheckinSpecification spec = new RepositoryCheckinSpecification();
        String ev = cParms.getEnableVersioning();
        if (!ValidationUtils.valueIsMissing((Serializable)((Object)ev))) {
            spec.setEnableVersioningForNewFiles(ValidationUtils.validateBinaryFlag(ev, "Versioning"));
        }
        String vt = cParms.getVersionType();
        String cv = cParms.getCustomVersion();
        if (!ValidationUtils.valueIsMissing((Serializable)((Object)vt))) {
            spec.setVersionType(ContentCreationParametersHelper.validateVersionTypeWithCustom(vt, cv));
        }
        spec.setCustomVersion(cv);
        spec.setComment(cParms.getComment());
        return spec;
    }
}

