/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.common.utils.validation;

import com.sas.lsaf.core.EntityStatus;
import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.execution.job.JobParameter;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.SasDataList;
import com.sas.lsaf.macro.common.SasProperties;
import com.sas.lsaf.macro.common.utils.DateFormatUtils;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.StringUtils;
import com.sas.lsaf.macro.common.utils.validation.SasDataTypeException;
import com.sas.lsaf.macro.common.utils.validation.SasParameterInvalidException;
import com.sas.lsaf.macro.common.utils.validation.SasParameterRequiredException;
import com.sas.lsaf.macro.common.utils.validation.SasRequiredInputDataMissingException;
import com.sas.lsaf.macro.content.RecursionException;
import com.sas.lsaf.macro.security.authentication.LsafAuthenticationException;
import com.sas.lsaf.macro.security.authentication.LsafSessionHolder;
import com.sas.lsaf.macro.security.authentication.LsafSessionMissingException;
import com.sas.lsaf.workflow.AutoFlowType;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.EnumUtils;

public final class ValidationUtils {
    private static ValidationUtils FOR_COVERAGE = new ValidationUtils();

    private ValidationUtils() {
    }

    public static final <V extends Enum<V>> Enum<?> validateNotRequiredEnum(String value, String type, Class<V> eClass, boolean upcaseValue) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value))) {
            return null;
        }
        String finalValue = upcaseValue ? value.toUpperCase().trim() : value.trim();
        try {
            return Enum.valueOf(eClass, finalValue);
        }
        catch (RuntimeException rx) {
            String validValues = SasUtils.toSasCommaDelimitedString(EnumUtils.getEnumList(eClass));
            ValidationUtils.handleInvalidParameterValue(validValues, type);
            return null;
        }
    }

    public static final <V extends Enum<V>> Enum<?> validateEnum(String value, String type, Class<V> eClass, boolean upcaseValue) {
        ValidationUtils.validateRequiredParameter(value, type);
        return ValidationUtils.validateNotRequiredEnum(value, type, eClass, upcaseValue);
    }

    public static final <V extends Enum<V>> Enum<?> validateUpcasedEnum(String value, String type, Class<V> eClass) {
        return ValidationUtils.validateEnum(value, type, eClass, true);
    }

    public static void validateInvalidTrustedLsafSessionOperation() {
        if (LsafSessionHolder.isTrusted()) {
            throw new LsafAuthenticationException("This macro is not allowed when running in an active SAS Life Science Analytics Framework session.");
        }
    }

    public static void validateHaveLsafSession() {
        if (!LsafSessionHolder.hasSession()) {
            throw new LsafSessionMissingException();
        }
    }

    public static boolean valueIsMissing(Serializable value) {
        return value == null || value.toString().trim().length() == 0;
    }

    public static String toJavaString(String value) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value))) {
            return null;
        }
        return value.trim();
    }

    public static boolean validateBinaryFlag(String value, String type) {
        if ("0".equals(value)) {
            return false;
        }
        if ("1".equals(value)) {
            return true;
        }
        ValidationUtils.handleInvalidParameterValue("0, 1", type);
        return false;
    }

    public static boolean validateBinaryFlagDefaultFalse(String value, String type) {
        String flag = ValidationUtils.valueIsMissing((Serializable)((Object)value)) ? "0" : value;
        return ValidationUtils.validateBinaryFlag(flag, type);
    }

    public static boolean validateBinaryFlagDefaultTrue(String value, String type) {
        String flag = ValidationUtils.valueIsMissing((Serializable)((Object)value)) ? "1" : value;
        return ValidationUtils.validateBinaryFlag(flag, type);
    }

    public static boolean validateBinaryFlagRequired(String value, String type) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value))) {
            throw new SasParameterRequiredException(type);
        }
        return ValidationUtils.validateBinaryFlag(value, type);
    }

    public static boolean validateBinaryFlagQuietly(String value) {
        try {
            return ValidationUtils.validateBinaryFlagDefaultFalse(value, null);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String validateRequiredParameter(String value, String type) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value))) {
            throw new SasParameterRequiredException(type);
        }
        return value.trim();
    }

    public static void validateRequiredString(String value, String message) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value))) {
            throw new ResultException(message);
        }
    }

    public static byte[] assertRequiredPassword(String value) {
        ValidationUtils.validateRequiredParameter(value, "Password");
        return StringUtils.trim(value).getBytes();
    }

    public static String assertRequiredPath(String value) {
        return ValidationUtils.validateRequiredParameter(value, "Path");
    }

    public static void assertRequiredPrivilege(String value) {
        ValidationUtils.validateRequiredParameter(value, "Privilege");
    }

    public static void assertRequiredSasInputDataList(String type, SasDataList list) {
        if (list == null) {
            throw new SasParameterRequiredException(type);
        }
        if (list.getSize() == 0) {
            throw new SasRequiredInputDataMissingException(type);
        }
    }

    public static void assertRequiredSasProperties(SasProperties props) {
        ValidationUtils.assertRequiredSasInputDataList("Update properties", props);
    }

    public static void assertRequiredType(String value) {
        ValidationUtils.validateRequiredParameter(value, "Type");
    }

    public static void assertRequiredUserId(String value) {
        ValidationUtils.validateRequiredParameter(value, "User id");
    }

    public static void handleInvalidOptionalParameterValue(String validValues, String type) {
        throw new SasParameterInvalidException(type, validValues, true);
    }

    public static void handleInvalidParameterValue(String validValues, String type) {
        throw new SasParameterInvalidException(type, validValues);
    }

    public static AutoFlowType validateAutoFlowType(String autoFlowType, boolean isRequired) {
        AutoFlowType type = (AutoFlowType)ValidationUtils.validateNotRequiredEnum(autoFlowType, "Autoflow type", AutoFlowType.class, true);
        if (type == null && isRequired) {
            return AutoFlowType.TLF;
        }
        return type;
    }

    public static EntityStatus validateEntityStatus(String value) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value))) {
            return EntityStatus.PUBLISHED;
        }
        return (EntityStatus)ValidationUtils.validateUpcasedEnum(value, "Status", EntityStatus.class);
    }

    public static JobParameter.ParameterType validateJobParameterType(String value) {
        return (JobParameter.ParameterType)ValidationUtils.validateUpcasedEnum(value, "Job parameter type", JobParameter.ParameterType.class);
    }

    public static SourceLocation validateSourceLocation(String value) {
        return (SourceLocation)ValidationUtils.validateUpcasedEnum(value, "Location", SourceLocation.class);
    }

    public static void assertRequiredStudyBaseParameters(String studyId, String baseStandardName, String modelId) {
        ValidationUtils.validateRequiredParameter(studyId, "Study id");
        ValidationUtils.validateRequiredParameter(baseStandardName, "Base standard name");
        ValidationUtils.validateRequiredParameter(modelId, "Model id");
    }

    public static boolean validateBooleanProperty(String name, String value) {
        try {
            return ValidationUtils.validateBinaryFlagDefaultFalse(value, name);
        }
        catch (Exception e) {
            throw new SasDataTypeException(name, SasDataTypeException.SasDataType.BOOLEAN);
        }
    }

    public static Date validateDate(String name, String date) {
        Date validDate = DateFormatUtils.getDateValueFromValidFormat(date.trim());
        if (validDate == null) {
            throw new SasDataTypeException(name, SasDataTypeException.SasDataType.DATE);
        }
        return validDate;
    }

    public static Date validateDateString(String name, String date) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)date))) {
            return null;
        }
        return ValidationUtils.validateDate(name, date);
    }

    public static Date validateRequiredDateString(String name, String date) {
        ValidationUtils.validateRequiredParameter(date, name);
        return ValidationUtils.validateDate(name, date);
    }

    public static float validateRequiredFloat(String name, String value) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value))) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (Exception e) {
            throw new SasParameterInvalidException(name, null);
        }
    }

    public static int validateIntegerValue(String name, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SasDataTypeException(name, SasDataTypeException.SasDataType.INTEGER);
        }
    }

    public static int validateRequiredIntegerValue(String name, String value) {
        ValidationUtils.validateRequiredParameter(value, name);
        return ValidationUtils.validateIntegerValue(name, value);
    }

    public static Long validateLongValue(String name, String numValue) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)numValue))) {
            return null;
        }
        try {
            return Long.parseLong(numValue.trim());
        }
        catch (NumberFormatException e) {
            throw new SasDataTypeException(name, SasDataTypeException.SasDataType.LONG);
        }
    }

    public static Serializable toJavaSerializable(String name, String value, String type) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value))) {
            return null;
        }
        switch (type.toUpperCase()) {
            case "BOOLEAN": {
                return Boolean.valueOf(ValidationUtils.validateBooleanProperty(name, value));
            }
            case "DATE": {
                return ValidationUtils.validateDateString(name, value);
            }
            case "LONG": {
                return ValidationUtils.validateLongValue(name, value);
            }
        }
        return value.trim();
    }

    public static int validateRecursionGetChildren(String recursion) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)recursion))) {
            return 0;
        }
        try {
            int r = Integer.parseInt(recursion);
            if (-1 >= r || r >= 100) {
                throw new RecursionException();
            }
            return r;
        }
        catch (NumberFormatException e) {
            throw new RecursionException();
        }
    }
}

