/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.common.utils.validation;

public class SasParameterInvalidException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String parameter;
    private final String validValues;
    private boolean optional = false;
    public static final String PARAMETER_IS_INVALID_TEXT = "Invalid value specified for ";
    public static final String PARAMETER_VALID_VALUES_TEXT = "Valid values are: ";
    public static final String OPTIONAL_PARAMETER_IS_INVALID_TEXT = "Invalid value specified for optional parameter ";
    public static final String OPTIONAL_PARAMETER_VALID_VALUES_TEXT = "Omit the parameter or use valid value. ";

    public SasParameterInvalidException(String parm, String values) {
        this.parameter = parm;
        this.validValues = values;
    }

    public SasParameterInvalidException(String parm, String values, boolean parmIsOptional) {
        this.parameter = parm;
        this.validValues = values;
        this.optional = parmIsOptional;
    }

    @Override
    public String getLocalizedMessage() {
        Object msg = SasParameterInvalidException.getInvalidValueMessage(this.parameter, this.optional);
        if (this.validValues != null) {
            msg = (String)msg + " Valid values are: " + this.validValues;
        }
        return msg;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String getValidValues() {
        return this.validValues;
    }

    public static String getInvalidValueMessage(String parameter) {
        return SasParameterInvalidException.getInvalidValueMessage(parameter, false);
    }

    public static String getInvalidValueMessage(String parameter, boolean optional) {
        String message = (optional ? OPTIONAL_PARAMETER_IS_INVALID_TEXT : PARAMETER_IS_INVALID_TEXT) + parameter.toLowerCase() + ".";
        if (optional) {
            message = message + " Omit the parameter or use valid value. ";
        }
        return message;
    }
}

