/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.common.utils.validation;

import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import java.io.Serializable;

public class SasDataTypeException
extends ResultException {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_INVALID_VALUE_MESSAGE = "A supplied value is not valid for the expected data type.";
    public static final String INVALID_TYPE_VALUE_MESSAGE = "A supplied value is not valid for type ";
    public static final String DATE_FORMAT_MESSAGE = "Dates must be in SAS datetime20. or E8601DZ25. format (e.g., 05NOV2012:09:23:12 or 2012-11-05T09:23:12-04:00).";
    public static final String BOOLEAN_FORMAT_MESSAGE = "Valid values are: 0, 1";
    private String name;
    private SasDataType type;

    public SasDataTypeException(String name, SasDataType type) {
        super(DEFAULT_INVALID_VALUE_MESSAGE);
        this.name = name;
        this.type = type;
    }

    @Override
    public String getMessage() {
        return SasDataTypeException.getDerivedMessage(this.getTypeAsString(), this.getName());
    }

    public static String getDerivedMessage(String type, String name) {
        StringBuffer buf = new StringBuffer();
        if (ValidationUtils.valueIsMissing((Serializable)((Object)name))) {
            buf.append(INVALID_TYPE_VALUE_MESSAGE);
        } else {
            buf.append("The value supplied for ");
            buf.append(name.toLowerCase());
            buf.append(" is not valid for type ");
        }
        buf.append(type);
        buf.append(".");
        if (SasDataType.DATE.name().equals(type)) {
            buf.append(" Dates must be in SAS datetime20. or E8601DZ25. format (e.g., 05NOV2012:09:23:12 or 2012-11-05T09:23:12-04:00).");
        } else if (SasDataType.BOOLEAN.name().equals(type)) {
            buf.append(" Valid values are: 0, 1");
        }
        return buf.toString();
    }

    public String getName() {
        return this.name;
    }

    public SasDataType getType() {
        return this.type;
    }

    public String getTypeAsString() {
        return this.type.name();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(SasDataType t) {
        this.type = t;
    }

    public static enum SasDataType {
        BOOLEAN,
        DATE,
        FLOAT,
        INTEGER,
        LONG,
        NUMERIC;

    }
}

