/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.common.utils;

import com.sas.lsaf.core.Attribute;
import com.sas.lsaf.core.type.AttributeDefinition;
import com.sas.lsaf.execution.job.JobInput;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.security.principal.Principal;
import com.sas.lsaf.security.user.UserDescriptor;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.springframework.util.CollectionUtils;

public final class SasUtils {
    public static final String NULL_STRING = "";
    public static final String TRUE = "1";
    public static final String FALSE = "0";
    public static final String FORMAT_SASDATE = "ddMMMyyyy:HH:mm:ss";
    public static final String FORMAT_DATE = "EEE MMM dd HH:mm:ss zzz yyyy";
    public static final String FORMAT_DURATION = "HH:mm:ss:SSS";
    private static final String SPACE = " ";
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static SasUtils FOR_COVERAGE = new SasUtils();
    public static String[] fileSizeLabels = new String[]{"bytes", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};

    private SasUtils() {
    }

    public static int toSasInteger(boolean b) {
        return Integer.valueOf(SasUtils.toSasString(b));
    }

    public static String toSasString(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static String toSasString(String s) {
        return ValidationUtils.valueIsMissing((Serializable)((Object)s)) ? NULL_STRING : s.trim();
    }

    public static String toSasString(Date date) {
        if (date == null) {
            return NULL_STRING;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE);
        sdf.setTimeZone(GMT);
        return sdf.format(date);
    }

    public static String toSasString(Enum<?> value) {
        if (value == null) {
            return NULL_STRING;
        }
        return value.name();
    }

    public static String toSasString(Serializable ser) {
        if (ser == null) {
            return NULL_STRING;
        }
        if (ser instanceof Date) {
            return SasUtils.toSasString((Date)ser);
        }
        if (ser instanceof Principal) {
            Principal p = (Principal)ser;
            if (p instanceof UserDescriptor) {
                return ((UserDescriptor)p).getUserId();
            }
            return p.getPrincipalName();
        }
        return SasUtils.toSasString(ser.toString());
    }

    public static String toSasString(Attribute attribute) {
        if (attribute == null) {
            return NULL_STRING;
        }
        return SasUtils.toSasString(attribute.getValue());
    }

    public static String toSasString(Long value) {
        return value == null ? NULL_STRING : value.toString();
    }

    public static String toSasString(int value) {
        String s = String.valueOf(value);
        return s == null ? NULL_STRING : s;
    }

    public static String toSasString(float value) {
        String s = String.valueOf(value);
        return s == null ? NULL_STRING : s;
    }

    public static String toSasDatetimeFormat(String dateString) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)dateString))) {
            return NULL_STRING;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE);
            Date newDate = sdf.parse(dateString);
            return SasUtils.toSasDatetimeFormat(newDate);
        }
        catch (ParseException e) {
            throw new ResultException(-500, "Error parsing date: " + dateString);
        }
    }

    public static String toSasDatetimeFormat(Date date) {
        if (date == null) {
            return NULL_STRING;
        }
        String newDateString = SasUtils.toSasString(date);
        String[] parts = newDateString.split(SPACE);
        return parts[2] + parts[1] + parts[5] + ":" + parts[3];
    }

    public static String toSasPropertyString(String type, String value) {
        if (!ValidationUtils.valueIsMissing((Serializable)((Object)value))) {
            if (AttributeDefinition.AttributeType.DATE.name().equals(type)) {
                return SasUtils.toSasDatetimeFormat(value);
            }
            if (AttributeDefinition.AttributeType.BOOLEAN.name().equals(type)) {
                return SasUtils.toSasString(value.toLowerCase().equals("true") || value.equals(TRUE));
            }
        }
        return value;
    }

    public static String toSasFormattedFileSize(Long bytes) {
        Object sizeToReturn = NULL_STRING;
        if (!ValidationUtils.valueIsMissing(bytes)) {
            double dValue = bytes.doubleValue();
            int index = 0;
            for (index = 0; index < fileSizeLabels.length && !(dValue < 1024.0); dValue /= 1024.0, ++index) {
            }
            DecimalFormat df = new DecimalFormat("#.##");
            String formattedBytes = df.format(dValue);
            sizeToReturn = formattedBytes + SPACE + fileSizeLabels[index];
        }
        return sizeToReturn;
    }

    public static String toSasFormattedDuration(Long time) {
        if (ValidationUtils.valueIsMissing(time)) {
            return NULL_STRING;
        }
        Object formattedTime = DurationFormatUtils.formatDuration((long)time, (String)"HH:mm:ss", (boolean)false);
        String fTime = DurationFormatUtils.formatDuration((long)time, (String)FORMAT_DURATION, (boolean)false);
        Integer milliseconds = Integer.valueOf(fTime.substring(fTime.lastIndexOf(":") + 1));
        formattedTime = (String)formattedTime + ":" + milliseconds.toString();
        return formattedTime;
    }

    public static String toSasFormattedString(Serializable ser) {
        if (ser == null) {
            return NULL_STRING;
        }
        if (ser instanceof Date) {
            return SasUtils.toSasDatetimeFormat((Date)ser);
        }
        if (ser instanceof JobInput) {
            return ((JobInput)ser).getPath();
        }
        return SasUtils.toSasString(ser.toString());
    }

    public static String toSasCommaDelimitedString(Collection<?> coll) {
        if (coll == null || CollectionUtils.isEmpty(coll)) {
            return NULL_STRING;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String[] getArrayFromSasCommaDelimitedString(String commaDelimitedString) {
        return commaDelimitedString.split("\\s*,\\s*");
    }

    public static List<String> getListFromSasCommaDelimitedString(String commaDelimitedString) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)commaDelimitedString))) {
            return new ArrayList<String>();
        }
        return Arrays.asList(SasUtils.getArrayFromSasCommaDelimitedString(commaDelimitedString));
    }
}

