/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.common.utils;

import com.sas.lsaf.content.repository.RepositoryExecutableFile;
import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.core.AbstractIdentifiable;
import com.sas.lsaf.core.Attribute;
import com.sas.lsaf.core.type.AttributeDefinition;
import com.sas.lsaf.core.type.Type;
import com.sas.lsaf.macro.common.SasObjectProperties;
import com.sas.lsaf.macro.common.SasProperties;
import com.sas.lsaf.macro.common.SasProperty;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.repository.SasItemProperty;
import com.sas.lsaf.security.user.AccountInfo;
import com.sas.lsaf.security.user.User;
import com.sas.lsaf.workflow.processflow.ProcessFlow;
import com.sas.lsaf.workflow.processflow.setup.JobTaskSetup;
import com.sas.lsaf.workflow.processflow.setup.NotificationTaskSetup;
import com.sas.lsaf.workflow.processflow.setup.TaskSetup;
import com.sas.lsaf.workflow.processflow.setup.UserTaskSetup;
import com.sas.lsaf.workflow.task.Task;
import com.sas.lsaf.workflow.task.UserTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class PropertyUtils {
    private static PropertyUtils FOR_COVERAGE = new PropertyUtils();

    private static Task.Complexity doValidateTaskComplexity(String value) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value))) {
            return Task.Complexity.MEDIUM;
        }
        return (Task.Complexity)ValidationUtils.validateUpcasedEnum(value, "Task complexity", Task.Complexity.class);
    }

    private static Task.Priority doValidateTaskPriority(String value) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value))) {
            return Task.Priority.MEDIUM;
        }
        return (Task.Priority)ValidationUtils.validateUpcasedEnum(value, "Task priority", Task.Priority.class);
    }

    private static void doUpdateProperties(Serializable serializable, Type type, List<Attribute> extAttrs, SasProperties sasProperties) {
        List<SasProperty> properties = sasProperties.getList();
        for (SasProperty sasProp : properties) {
            String attrType;
            ValidationUtils.validateRequiredParameter(sasProp.getName(), "Property name");
            String sasPropName = sasProp.getName();
            AttributeDefinition ad = type.getAttributeDefinitionById(sasPropName);
            boolean extended = ad == null ? false : ad.isExtended();
            String string = attrType = ad == null ? null : ad.getAttributeType().name();
            if (extended) {
                for (Attribute attr : extAttrs) {
                    if (!sasPropName.trim().equals(attr.getId())) continue;
                    Serializable apiValue = ValidationUtils.toJavaSerializable(sasPropName, sasProp.getValue(), attrType);
                    attr.setValue(apiValue);
                    break;
                }
            }
            String stringValue = sasProp.getValue() == null ? null : sasProp.getValue().trim();
            boolean valIsMissing = ValidationUtils.valueIsMissing((Serializable)((Object)stringValue));
            if (serializable instanceof User) {
                User user = (User)serializable;
                if (sasPropName.equals("displayName")) {
                    user.setDisplayName(stringValue);
                    continue;
                }
                if (sasPropName.equals("firstName")) {
                    user.setFirstName(stringValue);
                    continue;
                }
                if (sasPropName.equals("lastName")) {
                    user.setLastName(stringValue);
                    continue;
                }
                if (sasPropName.equals("department")) {
                    user.setDepartment(stringValue);
                    continue;
                }
                if (sasPropName.equals("phone")) {
                    user.setPhone(stringValue);
                    continue;
                }
                if (sasPropName.equals("email")) {
                    user.setEmail(stringValue);
                    continue;
                }
                if (sasPropName.equals("accountType")) {
                    AccountInfo.AccountType at = (AccountInfo.AccountType)ValidationUtils.validateUpcasedEnum(stringValue, "Account type", AccountInfo.AccountType.class);
                    user.getAccountInfo().setAccountType(at);
                    continue;
                }
                if (!sasPropName.equals("licenseType")) continue;
                user.getAccountInfo().setLicenseTypeId(stringValue);
                continue;
            }
            if (serializable instanceof RepositoryItem) {
                if (sasPropName.equals("description")) {
                    ((RepositoryItem)serializable).setDescription(stringValue);
                }
                if (!(serializable instanceof RepositoryExecutableFile)) continue;
                RepositoryExecutableFile re = (RepositoryExecutableFile)serializable;
                if (!sasPropName.equals("runAsOwner")) continue;
                re.setRunAsOwner(((Boolean)ValidationUtils.toJavaSerializable(sasPropName, sasProp.getValue(), attrType)).booleanValue());
                continue;
            }
            if (serializable instanceof TaskSetup) {
                TaskSetup setup = (TaskSetup)serializable;
                if (sasPropName.equalsIgnoreCase("description")) {
                    setup.setDescription(stringValue);
                } else if (sasPropName.equalsIgnoreCase("name") && !valIsMissing) {
                    setup.setName(stringValue);
                }
                if (serializable instanceof JobTaskSetup) {
                    JobTaskSetup jobDef = (JobTaskSetup)serializable;
                    if (sasPropName.equalsIgnoreCase("jobPath")) {
                        String pathValue = ValidationUtils.valueIsMissing((Serializable)((Object)stringValue)) ? null : stringValue;
                        jobDef.setJobPath(pathValue);
                        continue;
                    }
                    if (!sasPropName.equalsIgnoreCase("jobVersion")) continue;
                    jobDef.setJobVersion(stringValue);
                    continue;
                }
                if (serializable instanceof NotificationTaskSetup) {
                    NotificationTaskSetup notiDef = (NotificationTaskSetup)serializable;
                    if (sasPropName.equalsIgnoreCase("subject")) {
                        notiDef.setSubject(stringValue);
                        continue;
                    }
                    if (sasPropName.equalsIgnoreCase("message")) {
                        notiDef.setMessage(stringValue);
                        continue;
                    }
                    if (!sasPropName.equalsIgnoreCase("priority")) continue;
                    NotificationTaskSetup.MessagePriority priority = ValidationUtils.valueIsMissing((Serializable)((Object)stringValue)) ? NotificationTaskSetup.MessagePriority.MEDIUM : (NotificationTaskSetup.MessagePriority)ValidationUtils.validateUpcasedEnum(stringValue, "Message priority", NotificationTaskSetup.MessagePriority.class);
                    notiDef.setPriority(priority);
                    continue;
                }
                if (!(serializable instanceof UserTaskSetup)) continue;
                UserTaskSetup userTaskSetup = (UserTaskSetup)serializable;
                if (sasPropName.equalsIgnoreCase("assigneeID")) {
                    userTaskSetup.setAssignee(stringValue);
                    continue;
                }
                if (sasPropName.equalsIgnoreCase("priority")) {
                    userTaskSetup.setPriority(PropertyUtils.doValidateTaskPriority(stringValue));
                    continue;
                }
                if (sasPropName.equalsIgnoreCase("complexity")) {
                    userTaskSetup.setComplexity(PropertyUtils.doValidateTaskComplexity(stringValue));
                    continue;
                }
                if (!sasPropName.equalsIgnoreCase("dueDate")) continue;
                userTaskSetup.setDueDate(ValidationUtils.validateDateString(sasPropName, stringValue));
                continue;
            }
            if (serializable instanceof ProcessFlow) {
                ProcessFlow pf = (ProcessFlow)serializable;
                if (sasPropName.equals("description")) {
                    pf.setDescription(stringValue);
                    continue;
                }
                if (valIsMissing) continue;
                if (sasPropName.equals("owner")) {
                    pf.setOwner(stringValue);
                    continue;
                }
                if (!sasPropName.equals("name")) continue;
                pf.setName(stringValue);
                continue;
            }
            if (!(serializable instanceof UserTask)) continue;
            UserTask ut = (UserTask)serializable;
            if (sasPropName.equalsIgnoreCase("name")) {
                ut.setName(stringValue);
                continue;
            }
            if (sasPropName.equalsIgnoreCase("description")) {
                ut.setDescription(stringValue);
                continue;
            }
            if (sasPropName.equalsIgnoreCase("complexity")) {
                ut.setComplexity(PropertyUtils.doValidateTaskComplexity(stringValue));
                continue;
            }
            if (sasPropName.equalsIgnoreCase("priority")) {
                ut.setPriority(PropertyUtils.doValidateTaskPriority(stringValue));
                continue;
            }
            if (sasPropName.equalsIgnoreCase("assigneeID")) {
                ut.setAssignee(stringValue);
                continue;
            }
            if (sasPropName.equalsIgnoreCase("actualHours")) {
                ut.setActualHours(ValidationUtils.validateRequiredFloat("Actual hours", stringValue));
                continue;
            }
            if (!sasPropName.equalsIgnoreCase("dueDate")) continue;
            ut.setDueDate(ValidationUtils.validateDateString(sasPropName, stringValue));
        }
    }

    public static final List<SasItemProperty> doGetSasItemPropsFromAttrs(String itemTypeId, List<Attribute> attributes) {
        if (attributes == null) {
            return new ArrayList<SasItemProperty>();
        }
        Type type = PropertyUtils.getTypeById(itemTypeId);
        ArrayList<SasItemProperty> properties = new ArrayList<SasItemProperty>();
        for (Attribute a : attributes) {
            AttributeDefinition aDef = type.getAttributeDefinitionById(a.getId());
            properties.add(new SasItemProperty(a, aDef));
        }
        return properties;
    }

    public static void addObjectExtAttrsToProperties(SasObjectProperties sasProperties, List<Attribute> attrs, String elementId, String typeId) {
        if (attrs == null || attrs.isEmpty()) {
            return;
        }
        Type type = PropertyUtils.getTypeById(typeId);
        for (Attribute a : attrs) {
            String attrId = a.getId();
            AttributeDefinition ad = type.getAttributeDefinitionById(attrId);
            if (ad == null) continue;
            sasProperties.addExtendedAttribute(elementId, ad.getId(), ad.getName(), ad.getAttributeType().name(), a.getValue());
        }
    }

    public static void updateIdentifiablePropertiesByType(AbstractIdentifiable identifiable, List<Attribute> extAttrs, SasProperties sasProperties) {
        Type type = PropertyUtils.getTypeById(identifiable.getTypeId());
        PropertyUtils.doUpdateProperties((Serializable)identifiable, type, extAttrs, sasProperties);
    }

    public static void updatePFSetupElementPropertiesByType(TaskSetup taskSetup, SasProperties sasProperties) {
        Type type = PropertyUtils.getTypeById("sas:task");
        PropertyUtils.doUpdateProperties((Serializable)taskSetup, type, taskSetup.getAttributes(), sasProperties);
    }

    public static final Type getTypeById(String id) {
        try {
            return ServiceManagerFactory.getApiTypeService().getTypeById(id);
        }
        catch (Exception e) {
            return null;
        }
    }
}

