/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.common.utils;

import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class PathUtils {
    public static final String SEPARATOR = "/";
    public static final String PERIOD = ".";
    private static PathUtils FOR_COVERAGE = new PathUtils();

    private PathUtils() {
    }

    public static String getName(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals(SEPARATOR)) {
            return "";
        }
        int index = path.lastIndexOf(SEPARATOR);
        if (index < 0) {
            return path;
        }
        return path.substring(index + 1);
    }

    public static String getNameSansExtension(String path) {
        String name = PathUtils.getName(path);
        return name.substring(0, name.lastIndexOf(PERIOD));
    }

    public static String getParentPath(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(SEPARATOR);
        String parent = null;
        parent = path.length() == 1 || index < 0 ? "" : (index == 0 ? SEPARATOR : path.substring(0, index));
        return parent;
    }

    public static String getFileExt(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals(SEPARATOR)) {
            return "";
        }
        int index = path.lastIndexOf(PERIOD);
        if (index < 0) {
            return "";
        }
        return path.substring(index);
    }

    public static boolean pathIsAbsolute(String path) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)path))) {
            return false;
        }
        return path.startsWith(SEPARATOR);
    }

    public static boolean pathIsRelative(String path) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)path))) {
            return false;
        }
        return path.startsWith(PERIOD);
    }

    public static List<String> getPathComponentsAsList(String path) {
        ArrayList<String> paths = new ArrayList<String>();
        if (!ValidationUtils.valueIsMissing((Serializable)((Object)path))) {
            String[] items;
            for (String i : items = path.split("\\s*/\\s*")) {
                if (ValidationUtils.valueIsMissing((Serializable)((Object)i))) continue;
                paths.add(i);
            }
        }
        return paths;
    }
}

