/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.common.utils;

import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateFormatUtils {
    public static final SimpleDateFormat DATETIME20_FORMAT = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss");
    public static final SimpleDateFormat E8601DZ25_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");

    public static boolean dateIsDateTime18(String dateString) {
        return DateFormatUtils.getDateFromDateTime20String(dateString) != null;
    }

    public static Date getDateFromDateTime20String(String dateString) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)dateString))) {
            return null;
        }
        if (dateString.trim().length() != 18) {
            return null;
        }
        DATETIME20_FORMAT.setLenient(false);
        DATETIME20_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        try {
            Date dValue = DATETIME20_FORMAT.parse(dateString);
            return dValue;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static boolean dateIse8601(String dateString) {
        return DateFormatUtils.getDateFromE8601String(dateString) != null;
    }

    public static Date getDateFromE8601String(String dateString) {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)dateString))) {
            return null;
        }
        if (dateString.trim().length() != 25) {
            return null;
        }
        E8601DZ25_FORMAT.setLenient(false);
        try {
            Date dValue = E8601DZ25_FORMAT.parse(dateString);
            return dValue;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getDateValueFromValidFormat(String dateString) {
        Date value = DateFormatUtils.getDateFromDateTime20String(dateString);
        if (value == null) {
            value = DateFormatUtils.getDateFromE8601String(dateString);
        }
        return value;
    }
}

