/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.common;

import com.sas.lsaf.core.Attribute;
import com.sas.lsaf.macro.common.utils.SasUtils;
import java.util.ArrayList;
import java.util.List;

public class SasProperty {
    private final String name;
    private final String value;

    public SasProperty(Attribute attribute) {
        this.name = SasUtils.toSasString(attribute.getId());
        this.value = SasUtils.toSasString(attribute);
    }

    public SasProperty(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getValue() {
        return SasUtils.toSasString(this.value);
    }

    public String getName() {
        return this.name;
    }

    public static List<SasProperty> toSasProperties(List<Attribute> attributes) {
        if (attributes == null) {
            return new ArrayList<SasProperty>();
        }
        ArrayList<SasProperty> properties = new ArrayList<SasProperty>(attributes.size());
        for (Attribute a : attributes) {
            properties.add(new SasProperty(a));
        }
        return properties;
    }

    public String toString() {
        return "SasProperty [name=" + this.name + ", value=" + this.value + "]";
    }
}

