/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.common;

import com.sas.lsaf.macro.common.utils.SasUtils;
import java.io.Serializable;
import java.util.Date;

public class SasObjectProperty {
    private String objectId;
    private final String name;
    private final String displayName;
    private final String type;
    private final Serializable value;
    private boolean isReadonly = false;
    private boolean isExtendedAttribute = false;
    private boolean isRequired = false;

    public SasObjectProperty(String name, String displayname, String type, Serializable value, boolean isReadonly, boolean isExtended, boolean isRequired) {
        this.objectId = null;
        this.displayName = displayname;
        this.name = name;
        this.type = type;
        this.value = value;
        this.isReadonly = isReadonly;
        this.isExtendedAttribute = isExtended;
        this.isRequired = isRequired;
    }

    public SasObjectProperty(String objId, String name, String displayname, String type, Serializable value, boolean isReadonly, boolean isExtended, boolean isRequired) {
        this.objectId = objId;
        this.displayName = displayname;
        this.name = name;
        this.type = type;
        this.value = value;
        this.isReadonly = isReadonly;
        this.isExtendedAttribute = isExtended;
        this.isRequired = isRequired;
    }

    public String getObjectIdentifier() {
        return SasUtils.toSasString(this.objectId);
    }

    public String getName() {
        return SasUtils.toSasString(this.name);
    }

    public String getDisplayName() {
        return SasUtils.toSasString(this.displayName);
    }

    public String getType() {
        return SasUtils.toSasString(this.type);
    }

    public String getValue() {
        if (this.value == null) {
            return "";
        }
        if (this.value instanceof Boolean) {
            return SasUtils.toSasString((Boolean)this.value);
        }
        if (this.value instanceof Date) {
            return SasUtils.toSasDatetimeFormat((Date)this.value);
        }
        return SasUtils.toSasString(this.value.toString());
    }

    public boolean getIsReadonly() {
        return this.isReadonly;
    }

    public boolean getIsExtendedAttribute() {
        return this.isExtendedAttribute;
    }

    public boolean getIsRequired() {
        return this.isRequired;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("SasObjectProperty:");
        buf.append(" ObjectId: " + this.getObjectIdentifier());
        buf.append(" Type: " + this.getType());
        buf.append(" Name: " + this.getName());
        buf.append(" DisplayName: " + this.getDisplayName());
        buf.append(" Value: " + this.getValue());
        buf.append(" isExtended: " + this.getIsExtendedAttribute());
        buf.append(" isReadonly: " + this.getIsReadonly());
        buf.append(" isRequired: " + this.getIsRequired());
        return buf.toString();
    }
}

