/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.common;

import com.sas.lsaf.client.HttpConnectException;
import com.sas.lsaf.client.LogoffException;
import com.sas.lsaf.clinical.common.ExportException;
import com.sas.lsaf.clinical.common.ImportException;
import com.sas.lsaf.clinical.common.ValidationReportException;
import com.sas.lsaf.clinical.dictionary.DictionaryNotFoundException;
import com.sas.lsaf.clinical.standards.StandardNotFoundException;
import com.sas.lsaf.clinical.study.ExternalDictionaryAssociationExistsException;
import com.sas.lsaf.clinical.study.ExternalDictionaryAssociationNotFoundException;
import com.sas.lsaf.clinical.study.StandardAssociationExistsException;
import com.sas.lsaf.clinical.study.StandardAssociationNotFoundException;
import com.sas.lsaf.clinical.study.StudyCodeListUpdateException;
import com.sas.lsaf.clinical.study.StudyComponentEditException;
import com.sas.lsaf.clinical.study.StudyDictionaryException;
import com.sas.lsaf.clinical.study.StudyNotFoundException;
import com.sas.lsaf.clinical.study.StudyStandardReferencedException;
import com.sas.lsaf.clinical.study.StudySupportingDocumentUpdateException;
import com.sas.lsaf.clinical.study.StudyTableUpdateException;
import com.sas.lsaf.clinical.study.StudyUpdateException;
import com.sas.lsaf.clinical.study.StudyValueLevelMetadataUpdateException;
import com.sas.lsaf.clinical.tlf.AnalysisResultNotFoundException;
import com.sas.lsaf.clinical.tlf.SectionNotFoundException;
import com.sas.lsaf.clinical.tlf.TlfNotFoundException;
import com.sas.lsaf.clinical.tlf.TlfUpdateException;
import com.sas.lsaf.clinical.tlftemplate.TlfTemplateExistsException;
import com.sas.lsaf.clinical.tlftemplate.TlfTemplateNotFoundException;
import com.sas.lsaf.content.repository.CheckedOutFilesSearchException;
import com.sas.lsaf.content.repository.CopyToWorkspaceException;
import com.sas.lsaf.content.repository.RepositoryItemCheckedoutException;
import com.sas.lsaf.content.repository.RepositoryItemCheckinException;
import com.sas.lsaf.content.repository.RepositoryItemCheckoutException;
import com.sas.lsaf.content.repository.RepositoryItemCopyException;
import com.sas.lsaf.content.repository.RepositoryItemDeleteException;
import com.sas.lsaf.content.repository.RepositoryItemExistsException;
import com.sas.lsaf.content.repository.RepositoryItemIllegalStateException;
import com.sas.lsaf.content.repository.RepositoryItemLockException;
import com.sas.lsaf.content.repository.RepositoryItemLockedException;
import com.sas.lsaf.content.repository.RepositoryItemMoveException;
import com.sas.lsaf.content.repository.RepositoryItemNotFoundException;
import com.sas.lsaf.content.repository.RepositoryItemUndoCheckoutException;
import com.sas.lsaf.content.repository.RepositoryItemUnlockException;
import com.sas.lsaf.content.repository.RepositoryItemUpdateException;
import com.sas.lsaf.content.repository.RepositoryItemVersioningException;
import com.sas.lsaf.content.repository.RepositorySearchException;
import com.sas.lsaf.content.repository.recyclebin.RecycleBinItemSearchException;
import com.sas.lsaf.content.repository.signature.SigningException;
import com.sas.lsaf.content.utilization.ResourceUtilizationPathNotFoundException;
import com.sas.lsaf.content.workspace.SharedWorkspaceLinkNotFoundException;
import com.sas.lsaf.content.workspace.SharedWorkspaceNotFoundException;
import com.sas.lsaf.content.workspace.WorkspaceItemCopyException;
import com.sas.lsaf.content.workspace.WorkspaceItemDeleteException;
import com.sas.lsaf.content.workspace.WorkspaceItemExistsException;
import com.sas.lsaf.content.workspace.WorkspaceItemMoveException;
import com.sas.lsaf.content.workspace.WorkspaceItemNotFoundException;
import com.sas.lsaf.content.workspace.WorkspaceMarkForAddException;
import com.sas.lsaf.content.workspace.WorkspacePathNotFoundException;
import com.sas.lsaf.core.AccessDeniedException;
import com.sas.lsaf.core.DataAccessException;
import com.sas.lsaf.core.IllegalPathException;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.core.type.IllegalChildTypeException;
import com.sas.lsaf.core.type.IllegalTypeException;
import com.sas.lsaf.core.type.InvalidTypeException;
import com.sas.lsaf.core.type.TypeNotFoundException;
import com.sas.lsaf.execution.job.JobExistsException;
import com.sas.lsaf.execution.job.JobFormatException;
import com.sas.lsaf.execution.job.JobNotFoundException;
import com.sas.lsaf.execution.job.JobSubmissionNotFoundException;
import com.sas.lsaf.execution.job.ResultsNotFoundException;
import com.sas.lsaf.execution.session.SessionException;
import com.sas.lsaf.execution.session.SessionNotFoundException;
import com.sas.lsaf.execution.session.SessionUnsupportedFeatureException;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.SasParameterInvalidException;
import com.sas.lsaf.macro.common.utils.validation.SasParameterRequiredException;
import com.sas.lsaf.macro.security.authentication.LsafSessionMissingException;
import com.sas.lsaf.macro.workflow.SasProcessFlowElementNotFoundException;
import com.sas.lsaf.messaging.subscription.SubscriptionException;
import com.sas.lsaf.query.QueryException;
import com.sas.lsaf.query.QueryLimitException;
import com.sas.lsaf.schedule.ScheduleException;
import com.sas.lsaf.schedule.ScheduleNotFoundException;
import com.sas.lsaf.security.acl.AclNotFoundException;
import com.sas.lsaf.security.acl.AclUpdateException;
import com.sas.lsaf.security.authentication.AccountLockedException;
import com.sas.lsaf.security.authentication.AccountNotFoundException;
import com.sas.lsaf.security.authentication.CredentialsExpiredException;
import com.sas.lsaf.security.authentication.CredentialsIncorrectException;
import com.sas.lsaf.security.group.GroupContextNotFoundException;
import com.sas.lsaf.security.group.GroupExistsException;
import com.sas.lsaf.security.group.GroupNotFoundException;
import com.sas.lsaf.security.group.InvalidGroupMemberException;
import com.sas.lsaf.security.membership.InvalidMemberException;
import com.sas.lsaf.security.membership.MemberExistsException;
import com.sas.lsaf.security.membership.MemberNotFoundException;
import com.sas.lsaf.security.membership.MembershipContextNotFoundException;
import com.sas.lsaf.security.principal.PrincipalNotFoundException;
import com.sas.lsaf.security.privilege.PrivilegeNotFoundException;
import com.sas.lsaf.security.role.InvalidRoleMemberException;
import com.sas.lsaf.security.role.RoleContextNotFoundException;
import com.sas.lsaf.security.role.RoleExistsException;
import com.sas.lsaf.security.role.RoleNotFoundException;
import com.sas.lsaf.security.user.UserDeleteException;
import com.sas.lsaf.security.user.UserExistsException;
import com.sas.lsaf.security.user.UserLockedException;
import com.sas.lsaf.security.user.UserNotFoundException;
import com.sas.lsaf.security.user.UserPasswordException;
import com.sas.lsaf.security.user.UserUnlockedException;
import com.sas.lsaf.workflow.autoflow.AutoFlowException;
import com.sas.lsaf.workflow.autoflow.AutoFlowSetupException;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionDeploymentException;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionMappingUpdateException;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionNotFoundException;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionStateException;
import com.sas.lsaf.workflow.processflow.InvalidRecipientException;
import com.sas.lsaf.workflow.processflow.InvalidTaskAssigneeException;
import com.sas.lsaf.workflow.processflow.ProcessFlowContextNotFoundException;
import com.sas.lsaf.workflow.processflow.ProcessFlowCopyException;
import com.sas.lsaf.workflow.processflow.ProcessFlowException;
import com.sas.lsaf.workflow.processflow.ProcessFlowExistsException;
import com.sas.lsaf.workflow.processflow.ProcessFlowManifestCreateException;
import com.sas.lsaf.workflow.processflow.ProcessFlowNotFoundException;
import com.sas.lsaf.workflow.task.InvalidTaskStateException;
import com.sas.lsaf.workflow.task.TaskNotFoundException;
import com.sas.lsaf.workflow.task.TaskSearchException;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ExceptionHandler {
    private static final Log LOG = LogFactory.getLog(ExceptionHandler.class);
    private static ExceptionHandler FOR_COVERAGE = new ExceptionHandler();
    public static final String REPOSITORY_ITEM_EXISTS_MESSAGE = "Repository item already exists.";
    public static final String WORKSPACE_ITEM_EXISTS_MESSAGE = "Workspace item already exists.";
    public static final String SESSION_URL_UNKNOWN_MESSAGE = "URL is incorrect.";

    private ExceptionHandler() {
    }

    private static boolean isSessionMissingException(Exception e) {
        if (e instanceof LsafSessionMissingException) {
            return true;
        }
        if (e instanceof ResultException) {
            return ((ResultException)e).getCode() == -100;
        }
        return false;
    }

    public static void handleException(Exception e, Result result) {
        String eLocMsg;
        if (e instanceof ResultException) {
            ResultException re = (ResultException)e;
            result.init(re.getCode(), re.getMessage());
            return;
        }
        if (e instanceof LsafSessionMissingException) {
            LsafSessionMissingException ssme = (LsafSessionMissingException)e;
            result.init(ssme.getCode(), ssme.getMessage());
            return;
        }
        int code = -1;
        String string = eLocMsg = e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "";
        if (e instanceof SasParameterInvalidException || e instanceof SasParameterRequiredException || e instanceof SasProcessFlowElementNotFoundException) {
            result.init(-1, eLocMsg);
            return;
        }
        String specMsg = null;
        if (e instanceof RepositoryItemExistsException) {
            specMsg = REPOSITORY_ITEM_EXISTS_MESSAGE;
        } else if (e instanceof WorkspaceItemExistsException) {
            specMsg = WORKSPACE_ITEM_EXISTS_MESSAGE;
        } else if (e instanceof LogoffException || e instanceof IllegalStateException) {
            specMsg = "User is not logged into a Life Sciences and Analytic Framework session.";
        } else if (e instanceof SessionNotFoundException) {
            specMsg = "A SAS Session was not found with the given id.";
        }
        if (specMsg != null) {
            result.init(-1, specMsg);
            return;
        }
        if (e instanceof AccessDeniedException || e instanceof AccountLockedException || e instanceof AccountNotFoundException || e instanceof AclNotFoundException || e instanceof AclUpdateException || e instanceof AnalysisResultNotFoundException || e instanceof AutoFlowException || e instanceof AutoFlowSetupException || e instanceof CheckedOutFilesSearchException || e instanceof CopyToWorkspaceException || e instanceof CredentialsExpiredException || e instanceof CredentialsIncorrectException || e instanceof DataAccessException || e instanceof DictionaryNotFoundException || e instanceof ExportException || e instanceof ExternalDictionaryAssociationExistsException || e instanceof ExternalDictionaryAssociationNotFoundException || e instanceof GroupContextNotFoundException || e instanceof GroupExistsException || e instanceof GroupNotFoundException || e instanceof HttpConnectException || e instanceof IllegalArgumentException || e instanceof IllegalChildTypeException || e instanceof IllegalPathException || e instanceof IllegalTypeException || e instanceof InvalidTypeException || e instanceof ImportException || e instanceof IOException || e instanceof InvalidGroupMemberException || e instanceof InvalidMemberException || e instanceof InvalidRecipientException || e instanceof InvalidRoleMemberException || e instanceof InvalidTaskAssigneeException || e instanceof InvalidTaskStateException || e instanceof JobExistsException || e instanceof JobFormatException || e instanceof JobNotFoundException || e instanceof JobSubmissionNotFoundException || e instanceof MalformedURLException || e instanceof MemberExistsException || e instanceof MemberNotFoundException || e instanceof MembershipContextNotFoundException || e instanceof QueryException || e instanceof QueryLimitException || e instanceof PrincipalNotFoundException || e instanceof PrivilegeNotFoundException || e instanceof ProcessDefinitionDeploymentException || e instanceof ProcessDefinitionMappingUpdateException || e instanceof ProcessDefinitionNotFoundException || e instanceof ProcessDefinitionStateException || e instanceof ProcessFlowContextNotFoundException || e instanceof ProcessFlowCopyException || e instanceof ProcessFlowException || e instanceof ProcessFlowExistsException || e instanceof ProcessFlowManifestCreateException || e instanceof ProcessFlowNotFoundException || e instanceof RecycleBinItemSearchException || e instanceof RepositoryItemCheckedoutException || e instanceof RepositoryItemCheckinException || e instanceof RepositoryItemCheckoutException || e instanceof RepositoryItemCopyException || e instanceof RepositoryItemDeleteException || e instanceof RepositoryItemIllegalStateException || e instanceof RepositoryItemLockException || e instanceof RepositoryItemLockedException || e instanceof RepositoryItemMoveException || e instanceof RepositoryItemNotFoundException || e instanceof RepositoryItemVersioningException || e instanceof RepositoryItemUndoCheckoutException || e instanceof RepositoryItemUnlockException || e instanceof RepositorySearchException || e instanceof RepositoryItemUpdateException || e instanceof ResourceUtilizationPathNotFoundException || e instanceof ResultsNotFoundException || e instanceof RoleContextNotFoundException || e instanceof RoleExistsException || e instanceof RoleNotFoundException || e instanceof ScheduleException || e instanceof ScheduleNotFoundException || e instanceof SectionNotFoundException || e instanceof SessionException || e instanceof SessionUnsupportedFeatureException || e instanceof SharedWorkspaceLinkNotFoundException || e instanceof SharedWorkspaceNotFoundException || e instanceof SigningException || e instanceof StandardAssociationExistsException || e instanceof StandardAssociationNotFoundException || e instanceof StandardNotFoundException || e instanceof StudyCodeListUpdateException || e instanceof StudyComponentEditException || e instanceof StudyDictionaryException || e instanceof StudyNotFoundException || e instanceof StudyStandardReferencedException || e instanceof StudySupportingDocumentUpdateException || e instanceof StudyTableUpdateException || e instanceof StudyUpdateException || e instanceof StudyValueLevelMetadataUpdateException || e instanceof SubscriptionException || e instanceof TaskNotFoundException || e instanceof TaskSearchException || e instanceof TlfNotFoundException || e instanceof TlfTemplateExistsException || e instanceof TlfTemplateNotFoundException || e instanceof TlfUpdateException || e instanceof TypeNotFoundException || e instanceof UserDeleteException || e instanceof UserExistsException || e instanceof UserLockedException || e instanceof UserNotFoundException || e instanceof UserPasswordException || e instanceof UserUnlockedException || e instanceof ValidationException || e instanceof ValidationReportException || e instanceof WorkspaceItemCopyException || e instanceof WorkspaceItemDeleteException || e instanceof WorkspaceItemExistsException || e instanceof WorkspaceItemMoveException || e instanceof WorkspaceItemNotFoundException || e instanceof WorkspaceMarkForAddException || e instanceof WorkspacePathNotFoundException) {
            String cleansedMsg = eLocMsg.replaceAll("\"", "");
            cleansedMsg = cleansedMsg.replaceAll("'", "");
            result.init(-1, cleansedMsg);
            return;
        }
        String eMsg = e.getMessage() != null ? e.getMessage() : "";
        LOG.error((Object)"Unexpected error occurred", (Throwable)e);
        result.init(-500, eMsg);
    }

    public static void handleBooleanMethodException(Exception e, Result result) {
        if (e instanceof SasParameterRequiredException || ExceptionHandler.isSessionMissingException(e)) {
            ExceptionHandler.handleException(e, result);
        } else {
            result.init(0, "Success.");
        }
    }

    public static void throwNewResultException(Exception e) {
        Result result = new Result();
        ExceptionHandler.handleException(e, result);
        throw new ResultException(result.getReturnCode(), result.getReturnMessage());
    }
}

