/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.clinical.tlf;

import com.sas.lsaf.clinical.common.BatchFileCreateInfo;
import com.sas.lsaf.clinical.common.ClinicalUpdateResult;
import com.sas.lsaf.clinical.common.ExportFileCreateInfo;
import com.sas.lsaf.clinical.tlf.TlfImportInfo;
import com.sas.lsaf.clinical.tlf.TlfUpdateResult;
import com.sas.lsaf.clinical.tlftemplate.TlfTemplate;
import com.sas.lsaf.clinical.tlftemplate.TlfTemplateImportInfo;
import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.macro.clinical.ClinicalImportParametersHelper;
import com.sas.lsaf.macro.clinical.SasClinicalImportValidationResult;
import com.sas.lsaf.macro.clinical.SasClinicalUpdateTlfsParameters;
import com.sas.lsaf.macro.clinical.tlf.SasTlfTemplatesResult;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.result.SasPathResult;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.ContentCreationParametersHelper;
import com.sas.lsaf.macro.content.SasBatchFileCreateParameters;
import com.sas.lsaf.macro.content.SasFileCreateParameters;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TlfTemplateService {
    private static final Log LOG = LogFactory.getLog(TlfTemplateService.class);
    private static TlfTemplateService FOR_COVERAGE = new TlfTemplateService();

    private TlfTemplateService() {
    }

    private static com.sas.lsaf.clinical.tlftemplate.TlfTemplateService doGetService() {
        return ServiceManagerFactory.getApiTlfTemplateService();
    }

    private static void doExportTLFs(String templateId, String srcLoc, SasBatchFileCreateParameters createBatchFileParms, String includeAnalysisResults, SasPathResult result) throws Exception {
        ValidationUtils.validateRequiredParameter(templateId, "TLF template");
        boolean incResults = ValidationUtils.validateBinaryFlagDefaultTrue(includeAnalysisResults, "Include analysis results");
        createBatchFileParms.setLocation(srcLoc);
        BatchFileCreateInfo info = ContentCreationParametersHelper.toBatchFileCreateInfoWithPrefix(createBatchFileParms);
        Set paths = TlfTemplateService.doGetService().exportTlfsToDataSets(templateId, info, incResults);
        result.setLocationAndPaths(info.getLocation(), paths);
        result.init(0, "Success.");
    }

    public static void getTlfTemplates(SasTlfTemplatesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting Tlf Templates");
        }
        try {
            result.setTlfTemplates(TlfTemplateService.doGetService().getTlfTemplates());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String getTlfTemplateId(String name, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting id Tlf Template " + name));
        }
        try {
            ValidationUtils.validateRequiredParameter(name, "Name");
            result.init(0, "Success.");
            Set templates = TlfTemplateService.doGetService().getTlfTemplates();
            for (TlfTemplate tt : templates) {
                if (!tt.getName().equals(name)) continue;
                return tt.getId();
            }
            throw new ResultException("TLF Template was not found.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String createTlfTemplate(String name, String description, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Create new Tlf Template");
        }
        try {
            ValidationUtils.validateRequiredParameter(name, "Name");
            TlfTemplate t = TlfTemplateService.doGetService().createTlfTemplate(name, description);
            result.init(0, "Success.");
            return t.getId();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void importTlfsToTlfTemplate(String tlfTemplateId, SasClinicalUpdateTlfsParameters importTlfParameters, SasFileCreateParameters reportFileParameters, SasClinicalImportValidationResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Importing TLFs to template : " + tlfTemplateId));
        }
        try {
            ValidationUtils.validateRequiredParameter(tlfTemplateId, "TLF template");
            TlfTemplateImportInfo ti = ClinicalImportParametersHelper.toTlfTemplateImportInfo(tlfTemplateId, importTlfParameters);
            ExportFileCreateInfo ei = ContentCreationParametersHelper.toClinicalImportValidationReportInfo(reportFileParameters);
            TlfUpdateResult tur = TlfTemplateService.doGetService().importTlfsToTlfTemplate(ti, ei);
            result.init((TlfImportInfo)ti, (ClinicalUpdateResult)tur);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void exportTlfsToRepository(String tlfTemplateId, SasBatchFileCreateParameters batchFileCreateInfo, String includeResults, SasPathResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting TLFs to repository for template : " + tlfTemplateId));
        }
        try {
            TlfTemplateService.doExportTLFs(tlfTemplateId, SourceLocation.REPOSITORY.name(), batchFileCreateInfo, includeResults, result);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void exportTlfsToWorkspace(String tlfTemplateId, SasBatchFileCreateParameters batchFileCreateInfo, String includeResults, SasPathResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting TLFs to workspace for template : " + tlfTemplateId));
        }
        try {
            TlfTemplateService.doExportTLFs(tlfTemplateId, SourceLocation.WORKSPACE.name(), batchFileCreateInfo, includeResults, result);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

