/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.clinical.study.tlf;

import com.sas.lsaf.clinical.model.AttributeMetadata;
import com.sas.lsaf.clinical.study.tlf.StudyTlfInfo;
import com.sas.lsaf.clinical.tlf.Tlf;
import com.sas.lsaf.macro.clinical.SasClinicalPropertiesUpdateRecordsResult;
import com.sas.lsaf.macro.clinical.SasClinicalTlfNotFoundException;
import com.sas.lsaf.macro.clinical.study.tlf.SasQualifiedProperties;
import com.sas.lsaf.macro.clinical.study.tlf.SasStudyTlfMetadataHelper;
import com.sas.lsaf.macro.clinical.study.tlf.SasStudyTlfPropertiesResult;
import com.sas.lsaf.macro.clinical.study.tlf.SasStudyTlfSectionsResult;
import com.sas.lsaf.macro.clinical.study.tlf.SasStudyTlfsInfoResult;
import com.sas.lsaf.macro.clinical.tlf.SasTlfAnalysesResult;
import com.sas.lsaf.macro.clinical.tlf.SasTlfAnalysisDatasetsResult;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StudyTlfService {
    private static final Log LOG = LogFactory.getLog(StudyTlfService.class);
    private static StudyTlfService FOR_COVERAGE = new StudyTlfService();

    private StudyTlfService() {
    }

    private static com.sas.lsaf.clinical.study.tlf.StudyTlfService doGetService() {
        return ServiceManagerFactory.getApiStudyTlfService();
    }

    public static void getTlfSections(String studyId, String baseStandardName, String modelId, SasStudyTlfSectionsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting the Tlf Sections for study id " + studyId));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            result.setStudyTlfSections(StudyTlfService.doGetService().getStudySections(studyId, baseStandardName, modelId));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getTlfsInfo(String studyId, String baseStandardName, String modelId, String sectionId, String recurse, SasStudyTlfsInfoResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting the TLFs for study id " + studyId));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            ArrayList<Tlf> tlfs = new ArrayList<Tlf>();
            String sId = ValidationUtils.valueIsMissing((Serializable)((Object)sectionId)) ? null : sectionId.trim();
            boolean r = ValidationUtils.validateBinaryFlagDefaultTrue(recurse, "Recursive");
            tlfs.addAll(StudyTlfService.doGetService().getStudyTlfsBySectionId(studyId, baseStandardName, modelId, sId, r));
            result.setStudyTlfInfo(tlfs);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String getStudyTlfId(String studyId, String baseStandardName, String modelId, String tlfIdentifier, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting the id for TLF " + tlfIdentifier));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            ValidationUtils.validateRequiredParameter(tlfIdentifier, "TLF identifier");
            String id = StudyTlfService.doGetService().getStudyTlfByTlfIdentifier(studyId, baseStandardName, modelId, tlfIdentifier).getId();
            result.init(0, "Success.");
            return id;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void deleteTlf(String studyId, String baseStandardName, String modelId, String tlfIdentifier, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting study Tlf " + tlfIdentifier));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            ValidationUtils.validateRequiredParameter(tlfIdentifier, "TLF identifier");
            com.sas.lsaf.clinical.study.tlf.StudyTlfService srv = StudyTlfService.doGetService();
            StudyTlfInfo info = srv.getTlfs(studyId, baseStandardName, modelId);
            List tlfs = info.getTlfs();
            boolean found = false;
            for (int index = 0; index < tlfs.size(); ++index) {
                if (!((Tlf)tlfs.get(index)).getIdentifier().equals(tlfIdentifier)) continue;
                tlfs.remove(index);
                found = true;
                break;
            }
            if (!found) {
                throw new SasClinicalTlfNotFoundException(tlfIdentifier);
            }
            info.setTlfs(tlfs);
            srv.setTlfs(info);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean tlfExists(String studyId, String baseStandardName, String modelId, String tlfIdentifier, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting study Tlf " + tlfIdentifier));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            ValidationUtils.validateRequiredParameter(tlfIdentifier, "TLF identifier");
            Tlf t = StudyTlfService.doGetService().getStudyTlfByTlfIdentifier(studyId, baseStandardName, modelId, tlfIdentifier);
            result.init(0, "Success.");
            return t != null;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void getTlfProperties(String studyId, String baseStandardName, String modelId, String tlfIdentifier, SasStudyTlfPropertiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting the properties for study Tlf " + tlfIdentifier));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            ValidationUtils.validateRequiredParameter(tlfIdentifier, "TLF identifier");
            Tlf t = StudyTlfService.doGetService().getStudyTlfByTlfIdentifier(studyId, baseStandardName, modelId, tlfIdentifier);
            result.setProperties(SasStudyTlfMetadataHelper.toSasStudyTlfProperties(t, false));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateTlfProperties(String studyId, String baseStandardName, String modelId, String tlfIdentifier, SasQualifiedProperties properties, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting the properties for study Tlf " + tlfIdentifier));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            ValidationUtils.validateRequiredParameter(tlfIdentifier, "TLF identifier");
            ValidationUtils.assertRequiredSasInputDataList("Update properties", properties);
            com.sas.lsaf.clinical.study.tlf.StudyTlfService srv = StudyTlfService.doGetService();
            boolean found = false;
            StudyTlfInfo info = srv.getTlfs(studyId, baseStandardName, modelId);
            for (Tlf tlf : info.getTlfs()) {
                if (!tlf.getIdentifier().equals(tlfIdentifier)) continue;
                found = true;
                SasStudyTlfMetadataHelper.updateTlfProperties(tlf, properties);
                break;
            }
            if (!found) {
                throw new SasClinicalTlfNotFoundException(tlfIdentifier);
            }
            srv.setTlfs(info);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean tlfAutoflowEnabled(String studyId, String baseStandardName, String modelId, String tlfIdentifier, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking if Tlf is Autoflow enabled: " + tlfIdentifier));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            ValidationUtils.validateRequiredParameter(tlfIdentifier, "TLF identifier");
            Tlf t = StudyTlfService.doGetService().getStudyTlfByTlfIdentifier(studyId, baseStandardName, modelId, tlfIdentifier);
            result.init(0, "Success.");
            return t.isEnableAutoFlow();
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void updateTlfProperty(String studyId, String baseStandardName, String modelId, String tlfIdentifier, String propSasName, String propertyValue, String propertyValueQualifier, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting property " + propSasName + " to " + propertyValue + " for study Tlf " + tlfIdentifier));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            ValidationUtils.validateRequiredParameter(tlfIdentifier, "TLF identifier");
            ValidationUtils.validateRequiredParameter(propSasName, "Property SASName");
            com.sas.lsaf.clinical.study.tlf.StudyTlfService srv = StudyTlfService.doGetService();
            AttributeMetadata meta = SasStudyTlfMetadataHelper.getMetadataMap().get(propSasName.toUpperCase());
            if (meta == null) {
                throw new ResultException("Property with sasName " + propSasName + " not found for TLF " + tlfIdentifier);
            }
            if (meta.isDerived()) {
                throw new ResultException("Derived property " + propSasName + " cannot be updated");
            }
            boolean foundTlf = false;
            StudyTlfInfo info = srv.getTlfs(studyId, baseStandardName, modelId);
            for (Tlf tlf : info.getTlfs()) {
                if (!tlf.getIdentifier().equals(tlfIdentifier)) continue;
                foundTlf = true;
                SasStudyTlfMetadataHelper.updateTlfProperty(tlf, propSasName, propertyValue, propertyValueQualifier);
                break;
            }
            if (!foundTlf) {
                throw new SasClinicalTlfNotFoundException(tlfIdentifier);
            }
            srv.setTlfs(info);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getTlfTitlesAndFootnotes(String studyId, String baseStandardName, String modelId, String tlfIdentifier, SasStudyTlfPropertiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting the titles and footnotes for study Tlf " + tlfIdentifier));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            if (ValidationUtils.valueIsMissing((Serializable)((Object)tlfIdentifier))) {
                List tlfs = StudyTlfService.doGetService().getTlfs(studyId, baseStandardName, modelId).getTlfs();
                for (Tlf tlf : tlfs) {
                    result.setProperties(SasStudyTlfMetadataHelper.toSasStudyTlfProperties(tlf, true));
                }
            } else {
                Tlf t = StudyTlfService.doGetService().getStudyTlfByTlfIdentifier(studyId, baseStandardName, modelId, tlfIdentifier);
                result.setProperties(SasStudyTlfMetadataHelper.toSasStudyTlfProperties(t, true));
            }
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateTlfTitlesAndFootnotes(String studyId, String baseStandardName, String modelId, String tlfIdentifier, SasQualifiedProperties properties, SasClinicalPropertiesUpdateRecordsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating the titles and footers for study Tlf " + tlfIdentifier));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            ValidationUtils.validateRequiredParameter(tlfIdentifier, "TLF identifier");
            ValidationUtils.assertRequiredSasInputDataList("Update properties", properties);
            com.sas.lsaf.clinical.study.tlf.StudyTlfService srv = StudyTlfService.doGetService();
            boolean found = false;
            StudyTlfInfo info = srv.getTlfs(studyId, baseStandardName, modelId);
            for (Tlf tlf : info.getTlfs()) {
                if (!tlf.getIdentifier().equals(tlfIdentifier)) continue;
                found = true;
                result.setRecords(SasStudyTlfMetadataHelper.updateTlfTitlesAndFooters(tlf, properties));
                break;
            }
            if (!found) {
                throw new SasClinicalTlfNotFoundException(tlfIdentifier);
            }
            srv.setTlfs(info);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void createTlf(String studyId, String baseStandardName, String modelId, String tlfName, String tlfIdentifier, String enableAutoFlow, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating new Tlf " + tlfName));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            ValidationUtils.validateRequiredParameter(tlfName, "Name");
            ValidationUtils.validateRequiredParameter(tlfIdentifier, "Identifier");
            boolean af = ValidationUtils.validateBinaryFlagDefaultFalse(enableAutoFlow, "Enable autoflow");
            Tlf newTlf = new Tlf(tlfName, tlfIdentifier, af);
            SasStudyTlfMetadataHelper.setTlfRequiredAttributes(newTlf);
            com.sas.lsaf.clinical.study.tlf.StudyTlfService srv = StudyTlfService.doGetService();
            StudyTlfInfo info = srv.getTlfs(studyId, baseStandardName, modelId);
            info.getTlfs().add(newTlf);
            srv.setTlfs(info);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getTlfAnalysisResults(String studyId, String baseStandardName, String modelId, String tlfIdentifier, SasTlfAnalysesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting Analysis Results for tlf " + tlfIdentifier));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            ValidationUtils.validateRequiredParameter(tlfIdentifier, "TLF identifier");
            result.setAnalysisResults(StudyTlfService.doGetService().getAnalysisResultsByStudyTlfIdentifier(studyId, baseStandardName, modelId, tlfIdentifier));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getTlfAnalysisDatasets(String studyId, String baseStandardName, String modelId, String resultIdentifier, SasTlfAnalysisDatasetsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting Analysis Result Datasets for result " + resultIdentifier));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            ValidationUtils.validateRequiredParameter(resultIdentifier, "TLF result identifier");
            result.setAnalysisDatasets(StudyTlfService.doGetService().getAnalysisDatasetsByResultIdentifier(studyId, baseStandardName, modelId, resultIdentifier));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

