/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.clinical.study.tlf;

import com.sas.lsaf.clinical.model.AttributeMetadata;
import com.sas.lsaf.clinical.model.ModelConstants;
import com.sas.lsaf.clinical.model.ValueListMetadata;
import com.sas.lsaf.clinical.model.ValueListValueMetadata;
import com.sas.lsaf.macro.common.utils.SasUtils;
import java.io.Serializable;
import java.util.ArrayList;

public class SasStudyTlfProperty {
    private String tlfIdentifier;
    private AttributeMetadata attrMetadata;
    private Serializable value;
    private String valueQualifier;

    public SasStudyTlfProperty(String tlfIdentifier, AttributeMetadata metadata, Serializable value, String valueQualier) {
        this.tlfIdentifier = tlfIdentifier;
        this.attrMetadata = metadata;
        this.value = value;
        this.valueQualifier = valueQualier;
    }

    public String getTlfIdentifier() {
        return this.tlfIdentifier;
    }

    public String getName() {
        return this.attrMetadata.getName();
    }

    public String getSasName() {
        return this.attrMetadata.getSasName();
    }

    public String getDescription() {
        return this.attrMetadata.getDescription();
    }

    public int getOrdering() {
        return this.attrMetadata.getOrdering();
    }

    public String getDataType() {
        return this.attrMetadata.getDataType().name();
    }

    public String getLogicalType() {
        ModelConstants.LogicalType lt = this.attrMetadata.getLogicalType();
        return lt == null ? "" : lt.name();
    }

    public int getLength() {
        return this.attrMetadata.getLength();
    }

    public boolean isRequired() {
        return this.attrMetadata.isRequired();
    }

    public boolean mustBeUnique() {
        return this.attrMetadata.mustBeUnique();
    }

    public String getValues() {
        ValueListMetadata vl = this.attrMetadata.getValueList();
        ArrayList<String> validValues = new ArrayList<String>();
        if (vl != null) {
            for (ValueListValueMetadata vlvm : vl.getValueListValues()) {
                validValues.add(vlvm.getValue());
            }
        }
        return SasUtils.toSasCommaDelimitedString(validValues);
    }

    public String getValue() {
        return SasUtils.toSasString(this.value);
    }

    public String getValueQualifier() {
        return this.valueQualifier;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("SasStudyTlfProperty [ ");
        buf.append("Name=" + this.getName());
        buf.append(", SasName=" + this.getSasName());
        buf.append(", Description=" + this.getDescription());
        buf.append(", Ordering=" + this.getOrdering());
        buf.append(", DataType=" + this.getDataType());
        buf.append(", LogicalType=" + this.getLogicalType());
        buf.append(", Length=" + this.getLength());
        buf.append(", Required=" + this.isRequired());
        buf.append(", MustBeUnique=" + this.mustBeUnique());
        buf.append(", Values={" + this.getValues() + "}");
        buf.append(", Value=" + this.getValue());
        buf.append(", ValueQualifier=" + this.getValueQualifier());
        buf.append(" ]");
        return buf.toString();
    }
}

