/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.clinical.study.tlf;

import com.sas.lsaf.clinical.common.AttributeValue;
import com.sas.lsaf.clinical.model.AttributeMetadata;
import com.sas.lsaf.clinical.model.ModelConstants;
import com.sas.lsaf.clinical.model.ValueListMetadata;
import com.sas.lsaf.clinical.model.ValueListValueMetadata;
import com.sas.lsaf.clinical.tlf.Tlf;
import com.sas.lsaf.content.common.FileSpecification;
import com.sas.lsaf.content.repository.RepositoryService;
import com.sas.lsaf.core.Identifiable;
import com.sas.lsaf.macro.clinical.SasClinicalPropertiesUpdateRecord;
import com.sas.lsaf.macro.clinical.study.tlf.SasQualifiedProperties;
import com.sas.lsaf.macro.clinical.study.tlf.SasStudyTlfProperty;
import com.sas.lsaf.macro.common.ResultException;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.SasParameterInvalidException;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.security.group.GroupDescriptor;
import com.sas.lsaf.security.group.GroupService;
import com.sas.lsaf.security.user.UserDescriptor;
import com.sas.lsaf.security.user.UserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SasStudyTlfMetadataHelper {
    public static final String ATTRIB_SASNAME_RESULTS = "RESULTS";
    public static final String ATTRIB_SASNAME_NAME = "NAME";
    public static final String ATTRIB_SASNAME_IDENTIFIER = "IDENTIFIER";
    public static final String ATTRIB_SASNAME_SECTION = "SECTION";
    public static final String ATTRIB_SASNAME_ENABLEAUTOFLOW = "ENABLEAUTOFLOW";
    public static final String ATTRIB_SASNAME_TYPE = "TYPE";
    public static final List<String> includeInTitlesAndFooters = Arrays.asList("NAME", "TYPE", "SECTION");
    public static final List<String> derivedAttributesToIgnore = Arrays.asList("RESULTS");
    private static Map<String, AttributeMetadata> studyTlfMetadata = new HashMap<String, AttributeMetadata>();
    private static Map<String, AttributeMetadata> studyTlfTitlesAndFootnotesMetadata = new HashMap<String, AttributeMetadata>();
    private static boolean mapsAreSet = false;

    private static void doSetMetadataMap() throws Exception {
        if (mapsAreSet) {
            return;
        }
        List md = ServiceManagerFactory.getApiStudyTlfService().getTlfAttributeMetadata();
        for (AttributeMetadata a : md) {
            String attrSasName = a.getSasName();
            if (derivedAttributesToIgnore.contains(attrSasName)) continue;
            String sasAttrUpcased = attrSasName.toUpperCase();
            studyTlfMetadata.put(sasAttrUpcased, a);
            if (!includeInTitlesAndFooters.contains(sasAttrUpcased) && !sasAttrUpcased.startsWith("TITLE") && !sasAttrUpcased.startsWith("FOOTNOTE")) continue;
            studyTlfTitlesAndFootnotesMetadata.put(sasAttrUpcased, a);
        }
        mapsAreSet = true;
    }

    private static Serializable doGetUpdateValue(String propSasName, String value, String qualifier) throws Exception {
        if (ValidationUtils.valueIsMissing((Serializable)((Object)value))) {
            return null;
        }
        UserService userSrv = ServiceManagerFactory.getApiUserService();
        GroupService grpSrv = ServiceManagerFactory.getApiGroupService();
        RepositoryService repoSrv = ServiceManagerFactory.getApiRepositoryService();
        AttributeMetadata meta = SasStudyTlfMetadataHelper.getMetadataMap().get(propSasName.toUpperCase());
        String pValue = SasUtils.toSasString(value);
        String pvQual = SasUtils.toSasString(qualifier);
        if (meta == null || meta.isDerived() || ModelConstants.AttributeState.RETIRED.equals((Object)meta.getState())) {
            return null;
        }
        Object updateValue = null;
        String processType = SasStudyTlfMetadataHelper.getProcessingType(meta);
        try {
            switch (processType) {
                case "PRINCIPAL": {
                    if (ValidationUtils.valueIsMissing((Serializable)((Object)pvQual))) {
                        updateValue = userSrv.getUserDescriptorByUserId(pValue);
                        break;
                    }
                    updateValue = grpSrv.getGroupDescriptorByName(repoSrv.getItem(pvQual).getId(), pValue);
                    break;
                }
                case "USER": {
                    updateValue = userSrv.getUserDescriptorByUserId(pValue);
                    break;
                }
                case "FILE": {
                    updateValue = new FileSpecification(pValue);
                    ((FileSpecification)updateValue).setVersion(pvQual);
                    break;
                }
                case "FOLDER": {
                    updateValue = new FileSpecification(pValue);
                    break;
                }
                case "DATE": {
                    updateValue = ValidationUtils.validateDateString(propSasName, pValue);
                    break;
                }
                case "INTEGER": {
                    updateValue = Integer.parseInt(pValue);
                    break;
                }
                case "FLOAT": {
                    updateValue = Float.valueOf(Float.parseFloat(pValue));
                    break;
                }
                case "LONG": {
                    updateValue = Long.parseLong(pValue);
                    break;
                }
                case "BOOLEAN": {
                    updateValue = ValidationUtils.validateBinaryFlagDefaultFalse(pValue, propSasName);
                    break;
                }
                default: {
                    updateValue = pValue;
                    break;
                }
            }
        }
        catch (SasParameterInvalidException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ResultException("Cannot convert '" + propSasName + "' to type " + processType + ": " + pValue + " [" + pvQual + "]");
        }
        return updateValue;
    }

    public static Map<String, AttributeMetadata> getMetadataMap() throws Exception {
        SasStudyTlfMetadataHelper.doSetMetadataMap();
        return studyTlfMetadata;
    }

    public static Map<String, AttributeMetadata> getTitlesAndFootnotesMetadataMap() throws Exception {
        SasStudyTlfMetadataHelper.doSetMetadataMap();
        return studyTlfTitlesAndFootnotesMetadata;
    }

    public static String getProcessingType(AttributeMetadata am) {
        return am.getLogicalType() == null ? am.getDataType().name() : am.getLogicalType().name();
    }

    public static boolean isRootSection(Identifiable i) {
        return i == null || "sas:studyTlfRoot".equals(i.getTypeId());
    }

    public static void updateTlfProperty(Tlf tlf, String propSasName, String value, String valueQualifier) throws Exception {
        Object updateValue = SasStudyTlfMetadataHelper.doGetUpdateValue(propSasName, value, valueQualifier);
        switch (propSasName) {
            case "NAME": {
                tlf.setName(SasUtils.toSasString((Serializable)updateValue));
                break;
            }
            case "IDENTIFIER": {
                tlf.setIdentifier(SasUtils.toSasString((Serializable)updateValue));
                break;
            }
            case "SECTION": {
                break;
            }
            case "ENABLEAUTOFLOW": {
                tlf.setEnableAutoFlow(updateValue == null ? false : (Boolean)updateValue);
                break;
            }
            default: {
                AttributeMetadata attrMeta = SasStudyTlfMetadataHelper.getMetadataMap().get(propSasName.toUpperCase());
                if (attrMeta == null) {
                    return;
                }
                String modelPropName = attrMeta.getName();
                boolean tlfHasAttr = false;
                for (AttributeValue attr : tlf.getAttributes()) {
                    if (!attr.getName().equalsIgnoreCase(modelPropName)) continue;
                    ValueListMetadata vm = attrMeta.getValueList();
                    if (vm != null && !vm.getValueListValues().isEmpty()) {
                        boolean foundValue = false;
                        List valuesList = vm.getValueListValues();
                        for (ValueListValueMetadata vlvm : valuesList) {
                            if (!vlvm.getValue().equalsIgnoreCase(SasUtils.toSasString((Serializable)updateValue))) continue;
                            updateValue = vlvm.getValue();
                            foundValue = true;
                            break;
                        }
                        if (!foundValue) {
                            ArrayList<String> validValuesList = new ArrayList<String>();
                            for (ValueListValueMetadata m : valuesList) {
                                validValuesList.add(m.getValue());
                            }
                            ValidationUtils.handleInvalidParameterValue(SasUtils.toSasCommaDelimitedString(validValuesList), attr.getName().toUpperCase());
                        }
                    }
                    attr.setValue((Serializable)updateValue);
                    tlfHasAttr = true;
                    break;
                }
                if (tlfHasAttr) break;
                tlf.getAttributes().add(new AttributeValue(modelPropName, (Serializable)updateValue));
            }
        }
    }

    public static void updateTlfProperties(Tlf tlf, SasQualifiedProperties properties) throws Exception {
        for (SasQualifiedProperties.SasQualifiedProperty p : properties.getList()) {
            String pSasName = p.getName();
            String pValue = p.getValue();
            String pvQual = p.getValueQualifier();
            SasStudyTlfMetadataHelper.updateTlfProperty(tlf, pSasName, pValue, pvQual);
        }
    }

    public static List<SasClinicalPropertiesUpdateRecord> updateTlfTitlesAndFooters(Tlf tlf, SasQualifiedProperties properties) throws Exception {
        ArrayList<SasClinicalPropertiesUpdateRecord> statusRecords = new ArrayList<SasClinicalPropertiesUpdateRecord>();
        for (SasQualifiedProperties.SasQualifiedProperty p : properties.getList()) {
            String dsVarName = p.getName().toUpperCase();
            SasClinicalPropertiesUpdateRecord record = new SasClinicalPropertiesUpdateRecord(dsVarName);
            AttributeMetadata attrMeta = SasStudyTlfMetadataHelper.getMetadataMap().get(dsVarName);
            if (attrMeta == null) {
                record.setPropertyNotFoundStatusMessage();
                statusRecords.add(record);
                continue;
            }
            record.setSasPropertyName(attrMeta.getSasName());
            if (!dsVarName.startsWith("TITLE") && !dsVarName.startsWith("FOOTNOTE")) {
                record.setPropertyNotApplicableStatusMessage();
                statusRecords.add(record);
                continue;
            }
            String updateValue = ValidationUtils.valueIsMissing((Serializable)((Object)p.getValue())) ? "" : p.getValue().trim();
            String modelPropName = attrMeta.getName();
            boolean hasAttr = false;
            for (AttributeValue attr : tlf.getAttributes()) {
                if (!attr.getName().equalsIgnoreCase(modelPropName)) continue;
                attr.setValue((Serializable)((Object)updateValue));
                hasAttr = true;
                break;
            }
            if (!hasAttr) {
                tlf.getAttributes().add(new AttributeValue(modelPropName, (Serializable)((Object)updateValue)));
            }
            record.setPropertyUpdatedStatusMessage();
            statusRecords.add(record);
        }
        return statusRecords;
    }

    public static List<SasStudyTlfProperty> toSasStudyTlfProperties(Tlf tlf, boolean titlesFootnotesOnly) throws Exception {
        RepositoryService repoSrv = ServiceManagerFactory.getApiRepositoryService();
        ArrayList<SasStudyTlfProperty> props = new ArrayList<SasStudyTlfProperty>();
        Map<String, AttributeMetadata> metaDataMap = titlesFootnotesOnly ? SasStudyTlfMetadataHelper.getTitlesAndFootnotesMetadataMap() : SasStudyTlfMetadataHelper.getMetadataMap();
        for (String key : metaDataMap.keySet()) {
            AttributeMetadata am = metaDataMap.get(key);
            String propValue = "";
            String propValueQual = "";
            block7 : switch (key) {
                case "NAME": {
                    propValue = SasUtils.toSasString(tlf.getName());
                    break;
                }
                case "RESULTS": {
                    propValue = SasUtils.toSasString(tlf.getResultCount());
                    break;
                }
                case "IDENTIFIER": {
                    propValue = SasUtils.toSasString(tlf.getIdentifier());
                    break;
                }
                case "SECTION": {
                    Identifiable parent = tlf.getParent();
                    if (SasStudyTlfMetadataHelper.isRootSection(parent)) break;
                    propValue = parent.getId();
                    break;
                }
                case "ENABLEAUTOFLOW": {
                    propValue = SasUtils.toSasString(tlf.isEnableAutoFlow());
                    break;
                }
                default: {
                    String modelPropName = am.getName();
                    for (AttributeValue av : tlf.getAttributes()) {
                        Serializable attrValue = av.getValue();
                        if (!modelPropName.equalsIgnoreCase(av.getName())) continue;
                        if (attrValue instanceof Date) {
                            propValue = SasUtils.toSasDatetimeFormat((Date)attrValue);
                            propValueQual = "";
                            break block7;
                        }
                        if (attrValue instanceof FileSpecification) {
                            FileSpecification fs = (FileSpecification)attrValue;
                            propValue = SasUtils.toSasString(fs.getPath());
                            propValueQual = SasUtils.toSasString(fs.getVersion());
                            break block7;
                        }
                        if (attrValue instanceof GroupDescriptor) {
                            GroupDescriptor group = (GroupDescriptor)attrValue;
                            propValue = group.getName();
                            propValueQual = repoSrv.getContextById(group.getContext().getId()).getPath();
                            break block7;
                        }
                        if (attrValue instanceof UserDescriptor) {
                            UserDescriptor user = (UserDescriptor)attrValue;
                            propValue = user.getUserId();
                            propValueQual = "";
                            break block7;
                        }
                        propValue = SasUtils.toSasString(attrValue);
                        propValueQual = "";
                        break block7;
                    }
                }
            }
            props.add(new SasStudyTlfProperty(tlf.getIdentifier(), studyTlfMetadata.get(key), (Serializable)((Object)propValue), propValueQual));
        }
        return props;
    }

    public static void setTlfRequiredAttributes(Tlf tlf) throws Exception {
        ArrayList<String> attrsToIgnore = new ArrayList<String>(Arrays.asList(ATTRIB_SASNAME_NAME, ATTRIB_SASNAME_IDENTIFIER, ATTRIB_SASNAME_ENABLEAUTOFLOW));
        ArrayList<AttributeValue> attrs = new ArrayList<AttributeValue>();
        for (String key : SasStudyTlfMetadataHelper.getMetadataMap().keySet()) {
            AttributeMetadata meta = studyTlfMetadata.get(key);
            if (attrsToIgnore.contains(key) || !meta.isRequired() || meta.isDerived()) continue;
            Object value = null;
            if (meta.getValueList() != null) {
                List validValues = meta.getValueList().getValueListValues();
                for (ValueListValueMetadata d : validValues) {
                    if (!d.isDefault()) continue;
                    value = d.getValue();
                    break;
                }
                if (value == null) {
                    value = (Serializable)validValues.get(0);
                }
            } else {
                switch (meta.getDataType()) {
                    case INTEGER: 
                    case FLOAT: 
                    case LONG: {
                        value = 0;
                        break;
                    }
                    case BOOLEAN: {
                        value = false;
                        break;
                    }
                    default: {
                        value = "default value";
                    }
                }
            }
            attrs.add(new AttributeValue(meta.getName(), (Serializable)value));
        }
        tlf.setAttributes(attrs);
    }
}

