/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.clinical.study;

import com.sas.lsaf.clinical.common.BatchFileCreateInfo;
import com.sas.lsaf.clinical.common.ExportException;
import com.sas.lsaf.clinical.common.ExportFileCreateInfo;
import com.sas.lsaf.clinical.common.UpdateAction;
import com.sas.lsaf.clinical.dictionary.DictionaryDescriptor;
import com.sas.lsaf.clinical.dictionary.ExternalDictionary;
import com.sas.lsaf.clinical.standards.StandardDescriptor;
import com.sas.lsaf.clinical.study.StudyComponent;
import com.sas.lsaf.clinical.study.StudyComponentEditableStatus;
import com.sas.lsaf.clinical.study.StudyComponentImportInfo;
import com.sas.lsaf.clinical.study.StudyNotFoundException;
import com.sas.lsaf.clinical.study.StudyTablesImportInfo;
import com.sas.lsaf.clinical.study.StudyUpdateResult;
import com.sas.lsaf.clinical.tlf.TlfImportInfo;
import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.core.type.Type;
import com.sas.lsaf.macro.clinical.ClinicalImportParametersHelper;
import com.sas.lsaf.macro.clinical.SasClinicalUpdateParameters;
import com.sas.lsaf.macro.clinical.SasClinicalUpdateTablesParameters;
import com.sas.lsaf.macro.clinical.SasClinicalUpdateTlfsParameters;
import com.sas.lsaf.macro.clinical.dictionary.SasDictionariesResult;
import com.sas.lsaf.macro.clinical.externaldictionary.SasExternalDictionariesResult;
import com.sas.lsaf.macro.clinical.standards.SasStandardsResult;
import com.sas.lsaf.macro.clinical.study.SasStudiesResult;
import com.sas.lsaf.macro.clinical.study.SasStudyException;
import com.sas.lsaf.macro.clinical.study.SasStudyImportValidationResult;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.SasStrings;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.result.SasPathResult;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.ContentCreationParametersHelper;
import com.sas.lsaf.macro.content.SasBatchFileCreateParameters;
import com.sas.lsaf.macro.content.SasFileCreateParameters;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StudyService {
    private static final Log LOG = LogFactory.getLog(StudyService.class);
    private static StudyService FOR_COVERAGE = new StudyService();

    private StudyService() {
    }

    private static com.sas.lsaf.clinical.study.StudyService doGetService() {
        return ServiceManagerFactory.getApiStudyService();
    }

    private static StudyComponent doValidateStudyComponent(String value) {
        return (StudyComponent)ValidationUtils.validateUpcasedEnum(value, "Study component", StudyComponent.class);
    }

    private static void doExportStudyTables(String srcLoc, String studyId, String baseStandardName, String modelId, SasBatchFileCreateParameters createBatchFileParms, SasPathResult result) throws StudyNotFoundException, ExportException {
        ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
        createBatchFileParms.setLocation(srcLoc);
        BatchFileCreateInfo info = ContentCreationParametersHelper.toBatchFileCreateInfoWithPrefix(createBatchFileParms);
        Set paths = StudyService.doGetService().exportStudyTablesToDataSets(studyId, baseStandardName, modelId, info);
        result.setLocationAndPaths(info.getLocation(), paths);
        result.init(0, "Success.");
    }

    private static String doExportZeroObsDatasetsForStudyTables(String srcLoc, String studyId, String baseStandardName, String modelId, SasBatchFileCreateParameters createBatchFileParms, Result result) throws StudyNotFoundException, ExportException {
        ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
        createBatchFileParms.setLocation(srcLoc);
        BatchFileCreateInfo info = ContentCreationParametersHelper.toBatchFileCreateInfo(createBatchFileParms);
        String parentPath = StudyService.doGetService().exportZeroObservationDataSetsForStudyTables(studyId, baseStandardName, modelId, info);
        result.init(0, "Success.");
        return parentPath;
    }

    private static void doExportStudyTLFs(String srcLoc, String studyId, String baseStandardName, String modelId, SasBatchFileCreateParameters createBatchFileParms, String includeResultsAndDataSets, SasPathResult result) throws StudyNotFoundException, ExportException {
        ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
        boolean incResults = ValidationUtils.validateBinaryFlagDefaultTrue(includeResultsAndDataSets, "Include results and data sets");
        createBatchFileParms.setLocation(srcLoc);
        BatchFileCreateInfo info = ContentCreationParametersHelper.toBatchFileCreateInfoWithPrefix(createBatchFileParms);
        Set paths = StudyService.doGetService().exportTlfsToDataSets(studyId, baseStandardName, modelId, info, incResults);
        result.setLocationAndPaths(info.getLocation(), paths);
        result.init(0, "Success.");
    }

    public static String getStudyId(String path, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting the study id for " + path));
        }
        try {
            ValidationUtils.assertRequiredPath(path);
            RepositoryItem ri = ServiceManagerFactory.getApiRepositoryService().getItem(path);
            Type t = ServiceManagerFactory.getApiTypeService().getTypeById(ri.getTypeId());
            boolean isStudy = t.getCapabilities().contains(Type.Capability.STUDY);
            if (!isStudy) {
                throw new SasStudyException("The specified path is not a study context.");
            }
            result.init(0, "Success.");
            return ri.getId();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void getStandardStudies(String standardId, SasStudiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting studies for standard " + standardId));
        }
        try {
            ValidationUtils.validateRequiredParameter(standardId, "Standard id");
            Set studies = StudyService.doGetService().getStudiesAssociatedWithStandard(standardId);
            result.setStudies(studies);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getStudyStandards(String studyId, SasStandardsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting standards for study " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            Set standards = StudyService.doGetService().getStandardsAssociatedWithStudy(studyId);
            result.setStandards(standards);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isStudyStandard(String studyId, String standardId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Is standard associated to study " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ValidationUtils.validateRequiredParameter(standardId, "Standard id");
            Set standards = StudyService.doGetService().getStandardsAssociatedWithStudy(studyId);
            boolean found = false;
            for (StandardDescriptor sd : standards) {
                if (!sd.getId().equals(standardId)) continue;
                found = true;
                break;
            }
            result.init(0, "Success.");
            return found;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void addStudyStandard(String studyId, String standardId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding standard " + standardId + "to study " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ValidationUtils.validateRequiredParameter(standardId, "Standard id");
            HashSet<String> standardIds = new HashSet<String>();
            standardIds.add(standardId);
            StudyService.doGetService().associateStandards(studyId, standardIds);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void removeStudyStandard(String studyId, String standardId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing standard " + standardId + "from study " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ValidationUtils.validateRequiredParameter(standardId, "Standard id");
            HashSet<String> standardIds = new HashSet<String>();
            standardIds.add(standardId);
            StudyService.doGetService().disassociateStandards(studyId, standardIds);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getDictionaryStudies(String dictionaryId, SasStudiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting studies for dictionary " + dictionaryId));
        }
        try {
            ValidationUtils.validateRequiredParameter(dictionaryId, "Dictionary");
            Set studies = StudyService.doGetService().getStudiesAssociatedWithDictionary(dictionaryId);
            result.setStudies(studies);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getStudyDictionaries(String studyId, SasDictionariesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting dictionaries for study " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            List dictionaries = StudyService.doGetService().getDictionariesAssociatedWithStudy(studyId);
            result.setDictionaries(dictionaries);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isStudyDictionary(String studyId, String dictionaryId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Is dictionaryId associated to study " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ValidationUtils.validateRequiredParameter(dictionaryId, "Dictionary");
            List dictionaries = StudyService.doGetService().getDictionariesAssociatedWithStudy(studyId);
            boolean found = false;
            for (DictionaryDescriptor dd : dictionaries) {
                if (!dd.getId().equals(dictionaryId)) continue;
                found = true;
                break;
            }
            result.init(0, "Success.");
            return found;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void setStudyDictionaries(String studyId, SasStrings dictionaries, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating dictionaries for study " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ValidationUtils.assertRequiredSasInputDataList("Study dictionaries", dictionaries);
            ArrayList<String> dictionaryIds = new ArrayList<String>(dictionaries.getList());
            StudyService.doGetService().associateDictionaries(studyId, dictionaryIds);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void removeAllStudyDictionaries(String studyId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Remove all dictionaries from study " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ArrayList dictionaryIds = new ArrayList();
            StudyService.doGetService().associateDictionaries(studyId, dictionaryIds);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getExternalDictionaryStudies(String externalDictionaryId, SasStudiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting studies for dictionary " + externalDictionaryId));
        }
        try {
            ValidationUtils.validateRequiredParameter(externalDictionaryId, "External dictionary");
            Set studies = StudyService.doGetService().getStudiesAssociatedWithExternalDictionary(externalDictionaryId);
            result.setStudies(studies);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getStudyExternalDictionaries(String studyId, SasExternalDictionariesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting external dictionaries for study " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            Set dictionaries = StudyService.doGetService().getExternalDictionariesAssociatedWithStudy(studyId);
            result.setDictionaries(dictionaries);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean isStudyExternalDictionary(String studyId, String externalDictionaryId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Is externalDictionaryId associated to study " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ValidationUtils.validateRequiredParameter(externalDictionaryId, "External dictionary");
            Set dictionaries = StudyService.doGetService().getExternalDictionariesAssociatedWithStudy(studyId);
            boolean found = false;
            for (ExternalDictionary ed : dictionaries) {
                if (!ed.getId().equals(externalDictionaryId)) continue;
                found = true;
                break;
            }
            result.init(0, "Success.");
            return found;
        }
        catch (Exception e) {
            ExceptionHandler.handleBooleanMethodException(e, result);
            return false;
        }
    }

    public static void addStudyExternalDictionary(String studyId, String extDictionaryId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding external dictionary " + extDictionaryId + " to study " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ValidationUtils.validateRequiredParameter(extDictionaryId, "External dictionary");
            HashSet<String> extDictIds = new HashSet<String>();
            extDictIds.add(extDictionaryId);
            StudyService.doGetService().associateExternalDictionaries(studyId, extDictIds);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void removeStudyExternalDictionary(String studyId, String extDictionaryId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing external dictionary " + extDictionaryId + " from study " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ValidationUtils.validateRequiredParameter(extDictionaryId, "External dictionary");
            HashSet<String> extDictIds = new HashSet<String>();
            extDictIds.add(extDictionaryId);
            StudyService.doGetService().disassociateExternalDictionaries(studyId, extDictIds);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String getStudyComponentEditedBy(String studyId, String studyComponent, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting study component current editor: " + studyComponent + "  " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            StudyComponent sc = StudyService.doValidateStudyComponent(studyComponent);
            StudyComponentEditableStatus sceStatus = StudyService.doGetService().getStudyComponentEditableStatus(studyId, sc);
            result.init(0, "Success.");
            return SasUtils.toSasString(sceStatus.getEditedBy());
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String setStudyComponentEditStatus(String studyId, String studyComponent, String editStudyComponent, String forceClaim, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting study component " + studyComponent + " editability to " + editStudyComponent + " force=" + forceClaim + " for " + studyId));
        }
        try {
            String operation;
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            StudyComponent sc = StudyService.doValidateStudyComponent(studyComponent);
            boolean turnEditingOn = ValidationUtils.validateBinaryFlagDefaultFalse(editStudyComponent, "Edit study component");
            String string = operation = turnEditingOn ? "ALLOW" : "DISALLOW";
            if (turnEditingOn) {
                boolean claimIt = ValidationUtils.validateBinaryFlagDefaultFalse(forceClaim, "Force edit study component");
                if (claimIt) {
                    StudyService.doGetService().setStudyComponentAsNotEditable(studyId, sc);
                }
                StudyService.doGetService().setStudyComponentEditableByCurrentUser(studyId, sc);
            } else {
                StudyService.doGetService().setStudyComponentAsNotEditable(studyId, sc);
            }
            result.init(0, "Success.");
            return operation;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String exportStudyDetails(String studyId, SasFileCreateParameters fileCreateParameters, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting study details : " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ExportFileCreateInfo ei = ContentCreationParametersHelper.toExportFileCreateInfo(fileCreateParameters);
            String dsPath = StudyService.doGetService().exportStudyDetailsToDataSet(studyId, ei);
            result.init(0, "Success.");
            return dsPath;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String exportStudyStandards(String studyId, SasFileCreateParameters fileCreateParameters, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting study standards : " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ExportFileCreateInfo ei = ContentCreationParametersHelper.toExportFileCreateInfo(fileCreateParameters);
            String dsPath = StudyService.doGetService().exportStudyStandardsToDataSet(studyId, ei);
            result.init(0, "Success.");
            return dsPath;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String exportStudyDictionaries(String studyId, SasFileCreateParameters fileCreateParameters, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting study dictionaries : " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ExportFileCreateInfo ei = ContentCreationParametersHelper.toExportFileCreateInfo(fileCreateParameters);
            String dsPath = StudyService.doGetService().exportStudyDictionariesToDataSet(studyId, ei);
            result.init(0, "Success.");
            return dsPath;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String exportStudyCodelists(String studyId, SasFileCreateParameters fileCreateParameters, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting study codelists : " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ExportFileCreateInfo ei = ContentCreationParametersHelper.toExportFileCreateInfo(fileCreateParameters);
            String dsPath = StudyService.doGetService().exportStudyCodeListsToDataSet(studyId, ei);
            result.init(0, "Success.");
            return dsPath;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String exportStudyExternalDictionaries(String studyId, SasFileCreateParameters fileCreateParameters, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting study dictionaries : " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ExportFileCreateInfo ei = ContentCreationParametersHelper.toExportFileCreateInfo(fileCreateParameters);
            String dsPath = StudyService.doGetService().exportStudyExternalDictionariesToDataSet(studyId, ei);
            result.init(0, "Success.");
            return dsPath;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String exportStudyValueLevelMetadata(String studyId, String baseStandardName, String modelId, SasFileCreateParameters fileCreateParameters, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting study value level metadata : " + studyId));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            ExportFileCreateInfo ei = ContentCreationParametersHelper.toExportFileCreateInfo(fileCreateParameters);
            String dsPath = StudyService.doGetService().exportValueLevelMetadataToDataSet(studyId, baseStandardName, modelId, ei);
            result.init(0, "Success.");
            return dsPath;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String exportStudySupportingDocuments(String studyId, String baseStandardName, String modelId, SasFileCreateParameters fileCreateParameters, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting study documents : " + studyId));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            ExportFileCreateInfo ei = ContentCreationParametersHelper.toExportFileCreateInfo(fileCreateParameters);
            String dsPath = StudyService.doGetService().exportSupportingDocumentsToDataSet(studyId, baseStandardName, modelId, ei);
            result.init(0, "Success.");
            return dsPath;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void exportStudyTablesToRepository(String studyId, String baseStandardName, String modelId, SasBatchFileCreateParameters batchFileCreateInfo, SasPathResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting study tables to repository : " + studyId));
        }
        try {
            StudyService.doExportStudyTables(SourceLocation.REPOSITORY.name(), studyId, baseStandardName, modelId, batchFileCreateInfo, result);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void exportStudyTablesToWorkspace(String studyId, String baseStandardName, String modelId, SasBatchFileCreateParameters batchFileCreateInfo, SasPathResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting study tables to workspace : " + studyId));
        }
        try {
            StudyService.doExportStudyTables(SourceLocation.WORKSPACE.name(), studyId, baseStandardName, modelId, batchFileCreateInfo, result);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void exportStudyTlfsToRepository(String studyId, String baseStandardName, String modelId, SasBatchFileCreateParameters batchFileCreateInfo, String includeResultsAndDatasets, SasPathResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting study TLFs to repository : " + studyId));
        }
        try {
            StudyService.doExportStudyTLFs(SourceLocation.REPOSITORY.name(), studyId, baseStandardName, modelId, batchFileCreateInfo, includeResultsAndDatasets, result);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void exportStudyTlfsToWorkspace(String studyId, String baseStandardName, String modelId, SasBatchFileCreateParameters batchFileCreateInfo, String includeResultsAndDatasets, SasPathResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting study TLFs to workspace : " + studyId));
        }
        try {
            StudyService.doExportStudyTLFs(SourceLocation.WORKSPACE.name(), studyId, baseStandardName, modelId, batchFileCreateInfo, includeResultsAndDatasets, result);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String exportTableZeroObsDatasetsToRepository(String studyId, String baseStandardName, String modelId, SasBatchFileCreateParameters batchFileCreateInfo, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting study tables zero obs data sets to repository : " + studyId));
        }
        try {
            return StudyService.doExportZeroObsDatasetsForStudyTables(SourceLocation.REPOSITORY.name(), studyId, baseStandardName, modelId, batchFileCreateInfo, result);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static String exportTableZeroObsDatasetsToWorkspace(String studyId, String baseStandardName, String modelId, SasBatchFileCreateParameters batchFileCreateInfo, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting study tables zero obs data sets to workspace : " + studyId));
        }
        try {
            return StudyService.doExportZeroObsDatasetsForStudyTables(SourceLocation.WORKSPACE.name(), studyId, baseStandardName, modelId, batchFileCreateInfo, result);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void importStudyFromDefine(String studyId, String standardId, SasClinicalUpdateParameters importParameters, SasFileCreateParameters reportFileParameters, SasStudyImportValidationResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Importing study from define file: " + studyId + " using standardId: " + standardId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ValidationUtils.validateRequiredParameter(standardId, "Standard id");
            StudyComponentImportInfo sci = ClinicalImportParametersHelper.toStudyComponentImportInfo(importParameters);
            ExportFileCreateInfo ei = ContentCreationParametersHelper.toClinicalImportValidationReportInfo(reportFileParameters);
            StudyUpdateResult sur = StudyService.doGetService().importStudyFromDefine(studyId, standardId, sci.getImportFilePath(), sci.getImportFileVersion(), sci.getImportFileSourceLocation(), sci.getUpdateAction(), ei);
            result.init(sur);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void importStudyDetails(String studyId, SasClinicalUpdateParameters importParameters, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Importing study details : " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            importParameters.setUpdateAction(UpdateAction.REPLACE.name());
            StudyComponentImportInfo sci = ClinicalImportParametersHelper.toStudyComponentImportInfo(importParameters);
            StudyService.doGetService().importStudyDetails(studyId, sci);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void importStudyCodelists(String studyId, SasClinicalUpdateParameters importParameters, SasFileCreateParameters reportFileParameters, SasStudyImportValidationResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Importing study codelists : " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            StudyComponentImportInfo sci = ClinicalImportParametersHelper.toStudyComponentImportInfo(importParameters);
            ExportFileCreateInfo ei = ContentCreationParametersHelper.toClinicalImportValidationReportInfo(reportFileParameters);
            StudyUpdateResult sur = StudyService.doGetService().importStudyCodeLists(studyId, sci, ei);
            result.init(sci, sur);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void importStudyValueLevelMetadata(String studyId, String baseStandardName, String modelId, SasClinicalUpdateParameters importParameters, SasFileCreateParameters reportFileParameters, SasStudyImportValidationResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Importing study value level metadata : " + studyId));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            StudyComponentImportInfo sci = ClinicalImportParametersHelper.toStudyComponentImportInfo(importParameters);
            ExportFileCreateInfo ei = ContentCreationParametersHelper.toClinicalImportValidationReportInfo(reportFileParameters);
            StudyUpdateResult sur = StudyService.doGetService().importStudyValueLevelMetadata(studyId, baseStandardName, modelId, sci, ei);
            result.init(baseStandardName, modelId, sci, sur);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void importStudySupportingDocuments(String studyId, String baseStandardName, String modelId, SasClinicalUpdateParameters importParameters, SasFileCreateParameters reportFileParameters, SasStudyImportValidationResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Importing study supporting documents : " + studyId));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            StudyComponentImportInfo sci = ClinicalImportParametersHelper.toStudyComponentImportInfo(importParameters);
            ExportFileCreateInfo ei = ContentCreationParametersHelper.toClinicalImportValidationReportInfo(reportFileParameters);
            StudyUpdateResult sur = StudyService.doGetService().importStudySupportingDocuments(studyId, baseStandardName, modelId, sci, ei);
            result.init(baseStandardName, modelId, sci, sur);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void importStudyTables(String studyId, String standardId, SasClinicalUpdateTablesParameters importTableParameters, SasFileCreateParameters reportFileParameters, SasStudyImportValidationResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Importing study tables : " + studyId));
        }
        try {
            ValidationUtils.validateRequiredParameter(studyId, "Study id");
            ValidationUtils.validateRequiredParameter(standardId, "Standard id");
            StudyTablesImportInfo sti = importTableParameters.toStudyTablesImportInfo();
            ExportFileCreateInfo ei = ContentCreationParametersHelper.toClinicalImportValidationReportInfo(reportFileParameters);
            StudyUpdateResult sur = StudyService.doGetService().importStudyTables(studyId, standardId, sti, ei);
            result.init(standardId, sti, sur);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void importStudyTlfs(String studyId, String baseStandardName, String modelId, SasClinicalUpdateTlfsParameters importTlfParameters, SasFileCreateParameters reportFileParameters, SasStudyImportValidationResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Importing study TLFs : " + studyId));
        }
        try {
            ValidationUtils.assertRequiredStudyBaseParameters(studyId, baseStandardName, modelId);
            TlfImportInfo ti = ClinicalImportParametersHelper.toTlfImportInfo(importTlfParameters);
            ExportFileCreateInfo ei = ContentCreationParametersHelper.toClinicalImportValidationReportInfo(reportFileParameters);
            StudyUpdateResult sur = StudyService.doGetService().importStudyTlfs(studyId, baseStandardName, modelId, ti, ei);
            result.init(baseStandardName, modelId, ti, sur);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

