/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.clinical.standards;

import com.sas.lsaf.clinical.common.BatchFileCreateInfo;
import com.sas.lsaf.clinical.standards.StandardDescriptor;
import com.sas.lsaf.core.EntityStatus;
import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.macro.clinical.standards.SasStandardsResult;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.result.SasPathResult;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.ContentCreationParametersHelper;
import com.sas.lsaf.macro.content.SasBatchFileCreateParameters;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StandardsService {
    private static final Log LOG = LogFactory.getLog(StandardsService.class);
    private static StandardsService FOR_COVERAGE = new StandardsService();

    private StandardsService() {
    }

    private static com.sas.lsaf.clinical.standards.StandardsService doGetService() {
        return ServiceManagerFactory.getApiStandardsService();
    }

    private static SasPathResult doExportStandardToDataSets(String standardId, String status, String standardVersion, SasBatchFileCreateParameters batchFileCreateParameters, SasPathResult result) {
        try {
            ValidationUtils.validateRequiredParameter(standardId, "Standard");
            EntityStatus es = ValidationUtils.validateEntityStatus(status);
            String sv = es.equals((Object)EntityStatus.PUBLISHED) ? standardVersion : null;
            BatchFileCreateInfo info = ContentCreationParametersHelper.toBatchFileCreateInfoWithPrefix(batchFileCreateParameters);
            Set paths = StandardsService.doGetService().exportStandardToDataSets(standardId, es, sv, info);
            result.setLocationAndPaths(info.getLocation(), paths);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
        return result;
    }

    public static String getStandardIdByNameAndStatus(String name, String status, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting id for " + status + " standard " + name));
        }
        try {
            ValidationUtils.validateRequiredParameter(name, "Standard");
            EntityStatus es = ValidationUtils.validateEntityStatus(status);
            StandardDescriptor sd = StandardsService.doGetService().getStandardDescriptorByNameAndStatus(name, es);
            result.init(0, "Success.");
            return sd.getId();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void getStandardsByStatus(String status, SasStandardsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting standards for state " + status));
        }
        try {
            EntityStatus es = ValidationUtils.validateEntityStatus(status);
            Set standards = StandardsService.doGetService().getStandardDescriptorsByStatus(es);
            result.setStandards(standards);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void exportStandardToDataSetsInRepository(String standardId, String status, String standardVersion, SasBatchFileCreateParameters batchFileCreateParms, SasPathResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting standards to Repository: " + standardId + ", status=" + status));
        }
        batchFileCreateParms.setLocation(SourceLocation.REPOSITORY.name());
        StandardsService.doExportStandardToDataSets(standardId, status, standardVersion, batchFileCreateParms, result);
    }

    public static void exportStandardToDataSetsInWorkspace(String standardId, String status, String standardVersion, SasBatchFileCreateParameters batchFileCreateParms, SasPathResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting standards to Workspace: " + standardId + ", status=" + status));
        }
        batchFileCreateParms.setLocation(SourceLocation.WORKSPACE.name());
        StandardsService.doExportStandardToDataSets(standardId, status, standardVersion, batchFileCreateParms, result);
    }
}

