/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.clinical.standards;

import com.sas.lsaf.clinical.standards.StandardDescriptor;
import com.sas.lsaf.core.EntityState;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SasStandardsResult
extends Result {
    private List<StandardDescriptor> standards = new ArrayList<StandardDescriptor>();

    public void setStandards(Set<StandardDescriptor> items) {
        this.standards = new ArrayList<StandardDescriptor>(items);
    }

    public List<StandardDescriptor> getStandards() {
        return this.standards;
    }

    public int getSize() {
        return this.standards.size();
    }

    public String getId(double index) {
        return this.standards.get((int)index).getId();
    }

    public String getName(double index) {
        return this.standards.get((int)index).getName();
    }

    public String getBaseStandardType(double index) {
        return this.standards.get((int)index).getBaseStandardTypeInfo().getType();
    }

    public String getBaseStandardName(double index) {
        return this.standards.get((int)index).getBaseStandardTypeInfo().getName();
    }

    public String getBaseStandardVersion(double index) {
        return this.standards.get((int)index).getBaseStandardTypeInfo().getVersion();
    }

    public String getModelId(double index) {
        return this.standards.get((int)index).getModelId();
    }

    public String getDescription(double index) {
        return this.standards.get((int)index).getDescription();
    }

    public int isCheckedOut(double index) {
        StandardDescriptor s = this.standards.get((int)index);
        return s.isCheckedOut() ? 1 : 0;
    }

    public String getCheckedOutBy(double index) {
        return SasUtils.toSasString(this.standards.get((int)index).getCheckedOutBy());
    }

    public String getCheckedOutDate(double index) {
        return SasUtils.toSasString(this.standards.get((int)index).getCheckedOutDate());
    }

    public String getCheckedOutDataSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.standards.get((int)index).getCheckedOutDate());
    }

    public String getCreated(double index) {
        return SasUtils.toSasString(this.standards.get((int)index).getCreated());
    }

    public String getCreatedSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.standards.get((int)index).getCreated());
    }

    public String getCreatedBy(double index) {
        return this.standards.get((int)index).getCreatedBy();
    }

    public String getState(double index) {
        return this.standards.get((int)index).getState().name();
    }

    public String getPublishedState(double index) {
        EntityState pubState = this.standards.get((int)index).getPublishedState();
        if (ValidationUtils.valueIsMissing((Serializable)pubState)) {
            return "";
        }
        return pubState.name();
    }

    public String getCurrentVersion(double index) {
        return this.standards.get((int)index).getCurrentVersion();
    }

    public long getAssociatedStudiesCount(double index) {
        return this.standards.get((int)index).getNumStudiesAssociated();
    }

    public String getLastModified(double index) {
        return SasUtils.toSasString(this.standards.get((int)index).getLastModified());
    }

    public String getLastModifiedSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.standards.get((int)index).getLastModified());
    }

    public String getLastModifiedBy(double index) {
        return this.standards.get((int)index).getLastModifiedBy();
    }

    public String getStandardStatus(double index) {
        return this.standards.get((int)index).getStandardStatus().name();
    }
}

