/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.clinical.externaldictionary;

import com.sas.lsaf.clinical.common.ExportFileCreateInfo;
import com.sas.lsaf.clinical.dictionary.ExternalDictionary;
import com.sas.lsaf.core.DataType;
import com.sas.lsaf.macro.clinical.externaldictionary.SasExternalDictionariesResult;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.ContentCreationParametersHelper;
import com.sas.lsaf.macro.content.SasFileCreateParameters;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ExternalDictionaryService {
    private static final Log LOG = LogFactory.getLog(ExternalDictionaryService.class);
    private static ExternalDictionaryService FOR_COVERAGE = new ExternalDictionaryService();

    private ExternalDictionaryService() {
    }

    private static com.sas.lsaf.clinical.dictionary.ExternalDictionaryService doGetService() {
        return ServiceManagerFactory.getApiExternalDictionaryService();
    }

    public static String getExternalDictionaryId(String dictionaryName, String dictionaryVersion, String dataType, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting id for " + dictionaryName + ", " + dictionaryVersion + ", " + dataType));
        }
        try {
            ValidationUtils.validateRequiredParameter(dictionaryName, "Dictionary");
            ValidationUtils.validateRequiredParameter(dictionaryVersion, "Version");
            DataType dt = (DataType)ValidationUtils.validateUpcasedEnum(dataType, "Type", DataType.class);
            ExternalDictionary ed = ExternalDictionaryService.doGetService().getExternalDictionary(dictionaryName, dt, dictionaryVersion);
            result.init(0, "Success.");
            return ed.getId();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void getExternalDictionaries(SasExternalDictionariesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Getting external dictionaries");
        }
        try {
            Set dictionaries = ExternalDictionaryService.doGetService().getExternalDictionaries();
            result.setDictionaries(dictionaries);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String exportExtDictionariesToDataSet(SasFileCreateParameters fileCreateParms, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Exporting external dictionaries to Repository.");
        }
        try {
            ExportFileCreateInfo info = ContentCreationParametersHelper.toExportFileCreateInfo(fileCreateParms);
            String dsPath = ExternalDictionaryService.doGetService().exportExternalDictionariesToDataSet(info);
            result.init(0, "Success.");
            return dsPath;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }
}

