/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.clinical.dictionary;

import com.sas.lsaf.clinical.common.ExportFileCreateInfo;
import com.sas.lsaf.clinical.dictionary.DictionaryDescriptor;
import com.sas.lsaf.core.EntityStatus;
import com.sas.lsaf.macro.clinical.dictionary.SasDictionariesResult;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.content.ContentCreationParametersHelper;
import com.sas.lsaf.macro.content.SasFileCreateParameters;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DictionaryService {
    private static final Log LOG = LogFactory.getLog(DictionaryService.class);
    private static DictionaryService FOR_COVERAGE = new DictionaryService();

    private DictionaryService() {
    }

    private static com.sas.lsaf.clinical.dictionary.DictionaryService doGetService() {
        return ServiceManagerFactory.getApiDictionaryService();
    }

    public static String getDictionaryIdByNameAndStatus(String name, String status, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting id for " + status + " dictionary " + name));
        }
        try {
            ValidationUtils.validateRequiredParameter(name, "Dictionary");
            EntityStatus es = ValidationUtils.validateEntityStatus(status);
            DictionaryDescriptor dd = DictionaryService.doGetService().getDictionaryDescriptorByNameAndStatus(name, es);
            result.init(0, "Success.");
            return dd.getId();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void getDictionariesByStatus(String status, SasDictionariesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting dictionaries for state " + status));
        }
        try {
            EntityStatus es = ValidationUtils.validateEntityStatus(status);
            Set dictionaries = DictionaryService.doGetService().getDictionaryDescriptorsByStatus(es);
            result.setDictionaries(dictionaries);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String exportDictionaryToDataSet(String dictionaryId, String status, String dictVersion, SasFileCreateParameters fileCreateParms, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting dictionary to Repository: " + dictionaryId + ", status=" + status));
        }
        try {
            ValidationUtils.validateRequiredParameter(dictionaryId, "Dictionary");
            EntityStatus es = ValidationUtils.validateEntityStatus(status);
            String dv = es.equals((Object)EntityStatus.PUBLISHED) ? dictVersion : null;
            ExportFileCreateInfo info = ContentCreationParametersHelper.toExportFileCreateInfo(fileCreateParms);
            String dsPath = DictionaryService.doGetService().exportDictionaryToDataSet(dictionaryId, es, dv, info);
            result.init(0, "Success.");
            return dsPath;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }
}

