/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.clinical;

import com.sas.lsaf.clinical.common.UpdateAction;
import com.sas.lsaf.clinical.study.StudyTablesImportInfo;
import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.macro.clinical.ClinicalImportParametersHelper;
import com.sas.lsaf.macro.clinical.SasClinicalImportTablesParameters;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;

public class SasClinicalUpdateTablesParameters
extends SasClinicalImportTablesParameters {
    private String action;

    public void updateImportData(String srcLocation, String action, String tablesPath, String tablesVersion, String columnsPath, String columnsVersion) {
        this.updateImportData(srcLocation, tablesPath, tablesVersion, columnsPath, columnsVersion);
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public StudyTablesImportInfo toStudyTablesImportInfo() {
        SourceLocation srcLoc = ValidationUtils.validateSourceLocation(this.sourceLocation);
        ValidationUtils.validateRequiredParameter(this.tablesFilePath, "Tables file path");
        ValidationUtils.validateRequiredParameter(this.columnsFilePath, "Columns file path");
        UpdateAction ua = ClinicalImportParametersHelper.doValidateClinicalUpdateAction(this.action);
        StudyTablesImportInfo info = new StudyTablesImportInfo(this.tablesFilePath, ValidationUtils.toJavaString(this.tablesFileVersion), this.columnsFilePath, ValidationUtils.toJavaString(this.columnsFileVersion), srcLoc, ua);
        return info;
    }
}

