/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.clinical;

import com.sas.lsaf.clinical.common.ClinicalUpdateResult;
import com.sas.lsaf.clinical.common.UpdateAction;
import com.sas.lsaf.clinical.study.StudyComponentImportInfo;
import com.sas.lsaf.clinical.study.StudyTablesImportInfo;
import com.sas.lsaf.clinical.tlf.TlfImportInfo;
import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.core.ValidationMessage;
import com.sas.lsaf.core.ValidationResult;
import com.sas.lsaf.macro.common.result.SasPropertiesResult;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SasClinicalImportValidationResult
extends SasPropertiesResult {
    public static final String COMPLETION_STATUS_MSG_UNKNOWN = "Completion status unknown.";
    public static final String COMPLETION_STATUS_MSG_ERRORS = "The import completed with one or more errors reported.";
    public static final String COMPLETION_STATUS_MSG_WARNINGS = "The import completed with one or more warnings reported.";
    public static final String COMPLETION_STATUS_MSG_NOTES = "The import completed with one or more notes reported.";
    public static final String PROP_IMPORT_ACTION = "importAction";
    public static final String PROP_IMPORT_SOURCEFILE_LOCATION = "importSourceFileLocation";
    public static final String PROP_IMPORT_SOURCEFILE_PATH = "importSourceFilePath";
    public static final String PROP_IMPORT_SOURCEFILE_VERSION = "importSourceFileVersion";
    public static final String PROP_IMPORT_SECTIONS_PATH = "importSectionsFilePath";
    public static final String PROP_IMPORT_SECTIONS_VERSION = "importSectionsFileVersion";
    public static final String PROP_IMPORT_RESULTS_PATH = "importResultsFilePath";
    public static final String PROP_IMPORT_RESULTS_VERSION = "importResultsFileVersion";
    public static final String PROP_IMPORT_DATASETS_PATH = "importDatasetsFilePath";
    public static final String PROP_IMPORT_DATASETS_VERSION = "importDatasetsFileVersion";
    public static final String PROP_IMPORT_TLFS_PATH = "importTlfFilePath";
    public static final String PROP_IMPORT_TLFS_VERSION = "importTlfFileVersion";
    public static final String PROP_IMPORT_TABLES_PATH = "importTablesFilePath";
    public static final String PROP_IMPORT_TABLES_VERSION = "importTablesFileVersion";
    public static final String PROP_IMPORT_COLUMNS_PATH = "importColumnsFilePath";
    public static final String PROP_IMPORT_COLUMNS_VERSION = "importColumnsFileVersion";
    public static final String PROP_RUN_BY = "runBy";
    public static final String PROP_RUNDATE = "runDate";
    public static final String PROP_RUNDATE_SASFMT = "runDateSASFmt";
    public static final String PROP_VALIDATION_REPORT_LOCATION = "validationReportLocation";
    public static final String PROP_VALIDATION_REPORT_PATH = "validationReportPath";
    public static final String PROP_ERROR_COUNT = "errorCount";
    public static final String PROP_WARNING_COUNT = "warningCount";
    public static final String PROP_NOTE_COUNT = "noteCount";
    public static final String PROP_COMPLETION_STATUS = "completionStatus";
    public static final String PROP_COMPLETION_STATUS_MSG = "completionStatusMessage";
    private List<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
    private ImportCompletionStatus completionStatus = ImportCompletionStatus.UNKNOWN;
    private String completionStatusMessage = "Completion status unknown.";

    private void doAddUpdateActionPropery(UpdateAction ua) {
        this.addProperty(PROP_IMPORT_ACTION, ua.name());
    }

    private String doGetValidationMessageDetailedProblem(ValidationMessage vm) {
        if (vm == null) {
            return "";
        }
        int rowNum = vm.getRowNumber();
        String colName = vm.getColumnName();
        ArrayList<Object> msgParts = new ArrayList<Object>();
        if (rowNum > 0) {
            msgParts.add("Row: " + SasUtils.toSasString(rowNum));
        }
        if (!ValidationUtils.valueIsMissing((Serializable)((Object)colName))) {
            msgParts.add("Column: " + SasUtils.toSasString(vm.getColumnName()));
        }
        msgParts.add(SasUtils.toSasString(vm.getProblem()));
        return SasUtils.toSasCommaDelimitedString(msgParts);
    }

    private void doSetCompletionProperties() {
        this.addProperty(PROP_COMPLETION_STATUS, this.completionStatus.name());
        this.addProperty(PROP_COMPLETION_STATUS_MSG, this.completionStatusMessage);
    }

    private void doSetResults(ClinicalUpdateResult cur) {
        if (cur == null) {
            this.doSetCompletionProperties();
            super.init(0, "Success.");
            return;
        }
        SourceLocation sl = cur.getValidationReportSourceLocation();
        this.addProperty(PROP_VALIDATION_REPORT_LOCATION, sl == null ? "" : sl.name());
        this.addProperty(PROP_VALIDATION_REPORT_PATH, SasUtils.toSasString(cur.getValidationReportPath()));
        ValidationResult vr = cur.getValidationResult();
        this.validationMessages.addAll(vr.getErrors());
        this.validationMessages.addAll(vr.getWarnings());
        this.validationMessages.addAll(vr.getNotes());
        this.addProperty(PROP_RUN_BY, vr.getRunBy());
        this.addProperty(PROP_RUNDATE, SasUtils.toSasString(vr.getRunDate()));
        this.addProperty(PROP_RUNDATE_SASFMT, SasUtils.toSasDatetimeFormat(vr.getRunDate()));
        int errorCnt = vr.getErrors().size();
        int warningCnt = vr.getWarnings().size();
        int noteCnt = vr.getNotes().size();
        this.completionStatusMessage = SasClinicalImportValidationResult.getCountsCompletionStatusMessage(errorCnt, warningCnt, noteCnt);
        int code = 0;
        String message = "Success.";
        if (errorCnt > 0) {
            this.completionStatus = ImportCompletionStatus.ERROR;
            code = -302;
            message = COMPLETION_STATUS_MSG_ERRORS;
        } else if (warningCnt > 0) {
            this.completionStatus = ImportCompletionStatus.WARNING;
            code = -301;
            message = COMPLETION_STATUS_MSG_WARNINGS;
        } else if (noteCnt > 0) {
            this.completionStatus = ImportCompletionStatus.NOTE;
            code = -300;
            message = COMPLETION_STATUS_MSG_NOTES;
        } else {
            this.completionStatus = ImportCompletionStatus.SUCCESSFUL;
        }
        this.doSetCompletionProperties();
        this.addProperty(PROP_ERROR_COUNT, SasUtils.toSasString(errorCnt));
        this.addProperty(PROP_WARNING_COUNT, SasUtils.toSasString(warningCnt));
        this.addProperty(PROP_NOTE_COUNT, SasUtils.toSasString(noteCnt));
        for (ValidationMessage vm : this.validationMessages) {
            this.addProperty(vm.getSeverity().name(), this.doGetValidationMessageDetailedProblem(vm));
        }
        super.init(code, message);
    }

    public void init(ClinicalUpdateResult cur) {
        this.doSetResults(cur);
    }

    public void init(StudyComponentImportInfo sci, ClinicalUpdateResult cur) {
        this.addProperty(PROP_IMPORT_SOURCEFILE_LOCATION, sci.getImportFileSourceLocation().name());
        this.addProperty(PROP_IMPORT_SOURCEFILE_PATH, sci.getImportFilePath());
        this.addProperty(PROP_IMPORT_SOURCEFILE_VERSION, sci.getImportFileVersion());
        this.doAddUpdateActionPropery(sci.getUpdateAction());
        this.doSetResults(cur);
    }

    public void init(StudyTablesImportInfo sti, ClinicalUpdateResult cur) {
        this.addProperty(PROP_IMPORT_SOURCEFILE_LOCATION, sti.getImportFileSourceLocation().name());
        this.addProperty(PROP_IMPORT_TABLES_PATH, sti.getTablesImportFilePath());
        this.addProperty(PROP_IMPORT_TABLES_VERSION, sti.getTablesImportFileVersion());
        this.addProperty(PROP_IMPORT_COLUMNS_PATH, sti.getColumnsImportFilePath());
        this.addProperty(PROP_IMPORT_COLUMNS_VERSION, sti.getColumnsImportFileVersion());
        this.doAddUpdateActionPropery(sti.getUpdateAction());
        this.doSetResults(cur);
    }

    public void init(TlfImportInfo tti, ClinicalUpdateResult cur) {
        this.addProperty(PROP_IMPORT_SOURCEFILE_LOCATION, tti.getImportFileSourceLocation().name());
        this.addProperty(PROP_IMPORT_SECTIONS_PATH, tti.getSectionsFilePath());
        this.addProperty(PROP_IMPORT_SECTIONS_VERSION, tti.getSectionsFileVersion());
        this.addProperty(PROP_IMPORT_RESULTS_PATH, tti.getResultsFilePath());
        this.addProperty(PROP_IMPORT_RESULTS_VERSION, tti.getResultsFileVersion());
        this.addProperty(PROP_IMPORT_DATASETS_PATH, tti.getDataSetsFilePath());
        this.addProperty(PROP_IMPORT_DATASETS_VERSION, tti.getDataSetsFileVersion());
        this.addProperty(PROP_IMPORT_TLFS_PATH, tti.getTlfsFilePath());
        this.addProperty(PROP_IMPORT_TLFS_VERSION, tti.getTlfsFileVersion());
        this.doAddUpdateActionPropery(tti.getUpdateAction());
        this.doSetResults(cur);
    }

    public String getCompletionStatus() {
        return this.completionStatus == null ? "" : this.completionStatus.name();
    }

    public String getCompletionStatusMessage() {
        return this.completionStatusMessage;
    }

    public List<ValidationMessage> getValidationMessages() {
        return this.validationMessages;
    }

    public int getValidationMessagesSize() {
        return this.validationMessages.size();
    }

    public String getMessageSeverity(double index) {
        return this.validationMessages.get((int)index).getSeverity().name();
    }

    public String getMessageProblem(double index) {
        return this.validationMessages.get((int)index).getProblem();
    }

    public String getMessageDetailedProblem(double index) {
        return this.doGetValidationMessageDetailedProblem(this.validationMessages.get((int)index));
    }

    public static String getCountsCompletionStatusMessage(int errorCnt, int warningCnt, int noteCnt) {
        StringBuffer sb = new StringBuffer("Import validation reported ");
        sb.append(errorCnt + (errorCnt == 1 ? " Error, " : " Errors, "));
        sb.append(warningCnt + (warningCnt == 1 ? " Warning, " : " Warnings, "));
        sb.append(noteCnt + (noteCnt == 1 ? " Note. " : " Notes."));
        return sb.toString();
    }

    public static enum ImportCompletionStatus {
        UNKNOWN,
        ERROR,
        WARNING,
        NOTE,
        SUCCESSFUL;

    }
}

