/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.clinical;

import com.sas.lsaf.clinical.common.UpdateAction;
import com.sas.lsaf.clinical.study.StudyComponentImportInfo;
import com.sas.lsaf.clinical.tlf.TlfImportInfo;
import com.sas.lsaf.clinical.tlftemplate.TlfTemplateImportInfo;
import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.macro.clinical.SasClinicalUpdateParameters;
import com.sas.lsaf.macro.clinical.SasClinicalUpdateTlfsParameters;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;

public class ClinicalImportParametersHelper {
    protected static UpdateAction doValidateClinicalUpdateAction(String value) {
        return (UpdateAction)ValidationUtils.validateUpcasedEnum(value, "Update action", UpdateAction.class);
    }

    private static TlfImportInfo setTlfImportInfo(TlfImportInfo info, SasClinicalUpdateTlfsParameters parms) {
        SourceLocation srcLoc = ValidationUtils.validateSourceLocation(parms.getSourceLocation());
        UpdateAction ua = ClinicalImportParametersHelper.doValidateClinicalUpdateAction(parms.getAction());
        String sectionsPath = ValidationUtils.validateRequiredParameter(parms.getSectionsFilePath(), "Sections file path");
        String tlfsPath = ValidationUtils.validateRequiredParameter(parms.getTlfsFilePath(), "TLF file path");
        info.setImportFileSourceLocation(srcLoc);
        info.setUpdateAction(ua);
        info.setSectionsFilePath(sectionsPath);
        info.setSectionsFileVersion(ValidationUtils.toJavaString(parms.getSectionsFileVersion()));
        info.setTlfsFilePath(tlfsPath);
        info.setTlfsFileVersion(ValidationUtils.toJavaString(parms.getTlfsFileVersion()));
        info.setResultsFilePath(ValidationUtils.toJavaString(parms.getResultsFilePath()));
        info.setResultsFileVersion(ValidationUtils.toJavaString(parms.getResultsFileVersion()));
        info.setDataSetsFilePath(ValidationUtils.toJavaString(parms.getDataSetsFilePath()));
        info.setDataSetsFileVersion(ValidationUtils.toJavaString(parms.getDataSetsFileVersion()));
        return info;
    }

    public static TlfImportInfo toTlfImportInfo(SasClinicalUpdateTlfsParameters parms) {
        TlfImportInfo info = new TlfImportInfo();
        ClinicalImportParametersHelper.setTlfImportInfo(info, parms);
        return info;
    }

    public static TlfTemplateImportInfo toTlfTemplateImportInfo(String tlfTemplateId, SasClinicalUpdateTlfsParameters parms) {
        TlfTemplateImportInfo info = new TlfTemplateImportInfo();
        info.setTlfTemplateId(tlfTemplateId);
        ClinicalImportParametersHelper.setTlfImportInfo((TlfImportInfo)info, parms);
        return info;
    }

    public static StudyComponentImportInfo toStudyComponentImportInfo(SasClinicalUpdateParameters updateParms) {
        ValidationUtils.assertRequiredPath(updateParms.getFilePath());
        StudyComponentImportInfo info = new StudyComponentImportInfo();
        info.setImportFilePath(updateParms.getFilePath());
        info.setImportFileSourceLocation(ValidationUtils.validateSourceLocation(updateParms.getSourceLocation()));
        info.setImportSourceVersion(ValidationUtils.toJavaString(updateParms.getFileVersion()));
        info.setUpdateAction(ClinicalImportParametersHelper.doValidateClinicalUpdateAction(updateParms.getUpdateAction()));
        return info;
    }
}

