import com.sas.app.*;               // sas.launcher.jar classes
import java.util.LinkedHashSet;
import java.net.URL;

// This script will convert a picklist into a single STDOUT classpath string.
// For example, use this string to configure 3rd party software to consume a set of jars
// shipped by SAS that are in the VJR.
//
// A requirement is that groovy-all.jar is in the picklist, so that this groovy script can be executed.
//
// Parameters (key=value) to PicklistToClasspath.groovy:
//   picklist - The picklist filename that will be converted to a single classpath string.  Required.
//   exclude  - Comma seperated set of jars to exclude from the picklist.  Optional.
//              Typically, need to exclude groovy-all.jar.
//              This groovy will prepend the OS specific file seperator when looking for a match,
//              so that partial matches are not accidentally excluded.
//

class PicklistToClasspath {

   static void main(String[] args) {

      HashMap<String,String> argsHashMap = new HashMap<>()

      // Parse all key=value pairs.  If no value, then use zero length string
      for (String arg : args) {
         String[] strkey = new String()
         strkey = arg.split( '=' )
         if ( strkey.length > 1 ) {
           argsHashMap.put( strkey[0], strkey[1] )
         }
         else {
           argsHashMap.put( strkey[0], '' )
         }
      }

      // for (String s : argsHashMap.keySet()) {
      //    println s + " is " + argsHashMap.get(s)
      // }

      if ( false == argsHashMap.containsKey('picklist') ) {
         println "Failure:  Mising required parameter 'picklist' for PicklistToClasspath.groovy"
         System.exit( 1 )
      }

      // Look for arg "exclude" to skip a comma sepearated list of jars
      def excludeJars = argsHashMap.get( 'exclude' )
      def excludeJarList = null
      if ( null == excludeJars ) {
      }
      else {
         excludeJarList = excludeJars.split( ',' )
      }

      File f = new File( argsHashMap.get( 'picklist' ) );
      PickList pickList = new PickList( f )

      Repository repository = Repository.getDefaultRepository()

      LinkedHashSet plugins = new LinkedHashSet()

      Plugin[] plugin = RepositoryUtil.getClasspath( repository
                                                   , pickList
                                                   , plugins
                                                   , null ) // Map usedPluginNameVersions (may be null)

      String classpath = new String()

      // Iterate through all of the picklist fq file names
      for (URL aURL : plugins) {
         def jarFileName

         if ( System.properties['os.name'].toLowerCase().contains('windows') ) {
            File jarFile = new File(aURL.toURI());
            jarFileName = jarFile.getAbsolutePath()
         }
         else {
            jarFileName = aURL.getFile()
         }

         // If no command line option to skip jar names
         if ( null == excludeJarList ) {
           if ( classpath.length() == 0 ) {
              classpath = jarFileName
           }
           else {
              classpath = classpath + File.pathSeparator + jarFileName
           }
         }
         // Else look for jars to skip over
         else {
            def excludeThisJar = false
            for (String excludeJar : excludeJarList ) {
               if ( jarFileName.endsWith( File.separator + excludeJar ) ) {
                  excludeThisJar = true
               }
            }
            if ( true == excludeThisJar ) {
            }
            else {
               if ( classpath.length() == 0 ) {
                  classpath = jarFileName
               }
               else {
                  classpath = classpath + File.pathSeparator + jarFileName
               }
            }
         }

      }
      println classpath
      System.exit( 0 )
   }
}
