// (c) 2014, SAS Institute Inc.

sap.ui.define(['jquery.sap.global', 'sap/ui/core/Core',
    "sap/ui/unified/library", // library dependency
    "sap/ui/core/library" // library dependency
],
    function(jQuery) {
        "use strict";

        /**
         * @namespace
         * @name sas.hc.ui.unified
         * @public
         */

        /**
         * @namespace
         * @name sas.hc.ui.unified.calendar
         * @public
         */

        // delegate further initialization of this library to the Core
        sap.ui.getCore().initLibrary({
            name : "sas.hc.ui.unified",
            dependencies : ["sap.ui.unified","sap.ui.core"],
            types : [
                "sas.hc.ui.unified.DayName"
            ],
            interfaces : [
            ],
            controls : [
                "sas.hc.ui.unified.Calendar",
                "sas.hc.ui.unified.CalendarAppointment",
                "sas.hc.ui.unified.CalendarLegend",
                "sas.hc.ui.unified.CalendarLegendItem",
                "sas.hc.ui.unified.CalendarMonthInterval",
                "sas.hc.ui.unified.CalendarRow",
                "sas.hc.ui.unified.CalendarTimeInterval",
                "sas.hc.ui.unified.ContentSwitcher",
                "sas.hc.ui.unified.Currency",
                "sas.hc.ui.unified.DateRange",
                "sas.hc.ui.unified.DateTypeRange",
                "sas.hc.ui.unified.FileUploader",
                "sas.hc.ui.unified.FileUploaderParameter",
                "sas.hc.ui.unified.Menu",
                "sas.hc.ui.unified.MenuItem",
                "sas.hc.ui.unified.MenuItemBase",
                "sas.hc.ui.unified.MenuTextFieldItem",
                "sas.hc.ui.unified.Shell",
                "sas.hc.ui.unified.ShellHeadItem",
                "sas.hc.ui.unified.ShellHeadUserItem",
                "sas.hc.ui.unified.ShellLayout",
                "sas.hc.ui.unified.ShellOverlay",
                "sas.hc.ui.unified.SplitContainer",
                "sas.hc.ui.unified.calendar.DatesRow",
                "sas.hc.ui.unified.calendar.Header",
                "sas.hc.ui.unified.calendar.Month",
                "sas.hc.ui.unified.calendar.MonthPicker",
                "sas.hc.ui.unified.calendar.MonthsRow",
                "sas.hc.ui.unified.calendar.TimesRow",
                "sas.hc.ui.unified.calendar.YearPicker"
            ],
            elements : [
            ],
            version : "904001.11.16.20251118090100_f0htmcm94p"
        });


        var thisLib = sas.hc.ui.unified;

        /**
         * Predefined types for Calendar Day Name.
         *
         * @enum {int}
         * @public
         */
        thisLib.DayName = {

            /**
             * Sunday type
             * @public
             */
            Sunday : "Sunday",

            /**
             * Monday type
             * @public
             */
            Monday : "Monday",

            /**
             * Tuesday type
             * @public
             */
            Tuesday : "Tuesday",

            /**
             * Wednesday type
             * @public
             */
            Wednesday : "Wednesday",

            /**
             * Thursday type
             * @public
             */
            Thursday : "Thursday",

            /**
             * Friday type
             * @public
             */
            Friday : "Friday",

            /**
             * Saturday type
             * @public
             */
            Saturday : "Saturday"

        };

        return sas.hc.ui.unified;
    }
);