// (c) 2018, SAS Institute Inc.

/**
 * SAS class for sas.hc.ui.unified.DayRange for HTML Commons.
 * @name sas.hc.ui.unified.DayRange
 * @extends sap.ui.core.Element
 */
sap.ui.define([
    "jquery.sap.global",
    "sap/ui/core/Core",
    "sap/ui/core/library",
    "sas/hc/ui/unified/library"
],
    //Provides control sas.hc.ui.unified.DayRange.
    function(){
        jQuery.sap.require("sap.ui.core.Element");


        /**
         * Constructor for a new DayRange.
         *
         * @param {string} [sId] id for the new control, generated automatically if no id is given
         * @param {object} [mSettings] initial settings for the new control
         *
         * @class
         * Day range for use in Calendar
         * @extends sap.ui.core.Element
         * @version 904001.11.16.20251118090100_f0htmcm94p
         *
         * @constructor
         * @public
         * @since HC9.0
         */
        sap.ui.core.Element.extend("sas.hc.ui.unified.DayRange", {
            metadata : {
                library : "sas.hc.ui.unified",
                properties : {

                    /**
                     * Start day for a day range. This must be a sas.hc.ui.unified.DayName.
                     */
                    startDay : {type : "sas.hc.ui.unified.DayName", group : "Misc"},

                    /**
                     * End day for a day range. If empty only a single day is presented by this DayRange element. This must be a sas.hc.ui.unified.DayName.
                     */
                    endDay : {type : "sas.hc.ui.unified.DayName", group : "Misc"}
                }
            }
        });

    }
);
