sap.ui.define([
    "./TreeTable",
    "./WideTable"
], function(TreeTable, WideTable) {

    /**
     * Constructor for a new WideTreeTable.
     *
     * @param {string} [sId] id for the new control, generated automatically if no id is given
     * @param {object} [mSettings] initial settings for the new control
     *
     * @class
     * <p>
     *   Enhances the regular TreeTable control to improve rendering performance when there are many columns.
     *   Columns in WideTreeTable must be given an absolute width (px or rem).
     * </p>
     *
     * @extends sas.hc.ui.table.TreeTable
     * @version 904001.11.16.20251118090100_f0htmcm94p
     *
     * @class sas.hc.ui.table.WideTreeTable
     * @public
     */

    /**
     * Sets and renders the first visible column (left-most or right-most in RTL mode).
     * @param {int | sas.hc.ui.table.Column} oColumn The column that should be the first rendered column.
     * @param {boolean} bRetainFocus Indicate if cell focus should be retained when the columns are rendered.
     * @public
     * @name sas.hc.ui.table.WideTreeTable.makeFirstVisibleColumn
     * @function
     */

    return sas.hc.ui.table.WideTreeTable;
});