/*!
 * (c) 2014-2018, SAS Institute Inc.
 */

// Provides helper sas.hc.ui.table.TableExtension.
sap.ui.define(['jquery.sap.global', 'sap/ui/base/Object', './TableUtils'],
    function(jQuery, BaseObject, TableUtils) {
        "use strict";

        /**
         * Base class of extensions for sas.hc.ui.table.Table, ...
         *
         * @class Base class of extensions for sas.hc.ui.table.Table, ...
         *
         * @extends sap.ui.base.Object
         * @author SAP SE
         * @version 904001.11.16.20251118090100_f0htmcm94p
         * @constructor
         * @private
         * @alias sas.hc.ui.table.TableExtension
         */
        var TableExtension = BaseObject.extend("sas.hc.ui.table.TableExtension", /* @lends sas.hc.ui.table.TableExtension */ {

            constructor : function(oTable, mSettings) {
                BaseObject.call(this);
                this._table = oTable;
                this._settings = mSettings || {};

                this._type = TableExtension.TABLETYPES.STANDARD;

                // S1289449 - Since we forked TreeTable we also need to check for our version of it here.
                if (TableUtils.isInstanceOf(oTable, "sas/hc/ui/table/TreeTable") || TableUtils.isInstanceOf(oTable, "sas/hc/ui/table/SapTreeTable")) {

                    this._type = TableExtension.TABLETYPES.TREE;
                } else if (TableUtils.isInstanceOf(oTable, "sas/hc/ui/table/AnalyticalTable")) {
                    this._type = TableExtension.TABLETYPES.ANALYTICAL;
                }

                var sName = this._init(this._table, this._type, this._settings);

                //Attaching a getter to the related table control
                if (sName) {
                    var that = this;
                    oTable["_get" + sName] = function(){ return that; };
                }
            },

            /*
             * @see sap.ui.base.Object#destroy
             */
            destroy : function() {
                this._table = null;
                this._type = null;
                BaseObject.prototype.destroy.apply(this, arguments);
            },

            /*
             * @see sap.ui.base.Object#getInterface
             */
            getInterface : function() { return this; }

        });

        TableExtension.TABLETYPES = {
            TREE: "TREE",
            ANALYTICAL: "ANALYTICAL",
            STANDARD: "STANDARD"
        };

        /*
         * Returns the related table control.
         * @public (Part of the API for Table control only!)
         */
        TableExtension.prototype.getTable = function() {
            return this._table;
        };

        /*
         * Init function may be overridden by the subclasses
         */
        TableExtension.prototype._init = function(oTable, sTableType, mSettings) { return null; };


        /*
         * Initializes the Extension with the given type and attaches it to the given Table control.
         * @public (Part of the API for Table control only!)
         */
        TableExtension.enrich = function(oTable, oExtensionClass, mSettings) {
            if (!oExtensionClass || !(oExtensionClass.prototype instanceof TableExtension)) {
                return null;
            }

            var oExtension = new oExtensionClass(oTable, mSettings);
            return oExtension;
        };

        return TableExtension;

    });