/*
 * @sasViyaOnly
 */
sap.ui.define(['jquery.sap.global', 'sap/ui/base/EventProvider'], function(jQuery, EventProvider) {
    "use strict";

    /**
     * Creates an instance of AttachmentReader.
     *
     * @class
     *
     * @extends sap.ui.base.EventProvider
     * @version 904001.11.16.20251118090100_f0htmcm94p
     * @constructor
     * @public
     * @alias sas.hc.ui.services.comment.petrichor.util.AttachmentReader
     */
    var AttachmentReader = EventProvider.extend('sas.hc.ui.services.comment.petrichor.util.AttachmentReader',{
        metadata: {
            events: {
                "complete": {enableEventBubbling: true}
            }
        },

        constructor: function(oAttachments){
            EventProvider.call(this);
            this._attachments = [];
            this._attachmentsToAdd = [];
            this._attachments = oAttachments;
        }
    }
    );

    AttachmentReader.M_EVENTS = {
        "complete": "complete"
    };

    AttachmentReader.prototype.readAttachment = function() {
        var needToAdd = false;

        this._attachmentLoadCount = 0;
        this._attachmentLoadErrorOccured = false;
        this._filesNameOnWhichLoadErrorOccur = [];

        for(var i=0; i < this._attachments.length; i++){
            var attmnt = this._attachments[i];
            if (attmnt.id !== 0 && !attmnt.id) {
                var reader = new FileReader();
                reader.onload = jQuery.proxy(this._handleFileReaderOnload, this);
                reader.onerror = jQuery.proxy(this._handleFileReaderOnerror, this);

                reader.attachment = attmnt;
                this._attachmentsToAdd.push(attmnt);

                // read the file as byte array.
                reader.readAsArrayBuffer(attmnt.fileRef);

                needToAdd = true;
            }
        }

        if(!needToAdd) {
            this.fireEvent("complete");
        }
    };

    AttachmentReader.prototype._handleFileReaderOnload = function(oEvent) {
        var data = {}, attachment = oEvent.target.attachment; //, indx;

        delete oEvent.target.attachment;

        attachment.data = oEvent.target.result;

        this._attachmentLoadCount++;
        if(this._attachmentLoadCount === this._attachmentsToAdd.length) {
            data.attachments = this._attachmentsToAdd;
            if(this._attachmentLoadErrorOccured){
                data.errorFileName = this._filesNameOnWhichLoadErrorOccur;
            }
            this.fireEvent("complete",data);
        }

        // remove the assigned handlers
        oEvent.target.onload = undefined;
        oEvent.target.onerror = undefined;
    };

    AttachmentReader.prototype._handleFileReaderOnerror = function(oEvent) {
        var fileNm = oEvent.target.attachment.name, data = {};

        // removing the added attachments' data
        this._filesNameOnWhichLoadErrorOccur.push(fileNm);
        this._attachmentLoadErrorOccured = true;

        this._attachmentLoadCount++;
        if (this._attachmentLoadCount === this._attachmentsToAdd.length) {
            data.attachments = this._attachmentsToAdd;
            data.errorFileNames = this._filesNameOnWhichLoadErrorOccur;
            this.fireEvent("complete",data);
        }

        // remove the assigned handlers
        oEvent.target.onload = undefined;
        oEvent.target.onerror = undefined;
    };

    return AttachmentReader;
});