/**
 * Provides helper sas.hc.ui.commons.LargeTreeKeyboardExtension
 *
 * @class Extension for sas.hc.ui.commons.LargeTreeKeyboardExtension which handles keyboard related things.
 *
 * @extends sas.hc.ui.table.TableKeyboardExtension
 * @author SAS
 * @version 904001.11.16.20251118090100_f0htmcm94p
 * @constructor
 * @private
 */

sap.ui.define(['sas/hc/ui/commons/LargeTreeKeyboardDelegate', 'sas/hc/ui/table/TableKeyboardExtension', 'sas/hc/ui/table/TableUtils'],
    function(LargeTreeKeyboardDelegate, TableKeyboardExtension, TableUtils) {
        "use strict";

        var LargeTreeKeyboardExtension = TableKeyboardExtension.extend("sas.hc.ui.commons.LargeTreeKeyboardExtension", {});

        /* To create large tree's own delegate*/
        LargeTreeKeyboardExtension.prototype._createTableKeyboardDelegate = function(sTableType) {
            return new LargeTreeKeyboardDelegate(sTableType);
        };

        /* overridden method*/
        LargeTreeKeyboardExtension.prototype._onsapnext = function(oTable, oEvent) {
            return oTable._getKeyboardExtension()._handleSapNext(oTable, oEvent);
        };

        /* sets the focus on arrow key when right arrow key is pressed*/
        LargeTreeKeyboardExtension.prototype._handleSapNext = function (oTable, oEvent) {
            return new Promise(function (resolve) {
                function doSuper() {
                    if (!oTable._getItemNavigation()) {
                        return;
                    }
                    oTable._getItemNavigation()['onsapnext'](oEvent);
                }

                if (oEvent.keyCode !== jQuery.sap.KeyCodes.ARROW_RIGHT) {
                    return;
                }
                doSuper();
                resolve();
                oTable._getKeyboardExtension().setActionMode(true, {$Dom: oEvent.target});
            });
        };

        /* overridden method*/
        LargeTreeKeyboardExtension.prototype._onsapprevious = function(oTable, oEvent) {
            return oTable._getKeyboardExtension()._handleSapPrevious(oTable, oEvent);
        };

        /* sets the focus on arrow key when left arrow key is pressed*/
        LargeTreeKeyboardExtension.prototype._handleSapPrevious = function (oTable, oEvent) {
            return new Promise(function (resolve) {
                function doSuper() {
                    if (!oTable._getItemNavigation()) {
                        return;
                    }
                    oTable._getItemNavigation()['onsapnext'](oEvent);
                }

                if (oEvent.keyCode !== jQuery.sap.KeyCodes.ARROW_LEFT) {
                    return;
                }
                doSuper();
                resolve();
                oTable._getKeyboardExtension().setActionMode(true, {$Dom: oEvent.target});
            });
        };

        return LargeTreeKeyboardExtension;
    });
