// (c) 2015, SAS Institute Inc.
sap.ui.define([
    "jquery.sap.global",
    "sas/hc/m/IconTabBar"
], function(jQuery, IconTabBar) {
    "use strict";

    /**
     * Constructor for a new ObjectInspector IconTabBar
     *
     * Manages css class to be applied depending on if there is one tab ("item") or not
     *
     * @class
     * @name sas.hc.m.objectInspector.IconTabBar
     * @extends sas.hc.m.IconTabBar
     * @version 904001.11.16.20251118090100_f0htmcm94p
     * @author Jonathan Brink
     * @constructor
     * @public
     */
    var OIIconTabBar = IconTabBar.extend("sas.hc.m.objectInspector.IconTabBar", /** @lends sas.hc.m.objectInspector.IconTabBar.prototype */ {
        metadata: {
            library: "sas.hc.m",
        },
        renderer: "sas.hc.m.IconTabBarRenderer"
    });

    /**
     * onAfterRendering lifecycle callback.
     * @private
     */
    OIIconTabBar.prototype.onAfterRendering = function() {
        var aItems = this.getItems();
        if (aItems && aItems.length === 1) {
            this.addStyleClass("oiOnlyOneTab");
        } else {
            this.removeStyleClass("oiOnlyOneTab");
        }

        if (IconTabBar.prototype.onAfterRendering) {
            IconTabBar.prototype.onAfterRendering.apply(this, arguments);
        }

        // if IconTabBar has only one item
        if (aItems && aItems.length === 1) {
            // don't allow tab focus if there is only one item
            this.$().find('.sapMITBContainerContent').attr('tabindex', -1);

            // prevent role from being "tabpanel"
            this.$().find(".sapMITBContainerContent").removeAttr("role");
            this.$().find(".sapMITBContent").removeAttr("role");
        }
    };

    return OIIconTabBar;
}, /* bExport= */ true);
