sap.ui.require.preload({
	"sas/hc/home/customTiles/CustomTileAction.js": "// (c) 2014, SAS Institute Inc.\n!function(){\"use strict\";jQuery.sap.declare(\"sas.hc.home.customTiles.CustomTileAction\"),sas.hc.home.customTiles.CustomTileAction={Welcome:\"Welcome\",GetProperty:\"GetProperty\",SetProperty:\"SetProperty\",PropertyChange:\"PropertyChange\",Maximize:\"Maximize\",Normalize:\"Normalize\",GetMenuItems:\"GetMenuItems\",SetMenuItems:\"SetMenuItems\",MenuItemSelect:\"MenuItemSelect\",ShowMessageBoxError:\"ShowMessageBoxError\",ShowMessageBoxWarning:\"ShowMessageBoxWarning\",ShowMessageBoxInformation:\"ShowMessageBoxInformation\",GetApplicationUrl:\"GetApplicationUrl\",OpenObject:\"OpenObject\",GotoApp:\"GotoApp\",UpdateDirtyFlag:\"UpdateDirtyFlag\",SendMessageToApp:\"SendMessageToApp\",BroadcastMessage:\"BroadcastMessage\",AppShow:\"AppShow\",AppHide:\"AppHide\",AppAdded:\"AppAdded\",AppRemoved:\"AppRemove\",AppSwitch:\"AppSwitch\",LogoffImminent:\"LogoffImminent\"}}();",
	"sas/hc/home/customTiles/HomeProxy.js": "// (c) 2014, SAS Institute Inc.\n!function(){\"use strict\";jQuery.sap.declare(\"sas.hc.home.customTiles.HomeProxy\"),jQuery.sap.require(\"sas.hc.ui.core.Core\"),jQuery.sap.require(\"sap.ui.core.Element\"),jQuery.sap.require(\"sas.hc.home.customTiles.CustomTileAction\"),jQuery.sap.require(\"sas.hc.home.customTiles.PostMessageHandler\"),jQuery.sap.require(\"sas.hc.ui.core.Core\");var e=sas.hc.home.customTiles.CustomTileAction,t=sap.ui.core.Element,s=sas.hc.home.customTiles.PostMessageHandler;t.extend(\"sas.hc.home.customTiles.HomeProxy\",{metadata:{properties:{tileId:{type:\"string\",defaultValue:null},appId:{type:\"string\",defaultValue:null},directive:{type:\"string\",defaultValue:null},url:{type:\"string\",defaultValue:null},derivedUrl:{type:\"string\",defaultValue:null},customTileData:{type:\"string\",defaultValue:null},icon:{type:\"string\",defaultValue:null},title:{type:\"string\",defaultValue:null},height:{type:\"int\",defaultValue:null},colspan:{type:\"int\",defaultValue:null},maximizeEnabled:{type:\"boolean\",defaultValue:null},maximized:{type:\"boolean\",defaultValue:null}},aggregations:{menuItems:{type:\"sas.hc.ui.unified.MenuItem\",multiple:!0,singularName:\"menuItem\"}},events:{welcome:{},propertyChange:{},maximize:{},normalize:{},appShow:{},appHide:{},appAdded:{},appRemoved:{},appSwitch:{},logoffImminent:{}}},init:function(){t.prototype.init&&t.prototype.init.apply(this,arguments),this._oLogger=sas.log.getLogger(\"sas.hc.homeProxy\"),void 0!==sas.applicationSwitcher&&this._oLogger.error(\"sas.applicationSwitcher is detected!  Custom tiles must prevent Application Switcher from loading!\"),this._mMetadataProperties=this.getMetadata().getProperties(),this._oPostMsg=new s,this._oPostMsg.setRequestListener(e.Welcome,jQuery.proxy(this._onWelcomeRequest,this)),this._oPostMsg.setRequestListener(e.PropertyChange,jQuery.proxy(this._onPropertyChangeRequest,this)),this._oPostMsg.setRequestListener(e.Maximize,jQuery.proxy(this._onMaximizeRequest,this)),this._oPostMsg.setRequestListener(e.Normalize,jQuery.proxy(this._onNormalizeRequest,this)),this._oPostMsg.setRequestListener(e.MenuItemSelect,jQuery.proxy(this._onMenuItemSelectRequest,this)),this._oPostMsg.setRequestListener(e.AppShow,jQuery.proxy(this._onAppShowRequest,this)),this._oPostMsg.setRequestListener(e.AppHide,jQuery.proxy(this._onAppHideRequest,this)),this._oPostMsg.setRequestListener(e.AppAdded,jQuery.proxy(this._onAppAddedRequest,this)),this._oPostMsg.setRequestListener(e.AppRemoved,jQuery.proxy(this._onAppRemovedRequest,this)),this._oPostMsg.setRequestListener(e.AppSwitch,jQuery.proxy(this._onAppSwitchRequest,this)),this._oPostMsg.setRequestListener(e.LogoffImminent,jQuery.proxy(this._onLogoffImminentRequest,this)),setTimeout(jQuery.proxy(this._onInitIdle,this),0)},_onInitIdle:function(){void 0!==sas.ui&&void 0!==sas.ui.banner&&this._oLogger.error(\"sas.ui.banner is detected!  Custom tiles must prevent SAS Banner from loading!\"),void 0!==sas.timeoutManager&&sas.timeoutManager.quiet()},exit:function(){},invalidate:function(e){t.prototype.invalidate&&t.prototype.invalidate.apply(this,arguments),null!==e&&e.getParent()===this&&\"menuItems\"===e.sParentAggregationName&&this._sendMenuItemsRequest()},ready:function(){this._oPostMsg.prepareToReceiveHandshake()},getTileId:function(e){return this._getCustomTileProperty(\"tileId\",e)},setTileId:function(e,t){throw\"'tileId' is read-only\"},getAppId:function(e){return this._getCustomTileProperty(\"appId\",e)},setAppId:function(e,t){throw\"'appId' is read-only\"},getDirective:function(e){return this._getCustomTileProperty(\"directive\",e)},setDirective:function(e,t){return this._setCustomTileProperty(\"directive\",e,t)},getUrl:function(e){return this._getCustomTileProperty(\"url\",e)},setUrl:function(e,t){return this._setCustomTileProperty(\"url\",e,t)},getDerivedUrl:function(e){return this._getCustomTileProperty(\"derivedUrl\",e)},setDerivedUrl:function(e,t){throw\"'derivedUrl' is read-only\"},getCustomTileData:function(e){return this._getCustomTileProperty(\"customTileData\",e)},setCustomTileData:function(e,t){return this._setCustomTileProperty(\"customTileData\",e,t)},getIcon:function(e){return this._getCustomTileProperty(\"icon\",e)},setIcon:function(e,t){return this._setCustomTileProperty(\"icon\",e,t)},getTitle:function(e){return this._getCustomTileProperty(\"title\",e)},setTitle:function(e,t){return this._setCustomTileProperty(\"title\",e,t)},getHeight:function(e){return this._getCustomTileProperty(\"height\",e)},setHeight:function(e,t){return this._setCustomTileProperty(\"height\",e,t)},getColspan:function(e){return this._getCustomTileProperty(\"colspan\",e)},setColspan:function(e,t){return this._setCustomTileProperty(\"colspan\",e,t)},getMaximizeEnabled:function(e){return this._getCustomTileProperty(\"maximizeEnabled\",e)},setMaximizeEnabled:function(e,t){return this._setCustomTileProperty(\"maximizeEnabled\",e,t)},getMaximized:function(e){return this._getCustomTileProperty(\"maximized\",e)},setMaximized:function(e,t){throw\"'maximized' is read-only\"},_getCustomTileProperty:function(t,s){return s&&this._oPostMsg.sendRequest(e.GetProperty,{propertyName:t},jQuery.proxy(this._getCustomTilePropertyResponse,this,s)),this.getProperty(t)},_getCustomTilePropertyResponse:function(e,t,o){var i,n=o.propertyName;t!==s.ResponseCode.NotFound&&(i=o.value,this._mMetadataProperties.hasOwnProperty(n)&&this.setProperty(n,i)),e&&e(t,i)},_setCustomTileProperty:function(t,s,o){this._oPostMsg.sendRequest(e.SetProperty,{propertyName:t,value:s},jQuery.proxy(this._setCustomTilePropertyResponse,this,t,o))},_setCustomTilePropertyResponse:function(e,t,o,i){var n;o!==s.ResponseCode.NotFound&&(n=i.value,this._mMetadataProperties.hasOwnProperty(e)&&this.setProperty(e,n)),t&&t(o,n)},insertMenuItem:function(e,t,s){return this.insertAggregation(\"menuItems\",e,t,s),this._sendMenuItemsRequest(),this},addMenuItem:function(e,t){return this.addAggregation(\"menuItems\",e,t),this._sendMenuItemsRequest(),this},removeMenuItem:function(e,t){var s=this.removeAggregation(\"menuItems\",e,t);return this._sendMenuItemsRequest(),s},removeAllMenuItems:function(e){var t=this.removeAllAggregation(\"menuItems\",e);return this._sendMenuItemsRequest(),t},indexOfMenuItem:function(e,t){var s=this.indexOfAggregation(\"menuItems\",t);return this._sendMenuItemsRequest(),s},destroyMenuItems:function(e){return this.destroyAggregation(\"menuItems\",e),this._sendMenuItemsRequest(),this},_sendMenuItemsRequest:function(){var t,s,o=this.getMenuItems(),i=[];for(t=0;t<o.length;++t)s=o[t],i.push({icon:s.getIcon(),text:s.getText(),enabled:s.getEnabled(),visible:s.getVisible(),startsSection:s.getStartsSection()});this._oPostMsg.sendRequest(e.SetMenuItems,{menuItems:i})},showMessageBoxInformation:function(t,s,o,i){this._showMessageBox(e.ShowMessageBoxInformation,t,s,o,i)},showMessageBoxWarning:function(t,s,o,i){this._showMessageBox(e.ShowMessageBoxWarning,t,s,o,i)},showMessageBoxError:function(t,s,o,i){this._showMessageBox(e.ShowMessageBoxError,t,s,o,i)},_showMessageBox:function(e,t,s,o,i){this._oPostMsg.sendRequest(e,{title:s,message:t,action:o},jQuery.proxy(this._showMessageBoxResponse,this,i))},_showMessageBoxResponse:function(e,t,s){e&&e(s.action)},getApplicationUrl:function(t,s,o){this._oPostMsg.sendRequest(e.GetApplicationUrl,{appId:t,directiveName:s},jQuery.proxy(this._getApplicationUrlResponse,this,o))},_getApplicationUrlResponse:function(e,t,s){e&&e(s.applicationUrl)},openObject:function(t,s,o){this._oPostMsg.sendRequest(e.OpenObject,{objectType:t,objectInfo:s,preferredAppId:o})},gotoApp:function(t,s,o,i){this._oPostMsg.sendRequest(e.GotoApp,{appId:t,url:s,isCompliant:o,options:i})},updateDirtyFlag:function(t){this._oPostMsg.sendRequest(e.UpdateDirtyFlag,{dirtyFlag:t})},sendMessageToApp:function(t,s,o){this._oPostMsg.sendRequest(e.SendMessageToApp,{appId:t,type:s,data:o})},broadcastMessage:function(t,s){this._oPostMsg.sendRequest(e.BroadcastMessage,{type:t,data:s})},_onWelcomeRequest:function(e,t,o){var i;for(i in t)t.hasOwnProperty(i)&&this._mMetadataProperties.hasOwnProperty(i)&&this.setProperty(i,t[i]);this.fireWelcome(),o(s.ResponseCode.Ok)},_onPropertyChangeRequest:function(e,t,o){var i=t.propertyName;this._mMetadataProperties.hasOwnProperty(i)&&(this.setProperty(i,t.value),this.firePropertyChange({propertyName:i,value:t.value})),o(s.ResponseCode.Ok)},_onMaximizeRequest:function(e,t,o){this.fireMaximize(),o(s.ResponseCode.Ok)},_onNormalizeRequest:function(e,t,o){this.fireNormalize(),o(s.ResponseCode.Ok)},_onMenuItemSelectRequest:function(e,t,o){var i,n=t.menuItemIndex,r=this.getMenuItems();null!==n?(i=r[n],null!==i?(i.fireSelect({item:i}),o(s.ResponseCode.Ok)):o(s.ResponseCode.NotFound)):o(s.ResponseCode.InvalidValue)},_onAppShowRequest:function(e,t,s){this.fireAppShow(t),s()},_onAppHideRequest:function(e,t,s){this.fireAppHide(t),s()},_onAppAddedRequest:function(e,t,s){this.fireAppAdded(t),s()},_onAppRemovedRequest:function(e,t,s){this.fireAppRemoved(t),s()},_onAppSwitchRequest:function(e,t,s){this.fireAppSwitch(t),s()},_onLogoffImminentRequest:function(e,t,s){this.fireLogoffImminent(t),s()}}),sas.hc.homeProxy=new sas.hc.home.customTiles.HomeProxy}();",
	"sas/hc/home/customTiles/namespace.js": "// (c) 2014, SAS Institute Inc.\n",
	"sas/hc/home/customTiles/PostMessageHandler.js": "// (c) 2014, SAS Institute Inc.\n!function(){\"use strict\";jQuery.sap.declare(\"sas.hc.home.customTiles.PostMessageHandler\"),jQuery.sap.require(\"sas.hc.ui.core.Core\"),jQuery.sap.require(\"sap.ui.core.Element\"),jQuery.sap.require(\"sas.hc.ui.core.Core\");sap.ui.core.Element.extend(\"sas.hc.home.customTiles.PostMessageHandler\",{metadata:{},init:function(){sap.ui.core.Element.prototype.init&&sap.ui.core.Element.prototype.init.apply(this,arguments),this._oLogger=sas.log.getLogger(\"sas.hc.home.customTiles.PostMessageHandler\"),this._aQueuedMessages=[],this._mPendingRequests={},this._mRequestListeners={},this._oWindow=null,this._sTargetOrigin=\"*\",this._oHandshakeRequest=null,this._nHandshakeRequestAttempts=0,this._iHandshakeRequestIntervalId=null,this._fnHandshakeComplete=null},setRequestListener:function(e,s){null===s?this.clearRequestListener(e):this._mRequestListeners[e]=s},clearRequestListener:function(e){delete this._mRequestListeners[e]},initiateHandshake:function(s,n,t){var a=null;return this._logDebug(\"initiateHandshake: window is {0}, targetOrigin={1j}\",null!==s?\"not null\":\"null\",n),null!==this._oWindow&&(e._removeWindow(s),this._oWindow=null),this._clearPendingRequests(),null!==s&&(this._oWindow=s,e._addWindow(s,this),this._sTargetOrigin=null!==n?n:\"*\",a=this._sendRequest(null,null,jQuery.proxy(this._onHandshakeResponse,this),!1),a.message.messageType=e.MessageType.HandshakeRequest,delete a.message.action,this._oHandshakeRequest=a,this._fnHandshakeComplete=t,this._nHandshakeRequestAttempts=0,this._iHandshakeRequestIntervalId=setInterval(jQuery.proxy(this._postHandshakeRequest,this),1e3)),a},_postHandshakeRequest:function(){++this._nHandshakeRequestAttempts>60?(this._logWarning(\"Unable to deliver handshake request\"),this._sendNoResponseForRequestId(this._oHandshakeRequest.message.requestId)):this._postMessage(this._oHandshakeRequest.message)},_onHandshakeResponse:function(e,s){clearInterval(this._iHandshakeRequestIntervalId),this._iHandshakeRequestIntervalId=null,this._oHandshakeRequest=null,null!==this._fnHandshakeComplete&&this._fnHandshakeComplete(e,s)},prepareToReceiveHandshake:function(){e._addHandshakeHandler(this)},sendRequest:function(e,s,n){var t=null;return null===e?this._logError(\"Missing sAction\"):t=this._sendRequest(e,s,n),t},_sendRequest:function(s,n,t,a){var o=e._iNextRequestId++,i={messageType:e.MessageType.Request,requestId:o,action:s},r={message:i,response:t};return null!==n&&(i.data=n),this._mPendingRequests[o]=null!==t?r:null,!1!==a&&(null===this._oWindow?this._aQueuedMessages.push(i):this._postMessage(i)),r},_clearPendingRequests:function(){var e;for(e in this._mPendingRequests)this._mPendingRequests.hasOwnProperty(e)&&this._sendNoResponseForRequestId(e)},_sendNoResponseForRequestId:function(s){var n={messageType:e.MessageType.Response,requestId:s,responseCode:e.ResponseCode.NoResponse};this._logDebug(\"fake-recv: {0j}\",n),this._processReceivedResponse(null,n)},_onWindowMessageReceived:function(s){var n=s.data,t=n.messageType;if(this._logDebug(\"recv: {0j}\",n),null===n.requestId)this._logError(\"Missing ''requestId'' in received message\");else switch(t){case e.MessageType.HandshakeRequest:this._processReceivedHandshakeRequest(s,n);break;case e.MessageType.Request:this._processReceivedRequest(s,n);break;case e.MessageType.HandshakeResponse:case e.MessageType.Response:this._processReceivedResponse(s,n);break;default:this._logError(\"Unexpected ''messageType'' in received message: {0j}\",n.messageType)}},_processReceivedHandshakeRequest:function(s,n){var t,a,o=this._aQueuedMessages;for(null===this._oWindow&&(this._oWindow=s.source,this._sTargetOrigin=s.origin,e._addWindow(this._oWindow,this)),t=this._sendResponse(n.requestId,e.ResponseCode.Ok,null,!1),t.messageType=e.MessageType.HandshakeResponse,this._postMessage(t),this._aQueuedMessages=[],a=0;a<o.length;++a)this._postMessage(o[a])},_processReceivedRequest:function(s,n){var t=n.action;null===t?this._logError(\"Missing ''action'' in received request\"):this._mRequestListeners.hasOwnProperty(t)?this._mRequestListeners[t](t,n.data,jQuery.proxy(this._sendRequestResponse,this,n.requestId)):(this._logError(\"Unhandled ''action'' in received request: {0j}\",t),this._sendResponse(n.requestId,e.ResponseCode.UnknownAction))},_sendRequestResponse:function(s,n,t){null===n&&(n=e.ResponseCode.Ok),this._sendResponse(s,n,t)},_sendResponse:function(s,n,t,a){var o={messageType:e.MessageType.Response,requestId:s,responseCode:null!==n?n:e.ResponseCode.Ok};return null===s&&this._logError(\"Unable to send response with missing ''requestId''\"),null!==t&&(o.data=t),!1!==a&&this._postMessage(o),o},_processReceivedResponse:function(e,s){var n,t=s.requestId;this._mPendingRequests.hasOwnProperty(t)?(n=this._mPendingRequests[t],delete this._mPendingRequests[t],null!==n&&null!==n.response&&n.response(s.responseCode,s.data)):this._logError(\"Unexpected ''requestId'' in received response: {0j}\",s)},_postMessage:function(e){var s,n=!1;try{s=null===this._oWindow}catch(e){s=!0,n=!0}this._logDebug(\"send: {0j}\",e),n?this._logError(\"Cannot call postMessage: unable to access custom tile window (security error)\"):s?this._logError(\"Cannot call postMessage: no window set\"):this._oWindow.postMessage(e,this._sTargetOrigin)},_logError:function(s,n){this._oLogger.isLoggable(sas.log.Level.ERROR)&&(s=e.formatMessage(s,Array.prototype.slice.call(arguments,1)),this._oLogger.error(s))},_logWarning:function(s,n){this._oLogger.isLoggable(sas.log.Level.WARNING)&&(s=e.formatMessage(s,Array.prototype.slice.call(arguments,1)),this._oLogger.warning(s))},_logInfo:function(s,n){this._oLogger.isLoggable(sas.log.Level.INFO)&&(s=e.formatMessage(s,Array.prototype.slice.call(arguments,1)),this._oLogger.info(s))},_logDebug:function(s,n){this._oLogger.isLoggable(sas.log.Level.DEBUG)&&(s=e.formatMessage(s,Array.prototype.slice.call(arguments,1)),this._oLogger.debug(s))}});var e=sas.hc.home.customTiles.PostMessageHandler;e.MessageType={HandshakeRequest:\"PostMessageHandler.HandshakeRequest\",HandshakeResponse:\"PostMessageHandler.HandshakeResponse\",Request:\"PostMessageHandler.Request\",Response:\"PostMessageHandler.Response\"},e.ResponseCode={Ok:\"Ok\",NoResponse:\"NoResponse\",NotImplemented:\"NotImplemented\",UnknownAction:\"UnknownAction\",InvalidRequest:\"InvalidRequest\",NotFound:\"NotFound\",InvalidValue:\"InvalidValue\",Duplicate:\"Duplicate\"},e._iNextRequestId=0,e._aWindows=[],e._aHandshakeHandlers=[],e._bMessageListenerAdded=!1,e._addWindow=function(s,n){var t=e._indexOfWindow(s);t>=0?e._aWindows[t].oHandler=n:(e._aWindows.push({oWindow:s,oHandler:n}),e._addMessageListenerIfNecessary())},e._removeWindow=function(s){var n=e._indexOfWindow(s);n>=0&&e._aWindows.splice(n,1)},e._getHandler=function(s){var n=e._indexOfWindow(s);return n>=0?e._aWindows[n].oWindow:null},e._indexOfWindow=function(s){var n,t=e._aWindows,a=t.length,o=-1;for(n=0;n<a;++n)if(t[n].oWindow===s){o=n;break}return o},e._addHandshakeHandler=function(s){e._aHandshakeHandlers.indexOf(s)<0&&(e._aHandshakeHandlers.push(s),e._addMessageListenerIfNecessary())},e._addMessageListenerIfNecessary=function(){!1===e._bMessageListenerAdded&&(e._bMessageListenerAdded=!0,window.addEventListener(\"message\",e._onWindowMessageReceived,!1))},e._onWindowMessageReceived=function(s){var n,t,a=s.data,o=a.messageType;null!==o&&\"PostMessageHandler.\"===o.substr(0,\"PostMessageHandler.\".length)&&(n=e._indexOfWindow(s.source),n>=0?(t=e._aWindows[n].oHandler,t._onWindowMessageReceived(s)):o===e.MessageType.HandshakeRequest?e._aHandshakeHandlers.length>0?(t=e._aHandshakeHandlers.pop(),t._onWindowMessageReceived(s)):e._aWindows.length>0&&e._aWindows[0].oHandler._logInfo(\"Not expecting a handshake request just yet\"):e._aWindows.length>0&&e._aWindows[0].oHandler._logError(\"Window in message not registered\"))},sas.hc.home.customTiles.PostMessageHandler.formatMessage=function(e,n){return jQuery.sap.assert(\"string\"==typeof e||e instanceof String,\"pattern must be string\"),null===e?\"\":arguments.length<2?e:((arguments.length>2||null!==n&&!jQuery.isArray(n))&&(n=Array.prototype.slice.call(arguments,1)),n=n||[],e.replace(s,function(e,s,t,a,o){if(s)return\"'\";if(t)return t.replace(/''/g,\"'\");if(a){if(\"j\"===a.substr(a.length-1)){var i;try{i=JSON.stringify(n[parseInt(a,10)])}catch(e){i=e.toString()}return i}return String(n[parseInt(a,10)])}throw new Error(\"formatMessage: pattern syntax error at pos. \"+o)}))};var s=/('')|'([^']+(?:''[^']*)*)(?:'|$)|\\{([0-9]+j?(?:\\s*,[^{}]*)?)\\}|[{}]/g}();",
	"sas/hc/home/library.js": "// (c) 2014, SAS Institute Inc.\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Core\",\"sap/ui/core/library\"],function(e){\"use strict\";return sap.ui.getCore().initLibrary({name:\"sas.hc.home\",dependencies:[\"sap.ui.core\"],noLibraryCSS:!0,types:[],interfaces:[],controls:[\"sas.hc.home.customTiles.CustomTileAction\",\"sas.hc.home.customTiles.HomeProxy\",\"sas.hc.home.customTiles.PostMessageHandler\"],elements:[],version:\"904001.11.16.20251118090100_f0htmcm94p\"}),sas.hc.home});",
	"sas/hc/home/manifest.json": "{\"_version\":\"1.9.0\",\"sap.app\":{\"_version\":\"1.2.0\",\"id\":\"sas.hc.home\",\"type\":\"library\",\"applicationVersion\":{\"version\":\"9.4.0-0\"},\"title\":\"The OpenUI5-based library, sas.hc.home.\"},\"sap.ui5\":{\"_version\":\"1.1.0\",\"dependencies\":{\"libs\":{\"sap.ui.core\":{}}},\"library\":{\"i18n\":false}}}"
}, "sas/hc/home/library-preload");