sap.ui.require.preload({
	"sap/uxap/AnchorBar.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/m/Button\",\"sap/m/library\",\"sap/m/Popover\",\"sap/m/Toolbar\",\"sap/ui/core/IconPool\",\"sap/ui/core/Item\",\"sap/ui/core/ResizeHandler\",\"sap/ui/core/delegate/ScrollEnablement\",\"sap/ui/layout/HorizontalLayout\",\"sap/ui/Device\",\"sap/ui/core/CustomData\",\"./HierarchicalSelect\",\"./library\",\"sap/uxap/AnchorBarRenderer\",\"jquery.sap.keycodes\"],function(t,e,o,r,i,s,n,a,l,c,h,p,u,d,g){\"use strict\";var _=o.SelectType,f=o.PlacementType,S=i.extend(\"sap.uxap.AnchorBar\",{metadata:{library:\"sap.uxap\",properties:{showPopover:{type:\"boolean\",defaultValue:!0},upperCase:{type:\"boolean\",defaultValue:!1}},associations:{selectedButton:{type:\"sap.m.Button\",multiple:!1}},aggregations:{_select:{type:\"sap.uxap.HierarchicalSelect\",multiple:!1,visibility:\"hidden\"},_popovers:{type:\"sap.m.Popover\",multiple:!0,visibility:\"hidden\"},_scrollArrowLeft:{type:\"sap.ui.core.Control\",multiple:!1,visibility:\"hidden\"},_scrollArrowRight:{type:\"sap.ui.core.Control\",multiple:!1,visibility:\"hidden\"}}}});return S.prototype.init=function(){i.prototype.init&&i.prototype.init.call(this),this.addStyleClass(\"sapUxAPAnchorBar\"),this._oPressHandlers={},this._oSectionInfo={},this._oScroller=null,this._sSelectedKey=null,this._bRtl=sap.ui.getCore().getConfiguration().getRTL(),this._bRtlScenario=this._bRtl&&!h.browser.msie,this._bHasButtonsBar=h.system.tablet||h.system.desktop,this._oSelect=this._getHierarchicalSelect(),this._bHasButtonsBar&&(this._oScroller=new l(this,this.getId()+\"-scroll\",{horizontal:!0,vertical:!1,nonTouchScrolling:!0}),this._iREMSize=parseInt(t(\"body\").css(\"font-size\"),10),this._iTolerance=1*this._iREMSize,this._iOffset=3*this._iREMSize,this._sResizeListenerId=void 0),this.oLibraryResourceBundleOP=d.i18nModel.getResourceBundle(),this.setDesign(\"Transparent\")},S.SCROLL_STEP=250,S.SCROLL_DURATION=500,S.DOM_CALC_DELAY=200,S.prototype.setSelectedButton=function(t){var e=this._oSelect.getItems(),o=e.length>0;if(\"string\"==typeof t&&(t=sap.ui.getCore().byId(t)),t){if(t.getId()===this.getSelectedButton())return this;var r=t.data(\"sectionId\");this._sSelectedKey=r,r&&o&&this._oSelect.setSelectedKey(r),this._bHasButtonsBar&&(this.$().find(\".sapUxAPAnchorBarButtonSelected\").removeClass(\"sapUxAPAnchorBarButtonSelected\").attr(\"aria-checked\",!1),t.$().addClass(\"sapUxAPAnchorBarButtonSelected\").attr(\"aria-checked\",!0),r&&this.scrollToSection(r,S.SCROLL_DURATION),this._setAnchorButtonsTabFocusValues(t))}return this.setAssociation(\"selectedButton\",t,!0)},S.prototype.setShowPopover=function(e,o){if(this.getShowPopover()===e)return this;var r,i=!t.isEmptyObject(this._oPressHandlers);if(i){var s=this.getContent()||[];r=this.getSelectedButton(),s.forEach(this._detachPopoverHandler,this)}return this.setProperty(\"showPopover\",e,!0),i&&(this.rerender(),r&&this.setSelectedButton(r)),this},S.prototype.getSelectedSection=function(){var t=this.getSelectedButton();return t&&\"string\"==typeof t&&(t=sap.ui.getCore().byId(t)),t&&t instanceof e&&t.data(\"sectionId\")?sap.ui.getCore().byId(t.data(\"sectionId\")):null},S.prototype.onBeforeRendering=function(){i.prototype.onBeforeRendering&&i.prototype.onBeforeRendering.call(this);var t=this.getContent()||[],e=this.getUpperCase(),o={oLastFirstLevelButton:null,oCurrentPopover:null};this._oSelect.removeAllItems(),this._oSelect.setUpperCase(e),this.toggleStyleClass(\"sapUxAPAnchorBarUpperCase\",e),t.forEach(function(t){this._createSelectItem(t),this._bHasButtonsBar&&this._createPopoverSubMenu(t,o)},this),t.length>0&&this._sSelectedKey&&this._oSelect.setSelectedKey(this._sSelectedKey)},S.prototype.addContent=function(t,e){return t.addStyleClass(\"sapUxAPAnchorBarButton\"),t.removeAllAriaDescribedBy(),!this._bHasButtonsBar||!0!==t.data(\"secondLevel\")&&\"true\"!==t.data(\"secondLevel\")||t.attachPress(this._handleDirectScroll,this),this.addAggregation(\"content\",t,e)},S.prototype._createSelectItem=function(t){var e=!0===t.data(\"secondLevel\")||\"true\"===t.data(\"secondLevel\");if(\"\"!=t.getText().trim()&&(!e||!0===t.data(\"bTitleVisible\"))){var o=new n({key:t.data(\"sectionId\"),text:t.getText(),customData:[new p({key:\"secondLevel\",value:t.data(\"secondLevel\")})]});this._oSelect.addItem(o)}},S.prototype._createPopoverSubMenu=function(e,o){var i=!0===e.data(\"secondLevel\")||\"true\"===e.data(\"secondLevel\"),s=null;i?o.oLastFirstLevelButton&&o.oCurrentPopover?(this._oPressHandlers[o.oLastFirstLevelButton.getId()]||(s=t.proxy(this._handlePopover,{oCurrentPopover:o.oCurrentPopover,oLastFirstLevelButton:o.oLastFirstLevelButton}),o.oLastFirstLevelButton.attachPress(s),this._oPressHandlers[o.oLastFirstLevelButton.getId()]=s),o.oCurrentPopover.addContent(e)):this.getShowPopover()?t.sap.log.error(\"sapUxApAnchorBar :: missing parent first level for item \"+e.getText()):(this.removeContent(e),e.destroy()):(o.oLastFirstLevelButton=e,this.getShowPopover()?(o.oCurrentPopover=new r({placement:f.Bottom,showHeader:!1,verticalScrolling:!0,horizontalScrolling:!1,contentWidth:\"auto\",showArrow:!1,afterOpen:this._decorateSubMenuButtons}),o.oCurrentPopover.addStyleClass(\"sapUxAPAnchorBarPopover\"),this._addKeyboardHandling(o.oCurrentPopover),this.addAggregation(\"_popovers\",o.oCurrentPopover)):this._oPressHandlers[o.oLastFirstLevelButton.getId()]||(s=t.proxy(this._handleDirectScroll,this),o.oLastFirstLevelButton.attachPress(s),this._oPressHandlers[o.oLastFirstLevelButton.getId()]=s))},S.prototype._decorateSubMenuButtons=function(t){t.getSource().getContent().forEach(function(t){t.$().attr(\"aria-controls\",t.data(\"sectionId\"))})},S.prototype._addKeyboardHandling=function(t){t.onsapdown=function(t){t.target.nextSibling&&t.target.nextSibling.focus()},t.onsapright=function(e){t.onsapdown(e)},t.onsapup=function(t){t.target.previousSibling&&t.target.previousSibling.focus()},t.onsapleft=function(e){t.onsapup(e)},t.onsaphome=function(t){t.target.parentElement.firstChild&&t.target.parentElement.firstChild.focus()},t.onsapend=function(t){t.target.parentElement.lastChild&&t.target.parentElement.lastChild.focus()},t.onsappageup=this._handlePageUp.bind(t),t.onsappagedown=this._handlePageDown.bind(t)},S.prototype._detachPopoverHandler=function(t){this._oPressHandlers[t.getId()]&&(t.detachPress(this._oPressHandlers[t.getId()]),this._oPressHandlers[t.getId()]=null)},S.prototype._handlePopover=function(t){var e=this.oCurrentPopover.getContent()||[];this.oLastFirstLevelButton.$().is(\":visible\")&&(1==e.length?e[0].firePress({}):this.oCurrentPopover.openBy(this.oLastFirstLevelButton))},S.prototype._handleDirectScroll=function(t){t.getSource().getParent()instanceof r&&t.getSource().getParent().close(),this._requestScrollToSection(t.getSource().data(\"sectionId\"))},S.prototype._requestScrollToSection=function(t){var e=sap.ui.getCore().byId(t),o=e.getParent();if(this.getParent()instanceof d.ObjectPageLayout){var r=t;e instanceof d.ObjectPageSubSection&&o instanceof d.ObjectPageSection&&(r=o.getId()),this.getParent().setDirectScrollingToSection(r),this.getParent().scrollToSection(e.getId(),null,0,!0)}e instanceof d.ObjectPageSubSection&&o instanceof d.ObjectPageSection&&o.setAssociation(\"selectedSubSection\",e,!0)},S.prototype._onSelectChange=function(e){var o,r=e.getParameter(\"selectedItem\");o=sap.ui.getCore().byId(r.getKey()),o?this._requestScrollToSection(o.getId()):t.sap.log.error(\"AnchorBar :: cannot find corresponding section\",r.getKey())},S.prototype._getHierarchicalSelect=function(){return this.getAggregation(\"_select\")||this.setAggregation(\"_select\",new u({width:\"100%\",icon:\"sap-icon://slim-arrow-down\",change:t.proxy(this._onSelectChange,this)})),this.getAggregation(\"_select\")},S.prototype._createScrollArrow=function(t){var o,r,i,n,a,l=this,h=this.oLibraryResourceBundleOP.getText(\"TOOLTIP_OP_SCROLL_LEFT_ARROW\"),p=this.oLibraryResourceBundleOP.getText(\"TOOLTIP_OP_SCROLL_RIGHT_ARROW\");return t?(o=this.getId()+\"-arrowScrollLeft\",r=\"slim-arrow-left\",i=\"anchorBarArrowLeft\",n=this._bRtl?p:h):(o=this.getId()+\"-arrowScrollRight\",r=\"slim-arrow-right\",i=\"anchorBarArrowRight\",n=this._bRtl?h:p),a=new e(o,{icon:s.getIconURI(r),type:\"Transparent\",press:function(e){e.preventDefault(),l._handleScrollButtonTap(t)},tooltip:n}),a.addEventDelegate({onAfterRendering:function(){\"sap_hcb\"!=sap.ui.getCore().getConfiguration().getTheme()&&this.$().attr(\"tabindex\",-1)},onThemeChanged:function(){\"sap_hcb\"==sap.ui.getCore().getConfiguration().getTheme()?this.$().removeAttr(\"tabindex\"):this.$().attr(\"tabindex\",-1)}},a),new c({content:[a]}).addStyleClass(\"anchorBarArrow\").addStyleClass(i)},S.prototype._getScrollArrowLeft=function(){var t=this.getAggregation(\"_scrollArrowLeft\");return t||(t=this._createScrollArrow(!0),this.setAggregation(\"_scrollArrowLeft\",t),t)},S.prototype._getScrollArrowRight=function(){var t=this.getAggregation(\"_scrollArrowRight\");return t||(t=this._createScrollArrow(!1),this.setAggregation(\"_scrollArrowRight\",t),t)},S.prototype._applyHierarchicalSelectMode=function(){this._sHierarchicalSelectMode===g._AnchorBarHierarchicalSelectMode.Icon?(this.$().find(\".sapUxAPAnchorBarScrollContainer\").show(),this._oSelect.setWidth(\"auto\"),this._oSelect.setAutoAdjustWidth(!0),this._oSelect.setType(_.IconOnly),this._computeBarSectionsInfo()):(this.$().find(\".sapUxAPAnchorBarScrollContainer\").hide(),this._oSelect.setWidth(\"100%\"),this._oSelect.setAutoAdjustWidth(!1),this._oSelect.setType(_.Default)),this.$().toggleClass(\"sapUxAPAnchorBarOverflow\",this._sHierarchicalSelectMode===g._AnchorBarHierarchicalSelectMode.Icon)},S.prototype._adjustSize=function(){var e=d.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())?g._AnchorBarHierarchicalSelectMode.Text:g._AnchorBarHierarchicalSelectMode.Icon;if(e!==this._sHierarchicalSelectMode&&(this._sHierarchicalSelectMode=e,this._applyHierarchicalSelectMode()),this._sHierarchicalSelectMode===g._AnchorBarHierarchicalSelectMode.Icon){if(this._iMaxPosition<0)return;var o,r,i,s=this.$(),n=s.find(\".sapUxAPAnchorBarScrollContainer\");i=n.width(),this._bRtlScenario?h.browser.firefox?(r=Math.abs(n.scrollLeft())+i<this._iMaxPosition-this._iTolerance,o=Math.abs(n.scrollLeft())>=this._iTolerance):(r=Math.abs(n.scrollLeft())>=this._iTolerance,o=Math.abs(n.scrollLeft())+i<this._iMaxPosition-this._iTolerance):(r=n.scrollLeft()+i<this._iMaxPosition-this._iTolerance,o=n.scrollLeft()>=this._iTolerance),t.sap.log.debug(\"AnchorBar :: scrolled at \"+n.scrollLeft(),\"scrollBegin [\"+(o?\"true\":\"false\")+\"] scrollEnd [\"+(r?\"true\":\"false\")+\"]\"),s.toggleClass(\"sapUxAPAnchorBarScrollLeft\",o),s.toggleClass(\"sapUxAPAnchorBarScrollRight\",r)}},S.prototype._handleScrollButtonTap=function(t){var e=!this._bRtlScenario&&t||this._bRtlScenario&&!t?-1:1;this._oScroller.scrollTo(this._iMaxPosition*e,0,3*S.SCROLL_DURATION)},S.prototype.scrollToSection=function(e,o){if(this._bHasButtonsBar){var r,o=o||S.SCROLL_DURATION;!d.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())&&this._oSectionInfo[e]?(this._bRtlScenario&&h.browser.firefox?r=this._oSectionInfo[e].scrollLeft+this._iOffset:(r=this._oSectionInfo[e].scrollLeft-this._iOffset)<0&&(r=0),t.sap.log.debug(\"AnchorBar :: scrolling to section \"+e+\" of \"+r),this._sCurrentScrollId!=e&&(this._sCurrentScrollId=e,this._iCurrentScrollTimeout&&(t.sap.clearDelayedCall(this._iCurrentScrollTimeout),t.sap.byId(this.getId()+\"-scroll\").parent().stop(!0,!1)),this._iCurrentScrollTimeout=t.sap.delayedCall(o,this,function(){this._sCurrentScrollId=void 0,this._iCurrentScrollTimeout=void 0}),this._oScroller.scrollTo(r,0,o))):t.sap.log.debug(\"AnchorBar :: no need to scroll to \"+e)}},S.prototype.getScrollDelegate=function(){return this._oScroller},S.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5,S.prototype.onsapdown=function(t){t.preventDefault(),t.target.nextSibling&&t.target.nextSibling.focus()},S.prototype.onsapright=function(t){this[this._bRtl?\"onsapup\":\"onsapdown\"](t)},S.prototype.onsapup=function(t){t.preventDefault(),t.target.previousSibling&&t.target.previousSibling.focus()},S.prototype.onsapleft=function(t){this[this._bRtl?\"onsapdown\":\"onsapup\"](t)},S.prototype.onsaphome=function(t){t.preventDefault(),t.target.parentElement.firstChild&&t.target.parentElement.firstChild.focus()},S.prototype.onsapend=function(t){t.preventDefault(),t.target.parentElement.lastChild&&t.target.parentElement.lastChild.focus()},S.prototype.onsappageup=function(t){this._handlePageUp(t)},S.prototype.onsappagedown=function(t){this._handlePageDown(t)},S.prototype._handlePageUp=function(t){t.preventDefault();var e,o=this.getContent();o.forEach(function(o,r){if(o.getId()===t.target.id)return void(e=r-(S.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1))}),e&&o[e]?o[e].focus():o[0]&&o[0].focus()},S.prototype._handlePageDown=function(t){t.preventDefault();var e,o=this.getContent();o.forEach(function(o,r){if(o.getId()===t.target.id)return void(e=r+S.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1)}),e&&o[e]?o[e].focus():o[o.length-1]&&o[o.length-1].focus()},S.prototype._setAnchorButtonsTabFocusValues=function(t){var e,o=this.getContent()||[];o.forEach(function(o){e=o.$(),o.sId===t.sId?e.attr(\"tabIndex\",\"0\"):e.attr(\"tabIndex\",\"-1\")})},S.prototype.onsapskipforward=function(t){this._handleGroupNavigation(t,!1)},S.prototype._handleGroupNavigation=function(e,o){var r=t.Event(\"keydown\"),i={},s=this.getParent(),n=s.getUseIconTabBar(),a=s.getSelectedSection(),l=s.getSections(),c=[this.getDomRef()],h=[];n?(h=sap.ui.getCore().byId(a).getSubSections().map(function(t){return t.$().attr(\"tabindex\",-1)[0]}),c=c.concat(h)):l.forEach(function(t){h=t.getSubSections().map(function(t){return t.$().attr(\"tabindex\",-1)[0]}),c=c.concat(h)}),i.scope=c,e.preventDefault(),this.$().focus(),r.target=e.target,r.keyCode=t.sap.KeyCodes.F6,r.shiftKey=o,t.sap.handleF6GroupNavigation(r,i)},S.prototype.onAfterRendering=function(){var e;i.prototype.onAfterRendering&&i.prototype.onAfterRendering.call(this),e=sap.ui.getCore().byId(this.getSelectedButton()),this._iMaxPosition=-1,this._sResizeListenerId=a.register(this,t.proxy(this._adjustSize,this)),this.$().find(\".sapUxAPAnchorBarScrollContainer\").scroll(t.proxy(this._onScroll,this)),e&&(this.setSelectedButton(e),this._setAnchorButtonsTabFocusValues(e)),this._bHasButtonsBar&&t.sap.delayedCall(S.DOM_CALC_DELAY,this,function(){this._sHierarchicalSelectMode===g._AnchorBarHierarchicalSelectMode.Icon&&this._computeBarSectionsInfo(),this._adjustSize()})},S.prototype._onScroll=function(){this._iCurrentSizeCheckTimeout||(this._iCurrentSizeCheckTimeout=t.sap.delayedCall(S.SCROLL_DURATION,this,function(){this._iCurrentSizeCheckTimeout=void 0,this._adjustSize()}))},S.prototype._computeBarSectionsInfo=function(){this._iMaxPosition=0;var t=this.getContent()||[];t.forEach(this._computeNextSectionInfo,this),this._bRtlScenario&&(h.browser.webkit||h.browser.firefox)&&(t.forEach(this._adjustNextSectionInfo,this),this._oScroller.scrollTo(this._iMaxPosition,0,0))},S.prototype._computeNextSectionInfo=function(t){t.data(\"bHasSubMenu\")&&t.$().attr(\"aria-haspopup\",\"true\"),t.$().attr(\"aria-controls\",t.data(\"sectionId\")).attr(\"aria-checked\",!1);var e=t.$().outerWidth(!0);this._oSectionInfo[t.data(\"sectionId\")]={scrollLeft:this._iMaxPosition,width:e},this._iMaxPosition+=e},S.prototype._adjustNextSectionInfo=function(t){var e=this._oSectionInfo[t.data(\"sectionId\")];h.browser.firefox?e.scrollLeft=-e.scrollLeft:e.scrollLeft=this._iMaxPosition-e.scrollLeft-e.width},S.prototype._destroyPopoverContent=function(){var t=this.getAggregation(\"_popovers\");Array.isArray(t)&&t.forEach(function(t){t.destroyContent()})},S.prototype._resetControl=function(){return this._destroyPopoverContent(),this.getContent().forEach(this._detachPopoverHandler,this),this.destroyAggregation(\"content\",!0),this},S.prototype.enhanceAccessibilityState=function(t,e){var o=this.getContent(),r=o.indexOf(t);-1!==r&&(e.role=\"menuitemradio\",e.type=\"button\",e.setsize=o.length,e.posinset=r+1)},S.prototype.exit=function(){this._sResizeListenerId&&(a.deregister(this._sResizeListenerId),this._sResizeListenerId=null),this._oScroller&&(this._oScroller.destroy(),this._oScroller=null),this.oLibraryResourceBundleOP&&(this.oLibraryResourceBundleOP=null)},S});",
	"sap/uxap/AnchorBarRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/m/ToolbarRenderer\",\"sap/ui/core/Renderer\",\"sap/m/BarInPageEnabler\",\"./library\"],function(e,r,t,o){\"use strict\";var a=r.extend(e),n=a._AnchorBarHierarchicalSelectMode={Icon:\"icon\",Text:\"text\"};return a.renderBarContent=function(e,r){r._bHasButtonsBar&&(e.renderControl(r._getScrollArrowLeft()),e.write(\"<div\"),e.writeAttributeEscaped(\"id\",r.getId()+\"-scrollContainer\"),e.writeAttributeEscaped(\"aria-label\",o.i18nModel.getResourceBundle().getText(\"ANCHOR_BAR_LABEL\")),e.addClass(\"sapUxAPAnchorBarScrollContainer\"),e.writeClasses(),e.write(\">\"),e.write(\"<div\"),e.writeAttributeEscaped(\"id\",r.getId()+\"-scroll\"),e.writeAttributeEscaped(\"role\",\"menu\"),e.write(\">\"),a.renderBarItems(e,r),e.write(\"</div>\"),e.write(\"</div>\"),e.renderControl(r._getScrollArrowRight())),t.addChildClassTo(r._oSelect,r),e.renderControl(r._oSelect)},a.renderBarItems=function(e,r){var o=r.getSelectedButton();r.getContent().forEach(function(a){t.addChildClassTo(a,r),a.getId()===o&&a.addStyleClass(\"sapUxAPAnchorBarButtonSelected\"),e.renderControl(a)})},a.decorateRootElement=function(r,t){e.decorateRootElement.apply(this,arguments),t._sHierarchicalSelectMode===n.Icon&&r.addClass(\"sapUxAPAnchorBarOverflow\")},a},!0);",
	"sap/uxap/BlockBase.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/core/CustomData\",\"./BlockBaseMetadata\",\"sap/ui/model/Context\",\"sap/ui/Device\",\"sap/ui/layout/form/ResponsiveGridLayout\",\"./library\",\"sap/ui/core/Component\",\"sap/ui/layout/library\"],function(t,e,o,i,a,n,s,r,p,l){\"use strict\";var d=l.form.SimpleFormLayout,u=r.BlockBaseFormAdjustment,g=e.extend(\"sap.uxap.BlockBase\",{metadata:{designtime:\"sap/uxap/designtime/BlockBase.designtime\",library:\"sap.uxap\",properties:{mode:{type:\"string\",group:\"Appearance\"},visible:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},columnLayout:{type:\"sap.uxap.BlockBaseColumnLayout\",group:\"Behavior\",defaultValue:\"auto\"},formAdjustment:{type:\"sap.uxap.BlockBaseFormAdjustment\",group:\"Behavior\",defaultValue:u.BlockColumns},showSubSectionMore:{type:\"boolean\",group:\"Behavior\",defaultValue:!1}},defaultAggregation:\"mappings\",aggregations:{mappings:{type:\"sap.uxap.ModelMapping\",multiple:!0,singularName:\"mapping\"},_views:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"view\",visibility:\"hidden\"}},associations:{selectedView:{type:\"sap.ui.core.Control\",multiple:!1}},views:{}},renderer:\"sap.uxap.BlockBaseRenderer\"},i);return g.prototype.init=function(){this.getMetadata().hasViews()||this.getMetadata().setView(\"defaultXML\",{viewName:this.getMetadata().getName(),type:\"XML\"}),this._oMappingApplied={},this._bLazyLoading=!1,this._bConnected=!1,this._oUpdatedModels={},this._oParentObjectPageSubSection=null},g.prototype.onBeforeRendering=function(){var e;this._applyMapping(),this.getMode()&&\"\"!==this.getMode()||(this.getMetadata().getView(\"defaultXML\")?this.setMode(\"defaultXML\"):t.sap.log.error(\"BlockBase ::: there is no mode defined for rendering \"+this.getMetadata().getName()+\". You can either set a default mode on the block metadata or set the mode property before rendering the block.\")),this._applyFormAdjustment(),e=this._getObjectPageLayout(),this._bLazyLoading=e&&(e.getEnableLazyLoading()||e.getUseIconTabBar())},g.prototype.onAfterRendering=function(){var t=this._getObjectPageLayout();t&&t._requestAdjustLayout()},g.prototype.setParent=function(t,o,i){e.prototype.setParent.call(this,t,o,i),t instanceof r.ObjectPageSubSection&&(this._bLazyLoading=!0,this._oParentObjectPageSubSection=t)},g.prototype.setModel=function(t,o){return this._applyMapping(o),e.prototype.setModel.call(this,t,o)},g.prototype._applyMapping=function(){this._shouldLazyLoad()?t.sap.log.debug(\"BlockBase ::: Ignoring the _applyMapping as the block is not connected\"):this.getMappings().forEach(function(o,i){var n,s,r,p=o.getInternalModelName(),l=o.getExternalPath(),d=o.getExternalModelName();if(l){if(\"\"==p||\"\"==l)throw new Error(\"BlockBase :: incorrect mapping, one of the modelMapping property is empty\");if(!(n=this.getModel(d)))return;r=n.resolve(l,this.getBindingContext(d)),s=this.getBindingContext(p),(!this._isMappingApplied(p)||this.getModel(p)!==this.getModel(d)||s&&s.getPath()!==r)&&(t.sap.log.info(\"BlockBase :: mapping external model \"+d+\" to \"+p),this._oMappingApplied[p]=!0,e.prototype.setModel.call(this,n,p),this.setBindingContext(new a(n,r),p))}},this)},g.prototype._isMappingApplied=function(t){return this.getModel(t)&&this._oMappingApplied[t]},g.prototype.propagateProperties=function(t){return this._shouldLazyLoad()&&!this._oUpdatedModels.hasOwnProperty(t)?this._oUpdatedModels[t]=!0:this._applyMapping(t),e.prototype.propagateProperties.call(this,t)},g.prototype.getSupportedModes=function(){var e=t.extend({},this.getMetadata().getViews());for(var o in e)e[o]=o;return e},g.prototype.setMode=function(t){return t=this._validateMode(t),this.getMode()!==t&&(this.setProperty(\"mode\",t,!1),this._shouldLazyLoad()||this._initView(t)),this},g.prototype.setColumnLayout=function(t){this._oParentObjectPageSubSection&&this._oParentObjectPageSubSection.invalidate(),this.setProperty(\"columnLayout\",t)},g.prototype.clone=function(){var t=-1,o=this.getAssociation(\"selectedView\"),i=this.getAggregation(\"_views\")||[];o&&i.forEach(function(e,i){return e.getId()===o&&(t=i),t<0});var a=e.prototype.clone.call(this);return t>=0&&a.setAssociation(\"selectedView\",a.getAggregation(\"_views\")[t]),a},g.prototype._validateMode=function(e){if(this.validateProperty(\"mode\",e),!this.getMetadata().getView(e)){var o=this.getMetadata()._sClassName||this.getId();if(!this.getMetadata().getView(\"defaultXML\"))throw new Error(\"BlockBase :: no view defined for block \"+o+\" for mode \"+e);t.sap.log.warning(\"BlockBase :: no view defined for block \"+o+\" for mode \"+e+\", loading defaultXML instead\"),e=\"defaultXML\"}return e},g.prototype._getSelectedViewContent=function(){var t,e,o=null;if(t=this.getAssociation(\"selectedView\"),e=this.getAggregation(\"_views\"))for(var i=0;!o&&i<e.length;i++)e[i].getId()===t&&(o=e[i]);return o},g.prototype.createView=function(t,e){var o,i;return i=function(){return sap.ui.view(this.getId()+\"-\"+e,t)}.bind(this),o=p.getOwnerComponentFor(this),o?o.runAsOwner(i):i()},g.prototype._initView=function(e){var o,i=this.getAggregation(\"_views\")||[],a=this.getMetadata().getView(e);return i.forEach(function(t,i){t.data(\"layoutMode\")===e&&(o=t)}),o||(o=this._initNewView(e)),this.setAssociation(\"selectedView\",o,!0),o.getController()&&o.getController().onParentBlockModeChange?o.getController().onParentBlockModeChange(e):t.sap.log.info(\"BlockBase ::: could not notify \"+a.viewName+\" of loading in mode \"+e+\": missing controller onParentBlockModeChange method\"),o},g.prototype._initNewView=function(t){var e=this._getSelectedViewContent(),i=this.getMetadata().getView(t);if(!e||i.viewName!=e.getViewName()){if(!(e=this.createView(i,t)))throw new Error(\"BlockBase :: no view defined in metadata.views for mode \"+t);e.getController()&&(e.getController().oParentBlock=this),e.addCustomData(new o({key:\"layoutMode\",value:t})),this.addAggregation(\"_views\",e,!0)}return e},g.FORM_ADUSTMENT_OFFSET=32,g._FORM_ADJUSTMENT_CONST={breakpoints:{XL:n.media._predefinedRangeSets.StdExt.points[2]-g.FORM_ADUSTMENT_OFFSET,L:n.media._predefinedRangeSets.StdExt.points[1]-g.FORM_ADUSTMENT_OFFSET,M:n.media._predefinedRangeSets.StdExt.points[0]-g.FORM_ADUSTMENT_OFFSET},labelSpan:{XL:12,L:12,M:12,S:12},emptySpan:{XL:0,L:0,M:0,S:0},columns:{XL:1,L:1,M:1}},g._PARENT_GRID_SIZE=12,g.prototype._computeFormAdjustmentFields=function(e,o,i,a){if(e&&o&&i&&a){var n=this._computeFormColumns(o,i,a),s=this._computeFormBreakpoints(o,i);return t.extend({},g._FORM_ADJUSTMENT_CONST,{columns:n},{breakpoints:s})}},g.prototype._computeFormColumns=function(e,o,i){var a=t.extend({},g._FORM_ADJUSTMENT_CONST.columns);if(o===u.BlockColumns){var n=g._PARENT_GRID_SIZE/i.XL,s=g._PARENT_GRID_SIZE/i.L,r=g._PARENT_GRID_SIZE/i.M;a.XL=e.getSpanXL()/n,a.L=e.getSpanL()/s,a.M=e.getSpanM()/r}return a},g.prototype._computeFormBreakpoints=function(e,o){var i=t.extend({},g._FORM_ADJUSTMENT_CONST.breakpoints);return o===u.BlockColumns&&(i.XL=Math.round(i.XL*e.getSpanXL()/g._PARENT_GRID_SIZE),i.L=Math.round(i.L*e.getSpanL()/g._PARENT_GRID_SIZE),i.M=Math.round(i.M*e.getSpanM()/g._PARENT_GRID_SIZE)),i},g.prototype._applyFormAdjustment=function(){var t,e=this.getLayoutData(),o=this.getFormAdjustment(),i=this._getSelectedViewContent(),a=this._oParentObjectPageSubSection;if(o&&o!==u.None&&i&&e&&a){var n=a._oLayoutConfig;i.getContent().forEach(function(a){if(\"sap.ui.layout.form.SimpleForm\"===a.getMetadata().getName())a.setLayout(d.ResponsiveGridLayout),t||(t=this._computeFormAdjustmentFields(i,e,o,n)),this._applyFormAdjustmentFields(t,a),a.setWidth(\"100%\");else if(\"sap.ui.layout.form.Form\"===a.getMetadata().getName()){var r,p=a.getLayout();p&&\"sap.ui.layout.form.ResponsiveGridLayout\"===p.getMetadata().getName()?r=p:(r=new s,a.setLayout(r)),t||(t=this._computeFormAdjustmentFields(i,e,o,n)),this._applyFormAdjustmentFields(t,r),a.setWidth(\"100%\")}},this)}},g.prototype._applyFormAdjustmentFields=function(t,e){e.setColumnsXL(t.columns.XL),e.setColumnsL(t.columns.L),e.setColumnsM(t.columns.M),e.setLabelSpanXL(t.labelSpan.XL),e.setLabelSpanL(t.labelSpan.L),e.setLabelSpanM(t.labelSpan.M),e.setLabelSpanS(t.labelSpan.S),e.setEmptySpanXL(t.emptySpan.XL),e.setEmptySpanL(t.emptySpan.L),e.setEmptySpanM(t.emptySpan.M),e.setEmptySpanS(t.emptySpan.S),e.setBreakpointXL(t.breakpoints.XL),e.setBreakpointL(t.breakpoints.L),e.setBreakpointM(t.breakpoints.M)},g.prototype._getObjectPageLayout=function(){return r.Utilities.getClosestOPL(this)},g.prototype.setVisible=function(t,e){var o=this._getObjectPageLayout();return this.setProperty(\"visible\",t,e),o&&o._requestAdjustLayoutAndUxRules(),this},g.prototype.setShowSubSectionMore=function(t,e){return t!=this.getShowSubSectionMore()&&(this.setProperty(\"showSubSectionMore\",t,!0),this._oParentObjectPageSubSection&&this._oParentObjectPageSubSection.refreshSeeMoreVisibility()),this},g.prototype.connectToModels=function(){if(!this._bConnected){if(t.sap.log.debug(\"BlockBase :: Connecting block to the UI5 model tree\"),this._bConnected=!0,this._bLazyLoading){var e=this.getMode();e&&this._initView(e)}this.invalidate()}},g.prototype._allowPropagationToLoadedViews=function(t){this._bConnected&&(this.mSkipPropagation._views=!t)},g.prototype.updateBindingContext=function(o,i,a,n){if(!this._shouldLazyLoad())return e.prototype.updateBindingContext.call(this,o,i,a,n);t.sap.log.debug(\"BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout\")},g.prototype.updateBindings=function(o,i){if(!this._shouldLazyLoad())return e.prototype.updateBindings.call(this,o,i);t.sap.log.debug(\"BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout\")},g.prototype._shouldLazyLoad=function(){return!!this._oParentObjectPageSubSection&&this._bLazyLoading&&!this._bConnected},g});",
	"sap/uxap/BlockBaseMetadata.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/ElementMetadata\"],function(e,t){\"use strict\";var r=function(e,r){t.apply(this,arguments),this._mViews=r.metadata.views||{}};return r.prototype=e.sap.newObject(t.prototype),r.prototype.applySettings=function(e){var r=e.hasOwnProperty(\"renderer\")?e.renderer||\"\":void 0;t.prototype.applySettings.call(this,e),null==r&&(this._sRendererName=null)},r.prototype.getRendererName=function(){return this._sBlockRenderer||(this._sBlockRenderer=this._resolveRendererName(),e.sap.log.debug(\"BlockBaseMetadata :: \"+this.getName()+\" is renderer with \"+this._sBlockRenderer)),this._sBlockRenderer},r.prototype._resolveRendererName=function(){var e=t.prototype.getRendererName.call(this);if(null==e){var n=this.getParent();if(!n)throw new Error(\"BlockBaseMetadata :: no renderer found for \"+this.getName());e=r.prototype._resolveRendererName.apply(n)}return e},r.prototype.getView=function(e){return this._mViews[e]},r.prototype.getViews=function(){return this._mViews},r.prototype.setView=function(e,t){return this._mViews[e]=t,this},r.prototype.hasViews=function(){return!e.isEmptyObject(this._mViews)},r},!0);",
	"sap/uxap/BlockBaseRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define(function(){\"use strict\";var e={};return e.render=function(e,t){if(t.getVisible()){if(e.write(\"<div\"),e.writeControlData(t),t._getSelectedViewContent())e.addClass(\"sapUxAPBlockBase\"),e.addClass(\"sapUxAPBlockBase\"+t.getMode());else{var a=t.getMetadata().getName().split(\".\").pop();e.addClass(\"sapUxAPBlockBaseDefaultSize\"),e.addClass(\"sapUxAPBlockBaseDefaultSize\"+a+t.getMode())}e.writeClasses(),e.write(\">\"),t._getSelectedViewContent()&&e.renderControl(t._getSelectedViewContent()),e.write(\"</div>\")}},e},!0);",
	"sap/uxap/BreadCrumbs.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/m/Link\",\"sap/m/Select\",\"sap/ui/core/Control\",\"sap/ui/core/ResizeHandler\",\"sap/ui/core/delegate/ItemNavigation\",\"sap/ui/core/Item\",\"sap/ui/core/Icon\",\"sap/ui/Device\",\"./library\",\"sap/ui/core/InvisibleText\",\"./BreadCrumbsRenderer\"],function(e,t,i,s,r,o,n,a,l,h,u){\"use strict\";var g=i.extend(\"sap.uxap.BreadCrumbs\",{metadata:{library:\"sap.uxap\",properties:{showCurrentLocation:{type:\"boolean\",group:\"Behavior\",defaultValue:!0}},defaultAggregation:\"links\",aggregations:{links:{type:\"sap.m.Link\",multiple:!0,singularName:\"link\"},currentLocation:{type:\"sap.m.Text\",multiple:!1},_tubeIcon:{type:\"sap.ui.core.Icon\",multiple:!1,visibility:\"hidden\"},_overflowSelect:{type:\"sap.m.Select\",multiple:!1,visibility:\"hidden\"}}}});return g.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5,g.prototype.init=function(){this._iREMSize=parseInt(jQuery(\"body\").css(\"font-size\"),10),this._iContainerMaxHeight=2*this._iREMSize},g.prototype.onBeforeRendering=function(){this._bOnPhone=a.system.phone,this._resetControl()},g.prototype.onAfterRendering=function(){this._handleInitialModeSelection()},g.prototype._handleInitialModeSelection=function(){return this._bOnPhone?(this._setSelectVisible(!0),this):(this._configureKeyboardHandling(),this._iContainerHeight||(this._iContainerHeight=this.$().outerHeight()),this._iContainerHeight>this._iContainerMaxHeight?(this._toggleOverflowMode(!0),this):(this._sResizeListenerId=s.register(this,this._handleScreenResize.bind(this)),this))},g.prototype._toggleOverflowMode=function(e){return this._sResizeListenerId&&s.deregister(this._sResizeListenerId),this._setSelectVisible(e),this._setBreadcrumbsVisible(!e),this._sResizeListenerId=s.register(this,this._handleScreenResize.bind(this)),this},g.prototype._getTubeIcon=function(){return this.getAggregation(\"_tubeIcon\")||this.setAggregation(\"_tubeIcon\",new n({src:\"sap-icon://slim-arrow-right\",color:\"#bfbfbf\",size:\"1rem\",useIconTooltip:!1}).addStyleClass(\"sapUxAPTubeIcon\")),this.getAggregation(\"_tubeIcon\")},g.prototype._getOverflowSelect=function(){var e,i;return this.getAggregation(\"_overflowSelect\")||(i=this.getLinks().reverse()||[],i.unshift(this.getCurrentLocation()),e=new t({items:i.map(this._createSelectItem),autoAdjustWidth:!0}),e.attachChange(this._overflowSelectChangeHandler),this.setAggregation(\"_overflowSelect\",e)),this.getAggregation(\"_overflowSelect\")},g.prototype._createSelectItem=function(e){return new o({key:e.getId(),text:e.getText()})},g.prototype._overflowSelectChangeHandler=function(t){var i,s,r=t.getParameter(\"selectedItem\").getKey(),o=sap.ui.getCore().byId(r);return o instanceof e&&(i=o.getHref(),o.firePress(),i&&(s=o.getTarget(),s?window.open(i,s):window.location.href=i)),this},g.prototype._handleScreenResize=function(e){var t=this._shouldOverflow(),i=this._getUsingOverflowSelect();return t&&!i?this._toggleOverflowMode(!0):!t&&i&&this._toggleOverflowMode(!1),this},g.prototype._shouldOverflow=function(){var e,t=this._getBreadcrumbsAsJQueryObject(),i=this._getUsingOverflowSelect();return i&&this._setBreadcrumbsVisible(!0),t.addClass(\"sapUxAPInvisible\"),e=t.outerHeight()>this._iContainerMaxHeight,t.removeClass(\"sapUxAPInvisible\"),i&&this._setBreadcrumbsVisible(!1),e},g.prototype._getBreadcrumbsAsJQueryObject=function(){return this._$breadcrumbs||(this._$breadcurmbs=this.$(\"breadcrumbs\")),this._$breadcurmbs},g.prototype._getOverflowSelectAsJQueryObject=function(){return this._$select||(this._$select=this.$(\"select\")),this._$select},g.prototype._setBreadcrumbsVisible=function(e){var t=this.$(),i=this._getBreadcrumbsAsJQueryObject();return e?(i.removeClass(\"sapUiHidden\"),t.removeClass(\"sapUxAPFullWidth\")):(i.addClass(\"sapUiHidden\"),t.addClass(\"sapUxAPFullWidth\")),t},g.prototype._setSelectVisible=function(e){var t=this._getOverflowSelectAsJQueryObject();return e?t.removeClass(\"sapUiHidden\"):t.addClass(\"sapUiHidden\"),this},g.prototype._resetControl=function(){return this._iContainerHeight=null,this._$select=null,this._$breadcrumbs=null,this.setAggregation(\"_overflowSelect\",null,!0),this._sResizeListenerId&&s.deregister(this._sResizeListenerId),this},g.prototype._getAriaLabelledBy=function(){return this._oAriaLabelledBy||(g.prototype._oAriaLabelledBy=new h({text:l.i18nModel.getResourceBundle().getText(\"BREADCRUMB_TRAIL_LABEL\")}).toStatic()),this._oAriaLabelledBy},g.prototype._getItemNavigation=function(){return this._ItemNavigation||(this._ItemNavigation=new r),this._ItemNavigation},g.prototype._getItemsToNavigate=function(){var e=this.getLinks(),t=this.getCurrentLocation();return this.getShowCurrentLocation()&&t&&e.push(t),e},g.prototype._configureKeyboardHandling=function(){var e=this._getItemNavigation(),t=this._getBreadcrumbsAsJQueryObject()[0],i=this._getItemsToNavigate(),s=[];return i.forEach(function(e){e.$().attr(\"tabIndex\",\"-1\"),s.push(e.getDomRef())}),this.addDelegate(e),e.setCycling(!1),e.setRootDomRef(t),e.setItemDomRefs(s),e.setSelectedIndex(-1),this._getBreadcrumbsAsJQueryObject().attr(\"tabindex\",\"-1\"),i[0].$().attr(\"tabindex\",\"0\"),this},g.prototype.onsappageup=function(e){this._handlePageKeys(e,!1)},g.prototype.onsappagedown=function(e){this._handlePageKeys(e,!0)},g.prototype._handlePageKeys=function(e,t){var i,s=this._getItemsToNavigate(),r=0,o=t?s.length-1:0;e.preventDefault(),s.some(function(t,i){if(t.getId()===e.target.id)return r=i,!0}),i=t?r+g.PAGEUP_AND_PAGEDOWN_JUMP_SIZE:r-g.PAGEUP_AND_PAGEDOWN_JUMP_SIZE,i&&s[i]?s[i].focus():s[o]&&s[o].focus()},g.prototype._getUsingOverflowSelect=function(){return!this._getOverflowSelectAsJQueryObject().hasClass(\"sapUiHidden\")},g.prototype.exit=function(){this._ItemNavigation&&(this.removeDelegate(this._ItemNavigation),this._ItemNavigation.destroy(),this._ItemNavigation=null),this._resetControl()},g});",
	"sap/uxap/BreadCrumbsRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define(function(){\"use strict\";var e={};return e.render=function(e,r){e.write(\"<div\"),e.writeControlData(r),e.addClass(\"sapUxAPBreadCrumbs\"),e.writeClasses(),e.writeAttribute(\"role\",\"navigation\"),e.writeAttributeEscaped(\"aria-labelledby\",r._getAriaLabelledBy().getId()),e.write(\">\"),this._renderOverflowSelect(e,r),r._bOnPhone||this._renderBreadcrumbTrail(e,r),e.write(\"</div>\")},e._renderBreadcrumbTrail=function(e,r){var t=r.getLinks(),i=r.getCurrentLocation(),n=r._getTubeIcon(),a=r.getShowCurrentLocation();e.write(\"<ul id='\"+r.getId()+\"-breadcrumbs'\"),e.write(\">\"),t.forEach(function(r){e.write(\"<li>\"),e.renderControl(r),e.renderControl(n),e.write(\"</li>\")}),a&&(e.write(\"<li>\"),e.renderControl(i),e.write(\"</li>\")),e.write(\"</ul>\")},e._renderOverflowSelect=function(e,r){var t=r._getTubeIcon();e.write(\"<div id='\"+r.getId()+\"-select'\"),e.addClass(\"sapUiHidden\"),e.writeClasses(),e.write(\">\"),e.write('<span class=\"sapUxAPBreadCrumbsDots\">...</span>'),e.renderControl(t),e.renderControl(r._getOverflowSelect()),e.write(\"</div>\")},e},!0);",
	"sap/uxap/changeHandler/MoveObjectPageSection.js": "/*!\n\t* UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n\t*/\nsap.ui.define([\"sap/ui/fl/changeHandler/MoveControls\"],function(e){\"use strict\";var r=jQuery.extend({},e);return r.applyChange=function(r,n,t){var a=\"jsControlTree\"===t.modifier.targets;a&&n._suppressScroll();var o=e.applyChange.call(this,r,n,t);return a&&n.attachEventOnce(\"onAfterRenderingDOMReady\",function(){n._resumeScroll(!1)}),o},r.revertChange=function(r,n,t){var a=\"jsControlTree\"===t.modifier.targets;a&&n._suppressScroll();var o=e.revertChange.call(this,r,n,t);return a&&n.attachEventOnce(\"onAfterRenderingDOMReady\",function(){n._resumeScroll(!1)}),o},r},!0);",
	"sap/uxap/changeHandler/RenameObjectPageSection.js": "/*!\n\t * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n\t */\nsap.ui.define([\"sap/ui/fl/Utils\",\"sap/ui/fl/changeHandler/BaseRename\"],function(e,t){\"use strict\";var r={propertyName:\"title\",changePropertyName:\"newText\",translationTextType:\"XGRP\"},n=t.createRenameChangeHandler(r);return n._getControlForRename=function(e,t){var r=t.getAggregation(e,\"subSections\");return r&&1===r.length&&t.getProperty(r[0],\"title\")&&\"TitleOnTop\"===t.getProperty(t.getParent(e),\"subSectionLayout\")?r[0]:e},n._getSetterMethodName=function(t,r,n){return e.isBinding(t)?\"setPropertyBinding\":\"setProperty\"},n.applyChange=function(t,a,o){var i=o.modifier,g=r.propertyName,p=t.getDefinition(),s=p.texts[r.changePropertyName],f=s.value,l=n._getControlForRename(a,i);if(p.texts&&s&&\"string\"==typeof f){t.setRevertData(i.getProperty(l,g));return i[n._getSetterMethodName(f)](l,g,f),!0}e.log.error(\"Change does not contain sufficient information to be applied: [\"+p.layer+\"]\"+p.namespace+\"/\"+p.fileName+\".\"+p.fileType)},n.revertChange=function(t,a,o){var i=t.getRevertData();if(\"string\"==typeof i){var g=o.modifier,p=n._getControlForRename(a,g),s=r.propertyName;return g[n._getSetterMethodName(i)](p,s,i),t.resetRevertData(),!0}e.log.error(\"Change doesn't contain sufficient information to be reverted. Most Likely the Change didn't go through applyChange.\")},n},!0);",
	"sap/uxap/component/Component.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/uxap/library\",\"sap/ui/core/UIComponent\",\"sap/ui/core/library\",\"sap/ui/core/Component\"],function(o,t,e,n){\"use strict\";var i=n.mvc.ViewType,a=t.ObjectPageConfigurationMode;return e.extend(\"sap.uxap.component.Component\",{metadata:{},init:function(){switch(this._oModel=null,this._oViewConfig={viewData:{component:this}},this.oComponentData.mode){case a.JsonURL:this._oModel=new e(this.oComponentData.jsonConfigurationURL),this._oViewConfig.viewName=\"sap.uxap.component.ObjectPageLayoutUXDrivenFactory\",this._oViewConfig.type=i.XML;break;case a.JsonModel:this._oViewConfig.viewName=\"sap.uxap.component.ObjectPageLayoutUXDrivenFactory\",this._oViewConfig.type=i.XML;break;default:o.sap.log.error(\"UxAPComponent :: missing bootstrap information. Expecting one of the following: JsonURL, JsonModel and FacetsAnnotation\")}e.prototype.init.call(this)},createContent:function(){var o;return this._oView=sap.ui.view(this._oViewConfig),this._oModel&&(o=this._oView.getController(),o&&o.connectToComponent&&o.connectToComponent(this._oModel),this._oView.setModel(this._oModel,\"objectPageLayoutMetadata\")),this._oView},propagateProperties:function(o){if(this.oComponentData.mode===a.JsonModel){var t=this._oView.getController();t&&t.connectToComponent&&t.connectToComponent(this.getModel(\"objectPageLayoutMetadata\"))}return e.prototype.propagateProperties.apply(this,arguments)},destroy:function(){this._oView&&(this._oView.destroy(),this._oView=null),this._oModel&&(this._oModel.destroy(),this._oModel=null),e.prototype.destroy&&e.prototype.destroy.call(this)}})});",
	"sap/uxap/component/ObjectPageComponentContainer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/ComponentContainer\",\"sap/ui/core/Component\"],function(e,o){\"use strict\";return o.extend(\"sap.uxap.component.ObjectPageComponentContainer\",{metadata:{properties:{jsonConfigurationURL:{type:\"string\",group:\"Behavior\"},mode:{type:\"sap.uxap.ObjectPageConfigurationMode\",group:\"Behavior\"}}},init:function(){this.setPropagateModel(!0),this.setName(\"sap.uxap.component\")},onBeforeRendering:function(){this._oComponent=sap.ui.component(\"sap.uxap\"),this._oComponent||(this._oComponent=sap.ui.component({name:this.getName(),url:this.getUrl(),componentData:{jsonConfigurationURL:this.getJsonConfigurationURL(),mode:this.getMode()}}),this.setComponent(this._oComponent,!0)),o.prototype.onBeforeRendering&&o.prototype.onBeforeRendering.call(this)},getObjectPageLayoutInstance:function(){var o=null;return this._oComponent&&this._oComponent._oView?o=this._oComponent._oView.byId(\"ObjectPageLayout\"):e.sap.log.error(\"ObjectPageComponentContainer :: cannot find children ObjectPageLayout, has it been rendered already?\"),o},renderer:\"sap.ui.core.ComponentContainerRenderer\"})});",
	"sap/uxap/component/ObjectPageLayoutUXDrivenFactory.controller.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/model/BindingMode\",\"sap/ui/model/Context\",\"sap/ui/base/ManagedObject\",\"sap/ui/core/mvc/Controller\"],function(e,t,r,o,a){\"use strict\";return a.extend(\"sap.uxap.component.ObjectPageLayoutUXDrivenFactory\",{connectToComponent:function(o){var a=e.isEmptyObject(o.getData());o.setDefaultBindingMode(t.OneWay);var n=e.proxy(function(){a&&o.detachRequestCompleted(n);var t=new r(o,\"/headerTitle\"),c=this.getView().byId(\"ObjectPageLayout\");if(t.getProperty(\"\"))try{this._oHeader=this.controlFactory(c.getId(),t),c.setHeaderTitle(this._oHeader)}catch(t){e.sap.log.error(\"ObjectPageLayoutFactory :: error in header creation from config: \"+t)}},this);a?o.attachRequestCompleted(n):n()},controlFactory:function(t,r){var a,n,c,i=r.getProperty(\"\");try{e.sap.require(i.Type),n=e.sap.getObject(i.Type),c=n.getMetadata(),e.each(c._mAllEvents,e.proxy(function(e,t){\"string\"==typeof i[e]&&(i[e]=this.convertEventHandler(i[e]))},this)),a=o.create(i),e.each(c._mAllProperties,e.proxy(function(e,t){i[e]&&a.bindProperty(e,\"objectPageLayoutMetadata>\"+r.getPath()+\"/\"+e)},this))}catch(t){e.sap.log.error(\"ObjectPageLayoutFactory :: error in control creation from config: \"+t)}return a},convertEventHandler:function(t){var r=window,o=t.split(\".\");try{e.each(o,function(e,t){r=r[t]})}catch(o){e.sap.log.error(\"ObjectPageLayoutFactory :: undefined event handler: \"+t+\". Did you forget to require its static class?\"),r=void 0}return r}})},!0);",
	"sap/uxap/flexibility/ObjectPageHeader.flexibility.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/m/changeHandler/CombineButtons\",\"sap/m/changeHandler/SplitMenuButton\"],function(n,e){\"use strict\";return{combineButtons:{changeHandler:n,layers:{CUSTOMER:!1}},moveControls:\"default\",splitMenuButton:{changeHandler:e,layers:{CUSTOMER:!1}}}},!0);",
	"sap/uxap/flexibility/ObjectPageLayout.flexibility.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/uxap/changeHandler/MoveObjectPageSection\"],function(e){\"use strict\";return{moveControls:{changeHandler:e,layers:{USER:!0}}}},!0);",
	"sap/uxap/flexibility/ObjectPageSection.flexibility.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/uxap/changeHandler/RenameObjectPageSection\"],function(e){\"use strict\";return{rename:e,moveControls:\"default\",hideControl:{changeHandler:\"default\",layers:{USER:!0}},unhideControl:{changeHandler:\"default\",layers:{USER:!0}},stashControl:{changeHandler:\"default\",layers:{USER:!0}},unstashControl:{changeHandler:\"default\",layers:{USER:!0}}}},!0);",
	"sap/uxap/flexibility/ObjectPageSubSection.flexibility.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/m/changeHandler/CombineButtons\",\"sap/m/changeHandler/SplitMenuButton\",\"sap/ui/fl/changeHandler/BaseRename\"],function(e,n,a){\"use strict\";return{hideControl:\"default\",unhideControl:\"default\",rename:a.createRenameChangeHandler({propertyName:\"title\",translationTextType:\"XGRP\"}),combineButtons:{changeHandler:e,layers:{CUSTOMER:!1}},moveControls:\"default\",splitMenuButton:{changeHandler:n,layers:{CUSTOMER:!1}}}},!0);",
	"sap/uxap/HierarchicalSelect.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/m/Select\",\"sap/ui/Device\",\"./library\",\"./HierarchicalSelectRenderer\"],function(e,t,o,r,a){\"use strict\";var i=t.extend(\"sap.uxap.HierarchicalSelect\",{metadata:{library:\"sap.uxap\",properties:{upperCase:{type:\"boolean\",group:\"Appearance\",defaultValue:!1}}}});return i.POPOVER_MIN_WIDTH_REM=11,i.prototype.onAfterRendering=function(){t.prototype.onAfterRendering.apply(this,arguments)},i.prototype.onAfterRenderingPicker=function(){t.prototype.onAfterRenderingPicker.call(this),(this.getItems()||[]).forEach(function(e){var t=!0===e.data(\"secondLevel\")?\"sapUxAPHierarchicalSelectSecondLevel\":\"sapUxAPHierarchicalSelectFirstLevel\";e.$().addClass(t)},this)},i.prototype.setUpperCase=function(e,t){this.setProperty(\"upperCase\",e,t),this.toggleStyleClass(\"sapUxAPHierarchicalSelectUpperCase\",e);var o=this.getAggregation(\"picker\");return o&&(o.toggleStyleClass(\"sapMSltPickerFirstLevelUpperCase\",e),t||o.invalidate()),this},i.prototype.onsapenter=t.prototype.onsapspace,[\"onsapup\",\"onsappageup\",\"onsappagedown\",\"onsaphome\",\"onsapend\"].forEach(function(e){i.prototype[e]=function(o){t.prototype[e].call(this,o),o.stopPropagation()}}),i.prototype._createDialog=function(){var e=t.prototype._createDialog.call(this),o=e.getCustomHeader();return o&&o.addStyleClass(\"sapUxAPHierarchicalSelect\"),e},i.prototype._decoratePopover=function(r){if(t.prototype._decoratePopover.call(this,r),r._adaptPositionParams=function(){this._marginTop=0,this._marginLeft=0,this._marginRight=0,this._marginBottom=0,this._arrowOffset=0,this._offsets=[\"0 0\",\"0 0\",\"0 0\",\"0 0\"],this._myPositions=[\"end bottom\",\"end center\",\"end top\",\"begin center\"],this._atPositions=[\"end top\",\"end center\",\"end bottom\",\"begin center\"]},o.system.tablet||o.system.desktop){var a=e.position.scrollbarWidth();a>0&&r.setOffsetX(a)}},i.prototype._onAfterRenderingPopover=function(){var t=this.getPicker(),o=t.getDomRef(\"cont\"),r=o.style.minWidth;if(e.sap.endsWith(r,\"rem\")){r=r.substring(0,r.length-3);parseFloat(r)<i.POPOVER_MIN_WIDTH_REM&&o&&(o.style.minWidth=i.POPOVER_MIN_WIDTH_REM+\"rem\")}},i});",
	"sap/uxap/HierarchicalSelectRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/m/SelectRenderer\",\"sap/ui/core/Renderer\"],function(e,a){\"use strict\";var r=a.extend(e);return r.addClass=function(e){e.addClass(\"sapUxAPHierarchicalSelect\")},r},!0);",
	"sap/uxap/LazyLoading.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/Device\",\"sap/ui/base/Metadata\",\"./ObjectPageSubSection\",\"./library\"],function(i,e,t,o,s){\"use strict\";var a=t.createClass(\"sap.uxap._helpers.LazyLoading\",{constructor:function(e){this._oObjectPageLayout=e,this._$html=i(\"html\"),this._iPreviousScrollTop=0,this._iScrollProgress=0,this._iPreviousScrollTimestamp=0,this._sLazyLoadingTimer=null,this._oPrevSubSectionsInView={},this.setLazyLoadingParameters()}});return a.prototype.setLazyLoadingParameters=function(){this.LAZY_LOADING_DELAY=200,this.LAZY_LOADING_EXTRA_PAGE_SIZE=.5,this._isPhone()?this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:1,ScrollToSection:1}:this._isTablet()?this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:2,ScrollToSection:1}:this._isTabletSize()?this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:2,ScrollToSection:2}:this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:3,ScrollToSection:3},this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD=5},a.prototype._triggerVisibleSubSectionsEvents=function(){this._oPrevSubSectionsInView={},this.doLazyLoading()},a.prototype.lazyLoadDuringScroll=function(e,t,o){var s,a,n=!1;this._iScrollProgress=e-this._iPreviousScrollTop,s=Math.round(Math.abs(this._iScrollProgress)/o*100),s>=this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD&&(n=!0),this._iPreviousScrollTop=e,this._iPreviousScrollTimestamp=t||0,a=0===e?0:this.LAZY_LOADING_DELAY,n&&this._sLazyLoadingTimer&&(i.sap.log.debug(\"ObjectPageLayout :: lazyLoading\",\"delayed by \"+a+\" ms because of fast scroll\"),i.sap.clearDelayedCall(this._sLazyLoadingTimer),this._sLazyLoadingTimer=null),this._sLazyLoadingTimer||(this._sLazyLoadingTimer=i.sap.delayedCall(a,this,this.doLazyLoading))},a.prototype.doLazyLoading=function(){var e,t,o,s,a,n,r,l=this._oObjectPageLayout._getHeightRelatedParameters(),_=this._oObjectPageLayout._oSectionInfo,c=this._iPreviousScrollTop>=l.iHeaderContentHeight,h=-1,L={},g={};o=l.iScreenHeight-(c?l.iAnchorBarHeight:0)-(c?l.iHeaderTitleHeightStickied:0),e=l.iScrollTop,a=Date.now()-this._iPreviousScrollTimestamp,n=a<this.LAZY_LOADING_DELAY/2&&Math.abs(this._iScrollProgress)>5,n&&(r=this._iScrollProgress>=0?Math.round(Math.min(20*this._iScrollProgress,o/2)):-1*Math.round(Math.min(20*Math.abs(this._iScrollProgress),o/2)),e+=r,i.sap.log.debug(\"ObjectPageLayout :: lazyLoading\",\"Visible page shifted from : \"+r)),t=e+o,e+=16,i.each(_,i.proxy(function(i,a){!a.isSection&&a.sectionReference.getParent()&&a.sectionReference.getParent().getVisible()&&(a.positionTop<=t&&e<a.positionBottom-1?(g[i]=i,a.loaded||(L[i]=i)):!a.loaded&&a.positionTop>t&&a.positionTop<t+o*this.LAZY_LOADING_EXTRA_PAGE_SIZE&&(-1==h||a.positionTop<h)&&(h=a.positionTop,s=i))},this)),-1!=h&&i.isEmptyObject(L)&&(i.sap.log.debug(\"ObjectPageLayout :: lazyLoading\",\"extra section added : \"+s),L[s]=s),i.each(L,i.proxy(function(e,t){i.sap.log.debug(\"ObjectPageLayout :: lazyLoading\",\"connecting \"+t),sap.ui.getCore().byId(t).connectToModels(),_[t].loaded=!0},this)),i.each(g,i.proxy(function(e,t){this._oPrevSubSectionsInView[e]||(i.sap.log.debug(\"ObjectPageLayout :: lazyLoading\",\"subSectionEnteredViewPort \"+t),this._oObjectPageLayout.fireEvent(\"subSectionEnteredViewPort\",{subSection:sap.ui.getCore().byId(t)}))},this)),this._oPrevSubSectionsInView=g,this._sLazyLoadingTimer=n?i.sap.delayedCall(this.LAZY_LOADING_DELAY,this,this.doLazyLoading):h?i.sap.delayedCall(5*this.LAZY_LOADING_DELAY,this,this.doLazyLoading):null},a.prototype.getSubsectionsToPreload=function(i,e){var t,s;e?(t=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.ScrollToSection,s=!1):(t=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.FirstRendering,s=!0);var a=[];return i.some(function(i){return!s&&e&&(s=i.getId()==e),s&&i instanceof o&&i.getVisible()&&i._getInternalVisible()&&(a.push(i),t--),t<=0}),a},a.prototype._isPhone=function(){return s.Utilities.isPhoneScenario(this._oObjectPageLayout._getCurrentMediaContainerRange())},a.prototype._isTablet=function(){return e.system.tablet},a.prototype._isTabletSize=function(){return s.Utilities.isTabletScenario(this._oObjectPageLayout._getCurrentMediaContainerRange())},a},!1);",
	"sap/uxap/library.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Core\",\"sap/ui/base/DataType\",\"sap/ui/Device\",\"sap/m/library\",\"sap/ui/layout/library\"],function(e,a,t,p){\"use strict\";return sap.ui.getCore().initLibrary({name:\"sap.uxap\",dependencies:[\"sap.ui.core\",\"sap.m\",\"sap.ui.layout\"],designtime:\"sap/uxap/designtime/library.designtime\",types:[\"sap.uxap.BlockBaseColumnLayout\",\"sap.uxap.ObjectPageConfigurationMode\",\"sap.uxap.ObjectPageHeaderDesign\",\"sap.uxap.ObjectPageHeaderPictureShape\",\"sap.uxap.ObjectPageSubSectionLayout\",\"sap.uxap.ObjectPageSubSectionMode\"],interfaces:[\"sap.uxap.IHeaderTitle\",\"sap.uxap.IHeaderContent\"],controls:[\"sap.uxap.AnchorBar\",\"sap.uxap.BlockBase\",\"sap.uxap.BreadCrumbs\",\"sap.uxap.HierarchicalSelect\",\"sap.uxap.ObjectPageHeader\",\"sap.uxap.ObjectPageDynamicHeaderTitle\",\"sap.uxap.ObjectPageDynamicHeaderContent\",\"sap.uxap.ObjectPageHeaderActionButton\",\"sap.uxap.ObjectPageHeaderContent\",\"sap.uxap.ObjectPageLayout\",\"sap.uxap.ObjectPageSection\",\"sap.uxap.ObjectPageSectionBase\",\"sap.uxap.ObjectPageSubSection\"],elements:[\"sap.uxap.ModelMapping\",\"sap.uxap.ObjectPageHeaderLayoutData\"],version:\"904001.7.0.20251118090100_f0htmcm94p\",extensions:{flChangeHandlers:{\"sap.uxap.ObjectPageHeader\":\"sap/uxap/flexibility/ObjectPageHeader\",\"sap.uxap.ObjectPageLayout\":\"sap/uxap/flexibility/ObjectPageLayout\",\"sap.uxap.ObjectPageSection\":\"sap/uxap/flexibility/ObjectPageSection\",\"sap.uxap.ObjectPageSubSection\":\"sap/uxap/flexibility/ObjectPageSubSection\",\"sap.ui.core._StashedControl\":{unstashControl:{changeHandler:\"default\",layers:{USER:!0}}}},\"sap.ui.support\":{publicRules:!0}}}),sap.uxap.BlockBaseColumnLayout=t.createType(\"sap.uxap.BlockBaseColumnLayout\",{isValid:function(e){return/^(auto|[1-4]{1})$/.test(e)}},t.getType(\"string\")),sap.uxap.BlockBaseFormAdjustment={BlockColumns:\"BlockColumns\",OneColumn:\"OneColumn\",None:\"None\"},sap.uxap.ObjectPageConfigurationMode={JsonURL:\"JsonURL\",JsonModel:\"JsonModel\"},sap.uxap.ObjectPageHeaderDesign={Light:\"Light\",Dark:\"Dark\"},sap.uxap.ObjectPageHeaderPictureShape={Circle:\"Circle\",Square:\"Square\"},sap.uxap.ObjectPageSubSectionLayout={TitleOnTop:\"TitleOnTop\",TitleOnLeft:\"TitleOnLeft\"},sap.uxap.ObjectPageSubSectionMode={Collapsed:\"Collapsed\",Expanded:\"Expanded\"},sap.uxap.Importance={Low:\"Low\",Medium:\"Medium\",High:\"High\"},sap.uxap.i18nModel=function(){return new sap.ui.model.resource.ResourceModel({bundleUrl:e.sap.getModulePath(\"sap.uxap.i18n.i18n\",\".properties\")})}(),sap.uxap.Utilities={getClosestOPL:function(e){for(;e&&!(e instanceof sap.uxap.ObjectPageLayout);)e=e.getParent();return e},isPhoneScenario:function(e){return!!p.system.phone||sap.uxap.Utilities._isCurrentMediaSize(\"Phone\",e)},isTabletScenario:function(e){return sap.uxap.Utilities._isCurrentMediaSize(\"Tablet\",e)},_isCurrentMediaSize:function(e,a){return a&&a.name===e}},sap.uxap});",
	"sap/uxap/library.support.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"./rules/ObjectPageLayout.support\"],function(e){\"use strict\";return{name:\"sap.uxap\",niceName:\"ObjectPage library\",ruleset:[e]}},!0);",
	"sap/uxap/ModelMapping.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Element\",\"./library\"],function(e,a){\"use strict\";return e.extend(\"sap.uxap.ModelMapping\",{metadata:{library:\"sap.uxap\",properties:{externalModelName:{type:\"string\",group:\"Misc\",defaultValue:null},internalModelName:{type:\"string\",group:\"Misc\",defaultValue:\"Model\"},externalPath:{type:\"string\",group:\"Misc\",defaultValue:null}}}})});",
	"sap/uxap/ObjectImageHelper.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Icon\",\"sap/ui/core/IconPool\",\"sap/m/Image\"],function(e,a,t){\"use strict\";var r=function(){};return r.createObjectImage=function(a){var r,s=a.getObjectImageURI();return 0===s.indexOf(\"sap-icon://\")?(r=new e,r.addStyleClass(\"sapUxAPObjectPageHeaderObjectImageIcon\")):(r=new t({densityAware:a.getObjectImageDensityAware(),alt:a.getObjectImageAlt(),decorative:!1}),r.addStyleClass(\"sapUxAPObjectPageHeaderObjectImage\")),r.setSrc(s),a.getObjectImageAlt()&&r.setTooltip(a.getObjectImageAlt()),r},r.createPlaceholder=function(){return a.createControlByURI({src:a.getIconURI(\"picture\"),visible:!0})},r._renderImageAndPlaceholder=function(a,t){var s=t.oHeader,c=t.oObjectImage,d=t.oPlaceholder,l=t.bIsObjectIconAlwaysVisible,n=t.bAddSubContainer,i=t.sBaseClass,o=!(s.getObjectImageShape()||s.getShowPlaceholder()),g=c instanceof e;(s.getObjectImageURI()||s.getShowPlaceholder())&&(a.write(\"<span \"),a.addClass(i),a.addClass(\"sapUxAPObjectPageHeaderObjectImage-\"+s.getObjectImageShape()),l&&a.addClass(\"sapUxAPObjectPageHeaderObjectImageForce\"),a.writeClasses(),a.write(\">\"),n&&a.write(\"<span class='sapUxAPObjectPageHeaderObjectImageContainerSub'>\"),g&&(a.write(\"<div\"),a.addClass(\"sapUxAPObjectPageHeaderObjectImage\"),a.addClass(\"sapUxAPObjectPageHeaderPlaceholder\"),a.writeClasses(),a.write(\">\")),a.renderControl(c),r._renderPlaceholder(a,d,o),g&&a.write(\"</div>\"),n&&a.write(\"</span>\"),a.write(\"</span>\"))},r._renderPlaceholder=function(e,a,t){e.write(\"<div\"),e.addClass(\"sapUxAPObjectPageHeaderPlaceholder\"),e.addClass(\"sapUxAPObjectPageHeaderObjectImage\"),t||e.addClass(\"sapUxAPHidePlaceholder\"),e.writeClasses(),e.write(\">\"),e.renderControl(a),e.write(\"</div>\")},r},!1);",
	"sap/uxap/ObjectPageDynamicHeaderContent.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./library\",\"./ObjectPageDynamicHeaderContentRenderer\"],function(e,n,t){\"use strict\";try{sap.ui.getCore().loadLibrary(\"sap.f\")}catch(n){throw e.sap.log.error(\"The control 'sap.uxap.ObjectPageDynamicHeaderContent' needs library 'sap.f'.\"),n}var a=sap.ui.requireSync(\"sap/f/DynamicPageHeader\"),r=a.extend(\"sap.uxap.ObjectPageDynamicHeaderContent\",{metadata:{interfaces:[\"sap.uxap.IHeaderContent\"],library:\"sap.uxap\"}});return r.createInstance=function(e,n,t,a){return new r({content:e,visible:n,pinnable:a})},r.prototype.supportsPinUnpin=function(){return!0},r.prototype.supportsChildPageDesign=function(){return!1},r.prototype.supportsAlwaysExpanded=function(){return!1},r.prototype.setContentDesign=function(e){},r});",
	"sap/uxap/ObjectPageDynamicHeaderContentRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Renderer\",\"sap/f/DynamicPageHeaderRenderer\"],function(e,r){\"use strict\";return e.extend(r)},!0);",
	"sap/uxap/ObjectPageDynamicHeaderTitle.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./library\",\"sap/uxap/ObjectPageDynamicHeaderContent\",\"./ObjectPageDynamicHeaderTitleRenderer\"],function(e,t,a,r){\"use strict\";try{sap.ui.getCore().loadLibrary(\"sap.f\")}catch(t){throw e.sap.log.error(\"The control 'sap.uxap.ObjectPageDynamicHeaderTitle' needs library 'sap.f'.\"),t}var n=sap.ui.requireSync(\"sap/f/DynamicPageTitle\"),o=n.extend(\"sap.uxap.ObjectPageDynamicHeaderTitle\",{metadata:{interfaces:[\"sap.uxap.IHeaderTitle\"],library:\"sap.uxap\"}});return o.prototype.isDynamic=function(){return!0},o.prototype.getCompatibleHeaderContentClass=function(){return a},o.prototype.supportsTitleInHeaderContent=function(){return!1},o.prototype.supportsAdaptLayoutForDomElement=function(){return!1},o.KNOWN_HEADING_CONTROL_CLASS_NAMES=[\"sap.m.Title\",\"sap.m.Text\",\"sap.m.FormattedText\",\"sap.m.Label\"],o.prototype.getTitleText=function(){var e=this.getHeading(),t=e&&e.getMetadata().getName();if(o.KNOWN_HEADING_CONTROL_CLASS_NAMES.indexOf(t)>-1)return e.getText()},o.prototype.getHeaderDesign=function(){return t.ObjectPageHeaderDesign.Light},o.prototype.snap=function(e){this._toggleState(!1,e)},o.prototype.unSnap=function(e){this._toggleState(!0,e)},o.prototype._adaptLayoutForDomElement=function(e,t){},o});",
	"sap/uxap/ObjectPageDynamicHeaderTitleRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Renderer\",\"sap/f/DynamicPageTitleRenderer\"],function(e,n){\"use strict\";return e.extend(n)},!0);",
	"sap/uxap/ObjectPageHeader.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/core/IconPool\",\"sap/ui/core/CustomData\",\"sap/ui/Device\",\"sap/m/Breadcrumbs\",\"./ObjectPageHeaderActionButton\",\"sap/ui/core/ResizeHandler\",\"sap/m/Button\",\"sap/m/ActionSheet\",\"./ObjectImageHelper\",\"./ObjectPageHeaderContent\",\"./library\",\"sap/m/library\",\"./ObjectPageHeaderRenderer\"],function(t,e,i,o,n,a,r,s,l,c,u,p,h,g,d){\"use strict\";var _=h.Importance,y=g.ButtonType,f=g.PlacementType,b=h.ObjectPageHeaderDesign,I=h.ObjectPageHeaderPictureShape,m=e.extend(\"sap.uxap.ObjectPageHeader\",{metadata:{library:\"sap.uxap\",interfaces:[\"sap.uxap.IHeaderTitle\"],properties:{objectImageURI:{type:\"string\",defaultValue:null},objectImageAlt:{type:\"string\",defaultValue:\"\"},objectImageDensityAware:{type:\"boolean\",defaultValue:!1},objectTitle:{type:\"string\",defaultValue:null},objectSubtitle:{type:\"string\",defaultValue:null},objectImageShape:{type:\"sap.uxap.ObjectPageHeaderPictureShape\",defaultValue:I.Square},isObjectIconAlwaysVisible:{type:\"boolean\",defaultValue:!1},isObjectTitleAlwaysVisible:{type:\"boolean\",defaultValue:!0},isObjectSubtitleAlwaysVisible:{type:\"boolean\",defaultValue:!0},isActionAreaAlwaysVisible:{type:\"boolean\",defaultValue:!0},headerDesign:{type:\"sap.uxap.ObjectPageHeaderDesign\",defaultValue:b.Light},showTitleSelector:{type:\"boolean\",group:\"Misc\",defaultValue:!1},markFavorite:{type:\"boolean\",group:\"Misc\",defaultValue:!1},markFlagged:{type:\"boolean\",group:\"Misc\",defaultValue:!1},showMarkers:{type:\"boolean\",group:\"Misc\",defaultValue:!1},markLocked:{type:\"boolean\",group:\"Misc\",defaultValue:!1},showPlaceholder:{type:\"boolean\",group:\"Misc\",defaultValue:!1},markChanges:{type:\"boolean\",group:\"Misc\",defaultValue:!1}},defaultAggregation:\"actions\",aggregations:{_breadCrumbs:{type:\"sap.m.Breadcrumbs\",multiple:!1,visibility:\"hidden\"},breadcrumbs:{type:\"sap.m.Breadcrumbs\",multiple:!1,singularName:\"breadcrumb\"},breadCrumbsLinks:{type:\"sap.m.Link\",multiple:!0,singularName:\"breadCrumbLink\"},_overflowButton:{type:\"sap.m.Button\",multiple:!1,visibility:\"hidden\"},_expandButton:{type:\"sap.m.Button\",multiple:!1,visibility:\"hidden\"},_objectImage:{type:\"sap.ui.core.Control\",multiple:!1,visibility:\"hidden\"},_placeholder:{type:\"sap.ui.core.Icon\",multiple:!1,visibility:\"hidden\"},_lockIconCont:{type:\"sap.m.Button\",multiple:!1,visibility:\"hidden\"},_lockIcon:{type:\"sap.m.Button\",multiple:!1,visibility:\"hidden\"},_titleArrowIconCont:{type:\"sap.m.Button\",multiple:!1,visibility:\"hidden\"},_titleArrowIcon:{type:\"sap.m.Button\",multiple:!1,visibility:\"hidden\"},_favIcon:{type:\"sap.ui.core.Icon\",multiple:!1,visibility:\"hidden\"},_flagIcon:{type:\"sap.ui.core.Icon\",multiple:!1,visibility:\"hidden\"},_overflowActionSheet:{type:\"sap.m.ActionSheet\",multiple:!1,visibility:\"hidden\"},_changesIconCont:{type:\"sap.m.Button\",multiple:!1,visibility:\"hidden\"},_changesIcon:{type:\"sap.m.Button\",multiple:!1,visibility:\"hidden\"},_sideContentBtn:{type:\"sap.m.Button\",multiple:!1,visibility:\"hidden\"},navigationBar:{type:\"sap.m.Bar\",multiple:!1},actions:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"action\"},sideContentButton:{type:\"sap.m.Button\",multiple:!1}},events:{titleSelectorPress:{parameters:{domRef:{type:\"string\"}}},markLockedPress:{parameters:{domRef:{type:\"string\"}}},markChangesPress:{parameters:{domRef:{type:\"string\"}}}},designtime:\"sap/uxap/designtime/ObjectPageHeader.designtime\"}});m.prototype._iAvailablePercentageForActions=.3,m.prototype.init=function(){this._bFirstRendering=!0,this.oLibraryResourceBundle||(this.oLibraryResourceBundle=sap.ui.getCore().getLibraryResourceBundle(\"sap.m\")),this.oLibraryResourceBundleOP||(this.oLibraryResourceBundleOP=h.i18nModel.getResourceBundle()),this._oOverflowActionSheet=this._lazyLoadInternalAggregation(\"_overflowActionSheet\",!0),this._oOverflowButton=this._lazyLoadInternalAggregation(\"_overflowButton\",!0).attachPress(this._handleOverflowButtonPress,this),this._oExpandButton=this._lazyLoadInternalAggregation(\"_expandButton\",!0),this._oActionSheetButtonMap={},this._oFlagIcon=this._lazyLoadInternalAggregation(\"_flagIcon\",!0),this._oFavIcon=this._lazyLoadInternalAggregation(\"_favIcon\",!0),this._oTitleArrowIcon=this._lazyLoadInternalAggregation(\"_titleArrowIcon\",!0).attachPress(this._handleArrowPress,this),this._oTitleArrowIconCont=this._lazyLoadInternalAggregation(\"_titleArrowIconCont\",!0).attachPress(this._handleArrowPress,this),this._oLockIcon=this._lazyLoadInternalAggregation(\"_lockIcon\",!0).attachPress(this._handleLockPress,this),this._oLockIconCont=this._lazyLoadInternalAggregation(\"_lockIconCont\",!0).attachPress(this._handleLockPress,this),this._oChangesIcon=this._lazyLoadInternalAggregation(\"_changesIcon\",!0).attachPress(this._handleChangesPress,this),this._oChangesIconCont=this._lazyLoadInternalAggregation(\"_changesIconCont\",!0).attachPress(this._handleChangesPress,this)},m.getMetadata().forwardAggregation(\"breadCrumbsLinks\",{getter:function(){return this._lazyLoadInternalAggregation(\"_breadCrumbs\")},aggregation:\"links\"}),m.prototype._handleOverflowButtonPress=function(t){this._oOverflowActionSheet.openBy(this._oOverflowButton)},m.prototype._handleArrowPress=function(t){this.fireTitleSelectorPress({domRef:t.getSource().getDomRef()})},m.prototype._handleLockPress=function(t){this.fireMarkLockedPress({domRef:t.getSource().getDomRef()})},m.prototype._handleChangesPress=function(t){this.fireMarkChangesPress({domRef:t.getSource().getDomRef()})},m._internalAggregationFactory={_objectImage:u.createObjectImage,_placeholder:u.createPlaceholder,_overflowActionSheet:function(){return new c({placement:f.Bottom})},_lockIconCont:function(t){return this._getButton(t,\"sap-icon://private\",\"lock-cont\",t.oLibraryResourceBundleOP.getText(\"TOOLTIP_OP_LOCK_MARK_VALUE\"))},_breadCrumbs:function(t){return new a({links:t.getAggregation(\"breadCrumbLinks\")})},_lockIcon:function(t){return this._getButton(t,\"sap-icon://private\",\"lock\",t.oLibraryResourceBundleOP.getText(\"TOOLTIP_OP_LOCK_MARK_VALUE\"))},_titleArrowIconCont:function(t){return this._getButton(t,\"sap-icon://slim-arrow-down\",\"titleArrow-cont\",t.oLibraryResourceBundleOP.getText(\"OP_SELECT_ARROW_TOOLTIP\"))},_titleArrowIcon:function(t){return this._getButton(t,\"sap-icon://slim-arrow-down\",\"titleArrow\",t.oLibraryResourceBundleOP.getText(\"OP_SELECT_ARROW_TOOLTIP\"))},_favIcon:function(t){return this._getIcon(t,\"favorite\",t.oLibraryResourceBundleOP.getText(\"TOOLTIP_OP_FAVORITE_MARK_VALUE\"))},_flagIcon:function(t){return this._getIcon(t,\"flag\",t.oLibraryResourceBundleOP.getText(\"TOOLTIP_OP_FLAG_MARK_VALUE\"))},_overflowButton:function(t){return this._getButton(t,\"sap-icon://overflow\",\"overflow\",t.oLibraryResourceBundleOP.getText(\"TOOLTIP_OP_OVERFLOW_BTN\"))},_expandButton:function(t){return this._getButton(t,\"sap-icon://slim-arrow-down\",\"expand\",t.oLibraryResourceBundleOP.getText(\"TOOLTIP_OP_EXPAND_HEADER_BTN\"))},_changesIconCont:function(t){return this._getButton(t,\"sap-icon://user-edit\",\"changes-cont\",t.oLibraryResourceBundleOP.getText(\"TOOLTIP_OP_CHANGES_MARK_VALUE\"))},_changesIcon:function(t){return this._getButton(t,\"sap-icon://user-edit\",\"changes\",t.oLibraryResourceBundleOP.getText(\"TOOLTIP_OP_CHANGES_MARK_VALUE\"))},_getIcon:function(t,e,o){return i.createControlByURI({id:this._getParentAugmentedId(t,e),tooltip:o,src:i.getIconURI(e),visible:!1})},_getButton:function(t,e,i,o){return new l({id:this._getParentAugmentedId(t,i),tooltip:o,icon:e,type:y.Transparent})},_getParentAugmentedId:function(t,e){return t.getId()+\"-\"+e}},m.prototype._lazyLoadInternalAggregation=function(t,e){return this.getAggregation(t)||this.setAggregation(t,m._internalAggregationFactory[t](this),e),this.getAggregation(t)},m.prototype._applyActionProperty=function(t,e){var i=e[0];return this.getProperty(t)!==i&&(e.unshift(t),this.setProperty.apply(this,e),this._bFirstRendering||this._notifyParentOfChanges()),this},m.prototype._applyObjectImageProperty=function(t,e){var i=e[0];return this.getProperty(t)!==i&&(e.unshift(t),this.setProperty.apply(this,e),this._destroyObjectImage(),this._bFirstRendering||this._notifyParentOfChanges(!0)),this},m.prototype.setHeaderDesign=function(t){return this.setProperty(\"headerDesign\",t),this.getParent()&&this.getParent().invalidate(),this},m.prototype.setObjectTitle=function(t){var e=this.getProperty(\"objectTitle\"),i=e!==t;return this._applyActionProperty(\"objectTitle\",Array.prototype.slice.call(arguments)),i&&this.mEventRegistry._titleChange&&this.fireEvent(\"_titleChange\",{id:this.getId(),name:\"objectTitle\",oldValue:e,newValue:t}),this};var A=[\"objectSubtitle\",\"showTitleSelector\",\"markLocked\",\"markFavorite\",\"markFlagged\",\"showMarkers\",\"showPlaceholder\",\"markChanges\"],P=[\"objectImageURI\",\"objectImageAlt\",\"objectImageDensityAware\",\"objectImageShape\"],B=function(t){var e=\"set\"+t.charAt(0).toUpperCase()+t.slice(1);m.prototype[e]=function(){var e=Array.prototype.slice.call(arguments);this._applyActionProperty.call(this,t,e)}},O=function(t){var e=\"set\"+t.charAt(0).toUpperCase()+t.slice(1);m.prototype[e]=function(){var e=Array.prototype.slice.call(arguments);this._applyObjectImageProperty.call(this,t,e)}},v=function(t,e,i){e[\"set\"+t.charAt(0).toUpperCase()+t.slice(1)]=function(){var e=Array.prototype.slice.call(arguments);return e.unshift(t),i.setProperty.apply(i,e),this.setProperty.apply(this,e)}};return A.forEach(B),P.forEach(O),m.prototype._destroyObjectImage=function(){var t=this.getAggregation(\"_objectImage\");t&&(t.destroy(),this.setAggregation(\"_objectImage\",null))},m.prototype.onBeforeRendering=function(){var t=this.getSideContentButton();t&&!t.getTooltip()&&t.setTooltip(this.oLibraryResourceBundleOP.getText(\"TOOLTIP_OP_SHOW_SIDE_CONTENT\"));var e=this.getActions()||[];this._oOverflowActionSheet.removeAllButtons(),this._oActionSheetButtonMap={},(e.length>1||this._hasOneButtonShowText(e))&&e.forEach(function(t){if(t instanceof l&&!(t instanceof r)&&(t._bInternalVisible=t.getVisible(),t._getInternalVisible=function(){return this._bInternalVisible},t._setInternalVisible=function(t,e){this.$().toggle(t),t!=this._bInternalVisible&&(this._bInternalVisible=t,e&&this.invalidate())},t.setVisible=function(e){t._setInternalVisible(e,!0),l.prototype.setVisible.call(this,e)},t.onAfterRendering=function(){this._getInternalVisible()||this.$().hide()}),t instanceof l&&(\"Default\"===t.getType()||\"Unstyled\"===t.getType())&&t.setProperty(\"type\",y.Transparent,!1),t instanceof l&&t.getVisible()){var e=this._createActionSheetButton(t);this._oActionSheetButtonMap[t.getId()]=e,this._oOverflowActionSheet.addButton(e),v(\"text\",t,e),v(\"icon\",t,e),v(\"enabled\",t,e)}},this),this._oTitleArrowIcon.setVisible(this.getShowTitleSelector()),this._oFavIcon.setVisible(this.getMarkFavorite()),this._oFlagIcon.setVisible(this.getMarkFlagged()),this._attachDetachActionButtonsHandler(!1),this._bFirstRendering=!1},m.prototype._createActionSheetButton=function(e){return new l({press:t.proxy(this._onSeeMoreContentSelect,this),enabled:e.getEnabled(),text:e.getText(),icon:e.getIcon(),tooltip:e.getTooltip(),customData:new o({key:\"originalId\",value:e.getId()})})},m.prototype._handleImageNotFoundError=function(){var t=this._lazyLoadInternalAggregation(\"_objectImage\"),e=this.getParent(),i=e?e.$():this.$();this.getShowPlaceholder()?(i.find(\".sapMImg.sapUxAPObjectPageHeaderObjectImage\").hide(),i.find(\".sapUxAPObjectPageHeaderPlaceholder\").removeClass(\"sapUxAPHidePlaceholder\")):t.addStyleClass(\"sapMNoImg\")},m.prototype._clearImageNotFoundHandler=function(){this._lazyLoadInternalAggregation(\"_objectImage\").$().off(\"error\")},m.prototype.onAfterRendering=function(){var t=this._lazyLoadInternalAggregation(\"_objectImage\").$();this._adaptLayout(),this._clearImageNotFoundHandler(),t.error(this._handleImageNotFoundError.bind(this)),this.getObjectImageURI()||this._handleImageNotFoundError(),this._iResizeId||(this._iResizeId=s.register(this,this._onHeaderResize.bind(this))),this._attachDetachActionButtonsHandler(!0)},m.prototype._onHeaderResize=function(){this._adaptLayout(),this.getParent()&&\"function\"==typeof this.getParent()._adjustHeaderHeights&&this.getParent()._adjustHeaderHeights()},m.prototype._attachDetachActionButtonsHandler=function(t){var e=this.getActions()||[];e.length<1||e.forEach(function(e){if(e instanceof l){var i=this._oActionSheetButtonMap[e.getId()];t?(e.attachEvent(\"_change\",this._adaptLayout,this),i&&i.attachEvent(\"_change\",this._adaptOverflow,this)):(e.detachEvent(\"_change\",this._adaptLayout,this),i&&i.detachEvent(\"_change\",this._adaptOverflow,this))}},this)},m.prototype._onSeeMoreContentSelect=function(t){var e=t.getSource(),i=sap.ui.getCore().byId(e.data(\"originalId\"));i.firePress&&i.firePress({overflowButtonId:this._oOverflowButton.getId()}),this._oOverflowActionSheet.close()},m._actionImportanceMap={Low:3,Medium:2,High:1},m._sortActionsByImportance=function(t,e){var i=t instanceof r?t.getImportance():_.High,o=e instanceof r?e.getImportance():_.High,n=m._actionImportanceMap[i]-m._actionImportanceMap[o];return 0===n?t.position-e.position:n},m.prototype._hasOneButtonShowText=function(t){var e=!1;return 1!==t.length?e:(t[0]instanceof r?e=!t[0].getHideText()&&\"\"!=t[0].getText():t[0]instanceof l&&(e=\"\"!=t[0].getText()),e)},m.prototype._adaptLayout=function(t){this._adaptLayoutForDomElement(null,t)},m.prototype._adaptLayoutForDomElement=function(t,e){var i=this._findById(t,\"identifierLine\"),o=i.width(),a=this._getActionsWidth(),s=a/o,l=this._iAvailablePercentageForActions*o,c=this._oOverflowButton.$(),u=this._findById(t,\"actions\"),p=u.find(\".sapMBtn\").not(\".sapUxAPObjectPageHeaderExpandButton\");s>this._iAvailablePercentageForActions?this._adaptActions(l):e&&e.getSource()instanceof r&&e.getSource()._setInternalVisible(!0),n.system.phone&&p.css(\"visibility\",\"visible\"),p.filter(\":visible\").length===p.length&&c.hide(),this._adaptObjectPageHeaderIndentifierLine(t)},m.prototype._adaptLayoutDelayed=function(){this._adaptLayoutTimeout&&t.sap.clearDelayedCall(this._adaptLayoutTimeout),this._adaptLayoutTimeout=t.sap.delayedCall(0,this,function(){this._adaptLayoutTimeout=null,this._adaptLayout()})},m.prototype._adaptObjectPageHeaderIndentifierLine=function(t){var e,i,o=this._findById(t,\"identifierLine\"),n=o.width(),a=this._findById(t,\"subtitle\"),r=this._findById(t,\"innerTitle\"),s=this._findById(t,\"identifierLineContainer\"),l=this._findById(t,\"actions\"),c=t?t.find(\".sapUxAPObjectPageHeaderObjectImageContainer\"):this.$().find(\".sapUxAPObjectPageHeaderObjectImageContainer\"),u=l.width()+c.width(),p=this.$().parents().hasClass(\"sapUiSizeCompact\")?7:3;a.length&&(a.hasClass(\"sapOPHSubtitleBlock\")&&a.removeClass(\"sapOPHSubtitleBlock\"),e=a.outerHeight()+a.position().top,i=r.outerHeight()+r.position().top,Math.abs(e-i)>p&&a.addClass(\"sapOPHSubtitleBlock\")),s.width(100*(.95-u/n)+\"%\")},m.prototype._adaptActions=function(t){for(var e,i=h.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())||n.system.phone,o=this._oOverflowButton.$().show().width(),a=this.getActions(),r=a.length,s=0;s<r;s++)a[s].position=s;a.sort(m._sortActionsByImportance),a.forEach(function(n){(e=this._oActionSheetButtonMap[n.getId()])&&(o+=n.$().width(),t>o&&!i?this._setActionButtonVisibility(n,!0):this._setActionButtonVisibility(n,!1))},this)},m.prototype._adaptOverflow=function(){var t=this._oOverflowActionSheet.getButtons(),e=t.some(function(t){return t.getVisible()});this._oOverflowButton.$().toggle(e)},m.prototype._setActionButtonVisibility=function(t,e){var i=this._oActionSheetButtonMap[t.getId()];i&&(t.getVisible()?(t._setInternalVisible(e),i.setVisible(!e)):i.setVisible(!1))},m.prototype._getActionsWidth=function(){var t=0;return this.getActions().forEach(function(e){e instanceof l&&(e.$().show(),n.system.phone&&e.$().css(\"visibility\",\"hidden\"),t+=e.$().outerWidth(!0))}),t},m.prototype._findById=function(e,i){return i?e?(i=this.getId()+\"-\"+i,t.sap.byId(i,e)):this.$(i):null},m.prototype._getBreadcrumbsAggregation=function(){var t=this.getBreadcrumbs(),e=this._lazyLoadInternalAggregation(\"_breadCrumbs\",!0);return t||(e&&e.getLinks().length?e:null)},m.prototype._notifyParentOfChanges=function(t){var e=this.getParent();e&&\"function\"==typeof e._headerTitleChangeHandler&&e._headerTitleChangeHandler(t)},m.prototype.exit=function(){this._clearImageNotFoundHandler(),this._iResizeId&&s.deregister(this._iResizeId)},m.prototype.setNavigationBar=function(t){return this.setAggregation(\"navigationBar\",t),t&&this.mEventRegistry._adaptableContentChange&&this.fireEvent(\"_adaptableContentChange\",{parent:this,adaptableContent:t}),this},m.prototype._getAdaptableContent=function(){return this.getNavigationBar()},m.prototype.isDynamic=function(){return!1},m.prototype.getCompatibleHeaderContentClass=function(){return p},m.prototype.supportsTitleInHeaderContent=function(){return!0},m.prototype.supportsAdaptLayoutForDomElement=function(){return!0},m.prototype.getTitleText=function(){return this.getObjectTitle()},m.prototype.snap=function(){this._adaptLayout()},m.prototype.unSnap=function(){this._adaptLayout()},m.prototype._toggleExpandButton=function(t){},m.prototype._setShowExpandButton=function(t){},m.prototype._focusExpandButton=function(){},m.prototype._toggleFocusableState=function(t){},m});",
	"sap/uxap/ObjectPageHeaderActionButton.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/m/Button\",\"./library\",\"./ObjectPageHeaderActionButtonRenderer\"],function(t,e,o){\"use strict\";var n=t.extend(\"sap.uxap.ObjectPageHeaderActionButton\",{metadata:{interfaces:[\"sap.m.IOverflowToolbarContent\"],library:\"sap.uxap\",properties:{hideText:{type:\"boolean\",defaultValue:!0},hideIcon:{type:\"boolean\",defaultValue:!1},importance:{type:\"sap.uxap.Importance\",group:\"Behavior\",defaultValue:e.Importance.High}}}});return n.prototype.init=function(){this._bInternalVisible=this.getVisible()},n.prototype.onAfterRendering=function(){this._getInternalVisible()||this.$().hide()},n.prototype.applySettings=function(e,o){t.prototype.applySettings&&t.prototype.applySettings.call(this,e,o),this.toggleStyleClass(\"sapUxAPObjectPageHeaderActionButtonHideText\",this.getHideText()),this.toggleStyleClass(\"sapUxAPObjectPageHeaderActionButtonHideIcon\",this.getHideIcon())},n.prototype.setHideText=function(t,e){return this.toggleStyleClass(\"sapUxAPObjectPageHeaderActionButtonHideText\",t),this.setProperty(\"hideText\",t,e)},n.prototype.setHideIcon=function(t,e){return this.toggleStyleClass(\"sapUxAPObjectPageHeaderActionButtonHideIcon\",t),this.setProperty(\"hideIcon\",t,e)},n.prototype._setInternalVisible=function(t,e){this.$().toggle(t),t!=this._bInternalVisible&&(this._bInternalVisible=t,e&&this.invalidate())},n.prototype.setVisible=function(e){var o=t.prototype.setVisible.apply(this,arguments);return this.getParent()&&\"function\"==typeof this.getParent()._adaptLayoutDelayed&&this.getParent()._adaptLayoutDelayed(),o},n.prototype._getInternalVisible=function(){return this._bInternalVisible},n.prototype.getOverflowToolbarConfig=function(){var t={canOverflow:!0,propsUnrelatedToSize:[\"importance\"],getCustomImportance:function(){return this.getImportance()}.bind(this)};return t.onBeforeEnterOverflow=function(t){t.toggleStyleClass(\"sapUxAPObjectPageHeaderActionButtonHideText\",!1,!0),t.toggleStyleClass(\"sapUxAPObjectPageHeaderActionButtonHideIcon\",!1,!0)},t.onAfterExitOverflow=function(t){t.toggleStyleClass(\"sapUxAPObjectPageHeaderActionButtonHideText\",t.getHideText(),!0),t.toggleStyleClass(\"sapUxAPObjectPageHeaderActionButtonHideIcon\",t.getHideIcon(),!0)},t},n});",
	"sap/uxap/ObjectPageHeaderActionButtonRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/m/ButtonRenderer\",\"sap/ui/core/Renderer\"],function(e,n){\"use strict\";return n.extend(e)},!0);",
	"sap/uxap/ObjectPageHeaderContent.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/Control\",\"./library\",\"sap/m/Button\",\"./ObjectImageHelper\",\"./ObjectPageHeaderContentRenderer\"],function(t,e,a,n,o){\"use strict\";var r=e.ObjectPageHeaderDesign,i=t.extend(\"sap.uxap.ObjectPageHeaderContent\",{metadata:{library:\"sap.uxap\",interfaces:[\"sap.uxap.IHeaderContent\"],properties:{contentDesign:{type:\"sap.uxap.ObjectPageHeaderDesign\",group:\"Misc\",defaultValue:r.Light}},aggregations:{content:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"content\"},_editHeaderButton:{type:\"sap.m.Button\",multiple:!1,visibility:\"hidden\"},_objectImage:{type:\"sap.ui.core.Control\",multiple:!1,visibility:\"hidden\"},_placeholder:{type:\"sap.ui.core.Icon\",multiple:!1,visibility:\"hidden\"}}}});return i.prototype.onBeforeRendering=function(){var t=this.getParent(),a=this.getAggregation(\"_editHeaderButton\");a||t&&t instanceof e.ObjectPageLayout&&t.getShowEditHeaderButton()&&(a=this._getInternalBtnAggregation(\"_editHeaderButton\",\"EDIT_HEADER\",\"-editHeaderBtn\",\"Transparent\"),a.attachPress(this._handleEditHeaderButtonPress,this))},i.prototype.exit=function(){var t=this.getAggregation(\"_editHeaderButton\");t&&t.detachPress(this._handleEditHeaderButtonPress,this)},i.prototype._handleEditHeaderButtonPress=function(t){this.getParent().fireEditHeaderButtonPress()},i.prototype._getInternalBtnAggregation=function(t,n,o,r){if(!this.getAggregation(t)){var i=new a({text:e.i18nModel.getResourceBundle().getText(n),type:r,id:this.getId()+o});this.setAggregation(t,i)}return this.getAggregation(t)},i.prototype._getObjectImage=function(){if(!this.getAggregation(\"_objectImage\")){var t=this.getParent(),e=t&&t.getHeaderTitle&&t.getHeaderTitle(),a=e&&n.createObjectImage(e);a&&this.setAggregation(\"_objectImage\",a,!0)}return this.getAggregation(\"_objectImage\")},i.prototype._destroyObjectImage=function(t){var e=this.getAggregation(\"_objectImage\");e&&(e.destroy(),this.getAggregation(\"_objectImage\",null,t))},i.prototype._getPlaceholder=function(){if(!this.getAggregation(\"_placeholder\")){var t=this.getParent(),e=t&&t.getHeaderTitle&&t.getHeaderTitle(),a=e.getShowPlaceholder(),o=a&&n.createPlaceholder();o&&this.setAggregation(\"_placeholder\",o,!0)}return this.getAggregation(\"_placeholder\")},i.prototype._getLayoutDataForControl=function(t){var a=t.getLayoutData();if(a){if(a instanceof e.ObjectPageHeaderLayoutData)return a;if(\"sap.ui.core.VariantLayoutData\"==a.getMetadata().getName())for(var n=a.getMultipleLayoutData(),o=0;o<n.length;o++){var r=n[o];if(r instanceof e.ObjectPageHeaderLayoutData)return r}}},i.createInstance=function(t,e,a){return new i({content:t,visible:e,contentDesign:a})},i.prototype.supportsPinUnpin=function(){return!1},i.prototype.supportsChildPageDesign=function(){return!0},i.prototype.supportsAlwaysExpanded=function(){return!0},i.prototype._toggleCollapseButton=function(t){},i.prototype._setShowCollapseButton=function(t){},i.prototype._focusCollapseButton=function(){},i.prototype._focusPinButton=function(){},i});",
	"sap/uxap/ObjectPageHeaderContentRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"./ObjectPageHeaderRenderer\",\"./ObjectImageHelper\"],function(e,t){\"use strict\";function a(e,t){var a=sap.ui.require(t);return\"function\"==typeof a&&e instanceof a}var r={};return r.render=function(e,t){var r=t.getParent(),n=a(r,\"sap/uxap/ObjectPageLayout\"),s=r&&n?r.getHeaderTitle():void 0,d=!(!r||!n)&&(a(r,\"sap/uxap/ObjectPageLayout\")&&r.getShowTitleInHeaderContent()),i=n&&r.getShowEditHeaderButton()&&t.getContent()&&t.getContent().length>0;i&&(e.write(\"<div \"),e.writeControlData(t),e.addClass(\"sapUxAPObjectPageHeaderContentFlexBox\"),e.addClass(\"sapUxAPObjectPageHeaderContentDesign-\"+t.getContentDesign()),s&&e.addClass(\"sapUxAPObjectPageContentObjectImage-\"+s.getObjectImageShape()),e.writeClasses(),e.write(\">\")),e.write(\"<div \"),i?e.addClass(\"sapUxAPObjectPageHeaderContentCellLeft\"):(e.writeControlData(t),e.addClass(\"sapUxAPObjectPageHeaderContentDesign-\"+t.getContentDesign()),s&&e.addClass(\"sapUxAPObjectPageContentObjectImage-\"+s.getObjectImageShape())),e.addClass(\"ui-helper-clearfix\"),e.addClass(\"sapUxAPObjectPageHeaderContent\"),t.getVisible()||e.addClass(\"sapUxAPObjectPageHeaderContentHidden\"),e.writeClasses(),e.write(\">\"),n&&r.getIsChildPage()&&(e.write(\"<div\"),e.addClass(\"sapUxAPObjectChildPage\"),e.writeClasses(),e.write(\"></div>\")),d&&(this._renderTitleImage(e,t,s),0==t.getContent().length&&(e.write('<span class=\"sapUxAPObjectPageHeaderContentItem\">'),this._renderTitle(e,s),e.write(\"</span>\"))),t.getContent().forEach(function(a,r){this._renderHeaderContentItem(a,r,e,d,s,t)},this),e.write(\"</div>\"),i&&(this._renderEditButton(e,t),e.write(\"</div>\"))},r._renderHeaderContentItem=function(e,t,a,r,n,s){var d=!1,i=!1,o=s._getLayoutDataForControl(e),g=0===t;o?(d=o.getShowSeparatorBefore(),i=o.getShowSeparatorAfter(),a.write(\"<span \"),a.addClass(\"sapUxAPObjectPageHeaderWidthContainer\"),a.addClass(\"sapUxAPObjectPageHeaderContentItem\"),a.addStyle(\"width\",o.getWidth()),a.writeStyles(),(i||d)&&a.addClass(\"sapUxAPObjectPageHeaderSeparatorContainer\"),o.getVisibleL()||a.addClass(\"sapUxAPObjectPageHeaderLayoutHiddenL\"),o.getVisibleM()||a.addClass(\"sapUxAPObjectPageHeaderLayoutHiddenM\"),o.getVisibleS()||a.addClass(\"sapUxAPObjectPageHeaderLayoutHiddenS\"),a.writeClasses(),a.write(\">\"),d&&a.write('<span class=\"sapUxAPObjectPageHeaderSeparatorBefore\"></span>'),g&&r&&this._renderTitle(a,n)):g&&r?(a.write('<span class=\"sapUxAPObjectPageHeaderContentItem\">'),this._renderTitle(a,n)):e.addStyleClass(\"sapUxAPObjectPageHeaderContentItem\"),a.renderControl(e),i&&a.write('<span class=\"sapUxAPObjectPageHeaderSeparatorAfter\"></span>'),(o||g&&r)&&a.write(\"</span>\")},r._renderTitleImage=function(e,a,r){t._renderImageAndPlaceholder(e,{oHeader:r,oObjectImage:a._getObjectImage(),oPlaceholder:a._getPlaceholder(),bIsObjectIconAlwaysVisible:!1,bAddSubContainer:!1,sBaseClass:\"sapUxAPObjectPageHeaderContentImageContainer\"})},r._renderTitle=function(t,a){e._renderObjectPageTitle(t,a,!0)},r._renderEditButton=function(e,t){e.write('<div class=\"sapUxAPObjectPageHeaderContentCellRight\">'),e.renderControl(t.getAggregation(\"_editHeaderButton\")),e.write(\"</div>\")},r},!0);",
	"sap/uxap/ObjectPageHeaderLayoutData.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/LayoutData\",\"./library\"],function(e,a){\"use strict\";/*!\n\t * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n\t */\nreturn e.extend(\"sap.uxap.ObjectPageHeaderLayoutData\",{metadata:{library:\"sap.uxap\",properties:{visibleS:{type:\"boolean\",group:\"Misc\",defaultValue:!0},visibleM:{type:\"boolean\",group:\"Misc\",defaultValue:!0},visibleL:{type:\"boolean\",group:\"Misc\",defaultValue:!0},showSeparatorBefore:{type:\"boolean\",group:\"Misc\",defaultValue:!1},showSeparatorAfter:{type:\"boolean\",group:\"Misc\",defaultValue:!1},width:{type:\"sap.ui.core.CSSSize\",group:\"Misc\",defaultValue:\"auto\"}}}})});",
	"sap/uxap/ObjectPageHeaderRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"./ObjectImageHelper\",\"sap/ui/Device\"],function(e,t){\"use strict\";function a(e,t){var a=sap.ui.require(t);return\"function\"==typeof a&&e instanceof a}var r={};return r.render=function(r,s){var i,n=s.getNavigationBar(),d=s.getIsObjectIconAlwaysVisible()||s.getIsObjectTitleAlwaysVisible()||s.getIsObjectSubtitleAlwaysVisible()||s.getIsActionAreaAlwaysVisible(),o=s.getParent(),l=s.getAggregation(\"_expandButton\"),g=s._lazyLoadInternalAggregation(\"_objectImage\",!0),c=t.system.desktop,w=o&&a(o,\"sap/uxap/ObjectPageLayout\")&&(o.getHeaderContent()&&o.getHeaderContent().length>0&&o.getShowHeaderContent()||o.getShowHeaderContent()&&o.getShowTitleInHeaderContent());r.write(\"<div\"),r.writeControlData(s),r.addClass(\"sapUxAPObjectPageHeader\"),r.addClass(\"sapUxAPObjectPageHeaderDesign-\"+s.getHeaderDesign()),r.writeClasses(),r.write(\">\"),n&&(r.write(\"<div\"),r.addClass(\"sapUxAPObjectPageHeaderNavigation\"),r.writeClasses(),r.write(\">\"),r.renderControl(n),r.write(\"</div>\")),r.write(\"<div\"),r.writeAttributeEscaped(\"id\",s.getId()+\"-identifierLine\"),r.addClass(\"sapUxAPObjectPageHeaderIdentifier\"),d&&r.addClass(\"sapUxAPObjectPageHeaderIdentifierForce\"),r.writeClasses(),r.write(\">\"),o&&a(o,\"sap/uxap/ObjectPageLayout\")&&o.getIsChildPage()&&(r.write(\"<div\"),r.addClass(\"sapUxAPObjectChildPage\"),r.writeClasses(),r.write(\"></div>\")),s.getShowPlaceholder()&&(i=s._lazyLoadInternalAggregation(\"_placeholder\",!0)),e._renderImageAndPlaceholder(r,{oHeader:s,oObjectImage:g,oPlaceholder:i,bIsObjectIconAlwaysVisible:s.getIsObjectIconAlwaysVisible(),bAddSubContainer:!0,sBaseClass:\"sapUxAPObjectPageHeaderObjectImageContainer\"}),r.write(\"<span \"),r.writeAttributeEscaped(\"id\",s.getId()+\"-identifierLineContainer\"),r.addClass(\"sapUxAPObjectPageHeaderIdentifierContainer\"),r.writeClasses(),r.write(\">\"),this._renderObjectPageTitle(r,s),r.write(\"</span>\"),r.write(\"<span\"),r.writeAttributeEscaped(\"id\",s.getId()+\"-actions\"),r.addClass(\"sapUxAPObjectPageHeaderIdentifierActions\"),s.getIsActionAreaAlwaysVisible()&&r.addClass(\"sapUxAPObjectPageHeaderIdentifierActionsForce\"),r.writeClasses(),r.write(\">\"),c&&w&&(l.addStyleClass(\"sapUxAPObjectPageHeaderExpandButton\"),r.renderControl(l));for(var C=s.getActions(),p=0;p<C.length;p++){var b=C[p];r.renderControl(b)}var A=s.getAggregation(\"_overflowButton\");r.renderControl(A),this._renderSideContentBtn(r,s),r.write(\"</span>\"),r.write(\"</div>\"),r.write(\"</div>\")},r._renderObjectPageTitle=function(e,t,a){var r=t.getObjectTitle(),s=t.getShowMarkers()&&(t.getMarkFavorite()||t.getMarkFlagged()),i=t._getBreadcrumbsAggregation();if(!a&&i&&e.renderControl(i),e.write(\"<h1\"),e.addClass(\"sapUxAPObjectPageHeaderIdentifierTitle\"),t.getIsObjectTitleAlwaysVisible()&&e.addClass(\"sapUxAPObjectPageHeaderIdentifierTitleForce\"),a&&e.addClass(\"sapUxAPObjectPageHeaderIdentifierTitleInContent\"),t.getShowTitleSelector()&&e.addClass(\"sapUxAPObjectPageHeaderTitleFollowArrow\"),e.writeClasses(),e.writeAttributeEscaped(\"id\",t.getId()+\"-title\"),e.write(\">\"),e.write(\"<span\"),e.addClass(\"sapUxAPObjectPageHeaderTitleTextWrappable\"),e.writeClasses(),e.writeAttributeEscaped(\"id\",t.getId()+\"-innerTitle\"),e.write(\">\"),s||t.getShowTitleSelector()||t.getMarkLocked()||t.getMarkChanges()){var n=r.substr(r.lastIndexOf(\" \")+1),d=r.substr(0,r.lastIndexOf(\" \")+1);1===n.length&&(n=r,d=\"\"),e.writeEscaped(d),e.write(\"</span>\"),e.write(\"<span\"),e.addClass(\"sapUxAPObjectPageHeaderNowrapMarkers\"),(t.getMarkLocked()||t.getMarkChanges())&&e.addClass(\"sapUxAPObjectPageHeaderMarks\"),e.writeClasses(),e.write(\">\"),e.writeEscaped(n),this._renderMarkers(e,t),t.getMarkLocked()?this._renderLock(e,t,a):t.getMarkChanges()&&this._renderMarkChanges(e,t,a),this._renderSelectTitleArrow(e,t,a),e.write(\"</span>\")}else e.writeEscaped(r),e.write(\"</span>\");e.write(\"</h1>\"),e.write(\"<span\"),e.addClass(\"sapUxAPObjectPageHeaderIdentifierDescription\"),t.getIsObjectSubtitleAlwaysVisible()&&t.getObjectSubtitle()&&e.addClass(\"sapUxAPObjectPageHeaderIdentifierDescriptionForce\"),a&&e.addClass(\"sapUxAPObjectPageHeaderIdentifierSubTitleInContent\"),e.writeClasses(),e.writeAttributeEscaped(\"id\",t.getId()+\"-subtitle\"),e.write(\">\"),e.writeEscaped(t.getObjectSubtitle()),e.write(\"</span>\")},r._renderSelectTitleArrow=function(e,t,a){t.getShowTitleSelector()&&(e.write(\"<span\"),e.addClass(\"sapUxAPObjectPageHeaderTitleArrow\"),e.writeClasses(),e.write(\">\"),a?e.renderControl(t._oTitleArrowIconCont):e.renderControl(t._oTitleArrowIcon),e.write(\"</span>\"))},r._renderSideContentBtn=function(e,t){var a=t.getSideContentButton();a&&(e.write(\"<span\"),e.addClass(\"sapUxAPObjectPageHeaderSideContentBtn\"),e.writeClasses(),e.write(\">\"),e.write(\"<span\"),e.addClass(\"sapUxAPObjectPageHeaderSeparator\"),e.writeClasses(),e.write(\"></span>\"),e.renderControl(a),e.write(\"</span>\"))},r._renderMarkChanges=function(e,t,a){e.write(\"<span\"),e.addClass(\"sapUxAPObjectPageHeaderChangesBtn\"),e.addClass(\"sapUiSizeCompact\"),e.writeClasses(),e.write(\">\"),a?e.renderControl(t._oChangesIconCont):e.renderControl(t._oChangesIcon),e.write(\"</span>\")},r._renderLock=function(e,t,a){e.write(\"<span\"),e.addClass(\"sapUxAPObjectPageHeaderLockBtn\"),e.addClass(\"sapUiSizeCompact\"),e.writeClasses(),e.write(\">\"),a?e.renderControl(t._oLockIconCont):e.renderControl(t._oLockIcon),e.write(\"</span>\")},r._renderMarkers=function(e,t){var a=[];if(t.getShowMarkers()){a.push(t._oFavIcon),a.push(t._oFlagIcon),this._renderMarkersAria(e,t),e.write(\"<span\"),e.addClass(\"sapMObjStatusMarker\"),e.writeClasses(),e.writeAttributeEscaped(\"id\",t.getId()+\"-markers\"),e.writeAttributeEscaped(\"aria-describedby\",t.getId()+\"-markers-aria\"),e.write(\">\");for(var r=0;r<a.length;r++)e.renderControl(a[r]);e.write(\"</span>\")}},r._renderMarkersAria=function(e,t){var a=\"\";t.getMarkFlagged()&&(a+=t.oLibraryResourceBundle.getText(\"ARIA_FLAG_MARK_VALUE\")+\" \"),t.getMarkFavorite()&&(a+=t.oLibraryResourceBundle.getText(\"ARIA_FAVORITE_MARK_VALUE\")+\" \"),\"\"!==a&&(e.write(\"<div\"),e.writeAttributeEscaped(\"id\",t.getId()+\"-markers-aria\"),e.writeAttribute(\"aria-hidden\",\"false\"),e.addClass(\"sapUiHidden\"),e.writeClasses(),e.write(\">\"),e.writeEscaped(a),e.write(\"</div>\"))},r},!0);",
	"sap/uxap/ObjectPageLayout.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/ResizeHandler\",\"sap/ui/core/Control\",\"sap/ui/Device\",\"sap/ui/core/delegate/ScrollEnablement\",\"./ObjectPageSectionBase\",\"./ObjectPageSection\",\"./ObjectPageSubSection\",\"./ObjectPageHeaderContent\",\"./LazyLoading\",\"./ObjectPageLayoutABHelper\",\"./ThrottledTaskHelper\",\"sap/ui/core/ScrollBar\",\"sap/ui/core/library\",\"./library\",\"./ObjectPageLayoutRenderer\",\"jquery.sap.keycodes\"],function(e,t,i,o,n,r,s,a,h,l,c,d,g,p,u,_){\"use strict\";function S(e){return 1===arguments.length?Array.isArray(e)?e.length>0:!!e:Array.prototype.slice.call(arguments).every(function(e){return S(e)})}var y=p.TitleLevel,H=u.ObjectPageSubSectionLayout,b=i.extend(\"sap.uxap.ObjectPageLayout\",{metadata:{library:\"sap.uxap\",properties:{showAnchorBar:{type:\"boolean\",defaultValue:!0},showAnchorBarPopover:{type:\"boolean\",defaultValue:!0},upperCaseAnchorBar:{type:\"boolean\",defaultValue:!0},height:{type:\"sap.ui.core.CSSSize\",defaultValue:\"100%\"},enableLazyLoading:{type:\"boolean\",defaultValue:!1},subSectionLayout:{type:\"sap.uxap.ObjectPageSubSectionLayout\",defaultValue:H.TitleOnTop},sectionTitleLevel:{type:\"sap.ui.core.TitleLevel\",group:\"Appearance\",defaultValue:y.Auto},useIconTabBar:{type:\"boolean\",group:\"Misc\",defaultValue:!1},showHeaderContent:{type:\"boolean\",group:\"Misc\",defaultValue:!0},useTwoColumnsForLargeScreen:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},showTitleInHeaderContent:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},showOnlyHighImportance:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},isChildPage:{type:\"boolean\",group:\"Appearance\",defaultValue:!1},alwaysShowContentHeader:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},headerContentPinnable:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},toggleHeaderOnTitleClick:{type:\"boolean\",group:\"Behavior\",defaultValue:!0},preserveHeaderStateOnScroll:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},showEditHeaderButton:{type:\"boolean\",group:\"Behavior\",defaultValue:!1},flexEnabled:{type:\"boolean\",group:\"Misc\",defaultValue:!1},showFooter:{type:\"boolean\",group:\"Behavior\",defaultValue:!1}},associations:{selectedSection:{type:\"sap.uxap.ObjectPageSection\",multiple:!1}},defaultAggregation:\"sections\",aggregations:{sections:{type:\"sap.uxap.ObjectPageSection\",multiple:!0,singularName:\"section\"},headerTitle:{type:\"sap.uxap.IHeaderTitle\",multiple:!1},headerContent:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"headerContent\"},footer:{type:\"sap.m.IBar\",multiple:!1},_anchorBar:{type:\"sap.uxap.AnchorBar\",multiple:!1,visibility:\"hidden\"},_iconTabBar:{type:\"sap.m.IconTabBar\",multiple:!1,visibility:\"hidden\"},_headerContent:{type:\"sap.uxap.IHeaderContent\",multiple:!1,visibility:\"hidden\"},_customScrollBar:{type:\"sap.ui.core.ScrollBar\",multiple:!1,visibility:\"hidden\"}},events:{toggleAnchorBar:{parameters:{fixed:{type:\"boolean\"}}},editHeaderButtonPress:{},navigate:{parameters:{section:{type:\"sap.uxap.ObjectPageSection\"},subSection:{type:\"sap.uxap.ObjectPageSubSection\"}}}},designtime:\"sap/uxap/designtime/ObjectPageLayout.designtime\"}});return b.HEADER_CALC_DELAY=350,b.DOM_CALC_DELAY=200,b.FOOTER_ANIMATION_DURATION=350,b.MAX_SNAP_POSITION_OFFSET=20,b.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=.6,b.TITLE_LEVEL_AS_ARRAY=Object.keys(y),b.EVENTS={TITLE_PRESS:\"_titlePress\",TITLE_MOUSE_OVER:\"_titleMouseOver\",TITLE_MOUSE_OUT:\"_titleMouseOut\",PIN_UNPIN_PRESS:\"_pinUnpinPress\",VISUAL_INDICATOR_MOUSE_OVER:\"_visualIndicatorMouseOver\",VISUAL_INDICATOR_MOUSE_OUT:\"_visualIndicatorMouseOut\",HEADER_VISUAL_INDICATOR_PRESS:\"_headerVisualIndicatorPress\",TITLE_VISUAL_INDICATOR_PRESS:\"_titleVisualIndicatorPress\"},b.BREAK_POINTS={TABLET:1024,PHONE:600},b.DYNAMIC_HEADERS_MEDIA={PHONE:\"sapFDynamicPage-Std-Phone\",TABLET:\"sapFDynamicPage-Std-Tablet\",DESKTOP:\"sapFDynamicPage-Std-Desktop\"},b._getNextTitleLevelEntry=function(e){var t=b.TITLE_LEVEL_AS_ARRAY.indexOf(e),i=-1!==t,o=i&&t!==b.TITLE_LEVEL_AS_ARRAY.length-1;return i?b.TITLE_LEVEL_AS_ARRAY[o?t+1:t]:y.Auto},b.prototype.init=function(){this.oCore=sap.ui.getCore(),this._bFirstRendering=!0,this._bDomReady=!1,this._bPinned=!1,this._bStickyAnchorBar=!1,this._bHeaderInTitleArea=!1,this._bHeaderExpanded=!0,this._bHeaderBiggerThanAllowedHeight=!1,this._iStoredScrollPosition=0,this._bInternalAnchorBarVisible=!0,this._$opWrapper=[],this._$anchorBar=[],this._$headerTitle=[],this._$stickyAnchorBar=[],this._$headerContent=[],this._$stickyHeaderContent=[],this._bMobileScenario=!1,this._oSectionInfo={},this._aSectionBases=[],this._sScrolledSectionId=\"\",this._iScrollToSectionDuration=600,this._$spacer=[],this.iHeaderContentHeight=0,this.iStickyHeaderContentHeight=0,this.iHeaderTitleHeight=0,this.iHeaderTitleHeightStickied=0,this.iAnchorBarHeight=0,this.iTotalHeaderSize=0,this._iREMSize=parseInt(e(\"body\").css(\"font-size\"),10),this._iOffset=parseInt(.25*this._iREMSize,10),this._iResizeId=t.register(this,this._onUpdateScreenSize.bind(this)),this._iAfterRenderingDomReadyTimeout=null,this._oABHelper=new c(this)},b.prototype.onBeforeRendering=function(){var t,i;this._oLazyLoading=new l(this),this.getVisible()&&(this._bMobileScenario=u.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange()),this._bTabletScenario=u.Utilities.isTabletScenario(this._getCurrentMediaContainerRange()),this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea(),this._initializeScroller(),this._createHeaderContent(),this._getHeaderContent().setContentDesign(this._getHeaderDesign()),this._oABHelper._getAnchorBar().setProperty(\"upperCase\",this.getUpperCaseAnchorBar(),!0),this._storeScrollLocation(),this._applyUxRules(),this._getCustomScrollBar().setScrollPosition(0),!e.isEmptyObject(this._oSectionInfo)&&this._bFirstRendering&&(this._preloadSectionsOnBeforeFirstRendering(),this._bFirstRendering=!1),this._bStickyAnchorBar=!1,this._handleExpandButtonPressEventLifeCycle(!1),this._attachTitlePressHandler(),t=this._getHeaderContent(),t&&t.supportsPinUnpin()&&(i=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll(),this._getHeaderContent().setPinnable(i),i&&this._attachPinPressHandler()),this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this),this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this),this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this))},b.prototype.setToggleHeaderOnTitleClick=function(e){var t=this.getHeaderTitle(),i=this.setProperty(\"toggleHeaderOnTitleClick\",e,!0);return e=this.getProperty(\"toggleHeaderOnTitleClick\"),this.$().toggleClass(\"sapUxAPObjectPageLayoutTitleClickEnabled\",e),this._updateToggleHeaderVisualIndicators(),S(t)&&t._toggleFocusableState(e),i},b.prototype._attachTitlePressHandler=function(){var e=this.getHeaderTitle();S(e)&&!this._bAlreadyAttachedTitlePressHandler&&(e.attachEvent(b.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this),this._bAlreadyAttachedTitlePressHandler=!0)},b.prototype._toggleHeaderVisibility=function(e){var t=this._getHeaderContent();S(t)&&t.$().toggleClass(\"sapUxAPObjectPageHeaderContentHidden\",!e)},b.prototype._snapHeader=function(t){if(this._bPinned)return void e.sap.log.debug(\"ObjectPage :: aborted snapping, header is pinned\",this);if(this._toggleHeaderTitle(!1,!0),this._moveAnchorBarToTitleArea(),t)return this._moveHeaderToContentArea(),this._bHeaderExpanded=!1,this._updateToggleHeaderVisualIndicators(),this._adjustHeaderHeights(),this._requestAdjustLayout(!0),void(this._$opWrapper.scrollTop()<=this._getSnapPosition()+1&&this._scrollTo(this._getSnapPosition()+1));this._toggleHeaderVisibility(!1),this._bHeaderExpanded=!1,this._updateToggleHeaderVisualIndicators(),this._adjustHeaderHeights(),this._requestAdjustLayout()},b.prototype._expandHeader=function(e){if(this._toggleHeaderTitle(!0,!0),this._toggleHeaderVisibility(!0),e)return this._moveAnchorBarToTitleArea(),this._moveHeaderToTitleArea(),this._bHeaderExpanded=!0,this._updateToggleHeaderVisualIndicators(),this._adjustHeaderHeights(),void this._requestAdjustLayout();this._moveAnchorBarToContentArea(),this._moveHeaderToContentArea(),this._scrollTo(0,0,0),this._bHeaderExpanded=!0,this._updateToggleHeaderVisualIndicators()},b.prototype._handleDynamicTitlePress=function(){if(this.getToggleHeaderOnTitleClick()){var e,t,i,o=!this._bHeaderExpanded;o?(e=this._$opWrapper.scrollTop()<=this._getSnapPosition()+1,t=this._shouldPreserveHeaderInTitleArea()||!e,this._expandHeader(t)):(i=!this._shouldPreserveHeaderInTitleArea(),this._snapHeader(i))}},b.prototype._attachPinPressHandler=function(){var e=this._getHeaderContent();S(e)&&!this._bAlreadyAttachedPinPressHandler&&(e.attachEvent(b.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this),this._bAlreadyAttachedPinPressHandler=!0)},b.prototype._handleExpandButtonPressEventLifeCycle=function(e){var t,i=this.getHeaderTitle();i&&(t=i.getAggregation(\"_expandButton\"))&&t[e?\"attachPress\":\"detachPress\"](this._handleExpandButtonPress,this)},b.prototype._adjustSelectedSectionByUXRules=function(){var e=this.oCore.byId(this.getSelectedSection());if(!e||!this._sectionCanBeRenderedByUXRules(e)){if(!this._oFirstVisibleSection)return void this.setAssociation(\"selectedSection\",null,!0);e=this._oFirstVisibleSection,this.setAssociation(\"selectedSection\",e.getId(),!0)}var t=this.oCore.byId(this._sStoredScrolledSubSectionId);t&&this._sectionCanBeRenderedByUXRules(t)&&e.indexOfSubSection(t)>=0||(this._sStoredScrolledSubSectionId=null)},b.prototype._sectionCanBeRenderedByUXRules=function(e){return!!(e&&e.getVisible()&&e._getInternalVisible())&&this._aSectionBases.map(function(e){return e.getId()}).indexOf(e.getId())>-1},b.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var e=this.oCore.byId(this.getSelectedSection());return this.getUseIconTabBar()&&e?[e]:this.getSections()},b.prototype._preloadSectionsOnBeforeFirstRendering=function(){var e;if(this.getEnableLazyLoading()){var t=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;e=this._oLazyLoading.getSubsectionsToPreload(t)}else e=this._getSectionsToRender();this._connectModelsForSections(e)},b.prototype._grepCurrentTabSectionBases=function(){var e,t=[];if(this._adjustSelectedSectionByUXRules(),e=this.oCore.byId(this.getSelectedSection())){var i=e.getId();this._aSectionBases.forEach(function(e){e.getParent().getId()===i&&t.push(e)})}return t},b.prototype.onAfterRendering=function(){this._ensureCorrectParentHeight(),this._cacheDomElements(),this._$opWrapper.on(\"scroll\",this._onScroll.bind(this)),this._bDomReady&&0===this.$().parents(\":hidden\").length?this._onAfterRenderingDomReady():(this._iAfterRenderingDomReadyTimeout&&clearTimeout(this._iAfterRenderingDomReadyTimeout),this._iAfterRenderingDomReadyTimeout=e.sap.delayedCall(b.HEADER_CALC_DELAY,this,this._onAfterRenderingDomReady)),this._handleExpandButtonPressEventLifeCycle(!0)},b.prototype._onAfterRenderingDomReady=function(){var e,t,i;this._bIsBeingDestroyed||(this._adjustSelectedSectionByUXRules(),e=this.getSelectedSection(),t=this.oCore.byId(e),this._iAfterRenderingDomReadyTimeout=null,this._bDomReady=!0,this._adjustHeaderHeights(),this._initAnchorBarScroll(),e&&(this.getUseIconTabBar()?(this._setSelectedSectionId(e),this._setCurrentTabSection(t)):this.scrollToSection(e,0)),o.system.desktop&&this._$opWrapper.on(\"scroll\",this.onWrapperScroll.bind(this)),this._registerOnContentResize(),this.getHeaderTitle()&&this._shiftHeaderTitle(),this.getFooter()&&this._shiftFooter(),this._setSectionsFocusValues(),this._preserveHeaderStateOnScroll()&&this._overridePreserveHeaderStateOnScroll(),this._bHeaderExpanded||(i=!this._shouldPreserveHeaderInTitleArea(),this._snapHeader(i)),this._restoreScrollPosition(),this.oCore.getEventBus().publish(\"sap.ui\",\"ControlForPersonalizationRendered\",this),this._hasDynamicTitle()&&this._updateMedia(this._getWidth(this)),this._updateToggleHeaderVisualIndicators(),this.fireEvent(\"onAfterRenderingDOMReady\"))},b.prototype._shiftFooter=function(){var e=this.$(\"footerWrapper\"),t=this._calculateShiftOffset();e.css(t.sStyleAttribute,t.iMarginalsOffset+\"px\")},b.prototype._calculateShiftOffset=function(){var t,i=0,n=this.oCore.getConfiguration().getRTL()?\"left\":\"right\",r=this._hasVerticalScrollBar(),s=this._iOffset;return o.system.desktop&&(t=e.sap.scrollbarSize().width,i=t,r||(i=0,s+=t)),{sStyleAttribute:n,iActionsOffset:s,iMarginalsOffset:i}},b.prototype.exit=function(){this._oScroller&&(this._oScroller.destroy(),this._oScroller=null),this._iResizeId&&t.deregister(this._iResizeId),this._iContentResizeId&&t.deregister(this._iContentResizeId),this._iAfterRenderingDomReadyTimeout&&clearTimeout(this._iAfterRenderingDomReadyTimeout),this._oFirstVisibleSection=null,this._oFirstVisibleSubSection=null},b.prototype._getCustomScrollBar=function(){if(!this.getAggregation(\"_customScrollBar\")){var e=new g(this.getId()+\"-vertSB\",{vertical:!0,size:\"100%\",scrollPosition:0,scroll:this.onCustomScrollerScroll.bind(this)});this.setAggregation(\"_customScrollBar\",e,!0)}return this.getAggregation(\"_customScrollBar\")},b.prototype.onWrapperScroll=function(e){var t=Math.max(e.target.scrollTop,0);if(this._getCustomScrollBar()){if(!0===this.allowCustomScroll)return void(this.allowCustomScroll=!1);this.allowInnerDiv=!0,this._getCustomScrollBar().setScrollPosition(t)}},b.prototype.onCustomScrollerScroll=function(t){var i=Math.max(this._getCustomScrollBar().getScrollPosition(),0);if(!0===this.allowInnerDiv)return void(this.allowInnerDiv=!1);this.allowCustomScroll=!0,e(this._$opWrapper).scrollTop(i)},b.prototype.setShowOnlyHighImportance=function(e){return this.getShowOnlyHighImportance()!==e&&(this.setProperty(\"showOnlyHighImportance\",e,!0),this.getSections().forEach(function(e){e._updateImportance()})),this},b.prototype.setIsHeaderContentAlwaysExpanded=function(e){var t=this.getAlwaysShowContentHeader(),i=o.system.phone||o.system.tablet;return t!==e&&this.setProperty(\"alwaysShowContentHeader\",e,i),this},b.prototype._initializeScroller=function(){this._oScroller||(this._oScroller=new n(this,this.getId()+\"-scroll\",{horizontal:!1,vertical:!0}))},b.prototype.setSelectedSection=function(t){var i,o,n;return t instanceof r?i=t.getId():\"string\"==typeof t&&(i=t),i?i===this.getSelectedSection()?this:(this.scrollToSection(i),o=s._getClosestSection(i),n=o instanceof s?o.getId():o,this.setAssociation(\"selectedSection\",n,!0)):void e.sap.log.warning(\"section or sectionID expected\",this)},b.prototype._ensureCorrectParentHeight=function(){this._bCorrectParentHeightIsSet||(this.getParent().getHeight&&-1!==[\"\",\"auto\"].indexOf(this.getParent().getHeight())&&this.$().parent().css(\"height\",\"100%\"),this._bCorrectParentHeightIsSet=!0)},b.prototype._cacheDomElements=function(){this._$headerTitle=e.sap.byId(this.getId()+\"-headerTitle\"),this._$anchorBar=e.sap.byId(this.getId()+\"-anchorBar\"),this._$stickyAnchorBar=e.sap.byId(this.getId()+\"-stickyAnchorBar\"),this._$opWrapper=e.sap.byId(this.getId()+\"-opwrapper\"),this._$spacer=e.sap.byId(this.getId()+\"-spacer\"),this._$headerContent=e.sap.byId(this.getId()+\"-headerContent\"),this._$stickyHeaderContent=e.sap.byId(this.getId()+\"-stickyHeaderContent\"),this._$contentContainer=e.sap.byId(this.getId()+\"-scroll\"),this._$sectionsContainer=e.sap.byId(this.getId()+\"-sectionsContainer\"),this._bDomElementsCached=!0},b.prototype._handleExpandButtonPress=function(e){this._bStickyAnchorBar&&(this._moveHeaderToTitleArea(),this._toggleHeaderTitle(!0))},b.prototype._toggleHeaderTitle=function(e,t){var i=this.getHeaderTitle();this._$headerTitle.toggleClass(\"sapUxAPObjectPageHeaderStickied\",!e),e?i&&i.unSnap(t):i&&i.snap(t)},b.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent),this._bHeaderInTitleArea=!0,this._bSupressModifyOnScrollOnce=!0},b.prototype._moveHeaderToContentArea=function(){this._bHeaderInTitleArea&&(this._$headerContent.append(this._$stickyHeaderContent.children()),this._$stickyHeaderContent.children().remove(),this._bHeaderInTitleArea=!1)},b.prototype._updateNavigation=function(){this.getShowAnchorBar()&&this._oABHelper._buildAnchorBar()},b.prototype._applyUxRules=function(t){var i,o,n,r,s,a,h,l,c;i=this.getSections()||[],r=0,a=this.getShowAnchorBar(),h=this.getUseIconTabBar(),l=null,this._cleanMemory(),i.forEach(function(i){if(!i.getVisible())return!0;this._registerSectionBaseInfo(i),o=i.getSubSections()||[],n=0,c=null,o.forEach(function(i){if(!i.getVisible())return!0;this._registerSectionBaseInfo(i),s=i.getVisibleBlocksCount(),0===s?(i._setInternalVisible(!1,t),e.sap.log.info(\"ObjectPageLayout :: noVisibleBlock UX rule matched\",\"subSection \"+i.getTitle()+\" forced to hidden\")):(i._setInternalVisible(!0,t),i._setInternalTitleVisible(!0,t),n++,c||(c=i),this._shouldApplySectionTitleLevel(i)&&i._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(i)))},this),0==n?(i._setInternalVisible(!1,t),e.sap.log.info(\"ObjectPageLayout :: noVisibleSubSection UX rule matched\",\"section \"+i.getTitle()+\" forced to hidden\")):(i._setInternalVisible(!0,t),i._setInternalTitleVisible(!0,t),l||(l=i),this.getSubSectionLayout()===H.TitleOnTop&&1===n&&\"\"!==c.getTitle().trim()?(e.sap.log.info(\"ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched\",\"section \"+i.getTitle()+\" is taking its single subsection title \"+c.getTitle()),i._setInternalTitle(c.getTitle(),t),c._setInternalTitleVisible(!1,t)):i._setInternalTitle(\"\",t),this._shouldApplySectionTitleLevel(i)&&i._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(i)),r++),h&&i._setInternalTitleVisible(!1,t)},this),r<=1?(a=!1,e.sap.log.info(\"ObjectPageLayout :: notEnoughVisibleSection UX rule matched\",\"anchorBar forced to hidden\")):l&&a&&(l._setInternalTitleVisible(!1,t),e.sap.log.info(\"ObjectPageLayout :: firstSectionTitleHidden UX rule matched\",\"section \"+l.getTitle()+\" title forced to hidden\")),a&&this._oABHelper._buildAnchorBar(),this._setInternalAnchorBarVisible(a,t),this._oFirstVisibleSection=l,this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(l)},b.prototype.setUseIconTabBar=function(e){return e!=this.getUseIconTabBar()&&this._applyUxRules(),this.setProperty(\"useIconTabBar\",e),this},b.prototype._setCurrentTabSection=function(e,t){if(e){var i;e instanceof sap.uxap.ObjectPageSubSection?(i=e,e=e.getParent()):i=this._getFirstVisibleSubSection(e),this._oCurrentTabSection!==e&&(this._renderSection(e),this._oCurrentTabSection=e),this._oCurrentTabSubSection=i}},b.prototype._renderSection=function(e){var t,i=this.$().find(\".sapUxAPObjectPageContainer\");e&&i.length&&(t=this.oCore.createRenderManager(),this.getSections().forEach(function(i){i.getId()===e.getId()?t.renderControl(e):t.cleanupControlWithoutRendering(i)}),t.flush(i[0]),t.destroy())},b.prototype.setShowAnchorBarPopover=function(e,t){var i=this.getProperty(\"showAnchorBarPopover\"),e=this.validateProperty(\"showAnchorBarPopover\",e);if(e!==i)return this._oABHelper._buildAnchorBar(),this._oABHelper._getAnchorBar().setShowPopover(e),this.setProperty(\"showAnchorBarPopover\",e,!0)},b.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible},b.prototype._setInternalAnchorBarVisible=function(e,t){e!=this._bInternalAnchorBarVisible&&(this._bInternalAnchorBarVisible=e,!0===t&&this.invalidate())},b.prototype.setUpperCaseAnchorBar=function(e){return this._oABHelper._getAnchorBar().setProperty(\"upperCase\",e),this.setProperty(\"upperCaseAnchorBar\",e,!0)},b.prototype._requestAdjustLayout=function(t){return this._oLayoutTask||(this._oLayoutTask=new d(this._updateScreenHeightSectionBasesAndSpacer,b.DOM_CALC_DELAY,this)),t||e.sap.log.debug(\"ObjectPageLayout :: _requestAdjustLayout\",\"delayed by \"+b.DOM_CALC_DELAY+\" ms because of dom modifications\"),this._oLayoutTask.reSchedule(t,{}).catch(function(e){})},b.prototype._requestAdjustLayoutAndUxRules=function(t){return this._setSectionInfoIsDirty(!0),this._oUxRulesTask||(this._oUxRulesTask=new d(this._adjustLayoutAndUxRules,b.DOM_CALC_DELAY,this)),t||e.sap.log.debug(\"ObjectPageLayout :: _requestAdjustLayoutAndUxRules\",\"delayed by \"+b.DOM_CALC_DELAY+\" ms because of dom modifications\"),this._oUxRulesTask.reSchedule(t,{}).catch(function(e){})},b.prototype._adjustLayoutAndUxRules=function(){var t,i;e.sap.log.debug(\"ObjectPageLayout :: _requestAdjustLayout\",\"refreshing ux rules\"),this._applyUxRules(!0),this._adjustSelectedSectionByUXRules(),t=this.getSelectedSection(),(i=this.oCore.byId(t))&&(this._setSelectedSectionId(t),this.getUseIconTabBar()&&this._setCurrentTabSection(i),this._requestAdjustLayout(!0).then(function(e){e&&this._oLazyLoading.doLazyLoading(),this._adjustSelectedSectionByUXRules(),t=this.getSelectedSection(),this._isClosestScrolledSection(t)&&!this._oScroller._$Container.is(\":animated\")||this.scrollToSection(t,null,0,!1,!0)}.bind(this)))},b.prototype._isClosestScrolledSection=function(e){var t=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,i=this.iScreenHeight,o=this._getClosestScrolledSectionId(t,i);return o&&e===o},b.prototype._setSelectedSectionId=function(e){var t=this.getAggregation(\"_anchorBar\"),i=e&&this._oSectionInfo[e];i&&t&&i.buttonId&&(t.setSelectedButton(i.buttonId),this.setAssociation(\"selectedSection\",e,!0))},b.prototype.isFirstRendering=function(){return this._bFirstRendering},b.prototype._cleanMemory=function(){var e=this.getAggregation(\"_anchorBar\");e&&e._resetControl(),this._oSectionInfo={},this._aSectionBases=[]},b.prototype._registerSectionBaseInfo=function(e){this._oSectionInfo[e.getId()]={$dom:[],positionTop:0,positionTopMobile:0,buttonId:\"\",isSection:e instanceof s,sectionReference:e},this._aSectionBases.push(e)},b.prototype._triggerVisibleSubSectionsEvents=function(){this.getEnableLazyLoading()&&this._oLazyLoading&&this._oLazyLoading._triggerVisibleSubSectionsEvents()},b.prototype.scrollToSection=function(t,i,o,n,r){var h=this.oCore.byId(t);if(!this.getDomRef())return void e.sap.log.warning(\"scrollToSection can only be used after the ObjectPage is rendered\",this);if(!h)return void e.sap.log.warning(\"scrollToSection aborted: unknown section\",t,this);if(!this._oSectionInfo[t])return void e.sap.log.warning(\"scrollToSection aborted: section is hidden by UX rules\",t,this);if(this.bIsDestroyed)return void e.sap.log.debug(\"ObjectPageLayout :: scrollToSection\",\"scrolling canceled as page is being destroyed\");if(this.getUseIconTabBar()){var l=s._getClosestSection(h);this._oCurrentTabSection&&this._oCurrentTabSection._allowPropagationToLoadedViews(!1),l._allowPropagationToLoadedViews(!0),this._setCurrentTabSection(h),this.getAggregation(\"_anchorBar\").setSelectedButton(this._oSectionInfo[l.getId()].buttonId),this.setAssociation(\"selectedSection\",l.getId(),!0)}n&&this.fireNavigate({section:s._getClosestSection(h),subSection:h instanceof a?h:h.getSubSections()[0]}),this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()&&(this._moveHeaderToContentArea(),this._toggleHeaderTitle(!1),this._bHeaderExpanded=!1,this._updateToggleHeaderVisualIndicators()),o=o||0,h._expandSection(),this._requestAdjustLayout(!0),i=this._computeScrollDuration(i,h);var c=this._computeScrollPosition(h);(this._sCurrentScrollId!=t||r)&&(this._sCurrentScrollId=t,this._iCurrentScrollTimeout&&(clearTimeout(this._iCurrentScrollTimeout),this._$contentContainer&&this._$contentContainer.parent().stop(!0,!1)),this._bDomElementsCached&&(this._iCurrentScrollTimeout=e.sap.delayedCall(i,this,function(){this._sCurrentScrollId=void 0,this._iCurrentScrollTimeout=void 0})),this._preloadSectionsOnScroll(h),this.getHeaderTitle()&&this._shiftHeaderTitle(),this._scrollTo(c+o,i))},b.prototype._computeScrollDuration=function(e,t){var i=parseInt(e,10);return i=i>=0?i:this._iScrollToSectionDuration,this.getUseIconTabBar()&&(t instanceof s||this._isFirstVisibleSectionBase(t))&&this._bStickyAnchorBar&&(i=0),i},b.prototype._computeScrollPosition=function(e){var t=e&&e instanceof s,i=e.getId(),o=this._bMobileScenario||t?this._oSectionInfo[i].positionTopMobile:this._oSectionInfo[i].positionTop;return!this._bStickyAnchorBar&&this._isFirstVisibleSectionBase(e)&&(o=0),o},b.prototype._preloadSectionsOnScroll=function(t){var i,n=t.getId();if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()&&(i=t instanceof s?t:t.getParent(),this._connectModelsForSections([i])),this.getEnableLazyLoading()){var r=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;i=this._oLazyLoading.getSubsectionsToPreload(r,n),o.system.desktop?e.sap.delayedCall(50,this,function(){this._connectModelsForSections(i)}):this._connectModelsForSections(i),i.forEach(function(e){this.fireEvent(\"subSectionEnteredViewPort\",{subSection:e})},this)}},b.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId},b.prototype.setDirectScrollingToSection=function(e){this.sDirectSectionId=e},b.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId},b.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null},b.prototype._scrollTo=function(t,i){return this._oScroller&&this._bDomReady&&!this._bSuppressScroll&&(e.sap.log.debug(\"ObjectPageLayout :: scrolling to \"+t),0===i&&this._shouldSnapHeaderOnScroll(t)&&this._toggleHeader(!0),this._oScroller.scrollTo(0,t,i)),this},b.prototype._updateMedia=function(e){var t=function(e){Object.keys(b.DYNAMIC_HEADERS_MEDIA).forEach(function(t){var i=b.DYNAMIC_HEADERS_MEDIA[t],o=e===i;this.toggleStyleClass(i,o)},this)}.bind(this),i=b.DYNAMIC_HEADERS_MEDIA,o=b.BREAK_POINTS;t(e<=o.PHONE?i.PHONE:e<=o.TABLET?i.TABLET:i.DESKTOP)},b.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var t,i,o,n,r,a,h=!this._bHeaderExpanded,l=this.getDomRef();if(!l||!this._bDomReady)return!1;if(e.sap.log.debug(\"ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer\",\"re-evaluating dom positions\"),this.iScreenHeight=l.parentElement?l.getBoundingClientRect().height:0,0!==this.iScreenHeight){var c=0;return this._aSectionBases.forEach(function(e){var t,o=this._oSectionInfo[e.getId()],a=e.$(),h=!1;if(o&&a.length){o.isSection||c++,o.$dom=a;var l=a.position().top;if(o.positionTop=Math.ceil(l),t=o.isSection?e.$(\"header\"):e.$(\"headerTitle\"),h=0===t.length,o.positionTopMobile=h?o.positionTop:Math.ceil(t.position().top)+t.outerHeight(),this._bStickyAnchorBar||this._bHeaderInTitleArea||(o.positionTopMobile-=this.iAnchorBarHeight,o.positionTop-=this.iAnchorBarHeight),o.sectionReference.toggleStyleClass(\"sapUxAPObjectPageSubSectionPromoted\",h),this._bMobileScenario){var d=this.oCore.byId(e.getId()).getParent();if(d instanceof s&&d._getIsHidden())return;r&&(this._oSectionInfo[r].positionBottom=o.positionTop),r=e.getId(),i=e}else o.isSection?(r&&(this._oSectionInfo[r].positionBottom=o.positionTop,n&&(this._oSectionInfo[n].positionBottom=o.positionTop)),r=e.getId(),n=null):(n&&(this._oSectionInfo[n].positionBottom=o.positionTop),n=e.getId(),i=e)}},this),i&&(t=this._computeLastVisibleHeight(i),this._bMobileScenario&&r?this._oSectionInfo[r].positionBottom=this._oSectionInfo[r].positionTop+t:(n&&(this._oSectionInfo[n].positionBottom=this._oSectionInfo[n].positionTop+t),r&&n&&(this._oSectionInfo[r].positionBottom=this._oSectionInfo[n].positionTop+t)),a=this._bStickyAnchorBar||c>1||this._checkContentBottomRequiresSnap(i),a&&!this._shouldPreserveHeaderInTitleArea()&&(h=!0),o=this._computeSpacerHeight(i,t,a,h),this._$spacer.height(o+\"px\"),e.sap.log.debug(\"ObjectPageLayout :: bottom spacer is now \"+o+\"px\")),this._updateCustomScrollerHeight(h),this._setSectionInfoIsDirty(!1),!0}},b.prototype._updateCustomScrollerHeight=function(e){if(o.system.desktop&&this.getAggregation(\"_customScrollBar\")){var t=this._computeScrollableContentSize(e);t+=this._getStickyAreaHeight(e),this._getCustomScrollBar().setContentSize(t+\"px\");var i=t>Math.ceil(this.iScreenHeight);i!==this._getCustomScrollBar().getVisible()&&(this._getCustomScrollBar().setVisible(i),this.getHeaderTitle()&&this._shiftHeaderTitle())}},b.prototype._computeScrollableContentSize=function(e){var t=0;return this._$contentContainer&&this._$contentContainer.length&&(t=this._$contentContainer[0].scrollHeight),!this._bStickyAnchorBar&&e&&(t-=this.iAnchorBarHeight),this._bStickyAnchorBar&&!e&&(t+=this.iAnchorBarHeight),t},b.prototype._computeLastVisibleHeight=function(e){var t=this._bStickyAnchorBar||this._bHeaderInTitleArea,i=this._getSectionPositionTop(e,t);return this._$spacer.position().top-i},b.prototype._getStickyAreaHeight=function(e){return e?this.iHeaderTitleHeightStickied+this.iAnchorBarHeight:this.iHeaderTitleHeight},b.prototype._getScrollableViewportHeight=function(e){return this.$().height()-this._getStickyAreaHeight(e)},b.prototype._getSectionPositionTop=function(e,t){var i=this._oSectionInfo[e.getId()].positionTop;return t||(i+=this.iAnchorBarHeight),i},b.prototype._getSectionPositionBottom=function(e,t){var i=this._oSectionInfo[e.getId()].positionBottom;return t||(i+=this.iAnchorBarHeight),i},b.prototype._determineSectionBaseInternalTitleLevel=function(e){var t=this.getSectionTitleLevel(),i=e instanceof s;return t===y.Auto?i?y.H3:y.H4:i?t:b._getNextTitleLevelEntry(t)},b.prototype._shouldApplySectionTitleLevel=function(e){return e.getTitleLevel()===y.Auto},b.prototype._checkContentBottomRequiresSnap=function(e){return this._getSectionPositionBottom(e,!1)>=this._getScrollableViewportHeight(!1)+this._getSnapPosition()},b.prototype._computeSpacerHeight=function(e,t,i,o){var n,r,s;return this.getFooter()&&this.getShowFooter()&&(s=this.$(\"footerWrapper\").outerHeight()),r=this._getScrollableViewportHeight(o),i||(t=this._getSectionPositionBottom(e,!1)),t<r?(n=r-t,this._bMobileScenario&&(n+=this._oSectionInfo[e.getId()].positionTopMobile-this._oSectionInfo[e.getId()].positionTop)):n=0,s>n&&(n+=s),n},b.prototype._isFirstVisibleSectionBase=function(e){var t;return!(!e||!this._oFirstVisibleSubSection&&!this._oFirstVisibleSection)&&((t=e.getId())===this._oFirstVisibleSection.getId()||t===this._oFirstVisibleSubSection.getId())},b.prototype._getFirstVisibleSubSection=function(e){if(e){var t;return this._aSectionBases.every(function(i){return!i.getParent()||i.getParent().getId()!==e.getId()||(t=i,!1)}),t}},b.prototype._initAnchorBarScroll=function(){var e,t=this.oCore.byId(this.getSelectedSection());this._requestAdjustLayout(!0),e=t?this._computeScrollPosition(t):0,this._sScrolledSectionId=\"\",this._sCurrentScrollId=\"\",this._onScroll({target:{scrollTop:e}})},b.prototype._setAsCurrentSection=function(t){var i,o,n;this._sScrolledSectionId!==t&&(e.sap.log.debug(\"ObjectPageLayout :: current section is \"+t),this._sScrolledSectionId=t,(i=this.getAggregation(\"_anchorBar\"))&&this._getInternalAnchorBarVisible()&&(o=this.oCore.byId(t),n=o&&o instanceof a&&(\"\"===o.getTitle().trim()||!o._getInternalTitleVisible()||o.getParent()._getIsHidden()),n&&(t=o.getParent().getId(),e.sap.log.debug(\"ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent \"+t)),o&&this._oSectionInfo[t]&&(i.setSelectedButton(this._oSectionInfo[t].buttonId),this.setAssociation(\"selectedSection\",s._getClosestSection(t).getId(),!0),this._setSectionsFocusValues(t))))},b.prototype._registerOnContentResize=function(){var e=this._$contentContainer.length&&this._$contentContainer[0];e&&(this._iContentResizeId&&t.deregister(this._iContentResizeId),this._iContentResizeId=t.register(e,this._onUpdateContentSize.bind(this)))},b.prototype._onUpdateContentSize=function(e){var t,i,o,n;this._preserveHeaderStateOnScroll()&&this._overridePreserveHeaderStateOnScroll(),this._hasDynamicTitle()&&this._adjustHeaderHeights(),this._requestAdjustLayout().then(function(){t=this._$opWrapper.scrollTop(),0!==(i=this.iScreenHeight)&&(o=this._getClosestScrolledSectionId(t,i),n=this.getSelectedSection(),o&&n!==o&&this.getAggregation(\"_anchorBar\").setSelectedButton(this._oSectionInfo[o].buttonId))}.bind(this))},b.prototype._onUpdateScreenSize=function(t){var i,o=this.getHeaderTitle(),n=t.size.width,r=t.size.height,s=t.oldSize.height,a=r!==s\n;return 0===t.size.height||0===t.size.width?void e.sap.log.info(\"ObjectPageLayout :: not triggering calculations if height or width is 0\"):this._bDomReady?(this._oLazyLoading.setLazyLoadingParameters(),void e.sap.delayedCall(b.HEADER_CALC_DELAY,this,function(){if(this._bMobileScenario=u.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange()),this._bTabletScenario=u.Utilities.isTabletScenario(this._getCurrentMediaContainerRange()),this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader()&&this.invalidate(),o&&o.isDynamic()&&(o._onResize(n),this._updateMedia(n)),this._adjustHeaderHeights(),this._requestAdjustLayout(!0),this.getFooter()&&this.getShowFooter()&&this._shiftFooter(),i=this.getSelectedSection(),0===s&&a&&!this._isClosestScrolledSection(i))return void this.scrollToSection(i,0);this._scrollTo(this._$opWrapper.scrollTop(),0)})):void e.sap.log.info(\"ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready\")},b.prototype._shouldSnapHeaderOnScroll=function(e){return e>0&&e>=this._getSnapPosition()&&!this._shouldPreserveHeaderInTitleArea()},b.prototype._onScroll=function(t){var i,o,n,r=Math.max(t.target.scrollTop,0),s=this.getHeaderTitle(),a=this._shouldSnapHeaderOnScroll(r),h=this._shouldPreserveHeaderInTitleArea(),l=!1;if(this._bSupressModifyOnScrollOnce)return void(this._bSupressModifyOnScrollOnce=!1);if(0!==(i=this.iScreenHeight)&&!this._getSectionInfoIsDirty()){if(a&&!h&&(i-=this.iAnchorBarHeight+this.iHeaderTitleHeightStickied),this._bHeaderInTitleArea&&!h&&(this._moveHeaderToContentArea(),this._toggleHeaderTitle(!1),this._bHeaderExpanded=!1,this._updateToggleHeaderVisualIndicators(),this._requestAdjustLayout()),!h&&(s&&this.getShowHeaderContent()||this.getShowAnchorBar())&&this._toggleHeader(a,!(!t||\"scroll\"!==t.type)),h||this._adjustHeaderTitleBackgroundPosition(r),e.sap.log.debug(\"ObjectPageLayout :: lazy loading : Scrolling at \"+r,\"----------------------------------------\"),o=this._getClosestScrolledSectionId(r,i),n=this._getClosestScrolledSectionId(r,i,!0),o){var c=this.getDirectScrollingToSection();if(o!==this._sScrolledSectionId){e.sap.log.debug(\"ObjectPageLayout :: closest id \"+o,\"----------------------------------------\");var c=this.getDirectScrollingToSection();if(c&&c!==o)return;this.clearDirectScrollingToSection(),this._setAsCurrentSection(o)}else o===this.getDirectScrollingToSection()&&this.clearDirectScrollingToSection();n!==this._sScrolledSubSectionId&&(this._sScrolledSubSectionId=n,this.fireEvent(\"_sectionChange\",{section:this.oCore.byId(o),subSection:this.oCore.byId(n)}))}this.getEnableLazyLoading()&&this._oLazyLoading.lazyLoadDuringScroll(r,t.timeStamp,i),s&&s.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&s.getShowTitleSelector()&&(0===r?(e.sap.byId(this.getId()+\"-scroll\").css(\"z-index\",\"1000\"),l=!1):l||(l=!0,e.sap.byId(this.getId()+\"-scroll\").css(\"z-index\",\"0\")))}},b.prototype._getSnapPosition=function(){var e=this.iHeaderContentHeight,t=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;return t<b.MAX_SNAP_POSITION_OFFSET&&(e-=t),e},b.prototype._getClosestScrolledSectionId=function(t,i,o){if(o=!!o,t=Math.ceil(t),this.getUseIconTabBar()&&this._oCurrentTabSection)return this._oCurrentTabSection.getId();var n,r=t+i,a=o||this._bMobileScenario;return e.each(this._oSectionInfo,function(e,i){var h,l,c;if((h=this.oCore.byId(e))&&(l=h.getParent(),c=l instanceof s&&l._getIsHidden(),i.isSection||a&&!c)){if(n||!0!==i.sectionReference._getInternalVisible()||(n=i.isSection&&o?this._getFirstVisibleSubSection(i.sectionReference).getId():e),i.isSection&&o)return!0;if(i.positionTop<=r&&t<=i.positionBottom&&i.positionTop<=t&&i.positionBottom>t)return n=e,!1}}.bind(this)),n},b.prototype._toggleHeader=function(e,t){var i=this.getHeaderTitle();this._shouldPreserveHeaderInTitleArea()||this._bHeaderInTitleArea||this._toggleHeaderTitle(!e,t),!this._bStickyAnchorBar&&e?(this._restoreFocusAfter(this._moveAnchorBarToTitleArea),i&&i.snap(),this._bHeaderExpanded=!1,this._adjustHeaderHeights(),this._updateToggleHeaderVisualIndicators()):this._bStickyAnchorBar&&!e&&(this._restoreFocusAfter(this._moveAnchorBarToContentArea),i&&i.unSnap(),this._bHeaderExpanded=!0,this._adjustHeaderHeights(),this._updateToggleHeaderVisualIndicators())},b.prototype._restoreFocusAfter=function(e){var t=this.oCore.byId(this.oCore.getCurrentFocusedControlId());return e.call(this),!0!==o.system.phone&&(this.oCore.byId(this.oCore.getCurrentFocusedControlId())||t&&t.$().focus()),this},b.prototype._moveAnchorBarToTitleArea=function(){return this._$anchorBar.children().appendTo(this._$stickyAnchorBar),this._toggleHeaderStyleRules(!0),this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied&&this._adjustHeaderBackgroundSize(),this},b.prototype._moveAnchorBarToContentArea=function(){return this._shouldPreserveHeaderInTitleArea()||(this._$anchorBar.css(\"height\",\"auto\").append(this._$stickyAnchorBar.children()),this._toggleHeaderStyleRules(!1)),this},b.prototype._toggleHeaderStyleRules=function(e){e=!!e;var t=e?\"hidden\":\"inherit\";this._bStickyAnchorBar=e,this._$headerContent.css(\"overflow\",t),this._$headerContent.toggleClass(\"sapContrastPlus\",!e),this._$headerContent.toggleClass(\"sapUxAPObjectPageHeaderDetailsHidden\",e),this._$anchorBar.css(\"visibility\",t),this.fireToggleAnchorBar({fixed:e})},b.prototype.getScrollDelegate=function(){return this._oScroller},b.prototype.setHeaderTitle=function(e,t){return e&&\"function\"==typeof e.addEventDelegate&&e.addEventDelegate({onAfterRendering:this._adjustHeaderHeights.bind(this)}),this.setAggregation(\"headerTitle\",e,t),e&&this._createHeaderContent(),this},b.prototype.invalidate=function(e){this.getUseIconTabBar()&&e&&e instanceof s&&!e.isActive()||i.prototype.invalidate.apply(this,arguments)},b.prototype._createHeaderContent=function(){var e,t=this.getHeaderTitle(),i=this.getAggregation(\"_headerContent\"),o=t?t.getCompatibleHeaderContentClass():h;if(!(i instanceof o)){var e=o.createInstance(this.getAggregation(\"headerContent\"),this.getShowHeaderContent(),this._getHeaderDesign(),this.getHeaderContentPinnable());this.setAggregation(\"_headerContent\",e,!0)}},b.prototype._adjustHeaderBackgroundSize=function(){var e=this.getHeaderTitle();e&&\"Dark\"==e.getHeaderDesign()&&(this._shouldPreserveHeaderInTitleArea()?(this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height(),this._$stickyHeaderContent.css(\"background-size\",\"100% \"+this.iTotalHeaderSize+\"px\")):(this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight,this._$headerContent.css(\"background-size\",\"100% \"+this.iTotalHeaderSize+\"px\")),e.$().css(\"background-size\",\"100% \"+this.iTotalHeaderSize+\"px\"),this._adjustHeaderTitleBackgroundPosition(0))},b.prototype._adjustHeaderTitleBackgroundPosition=function(e){var t=this.getHeaderTitle();t&&\"Dark\"==t.getHeaderDesign()&&(this._bStickyAnchorBar?t.$().css(\"background-position\",\"0px \"+-1*(this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)+\"px\"):this._shouldPreserveHeaderInTitleArea()?t.$().css(\"background-position\",\"0px 0px\"):t.$().css(\"background-position\",\"0px \"+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-e)+\"px\"))},b.prototype._adjustHeaderHeights=function(){var t=this.getHeaderTitle(),i=!0;t&&!t.supportsAdaptLayoutForDomElement()&&(i=!1),this._$headerTitle.length>0?(this.iHeaderContentHeight=this._$headerContent[0].parentElement?Math.ceil(this._$headerContent[0].getBoundingClientRect().height):0,this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height(),this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.height():this._$anchorBar.height(),this._bHeaderExpanded?(this.iHeaderTitleHeight=this._$headerTitle.is(\":visible\")?this._$headerTitle.height():0,this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(i)):(this.iHeaderTitleHeightStickied=this._$headerTitle.height()-this.iAnchorBarHeight,this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(i)),this._adjustHeaderBackgroundSize(),e.sap.log.info(\"ObjectPageLayout :: adjustHeaderHeight\",\"headerTitleHeight: \"+this.iHeaderTitleHeight+\" - headerTitleStickiedHeight: \"+this.iHeaderTitleHeightStickied+\" - headerContentHeight: \"+this.iHeaderContentHeight)):e.sap.log.debug(\"ObjectPageLayout :: adjustHeaderHeight\",\"skipped as the objectPageLayout is being rendered\")},b.prototype._appendTitleCloneToDOM=function(e){var t=this._$headerTitle.clone();return t.css({left:\"-10000px\",top:\"-10000px\",width:this._$headerTitle.width()+\"px\"}),t.toggleClass(\"sapUxAPObjectPageHeaderStickied\",e),t.appendTo(this._$headerTitle.parent()),e&&this.getHeaderTitle()&&this.getHeaderTitle()._adaptLayoutForDomElement(t),t},b.prototype._obtainSnappedTitleHeight=function(e){var t,i,o=this.getHeaderTitle();return e?(t=this._appendTitleCloneToDOM(!0),i=t.height(),t.remove()):o&&o.snap&&(o.snap(!1),i=o.$().outerHeight(),o.unSnap(!1)),i},b.prototype._obtainExpandedTitleHeight=function(e){var t,i,o=this.getHeaderTitle();return e?(t=this._appendTitleCloneToDOM(!1),i=t.is(\":visible\")?t.height()-this.iAnchorBarHeight:0,t.remove()):o&&o.unSnap&&(o.unSnap(!1),i=o.$().outerHeight(),o.snap(!1)),i},b.prototype._getHeaderDesign=function(){var e=this.getHeaderTitle(),t=u.ObjectPageHeaderDesign.Light;return null!=e&&(t=e.getHeaderDesign()),t},b.prototype._getVisibleSections=function(){return this.getSections().filter(function(e){return e.getVisible()&&e._getInternalVisible()})},b.prototype._setSectionsFocusValues=function(e){var t,i,o=this._getVisibleSections()||[],n=o[0];return o.forEach(function(o){t=o.$(),e===o.sId?(t.attr(\"tabIndex\",\"0\"),i=o,o._setSubSectionsFocusValues()):(t.attr(\"tabIndex\",\"-1\"),o._disableSubSectionsFocus())}),!i&&o.length>0&&(n.$().attr(\"tabIndex\",\"0\"),n._setSubSectionsFocusValues(),i=n),i},b.prototype.setShowHeaderContent=function(e){var t,i=this.getShowHeaderContent();return i!==e&&(i&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()&&(this._moveHeaderToContentArea(),this._toggleHeaderTitle(!1)),this.setProperty(\"showHeaderContent\",e),(t=this._getHeaderContent())&&t.setProperty(\"visible\",e)),this},b.prototype._headerTitleChangeHandler=function(e){var t;this.getShowTitleInHeaderContent()&&(e&&this._getHeaderContent()._destroyObjectImage(!0),t=this.oCore.createRenderManager(),this.getRenderer()._rerenderHeaderContentArea(t,this),this._getHeaderContent().invalidate(),t.destroy())},b.prototype.getHeaderContent=function(){return this._getHeaderContent()?this._getHeaderContent().getAggregation(\"content\"):this.getAggregation(\"headerContent\")},b.prototype.insertHeaderContent=function(e,t,i){return this._getHeaderContent()?this._getHeaderContent().insertAggregation(\"content\",e,t,i):this.insertAggregation(\"headerContent\",e,t,i)},b.prototype.addHeaderContent=function(e,t){return this._getHeaderContent()?this._getHeaderContent().addAggregation(\"content\",e,t):this.addAggregation(\"headerContent\",e,t)},b.prototype.removeAllHeaderContent=function(e){return this._getHeaderContent()?this._getHeaderContent().removeAllAggregation(\"content\",e):this.removeAllAggregation(\"headerContent\",e)},b.prototype.removeHeaderContent=function(e,t){return this._getHeaderContent()?this._getHeaderContent().removeAggregation(\"content\",e,t):this.removeAggregation(\"headerContent\",e,t)},b.prototype.destroyHeaderContent=function(e){return this._getHeaderContent()?this._getHeaderContent().destroyAggregation(\"content\",e):this.destroyAggregation(\"headerContent\",e)},b.prototype.indexOfHeaderContent=function(e){return this._getHeaderContent()?this._getHeaderContent().indexOfAggregation(\"content\",e):this.indexOfAggregation(\"headerContent\",e)},b.prototype._getHeaderContent=function(){return this.getAggregation(\"_headerContent\")},b.prototype._checkAlwaysShowContentHeader=function(){var e=this._getHeaderContent();return e&&e.supportsAlwaysExpanded()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader()},b.prototype._connectModelsForSections=function(e){e=e||[],e.forEach(function(e){e.connectToModels()})},b.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()}},b.prototype._hasVerticalScrollBar=function(){return!0===this._getCustomScrollBar().getVisible()},b.prototype._shiftHeaderTitle=function(){var e=this._calculateShiftOffset(),t=e.sStyleAttribute,i=e.iMarginalsOffset;this.$().find(\".sapUxAPObjectPageHeaderTitle\").css(\"padding-\"+t,i+\"px\")},b.prototype._isFirstSection=function(e){return e===this._getVisibleSections()[0]},b.prototype._isPositionWithinSection=function(t,i){if(i&&this._bDomReady&&this._oSectionInfo[i.getId()]){var o=this._computeScrollPosition(i),n=e(i.getDomRef()).height(),r=o+n;return t>=o&&t<r}},b.prototype._restoreScrollPosition=function(){var e=this.oCore.byId(this._sStoredScrolledSubSectionId);e&&(this._isPositionWithinSection(this._iStoredScrollPosition,e)?this._scrollTo(this._iStoredScrollPosition,0):this.scrollToSection(e.getId(),0))},b.prototype._storeScrollLocation=function(){this.getDomRef()&&this._bDomReady&&(this._iStoredScrollPosition=this._oScroller.getScrollTop(),this._sStoredScrolledSubSectionId=this._getClosestScrolledSectionId(this._oScroller.getScrollTop(),this.iScreenHeight,!0),this._oCurrentTabSection=null)},b.prototype.onkeyup=function(t){var i,o;t.which===e.sap.KeyCodes.TAB&&(i=this.oCore.getCurrentFocusedControlId(),(o=i&&this.oCore.byId(i))&&this._isFirstSection(o)&&this._scrollTo(0,0))},b.prototype.setShowFooter=function(e){var t=this.setProperty(\"showFooter\",e,!0);return this._toggleFooter(e),t},b.prototype._toggleFooter=function(t){var i=this.oCore.getConfiguration().getAnimation(),o=this.getFooter();S(o)&&(o.toggleStyleClass(\"sapUxAPObjectPageFloatingFooterShow\",t),o.toggleStyleClass(\"sapUxAPObjectPageFloatingFooterHide\",!t),this._iFooterWrapperHideTimeout&&e.sap.clearDelayedCall(this._iFooterWrapperHideTimeout),i&&(t?(this.$(\"footerWrapper\").toggleClass(\"sapUiHidden\",!t),this._iFooterWrapperHideTimeout=null):this._iFooterWrapperHideTimeout=e.sap.delayedCall(b.FOOTER_ANIMATION_DURATION,this,function(){this.$(\"footerWrapper\").toggleClass(\"sapUiHidden\",!t)}),e.sap.delayedCall(b.FOOTER_ANIMATION_DURATION,this,function(){o.removeStyleClass(\"sapUxAPObjectPageFloatingFooterShow\")})),this._requestAdjustLayout())},b.prototype.clone=function(){var e,t;return Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this),e=i.prototype.clone.apply(this,arguments),t=this._getHeaderContent(),e.setAggregation(\"_headerContent\",t.clone(),!0),e},b.prototype._cloneProxiedAggregations=function(e){var t=this.mAggregations[e];Array.isArray(t)&&0===t.length&&(t=this[\"get\"+e.charAt(0).toUpperCase()+e.slice(1)]()),this.mAggregations[e]=t},b.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader()},b.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader()},b.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!o.system.desktop&&this._headerBiggerThanAllowedToBeFixed()},b.prototype._headerBiggerThanAllowedToBeFixed=function(){var e=this._getOwnHeight();return this._getEntireHeaderHeight()>b.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*e},b.prototype._getOwnHeight=function(){return this._getHeight(this)},b.prototype._getHeight=function(e){return e instanceof i?e.$().outerHeight()||0:0},b.prototype._getEntireHeaderHeight=function(){var e=0,t=0,i=this.getHeaderTitle(),o=this._getHeaderContent();return S(i)&&(e=i.$().outerHeight()),S(o)&&(t=o.$().outerHeight()),e+t},b.prototype._onPinUnpinButtonPress=function(e){this._bPinned?this._unPin(e):this._pin(e)},b.prototype._pin=function(){var e=this.$();this._bPinned||(this._bPinned=!0,this._toggleHeaderTitle(!0),this._moveAnchorBarToTitleArea(),this._moveHeaderToTitleArea(),this._adjustHeaderHeights(),this._requestAdjustLayout(),this._togglePinButtonARIAState(this._bPinned),this._updateToggleHeaderVisualIndicators(),S(e)&&e.addClass(\"sapUxAPObjectPageLayoutHeaderPinned\"))},b.prototype._unPin=function(){var e=this.$();this._bPinned&&(this._bPinned=!1,this._updateToggleHeaderVisualIndicators(),this._togglePinButtonARIAState(this._bPinned),S(e)&&e.removeClass(\"sapUxAPObjectPageLayoutHeaderPinned\"))},b.prototype._togglePinButtonARIAState=function(e){var t=this._getHeaderContent();S(t)&&t.supportsPinUnpin()&&t._updateARIAPinButtonState(e)},b.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight},b.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll())return void(this._bHeaderBiggerThanAllowedHeight=!1);this._bHeaderBiggerThanAllowedHeight=!0,this._bHeaderExpanded?(this._moveAnchorBarToContentArea(),this._moveHeaderToContentArea(!0)):this._snapHeader(!0),this._adjustHeaderHeights(),this._requestAdjustLayout()},b.prototype._hasDynamicTitle=function(){var e=this.getHeaderTitle();return e&&e.isDynamic()},b.prototype._attachVisualIndicatorsPressHandlers=function(e,t){var i=this.getHeaderTitle(),o=this._getHeaderContent();S(i)&&!this._bAlreadyAttachedTitleIndicatorPressHandler&&(i.attachEvent(b.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){e.call(t),this._focusCollapseVisualIndicator()},this),this._bAlreadyAttachedTitleIndicatorPressHandler=!0),S(o)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler&&(o.attachEvent(b.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){e.call(t),this._focusExpandVisualIndicator()},this),this._bAlreadyAttachedHeaderIndicatorPressHandler=!0)},b.prototype._updateToggleHeaderVisualIndicators=function(){var e,t,i;!this.getToggleHeaderOnTitleClick()||this._bPinned?(t=!1,i=!1):(e=this._bHeaderExpanded,t=e,i=!e),this._toggleCollapseVisualIndicator(t),this._toggleExpandVisualIndicator(i)},b.prototype._focusCollapseVisualIndicator=function(){var e=this._getHeaderContent();S(e)&&e._focusCollapseButton()},b.prototype._focusExpandVisualIndicator=function(){var e=this.getHeaderTitle();S(e)&&e._focusExpandButton()},b.prototype._toggleExpandVisualIndicator=function(e){var t=this.getHeaderTitle();S(t)&&t._toggleExpandButton(e)},b.prototype._toggleCollapseVisualIndicator=function(e){var t=this._getHeaderContent();S(t)&&t._toggleCollapseButton(e)},b.prototype._attachVisualIndicatorMouseOverHandlers=function(e,t,i){var o=this._getHeaderContent();S(o)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler&&(o.attachEvent(b.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,e,i),o.attachEvent(b.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,t,i),this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=!0)},b.prototype._attachTitleMouseOverHandlers=function(e,t,i){var o=this.getHeaderTitle();S(o)&&!this._bAlreadyAttachedTitleMouseOverOutHandler&&(o.attachEvent(b.EVENTS.TITLE_MOUSE_OVER,e,i),o.attachEvent(b.EVENTS.TITLE_MOUSE_OUT,t,i),this._bAlreadyAttachedTitleMouseOverOutHandler=!0)},b.prototype._suppressScroll=function(){this._bSuppressScroll=!0},b.prototype._resumeScroll=function(){this._bSuppressScroll=!1,this._iStoredScrollPosition?this._scrollTo(this._iStoredScrollPosition,0):this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}})},b.prototype._addHoverClass=function(){var e=this.$();e&&e.addClass(\"sapUxAPObjectPageLayoutTitleForceHovered\")},b.prototype._removeHoverClass=function(){var e=this.$();e&&e.removeClass(\"sapUxAPObjectPageLayoutTitleForceHovered\")},b.prototype._getHeight=function(e){return e instanceof i?e.$().outerHeight()||0:0},b.prototype._getWidth=function(e){return e instanceof i?e.$().outerWidth()||0:0},b.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty},b.prototype._setSectionInfoIsDirty=function(e){this.bSectionInfoIsDirty=e},b});",
	"sap/uxap/ObjectPageLayoutABHelper.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/base/Metadata\",\"sap/ui/core/CustomData\",\"./AnchorBar\",\"sap/m/Button\",\"sap/ui/core/IconPool\"],function(t,e,o,a,n,i){\"use strict\";var r=e.createClass(\"sap.uxap._helpers.AB\",{constructor:function(t){this._oObjectPageLayout=t,this._iScrollDuration=t._iScrollToSectionDuration}});return r.prototype.getObjectPageLayout=function(){return this._oObjectPageLayout},r.prototype._getAnchorBar=function(){var t=this.getObjectPageLayout().getAggregation(\"_anchorBar\");return t||(t=new a({id:this.getObjectPageLayout().getId()+\"-anchBar\",showPopover:this.getObjectPageLayout().getShowAnchorBarPopover()}),this.getObjectPageLayout().setAggregation(\"_anchorBar\",t,!0)),t},r.prototype._buildAnchorBar=function(){var t=this.getObjectPageLayout().getSections()||[],e=this._getAnchorBar();e&&this.getObjectPageLayout().getShowAnchorBar()&&(e._resetControl(),t.forEach(function(t){if(t.getVisible()&&t._getInternalVisible()){var o,a=t.getSubSections()||[];o=this._buildAnchorBarButton(t,!0),o&&(e.addContent(o),a.forEach(function(t){if(t.getVisible()&&t._getInternalVisible()){var o=this._buildAnchorBarButton(t,!1);o&&e.addContent(o)}},this))}},this))},r.prototype._focusOnSectionWhenUsingKeyboard=function(e){var o=e.srcControl.data(),a=sap.ui.getCore().byId(o.sectionId),n=this.getObjectPageLayout();!a||o.bHasSubMenu||n.getUseIconTabBar()||t.sap.delayedCall(this._iScrollDuration,a.$(),\"focus\")},r.prototype._buildAnchorBarButton=function(t,e){var a,r,s=null,c=this.getObjectPageLayout(),u=this._getAnchorBar(),g=t.getAggregation(\"subSections\"),l=this._focusOnSectionWhenUsingKeyboard.bind(this),h={onsapenter:l,onsapspace:l};if(t.getVisible()&&t._getInternalVisible()){if(a=t.getCustomAnchorBarButton())s=a.clone();else{r=u.getId()+\"-\"+t.getId()+\"-anchor\",s=new n({ariaDescribedBy:t,id:r}),s.addEventDelegate(h);var d=\"\"!=t._getInternalTitle()?t._getInternalTitle():t.getTitle();s.setText(d)}if(c._oSectionInfo[t.getId()].buttonId=s.getId(),s.addCustomData(new o({key:\"sectionId\",value:t.getId()})),s.addCustomData(new o({key:\"bTitleVisible\",value:t._getInternalTitleVisible()})),e||s.addCustomData(new o({key:\"secondLevel\",value:!0})),g&&g.length>1){g.filter(function(t){return t.getVisible()}).length>1&&(s.addCustomData(new o({key:\"bHasSubMenu\",value:!0})),c.getShowAnchorBarPopover()&&(s.setIcon(i.getIconURI(\"slim-arrow-down\")),s.setIconFirst(!1)))}}return s},r},!1);",
	"sap/uxap/ObjectPageLayoutRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/Device\"],function(e){\"use strict\";var t={};return t.render=function(t,r){var a,i,s=r.getHeaderTitle(),n=null,d=r.getHeaderContent()&&r.getHeaderContent().length>0&&r.getShowHeaderContent(),o=r.getShowTitleInHeaderContent()&&r.getShowHeaderContent(),l=d||o,C=r.getUseIconTabBar(),g=r.getToggleHeaderOnTitleClick();r.getShowAnchorBar()&&r._getInternalAnchorBarVisible()&&(n=r.getAggregation(\"_anchorBar\")),t.write(\"<div\"),t.writeControlData(r),s&&(i=s.getTitleText()||\"\",t.writeAttributeEscaped(\"aria-label\",i)),t.addClass(\"sapUxAPObjectPageLayout\"),g&&t.addClass(\"sapUxAPObjectPageLayoutTitleClickEnabled\"),n&&t.addClass(\"sapUxAPObjectPageLayoutWithNavigation\"),t.writeClasses(),t.addStyle(\"height\",r.getHeight()),t.writeStyles(),t.write(\">\"),e.system.desktop&&t.renderControl(r._getCustomScrollBar().addStyleClass(\"sapUxAPObjectPageCustomScroller\")),t.write(\"<header \"),t.writeAttribute(\"role\",\"banner\"),t.writeAttributeEscaped(\"id\",r.getId()+\"-headerTitle\"),t.writeAttribute(\"data-sap-ui-customfastnavgroup\",!0),t.addClass(\"sapUxAPObjectPageHeaderTitle\"),t.addClass(\"sapContrastPlus\"),t.writeClasses(),t.write(\">\"),s&&t.renderControl(s),this._renderHeaderContentDOM(t,r,l&&r._bHeaderInTitleArea,\"-stickyHeaderContent\"),t.write(\"<div \"),t.writeAttributeEscaped(\"id\",r.getId()+\"-stickyAnchorBar\"),t.addClass(\"sapUxAPObjectPageStickyAnchorBar\"),t.addClass(\"sapUxAPObjectPageNavigation\"),t.writeClasses(),t.write(\">\"),this._renderAnchorBar(t,r,n,r._bHeaderInTitleArea),t.write(\"</div>\"),t.write(\"</header>\"),t.write(\"<div \"),t.writeAttributeEscaped(\"id\",r.getId()+\"-opwrapper\"),t.addClass(\"sapUxAPObjectPageWrapper\"),(!s||s.supportsTitleInHeaderContent())&&r.getShowTitleInHeaderContent()&&s.getShowTitleSelector()||t.addClass(\"sapUxAPObjectPageWrapperTransform\"),t.writeClasses(),t.write(\">\"),t.write(\"<div \"),t.writeAttributeEscaped(\"id\",r.getId()+\"-scroll\"),t.addClass(\"sapUxAPObjectPageScroll\"),t.writeClasses(),t.write(\">\"),this._renderHeaderContentDOM(t,r,l&&!r._bHeaderInTitleArea,\"-headerContent\",!0),t.write(\"<section \"),t.writeAttributeEscaped(\"id\",r.getId()+\"-anchorBar\"),t.writeAttribute(\"role\",\"navigation\"),t.addClass(\"sapUxAPObjectPageNavigation\"),t.addClass(\"sapContrastPlus\"),t.writeClasses(),t.write(\">\"),this._renderAnchorBar(t,r,n,!r._bHeaderInTitleArea),t.write(\"</section>\"),t.write(\"<section\"),t.addClass(\"sapUxAPObjectPageContainer\"),t.writeAttributeEscaped(\"id\",r.getId()+\"-sectionsContainer\"),t.addClass(\"ui-helper-clearfix\"),n||t.addClass(\"sapUxAPObjectPageContainerNoBar\"),t.writeClasses(),t.write(\">\"),a=r._getSectionsToRender(),jQuery.isArray(a)&&jQuery.each(a,function(e,a){t.renderControl(a),C&&(r._oCurrentTabSection=a)}),t.write(\"</section>\"),this.renderFooterContent(t,r),t.write(\"<div\"),t.writeAttributeEscaped(\"id\",r.getId()+\"-spacer\"),t.write(\"></div>\"),t.write(\"</div>\"),t.write(\"</div>\"),this._renderFooterContentInternal(t,r),t.write(\"</div>\")},t._renderAnchorBar=function(e,t,r,a){var i,s=t.getAggregation(\"sections\");a&&(i=t._getHeaderContent(),t.getIsChildPage()&&i&&i.supportsChildPageDesign()&&(e.write(\"<div \"),e.writeAttributeEscaped(\"id\",t.getId()+\"-childPageBar\"),jQuery.isArray(s)&&s.length>1&&e.addClass(\"sapUxAPObjectChildPage\"),e.writeClasses(),e.write(\"></div>\")),r&&e.renderControl(r))},t._renderHeaderContentDOM=function(e,t,r,a,i){e.write(\"<header \"),e.writeAttributeEscaped(\"id\",t.getId()+a),e.addClass(\"ui-helper-clearfix\"),e.addClass(\"sapUxAPObjectPageHeaderDetails\"),e.addClass(\"sapUxAPObjectPageHeaderDetailsDesign-\"+t._getHeaderDesign()),i&&e.addClass(\"sapContrastPlus\"),e.writeClasses(),e.writeAttribute(\"data-sap-ui-customfastnavgroup\",!0),e.write(\">\"),r&&this.renderHeaderContent(e,t),e.write(\"</header>\")},t.renderHeaderContent=function(e,t){e.renderControl(t._getHeaderContent())},t.renderFooterContent=function(e,t){},t._renderFooterContentInternal=function(e,t){var r=t.getFooter();r&&(e.write(\"<footer\"),e.writeAttributeEscaped(\"id\",t.getId()+\"-footerWrapper\"),e.addClass(\"sapUxAPObjectPageFooter sapMFooter-CTX sapContrast sapContrastPlus\"),t.getShowFooter()||e.addClass(\"sapUiHidden\"),e.writeClasses(),e.write(\">\"),r.addStyleClass(\"sapUxAPObjectPageFloatingFooter\"),e.renderControl(r),e.write(\"</footer>\"))},t._rerenderHeaderContentArea=function(e,t){var r,a=t._bHeaderInTitleArea?\"stickyHeaderContent\":\"headerContent\";this.renderHeaderContent(e,t),(r=t.$(a)[0])&&e.flush(r)},t},!0);",
	"sap/uxap/ObjectPageLazyLoader.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"./library\",\"sap/ui/core/Element\",\"sap/ui/core/StashedControlSupport\"],function(t,e,a,n){\"use strict\";var r=a.extend(\"sap.uxap.ObjectPageLazyLoader\",{metadata:{library:\"sap.uxap\",aggregations:{content:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"content\"}},defaultAggregation:\"content\"}});return n.mixInto(r),r.prototype.setParent=function(e){return null===e||e instanceof sap.uxap.ObjectPageSubSection||t.sap.assert(!1,\"setParent(): oParent must be an instance of sap.uxap.ObjectPageSubSection or null\"),a.prototype.setParent.apply(this,arguments)},r});",
	"sap/uxap/ObjectPageSection.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/core/InvisibleText\",\"./ObjectPageSectionBase\",\"sap/ui/Device\",\"sap/m/Button\",\"sap/ui/core/StashedControlSupport\",\"./ObjectPageSubSection\",\"./library\",\"sap/m/library\",\"./ObjectPageSectionRenderer\"],function(t,e,o,i,n,s,a,u,r){\"use strict\";var h=u.ButtonType,p=e.extend(\"sap.uxap.ObjectPageSection\",{metadata:{library:\"sap.uxap\",properties:{showTitle:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},titleUppercase:{type:\"boolean\",group:\"Appearance\",defaultValue:!0}},defaultAggregation:\"subSections\",aggregations:{subSections:{type:\"sap.uxap.ObjectPageSubSection\",multiple:!0,singularName:\"subSection\"},ariaLabelledBy:{type:\"sap.ui.core.InvisibleText\",multiple:!1,visibility:\"hidden\"},_showHideAllButton:{type:\"sap.m.Button\",multiple:!1,visibility:\"hidden\"},_showHideButton:{type:\"sap.m.Button\",multiple:!1,visibility:\"hidden\"}},associations:{selectedSubSection:{type:\"sap.uxap.ObjectPageSubSection\",multiple:!1}},designtime:\"sap/uxap/designtime/ObjectPageSection.designtime\"}});return p.MEDIA_RANGE=o.media.RANGESETS.SAP_STANDARD,p._getClosestSection=function(t){var e=\"string\"==typeof t&&sap.ui.getCore().byId(t)||t;return e instanceof s?e.getParent():e},p.prototype._expandSection=function(){e.prototype._expandSection.call(this)._updateShowHideAllButton(!this._thereAreHiddenSubSections())},p.prototype.init=function(){e.prototype.init.call(this),this._sContainerSelector=\".sapUxAPObjectPageSectionContainer\"},p.prototype.exit=function(){this._detachMediaContainerWidthChange(this._updateImportance,this)},p.prototype._getImportanceLevelToHide=function(t){var e=this._getObjectPageLayout(),o=t||this._getCurrentMediaContainerRange(),i=e&&e.getShowOnlyHighImportance();return this._determineTheLowestLevelOfImportanceToShow(o.name,i)},p.prototype._updateImportance=function(t){var e=this._getObjectPageLayout(),o=this._getImportanceLevelToHide(t);this.getSubSections().forEach(function(t){t._applyImportanceRules(o)}),this._applyImportanceRules(o),this._updateShowHideAllButton(!1),e&&this.getDomRef()&&e._requestAdjustLayout()},p.prototype._determineTheLowestLevelOfImportanceToShow=function(t,e){return e||\"Phone\"===t?a.Importance.High:\"Tablet\"===t?a.Importance.Medium:a.Importance.Low},p.prototype.connectToModels=function(){this.getSubSections().forEach(function(t){t.connectToModels()})},p.prototype._allowPropagationToLoadedViews=function(t){this.getSubSections().forEach(function(e){e._allowPropagationToLoadedViews(t)})},p.prototype.onBeforeRendering=function(){this.getAggregation(\"ariaLabelledBy\")||this.setAggregation(\"ariaLabelledBy\",this._getAriaLabelledBy(),!0),this._detachMediaContainerWidthChange(this._updateImportance,this),this._updateImportance()},p.prototype.onAfterRendering=function(){this._attachMediaContainerWidthChange(this._updateImportance,this)},p.prototype._getAriaLabelledBy=function(){return new t({text:this._getTitle()}).toStatic()},p.prototype._isTitleVisible=function(){return this.getShowTitle()&&this._getInternalTitleVisible()},p.prototype._setSubSectionsFocusValues=function(){var t,e=this.getSubSections()||[],o=this.getSelectedSubSection();return 0===e.length?this:1===e.length?(e[0]._setToFocusable(!1),this):(e.forEach(function(e){o===e.sId?(e._setToFocusable(!0),t=!0):e._setToFocusable(!1)}),t||e[0]._setToFocusable(!0),this)},p.prototype._disableSubSectionsFocus=function(){return(this.getSubSections()||[]).forEach(function(t){t._setToFocusable(!1)}),this},p.prototype._thereAreHiddenSubSections=function(){return this.getSubSections().some(function(t){return t._getIsHidden()})},p.prototype._updateShowHideSubSections=function(t){this.getSubSections().forEach(function(e){t&&e._shouldBeHidden()?e._updateShowHideState(!0):t||e._updateShowHideState(!1)})},p.prototype._getShouldDisplayShowHideAllButton=function(){return this.getSubSections().some(function(t){return t._shouldBeHidden()})},p.prototype._showHideContentAllContent=function(){var t=this._thereAreHiddenSubSections();this._getIsHidden()&&t&&this._updateShowHideState(!1),this._updateShowHideSubSections(!t),this._updateShowHideAllButton(t)},p.prototype._updateShowHideState=function(t){return this._updateShowHideButton(t),this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton()),e.prototype._updateShowHideState.call(this,t)},p.prototype._updateShowHideAllButton=function(t){this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton()).setText(this._getShowHideAllButtonText(t))},p.prototype._getShowHideAllButton=function(){return this.getAggregation(\"_showHideAllButton\")||this.setAggregation(\"_showHideAllButton\",new i({visible:this._getShouldDisplayShowHideAllButton(),text:this._getShowHideAllButtonText(!this._thereAreHiddenSubSections()),press:this._showHideContentAllContent.bind(this),type:h.Transparent}).addStyleClass(\"sapUxAPSectionShowHideButton\"),!0),this.getAggregation(\"_showHideAllButton\")},p.prototype._getShowHideButtonText=function(t){return a.i18nModel.getResourceBundle().getText(t?\"HIDE\":\"SHOW\")},p.prototype._getShowHideAllButtonText=function(t){return a.i18nModel.getResourceBundle().getText(t?\"HIDE_ALL\":\"SHOW_ALL\")},p.prototype._updateShowHideButton=function(t){this._getShowHideButton().setVisible(this._shouldBeHidden()).setText(this._getShowHideButtonText(!t))},p.prototype._getShowHideButton=function(){return this.getAggregation(\"_showHideButton\")||this.setAggregation(\"_showHideButton\",new i({visible:this._shouldBeHidden(),text:this._getShowHideButtonText(!this._getIsHidden()),press:this._showHideContent.bind(this),type:h.Transparent}).addStyleClass(\"sapUxAPSectionShowHideButton\"),!0),this.getAggregation(\"_showHideButton\")},n.mixInto(p),p});",
	"sap/uxap/ObjectPageSectionBase.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/core/Control\",\"sap/ui/core/library\",\"./library\",\"jquery.sap.keycodes\"],function(t,e,i,n){\"use strict\";var o=i.TitleLevel,r=e.extend(\"sap.uxap.ObjectPageSectionBase\",{metadata:{abstract:!0,library:\"sap.uxap\",properties:{title:{type:\"string\",group:\"Appearance\",defaultValue:null},titleLevel:{type:\"sap.ui.core.TitleLevel\",group:\"Appearance\",defaultValue:o.Auto},visible:{type:\"boolean\",group:\"Appearance\",defaultValue:!0},importance:{type:\"sap.uxap.Importance\",group:\"Behavior\",defaultValue:n.Importance.High}},aggregations:{customAnchorBarButton:{type:\"sap.m.Button\",multiple:!1}}}});return r.prototype.init=function(){this._bInternalVisible=!0,this._bInternalTitleVisible=!0,this._sInternalTitle=\"\",this._sInternalTitleLevel=o.Auto,this._isHidden=!1,this._bRtl=sap.ui.getCore().getConfiguration().getRTL()},r.prototype.onAfterRendering=function(){this._getObjectPageLayout()&&(this._getObjectPageLayout()._requestAdjustLayout().catch(function(){t.sap.log.debug(\"ObjectPageSectionBase :: cannot adjustLayout\",this)}),this._getObjectPageLayout()._setSectionsFocusValues())},r.prototype.setCustomAnchorBarButton=function(t){var e=this.setAggregation(\"customAnchorBarButton\",t,!0);return this._getObjectPageLayout()&&this._getObjectPageLayout()._updateNavigation(),e},r.prototype._setInternalVisible=function(t,e){t!=this._bInternalVisible&&(this._bInternalVisible=t,e&&this.invalidate())},r.prototype._getInternalVisible=function(){return this._bInternalVisible},r.prototype._setInternalTitleVisible=function(t,e){t!=this._bInternalTitleVisible&&(this._bInternalTitleVisible=t,e&&this.invalidate())},r.prototype._getInternalTitleVisible=function(){return this._bInternalTitleVisible},r.prototype._setInternalTitle=function(t,e){t!=this._sInternalTitle&&(this._sInternalTitle=t,e&&this.invalidate())},r.prototype._getTitle=function(){return this._getInternalTitle()||this.getTitle()},r.prototype._getInternalTitle=function(){return this._sInternalTitle},r.prototype._getARIALevel=function(){return this._getTitleLevel().slice(-1)},r.prototype._getTitleLevel=function(){var t=this.getTitleLevel();return t===o.Auto?this._getInternalTitleLevel():t},r.prototype._setInternalTitleLevel=function(t){this._sInternalTitleLevel=t},r.prototype._getInternalTitleLevel=function(){return this._sInternalTitleLevel},r.prototype._getObjectPageLayout=function(){return n.Utilities.getClosestOPL(this)},r.prototype._notifyObjectPageLayout=function(){this._getObjectPageLayout()&&this._getObjectPageLayout().$().length&&this._getObjectPageLayout()._requestAdjustLayoutAndUxRules()},[\"addAggregation\",\"insertAggregation\",\"removeAllAggregation\",\"removeAggregation\",\"destroyAggregation\"].forEach(function(t){r.prototype[t]=function(i,n,o,r){[\"addAggregation\",\"removeAggregation\"].indexOf(t)>-1&&(r=o),[\"removeAllAggregation\",\"destroyAggregation\"].indexOf(t)>-1&&(r=n);var a=e.prototype[t].apply(this,arguments);return!0!==r&&this._notifyObjectPageLayout(),a}}),r.prototype.setVisible=function(t,e){return this._getObjectPageLayout()?(this.setProperty(\"visible\",t,!0),this._notifyObjectPageLayout(),this.invalidate(),this):this.setProperty(\"visible\",t,e)},r.prototype.setTitle=function(t,e){return this.setProperty(\"title\",t,e),this._notifyObjectPageLayout(),this},r.prototype._shouldBeHidden=function(){return r._importanceMap[this.getImportance()]>r._importanceMap[this._sCurrentLowestImportanceLevelToShow]},r._importanceMap={Low:3,Medium:2,High:1},r.prototype._updateShowHideState=function(t){var e=this._getObjectPageLayout();return this._isHidden=t,this.$().children(this._sContainerSelector).toggle(!t),e&&e._requestAdjustLayout(),this},r.prototype._getIsHidden=function(){return this._isHidden},r.prototype._expandSection=function(){return this._updateShowHideState(!1)},r.prototype._showHideContent=function(){return this._updateShowHideState(!this._getIsHidden())},r.prototype._applyImportanceRules=function(t){this._sCurrentLowestImportanceLevelToShow=t,this.getDomRef()?this._updateShowHideState(this._shouldBeHidden()):this._isHidden=this._shouldBeHidden()},r.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5,r.prototype.onkeydown=function(e){if(e.keyCode===t.sap.KeyCodes.F7){var i,n=this.getSubSections(),o=n[0];1===n.length?(i=o._oLastFocusedControlF7,i?i.$().focus():o.$().firstFocusableDomRef().focus()):o.getActions().length&&o.getActions()[0].$().focus()}},r.prototype.onsapdown=function(t){this._handleFocusing(t,t.currentTarget.nextSibling)},r.prototype._handleFocusing=function(e,i){this._targetIsCorrect(e)&&i&&(e.preventDefault(),i.focus(),this._scrollParent(t(i).attr(\"id\")))},r.prototype._targetIsCorrect=function(t){return t.srcControl===this},r.prototype.onsapright=function(t){this[this._bRtl?\"onsapup\":\"onsapdown\"](t)},r.prototype.onsapup=function(t){this._handleFocusing(t,t.currentTarget.previousSibling)},r.prototype.onsapleft=function(t){this[this._bRtl?\"onsapdown\":\"onsapup\"](t)},r.prototype.onsaphome=function(t){this._handleFocusing(t,t.currentTarget.parentElement.firstChild)},r.prototype.onsapend=function(t){this._handleFocusing(t,t.currentTarget.parentElement.lastChild)},r.prototype.onsappageup=function(e){if(this._targetIsCorrect(e)){e.preventDefault();var i,n,o=t(e.currentTarget).parent().children();o.each(function(n,o){if(t(o).attr(\"id\")===e.currentTarget.id)return void(i=n-(r.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1))}),i&&o[i]?(o[i].focus(),n=t(o[i]).attr(\"id\")):o[0]&&(o[0].focus(),n=t(o[0]).attr(\"id\")),this._scrollParent(n)}},r.prototype.onsappagedown=function(e){if(this._targetIsCorrect(e)){e.preventDefault();var i,n,o=t(e.currentTarget).parent().children();o.each(function(n,o){if(t(o).attr(\"id\")===e.currentTarget.id)return void(i=n+r.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1)}),i&&o[i]?(o[i].focus(),n=t(o[i]).attr(\"id\")):o[o.length-1]&&(o[o.length-1].focus(),n=t(o[o.length-1]).attr(\"id\")),this._scrollParent(n)}},r.prototype._scrollParent=function(t){this._getObjectPageLayout()&&this._getObjectPageLayout().scrollToSection(t,0,10)},r});",
	"sap/uxap/ObjectPageSectionRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define(function(){\"use strict\";var e={};return e.render=function(e,t){var i,r;t.getVisible()&&t._getInternalVisible()&&(i=t._getTitle(),r=t._isTitleVisible(),e.write(\"<section \"),e.addClass(\"sapUxAPObjectPageSection\"),r||e.addClass(\"sapUxAPObjectPageSectionNoTitle\"),e.writeClasses(),e.writeAttribute(\"role\",\"region\"),e.writeAttributeEscaped(\"aria-labelledby\",t.getAggregation(\"ariaLabelledBy\").getId()),e.writeControlData(t),e.write(\">\"),r&&(e.write(\"<div\"),e.writeAttribute(\"role\",\"heading\"),e.writeAttribute(\"aria-level\",t._getARIALevel()),e.writeAttributeEscaped(\"id\",t.getId()+\"-header\"),e.addClass(\"sapUxAPObjectPageSectionHeader\"),e.writeClasses(),e.write(\">\"),e.write(\"<div\"),e.writeAttributeEscaped(\"id\",t.getId()+\"-title\"),e.addClass(\"sapUxAPObjectPageSectionTitle\"),t.getTitleUppercase()&&e.addClass(\"sapUxAPObjectPageSectionTitleUppercase\"),e.writeClasses(),e.write(\">\"),e.writeEscaped(i),e.write(\"</div>\"),e.renderControl(t._getShowHideAllButton()),e.renderControl(t._getShowHideButton()),e.write(\"</div>\")),e.write(\"<div\"),e.addClass(\"sapUxAPObjectPageSectionContainer\"),e.writeClasses(),t._isHidden&&e.addStyle(\"display\",\"none\"),e.writeStyles(),e.write(\">\"),t.getSubSections().forEach(e.renderControl),e.write(\"</div>\"),e.write(\"</section>\"))},e},!0);",
	"sap/uxap/ObjectPageSubSection.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/layout/Grid\",\"sap/ui/layout/GridData\",\"./ObjectPageSectionBase\",\"./ObjectPageLazyLoader\",\"./BlockBase\",\"sap/m/Button\",\"sap/ui/Device\",\"sap/ui/core/StashedControlSupport\",\"sap/ui/base/ManagedObjectObserver\",\"./library\",\"sap/m/library\",\"./ObjectPageSubSectionRenderer\",\"jquery.sap.keycodes\"],function(t,e,o,i,n,r,a,s,g,c,u,h,l){\"use strict\";var p=h.ButtonType,d=u.ObjectPageSubSectionMode,y=u.ObjectPageSubSectionLayout,f=i.extend(\"sap.uxap.ObjectPageSubSection\",{metadata:{library:\"sap.uxap\",properties:{mode:{type:\"sap.uxap.ObjectPageSubSectionMode\",group:\"Appearance\",defaultValue:d.Collapsed},titleUppercase:{type:\"boolean\",group:\"Appearance\",defaultValue:!1}},defaultAggregation:\"blocks\",aggregations:{_grid:{type:\"sap.ui.core.Control\",multiple:!1,visibility:\"hidden\"},blocks:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"block\"},moreBlocks:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"moreBlock\"},actions:{type:\"sap.ui.core.Control\",multiple:!0,singularName:\"action\"}},designtime:\"sap/uxap/designtime/ObjectPageSubSection.designtime\"}});return f.MEDIA_RANGE=s.media.RANGESETS.SAP_STANDARD,f.prototype.init=function(){i.prototype.init.call(this),this._bRenderedFirstTime=!1,this._aAggregationProxy={blocks:[],moreBlocks:[]},this._$spacer=[],this._sContainerSelector=\".sapUxAPBlockContainer\",this._oObserver=new c(f.prototype._observeChanges.bind(this)),this._oObserver.observe(this,{aggregations:[\"actions\"]}),this._attachMediaContainerWidthChange(this._synchronizeBlockLayouts,this),this._switchSubSectionMode(this.getMode())},f.prototype._expandSection=function(){i.prototype._expandSection.call(this);var t=this.getParent();return t&&\"function\"==typeof t._expandSection&&t._expandSection(),this},f.prototype._getGrid=function(){return this.getAggregation(\"_grid\")||this.setAggregation(\"_grid\",new e({id:this.getId()+\"-innerGrid\",defaultSpan:\"XL12 L12 M12 S12\",hSpacing:1,vSpacing:1,width:\"100%\",containerQuery:!0}),!0),this.getAggregation(\"_grid\")},f.prototype._hasVisibleActions=function(){var t=this.getActions()||[];return 0!==t.length&&t.filter(function(t){return t.getVisible()}).length>0},f.prototype._observeChanges=function(t){var e=t.object,o=t.name,i=t.mutation,n=t.child;e===this?\"actions\"===o&&(\"insert\"===i?this._observeAction(n):\"remove\"===i&&this._unobserveAction(n)):\"visible\"===o&&(this._getInternalTitleVisible()&&\"\"!==this.getTitle().trim()||this.$(\"header\").toggleClass(\"sapUiHidden\",!this._hasVisibleActions()))},f.prototype._observeAction=function(t){this._oObserver.observe(t,{properties:[\"visible\"]})},f.prototype._unobserveAction=function(t){this._oObserver.unobserve(t,{properties:[\"visible\"]})},f.prototype._unStashControls=function(){g.getStashedControls(this.getId()).forEach(function(t){t.setStashed(!1)})},f.prototype.connectToModels=function(){var t=this.getBlocks()||[],e=this.getMoreBlocks()||[],o=this.getMode();this._unStashControls(),t.forEach(function(t){t instanceof r&&(t.getMode()||t.setMode(o),t.connectToModels())}),e.length>0&&o===d.Expanded&&e.forEach(function(t){t instanceof r&&(t.getMode()||t.setMode(o),t.connectToModels())})},f.prototype._allowPropagationToLoadedViews=function(t){var e=this.getBlocks()||[],o=this.getMoreBlocks()||[];e.forEach(function(e){e instanceof r&&e._allowPropagationToLoadedViews(t)}),o.forEach(function(e){e instanceof r&&e._allowPropagationToLoadedViews(t)})},f.prototype.clone=function(){return Object.keys(this._aAggregationProxy).forEach(function(t){var e=this.mAggregations[t];e&&0!==e.length||(this.mAggregations[t]=this._aAggregationProxy[t])},this),i.prototype.clone.apply(this,arguments)},f.prototype._cleanProxiedAggregations=function(){var t=this._aAggregationProxy;Object.keys(t).forEach(function(e){t[e].forEach(function(t){t.destroy()})})},f.prototype.exit=function(){this._oSeeMoreButton&&(this._oSeeMoreButton.destroy(),this._oSeeMoreButton=null),this._detachMediaContainerWidthChange(this._synchronizeBlockLayouts,this),this._cleanProxiedAggregations(),i.prototype.exit&&i.prototype.exit.call(this)},f.prototype.onAfterRendering=function(){var e=this._getObjectPageLayout();i.prototype.onAfterRendering&&i.prototype.onAfterRendering.call(this),e&&(this._$spacer=t.sap.byId(e.getId()+\"-spacer\"))},f.prototype.onBeforeRendering=function(){var t=this._getObjectPageLayout();t&&(i.prototype.onBeforeRendering&&i.prototype.onBeforeRendering.call(this),this._setAggregationProxy(),this._getGrid().removeAllContent(),this._applyLayout(t),this.refreshSeeMoreVisibility())},f.prototype._applyLayout=function(e){var o,i=this._getGrid(),n=this.getMode(),r=e.getSubSectionLayout(),a=this._calculateLayoutConfiguration(r,e),s=this.getBlocks(),g=s.concat(this.getMoreBlocks());this._oLayoutConfig=a,this._resetLayoutData(g),o=n===d.Expanded?g:s,this._calcBlockColumnLayout(o,this._oLayoutConfig);try{o.forEach(function(t){this._setBlockMode(t,n),i.addAggregation(\"content\",t,!0)},this)}catch(e){t.sap.log.error(\"ObjectPageSubSection :: error while building layout \"+r+\": \"+e)}return this},f.prototype._calculateLayoutConfiguration=function(t,e){var o={M:2,L:3,XL:4},i=o.L,n=o.XL,r=t===y.TitleOnLeft,a=e.getUseTwoColumnsForLargeScreen();return r&&(i-=1,n-=1),a&&(i-=1),o.L=i,o.XL=n,o},f.prototype.refreshSeeMoreVisibility=function(){var t=!!this.getMoreBlocks().length,e=this._getSeeMoreButton(),o=e.$(),i=this.$();return t||(t=this.getBlocks().some(function(t){if(t instanceof r&&t.getVisible()&&t.getShowSubSectionMore())return!0})),i.length&&i.toggleClass(\"sapUxAPObjectPageSubSectionWithSeeMore\",t),this.toggleStyleClass(\"sapUxAPObjectPageSubSectionWithSeeMore\",t),o.length&&o.toggleClass(\"sapUxAPSubSectionSeeMoreButtonVisible\",t),e.toggleStyleClass(\"sapUxAPSubSectionSeeMoreButtonVisible\",t),t},f.prototype.setMode=function(t){return this.getMode()!==t&&(this._switchSubSectionMode(t),this._bRenderedFirstTime&&this.rerender()),this},f.prototype.onkeydown=function(e){if(e.keyCode===t.sap.KeyCodes.F7){e.stopPropagation();var o=sap.ui.getCore().byId(e.target.id);o instanceof f?this._handleSubSectionF7():(this._handleInteractiveElF7(),this._oLastFocusedControlF7=o)}},f.prototype._handleInteractiveElF7=function(){this.getParent().getSubSections().length>1?this.$().focus():this.getParent().$().focus()},f.prototype._handleSubSectionF7=function(t){this._oLastFocusedControlF7?this._oLastFocusedControlF7.$().focus():this.$().firstFocusableDomRef().focus()},f.prototype._calcBlockColumnLayout=function(t,e){var i,n,r,a,s;return n={iRemaining:e.M,iColumnConfig:e.M},r={iRemaining:e.L,iColumnConfig:e.L},a={iRemaining:e.XL,iColumnConfig:e.XL},s=[a,r,n],i=t.filter(function(t){return t.getVisible&&t.getVisible()}),i.forEach(function(t,e){s.forEach(function(o){o.iCalculatedSize=this._calculateBlockSize(t,o.iRemaining,i,e,o.iColumnConfig)},this),t.setLayoutData(new o(t.getId()+\"-layoutData\",{spanS:12,spanM:n.iCalculatedSize*(12/n.iColumnConfig),spanL:r.iCalculatedSize*(12/r.iColumnConfig),spanXL:a.iCalculatedSize*(12/a.iColumnConfig),linebreakM:e>0&&n.iRemaining===n.iColumnConfig,linebreakL:e>0&&r.iRemaining===r.iColumnConfig,linebreakXL:e>0&&a.iRemaining===a.iColumnConfig})),s.forEach(function(t){t.iRemaining-=t.iCalculatedSize,t.iRemaining<1&&(t.iRemaining=t.iColumnConfig)})},this),i},f.prototype._calculateBlockSize=function(t,e,o,i,n){var r,a,s=n;if(!this._hasAutoLayout(t))return Math.min(n,parseInt(t.getColumnLayout(),10));for(a=1;a<=s&&(r=this._calcLayout(o[i+a]))<e;a++)e-=r;return e},f.prototype._calcLayout=function(t){var e=1;return t?t instanceof r&&\"auto\"!=t.getColumnLayout()&&(e=parseInt(t.getColumnLayout(),10)):e=0,e},f.prototype._hasAutoLayout=function(t){return!(t instanceof r)||\"auto\"==t.getColumnLayout()},f.prototype._onDesktopMediaRange=function(t){return this._onMediaRange(t,[\"LargeDesktop\",\"Desktop\"])},f.prototype._onTabletMediaRange=function(t){return this._onMediaRange(t,[\"Tablet\"])},f.prototype._onPhoneMediaRange=function(t){return this._onMediaRange(t,[\"Phone\"])},f.prototype._onMediaRange=function(t,e){var o=t||this._getCurrentMediaContainerRange();return e.indexOf(o.name)>-1},f.prototype._synchronizeBlockLayouts=function(t){this._getUseTitleOnTheLeft()&&this.$(\"header\").toggleClass(\"titleOnLeftLayout\",this._onDesktopMediaRange(t)),this._toggleBlockLayoutResponsiveStyles(t)},f.prototype._toggleBlockLayoutResponsiveStyles=function(t){this.$().find(\".sapUxAPBlockContainer\").toggleClass(\"sapUxAPBlockContainerDesktop\",this._onDesktopMediaRange(t)),this.$().find(\".sapUxAPBlockContainer\").toggleClass(\"sapUxAPBlockContainerTablet\",this._onTabletMediaRange(t)),this.$().find(\".sapUxAPBlockContainer\").toggleClass(\"sapUxAPBlockContainerPhone\",this._onPhoneMediaRange(t))},f.prototype._getMediaString=function(t){return this._onPhoneMediaRange(t)?\"Phone\":this._onTabletMediaRange(t)?\"Tablet\":\"Desktop\"},f.prototype._setAggregationProxy=function(){this._bRenderedFirstTime||(t.each(this._aAggregationProxy,t.proxy(function(t,e){this._setAggregation(t,this.removeAllAggregation(t,!0),!0)},this)),this._bRenderedFirstTime=!0)},f.prototype.hasProxy=function(t){return this._bRenderedFirstTime&&this._aAggregationProxy.hasOwnProperty(t)},f.prototype._getAggregation=function(t){return this._aAggregationProxy[t]},f.prototype._setAggregation=function(t,e,o){return this._aAggregationProxy[t]=e,!0!==o&&(this._notifyObjectPageLayout(),this.invalidate()),this._aAggregationProxy[t]},f.prototype.addAggregation=function(t,e,o){var a;return e instanceof n?(e.getContent().forEach(function(e){this.addAggregation(t,e,!0)},this),e.removeAllContent(),e.destroy(),this.invalidate(),this):this.hasProxy(t)?(a=this._getAggregation(t),a.push(e),this._setAggregation(t,a,o),(e instanceof r||e instanceof n)&&e.setParent(this),this):i.prototype.addAggregation.apply(this,arguments)},f.prototype.insertBlock=function(e,o){return t.sap.log.warning(\"ObjectPageSubSection :: usage of insertBlock is not supported - addBlock is performed instead.\"),this.addAggregation(\"blocks\",e)},f.prototype.insertMoreBlock=function(e,o){return t.sap.log.warning(\"ObjectPageSubSection :: usage of insertMoreBlock is not supported - addMoreBlock is performed instead.\"),this.addAggregation(\"moreBlocks\",e)},f.prototype.removeAllAggregation=function(t,e){var o;return this.hasProxy(t)?(o=this._getAggregation(t),this._setAggregation(t,[],e),o.slice()):i.prototype.removeAllAggregation.apply(this,arguments)},f.prototype.removeAggregation=function(t,e){var o,n=!1;return this.hasProxy(t)?(o=this._getAggregation(t),o.forEach(function(i,r){return i.getId()===e.getId()&&(o.splice(r,1),this._setAggregation(t,o),n=!0),!n},this),n?e:null):i.prototype.removeAggregation.apply(this,arguments)},f.prototype.indexOfAggregation=function(t,e){var o=-1;return this.hasProxy(t)?(this._getAggregation(t).some(function(t,i){if(t.getId()===e.getId())return o=i,!0},this),o):i.prototype.indexOfAggregation.apply(this,arguments)},f.prototype.getAggregation=function(t){return this.hasProxy(t)?this._getAggregation(t):i.prototype.getAggregation.apply(this,arguments)},f.prototype.destroyAggregation=function(t){return this.hasProxy(t)?(this._getAggregation(t).forEach(function(t){t.destroy()}),this._setAggregation(t,[]),this):i.prototype.destroyAggregation.apply(this,arguments)},f.prototype._getSeeMoreButton=function(){return this._oSeeMoreButton||(this._oSeeMoreButton=new a(this.getId()+\"--seeMore\",{type:p.Transparent,iconFirst:!1}).addStyleClass(\"sapUxAPSubSectionSeeMoreButton\").attachPress(this._seeMoreLessControlPressHandler,this)),this._oSeeMoreButton},f.prototype._seeMoreLessControlPressHandler=function(t){var e,o=this.getMode(),i=this.getMoreBlocks()||[];o===d.Expanded?e=d.Collapsed:(e=d.Expanded,i.forEach(function(t){t instanceof r&&(t.setMode(o),t.connectToModels())},this)),this._switchSubSectionMode(e),this._$spacer.length>0&&this._$spacer.height(this._$spacer.height()+this.$().height()),this.rerender()},f.prototype._switchSubSectionMode=function(t){t=this.validateProperty(\"mode\",t),t===d.Collapsed?(this.setProperty(\"mode\",d.Collapsed,!0),this._getSeeMoreButton().setText(u.i18nModel.getResourceBundle().getText(\"SEE_MORE\"))):(this.setProperty(\"mode\",d.Expanded,!0),this._getSeeMoreButton().setText(u.i18nModel.getResourceBundle().getText(\"SEE_LESS\")))},f.prototype._setBlockMode=function(e,o){e instanceof r?e.setMode(o):t.sap.log.debug(\"ObjectPageSubSection :: cannot propagate mode \"+o+\" to \"+e.getMetadata().getName())},f.prototype._setToFocusable=function(t){return t?this.$().attr(\"tabIndex\",\"0\"):this.$().attr(\"tabIndex\",\"-1\"),this},f.prototype._getUseTitleOnTheLeft=function(){var t=this._getObjectPageLayout();return t&&t.getSubSectionLayout()===y.TitleOnLeft},f.prototype._resetLayoutData=function(t){t.forEach(function(t){t.getLayoutData()&&t.destroyLayoutData()},this)},f.prototype.getVisibleBlocksCount=function(){var t=g.getStashedControls(this.getId()).length;return(this.getBlocks()||[]).forEach(function(e){if(e.getVisible&&!e.getVisible())return!0;t++}),(this.getMoreBlocks()||[]).forEach(function(e){if(e.getVisible&&!e.getVisible())return!0;t++}),t},f});",
	"sap/uxap/ObjectPageSubSectionRenderer.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define(function(){\"use strict\";var e={};return e.render=function(e,t){var i,a,r,s,d,l;t.getVisible()&&t._getInternalVisible()&&(i=t.getActions()||[],s=i.length>0,a=t._getInternalTitleVisible()&&\"\"!==t.getTitle().trim(),r=a||s,l=t._hasVisibleActions(),e.write(\"<div \"),e.writeAttribute(\"role\",\"region\"),e.writeControlData(t),e.addClass(\"sapUxAPObjectPageSubSection\"),e.addClass(\"ui-helper-clearfix\"),e.writeClasses(t),e.writeClasses(),e.write(\">\"),r&&(e.write(\"<div\"),e.addClass(\"sapUxAPObjectPageSubSectionHeader\"),a||l||e.addClass(\"sapUiHidden\"),d=t._getUseTitleOnTheLeft(),d&&t._onDesktopMediaRange()&&e.addClass(\"titleOnLeftLayout\"),e.writeAttributeEscaped(\"id\",t.getId()+\"-header\"),e.writeClasses(),e.write(\">\"),e.write(\"<div\"),a&&(e.writeAttribute(\"role\",\"heading\"),e.writeAttribute(\"aria-level\",t._getARIALevel())),e.addClass(\"sapUxAPObjectPageSubSectionHeaderTitle\"),t.getTitleUppercase()&&e.addClass(\"sapUxAPObjectPageSubSectionHeaderTitleUppercase\"),e.writeAttributeEscaped(\"id\",t.getId()+\"-headerTitle\"),e.writeClasses(),e.writeAttribute(\"data-sap-ui-customfastnavgroup\",!0),e.write(\">\"),a&&e.writeEscaped(t.getTitle()),e.write(\"</div>\"),s&&(e.write(\"<div\"),e.addClass(\"sapUxAPObjectPageSubSectionHeaderActions\"),e.writeClasses(),e.writeAttribute(\"data-sap-ui-customfastnavgroup\",!0),e.write(\">\"),i.forEach(e.renderControl),e.write(\"</div>\")),e.write(\"</div>\")),e.write(\"<div\"),e.addClass(\"ui-helper-clearfix\"),e.addClass(\"sapUxAPBlockContainer\"),e.addClass(\"sapUxAPBlockContainer\"+t._getMediaString()),e.writeClasses(),t._isHidden&&e.addStyle(\"display\",\"none\"),e.writeStyles(),e.write(\">\"),e.renderControl(t._getGrid()),e.write(\"<div\"),e.addClass(\"sapUxAPSubSectionSeeMoreContainer\"),e.writeClasses(),e.write(\">\"),e.renderControl(t._getSeeMoreButton()),e.write(\"</div>\"),e.write(\"</div>\"),e.write(\"</div>\"))},e},!0);",
	"sap/uxap/rules/ObjectPageLayout.support.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"sap/ui/support/library\"],function(e){\"use strict\";var t=e.Categories,n=e.Severity;return{id:\"objectPageComponentContainerHeight\",audiences:[e.Audiences.Control],categories:[t.Usability],enabled:!0,minversion:\"1.26\",title:\"ObjectPageLayout: Height of componentContainer\",description:\"The componentContainer of ObjectPageLayout should always have a '100%' height explicitly set\",resolution:\"Set a '100%' height to the ComponentContainer of ObjectPageLayout\",resolutionurls:[{text:\"SAP Fiori Design Guidelines: Object Page\",href:\"https://experience.sap.com/fiori-design-web/object-page/#guidelines\"}],check:function(e,t,i){var o=i.getElementsByClassName(\"sap.ui.core.ComponentContainer\"),a=i.getElementsByClassName(\"sap.uxap.ObjectPageLayout\"),r=[],s=function(e){for(var t=e.getParent();t;){if(t instanceof sap.ui.core.Component)return t;t=t.getParent()}},u=function(e){return r.indexOf(e.getComponent())>-1},c=function(e){var t=s(e);return t&&t.getId()};r=a.map(c),o.forEach(function(t){if(u(t)&&\"100%\"!==t.getHeight()){var i=t.getId(),o=t.getMetadata().getElementName();e.addIssue({severity:n.Medium,details:\"ComponentContainer '\"+o+\"' (\"+i+\") does not have '100%' height.\",context:{id:i}})}})}}},!0);",
	"sap/uxap/ThrottledTaskHelper.js": "/*!\n * UI development toolkit for HTML5 (OpenUI5)\n * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.\n * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.\n */\nsap.ui.define([\"jquery.sap.global\",\"sap/ui/base/Object\"],function(i,s){\"use strict\";return s.extend(\"ThrottledTask\",{constructor:function(i,s,t){this._fnTask=i,this._iDelay=s,this._oContext=t,this._oPromise=null,this._fnResolvePromise=null,this._fnRejectPromise=null,this._iTimer=null,this._oTaskOptions=null},reSchedule:function(s,t){var e=this._getPromise();if(this._iTimer&&(i.sap.clearDelayedCall(this._iTimer),this._iTimer=null),this._oTaskOptions=this._mergeOptions(this._oTaskOptions||{},t),s){var o=this._fnTask.call(this._oContext,this._oTaskOptions);return this._completePromise(o),e}return this._iTimer=i.sap.delayedCall(this._iDelay,this,function(){if(this._oPromise){var i=this._fnTask.call(this._oContext,this._oTaskOptions);this._completePromise(i)}}.bind(this)),e},_getPromise:function(){return this._oPromise||(this._oPromise=new window.Promise(function(i,s){this._fnResolvePromise=i,this._fnRejectPromise=s}.bind(this))),this._oPromise},_completePromise:function(i){(i?this._fnResolvePromise:this._fnRejectPromise)(),this._oPromise=null,this._fnResolvePromise=null,this._fnRejectPromise=null,this._oTaskOptions=null},_mergeOptions:function(s,t){var e=i.extend({},s,t);return i.each(e,function(i){e[i]=s[i]||t[i]}),e}})});",
	"sap/uxap/designtime/ObjectPageLayout.create.fragment.xml": "<core:FragmentDefinition\n\t\txmlns=\"sap.uxap\"\n\t\txmlns:m=\"sap.m\"\n\t\txmlns:core=\"sap.ui.core\"><ObjectPageLayout><headerTitle><ObjectPageHeader objectTitle=\"Header Title\"/></headerTitle><headerContent><m:Text text=\"Header Content\"/></headerContent><sections><ObjectPageSection title=\"First Section\"><ObjectPageSubSection><blocks><m:Text text=\"First Section content\"/></blocks></ObjectPageSubSection></ObjectPageSection><ObjectPageSection title=\"Second Section\"><ObjectPageSubSection><blocks><m:Text text=\"Second Section content\"/></blocks></ObjectPageSubSection></ObjectPageSection></sections></ObjectPageLayout></core:FragmentDefinition>",
	"sap/uxap/manifest.json": "{\"_version\":\"1.9.0\",\"sap.app\":{\"_version\":\"1.2.0\",\"id\":\"sap.uxap\",\"type\":\"library\",\"applicationVersion\":{\"version\":\"9.4.0-0\"},\"title\":\"The OpenUI5-based library, sap.uxap.\"},\"sap.ui5\":{\"_version\":\"1.1.0\",\"dependencies\":{\"libs\":{\"sap.ui.core\":{},\"sap.m\":{},\"sap.ui.layout\":{}}},\"library\":{\"i18n\":false}}}",
	"sap/uxap/component/ObjectPageLayoutUXDrivenFactory.view.xml": "<core:View xmlns:core=\"sap.ui.core\"\n\t\t   xmlns=\"sap.uxap\"\n\t\t   height=\"100%\"\n\t\t   controllerName=\"sap.uxap.component.ObjectPageLayoutUXDrivenFactory\"\n><ObjectPageLayout id=\"ObjectPageLayout\"\n\t\t\t\t\t  subSectionLayout=\"{objectPageLayoutMetadata>/subSectionLayout}\"\n\t\t\t\t\t  showAnchorBar=\"{objectPageLayoutMetadata>/showAnchorBar}\"\n\t\t\t\t\t  height=\"{objectPageLayoutMetadata>/height}\"\n\t\t\t\t\t  enableLazyLoading=\"{objectPageLayoutMetadata>/enableLazyLoading}\"\n\t\t\t\t\t  sections=\"{objectPageLayoutMetadata>/sections}\"\n\t\t\t\t\t  headerContent=\"{path:'objectPageLayoutMetadata>/headerContent', factory:'.controlFactory'}\"\n\t\t\t\t\t  showAnchorBarPopover=\"{objectPageLayoutMetadata>/showAnchorBarPopover}\"\n\t\t\t\t\t  upperCaseAnchorBar=\"{objectPageLayoutMetadata>/upperCaseAnchorBar}\"\n\t\t\t\t\t  useIconTabBar=\"{objectPageLayoutMetadata>/useIconTabBar}\"\n\t\t\t\t\t  showHeaderContent=\"{objectPageLayoutMetadata>/showHeaderContent}\"\n\t\t\t\t\t  useTwoColumnsForLargeScreen=\"{objectPageLayoutMetadata>/useTwoColumnsForLargeScreen}\"\n\t\t\t\t\t  showTitleInHeaderContent=\"{objectPageLayoutMetadata>/showTitleInHeaderContent}\"\n\t\t\t\t\t  showOnlyHighImportance=\"{objectPageLayoutMetadata>/showOnlyHighImportance}\"\n\t\t\t\t\t  isChildPage=\"{objectPageLayoutMetadata>/isChildPage}\"\n\t\t\t\t\t  alwaysShowContentHeader=\"{objectPageLayoutMetadata>/alwaysShowContentHeader}\"\n\t\t\t\t\t  showEditHeaderButton=\"{objectPageLayoutMetadata>/showEditHeaderButton}\"\n\t><sections><ObjectPageSection id=\"ObjectPageSection\"\n\t\t\t\t\t\t\t   title=\"{objectPageLayoutMetadata>title}\"\n\t\t\t\t\t\t\t   importance=\"{objectPageLayoutMetadata>importance}\"\n\t\t\t\t\t\t\t   showTitle=\"{objectPageLayoutMetadata>showTitle}\"\n\t\t\t\t\t\t\t   subSections=\"{objectPageLayoutMetadata>subSections}\"\n\t\t\t\t\t\t\t   visible=\"{objectPageLayoutMetadata>visible}\"><subSections><ObjectPageSubSection id=\"ObjectPageSubSection\"\n\t\t\t\t\t\t\t\t\t\t  title=\"{objectPageLayoutMetadata>title}\"\n\t\t\t\t\t\t\t\t\t\t  visible=\"{objectPageLayoutMetadata>visible}\"\n\t\t\t\t\t\t\t\t\t\t  mode=\"{objectPageLayoutMetadata>mode}\"\n\t\t\t\t\t\t\t\t\t\t  importance=\"{objectPageLayoutMetadata>importance}\"\n\t\t\t\t\t\t\t\t\t\t  actions=\"{path:'objectPageLayoutMetadata>actions', factory:'.controlFactory'}\"\n\t\t\t\t\t\t\t\t\t\t  blocks=\"{path:'objectPageLayoutMetadata>blocks', factory:'.controlFactory'}\"\n\t\t\t\t\t\t\t\t\t\t  moreBlocks=\"{path:'objectPageLayoutMetadata>moreBlocks', factory:'.controlFactory'}\"></ObjectPageSubSection></subSections></ObjectPageSection></sections></ObjectPageLayout></core:View>\n"
}, "sap/uxap/library-preload");